/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ICommSerialPort;
import com.neuron.app.tonto.ICommSerialPortID;
import com.neuron.app.tonto.ICommSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.SerialPort;

public class CommJavax
implements ICommSource {
    static Debug debug = Debug.getInstance("comm");

    @Override
    public ICommSerialPortID[] getSerialPorts() {
        Object[] objectArray;
        Vector<PortID> vector = new Vector<PortID>();
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        if (enumeration == null) {
            return null;
        }
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (objectArray.getPortType() != 1) continue;
            vector.add(new PortID((CommPortIdentifier)objectArray));
        }
        objectArray = new PortID[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public ICommSerialPortID getSerialPort(String string) {
        ICommSerialPortID[] iCommSerialPortIDArray = this.getSerialPorts();
        for (int i = 0; i < iCommSerialPortIDArray.length; ++i) {
            if (!iCommSerialPortIDArray[i].getName().equals(string)) continue;
            return iCommSerialPortIDArray[i];
        }
        throw new IllegalArgumentException("Port '" + string + "' not found");
    }

    class Port
    implements ICommSerialPort {
        private SerialPort port;

        Port(SerialPort serialPort) throws IOException {
            this.port = serialPort;
            try {
                serialPort.setSerialPortParams(115200, 8, 1, 0);
                serialPort.setInputBufferSize(4096);
                serialPort.enableReceiveTimeout(1500);
                serialPort.setFlowControlMode(3);
                debug.log(3, "port=" + serialPort.getName() + "@" + serialPort.getBaudRate() + "," + serialPort.getDataBits() + "-" + serialPort.getParity() + "-" + serialPort.getStopBits());
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }

        @Override
        public String getName() {
            return this.port.getName();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.port.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.port.getOutputStream();
        }

        @Override
        public void sendBreak(int n) throws IOException {
            this.port.sendBreak(n);
        }

        @Override
        public void close() {
            this.port.close();
        }

        public String toString() {
            return this.port.toString();
        }
    }

    class PortID
    implements ICommSerialPortID {
        private CommPortIdentifier id;

        PortID(CommPortIdentifier commPortIdentifier) {
            this.id = commPortIdentifier;
        }

        @Override
        public String getName() {
            return this.id.getName();
        }

        @Override
        public ICommSerialPort open() throws IOException {
            try {
                return new Port((SerialPort)this.id.open("Tonto", 1500));
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }

        @Override
        public boolean isCurrentlyOwned() {
            return this.id.isCurrentlyOwned();
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

