/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.DebugListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Debug {
    private static Hashtable buggers = new Hashtable();
    private static PrintStream out = System.out;
    private static BufferedWriter log = null;
    private static Thread flusher;
    private static Thread hook;
    private static Vector listeners;
    private String name;
    private int level;
    private static long lastLog;

    public static void setLevels(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                String string2 = stringTokenizer2.nextToken();
                int n = stringTokenizer2.hasMoreTokens() ? Integer.parseInt(stringTokenizer2.nextToken()) : 1;
                Debug.getInstance(string2).setLevel(n);
            }
        }
    }

    public static String getLevels() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = buggers.keys();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            String string = (String)enumeration.nextElement();
            Debug debug = (Debug)buggers.get(string);
            stringBuffer.append(string + "=" + debug.getLevel());
        }
        return stringBuffer.toString();
    }

    public static int getActiveLoggers() {
        return buggers.size();
    }

    public static Enumeration getLoggerNames() {
        return buggers.keys();
    }

    public static Debug getInstance(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(36);
        if (n < 0) {
            n = string.lastIndexOf(46);
        }
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return Debug.getInstance(string);
    }

    public static Debug getInstance(String string) {
        Debug debug = (Debug)buggers.get(string);
        if (debug == null) {
            debug = new Debug(string, 0);
            buggers.put(string, debug);
        }
        return debug;
    }

    public static void setLevel(Class clazz, int n) {
        Debug.getInstance(clazz).setLevel(n);
    }

    public static void setLevel(String string, int n) {
        Debug.getInstance(string).setLevel(n);
    }

    public Debug(String string, int n) {
        this.name = string;
        this.level = n;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean debug(int n) {
        return n <= this.level;
    }

    public void log(int n, String string) {
        if (n <= this.level) {
            String string2 = Long.toString(System.currentTimeMillis() % 10000L);
            if (string2.length() < 5) {
                string2 = "00000".substring(string2.length()) + string2;
            }
            Debug.log(string2 + " [" + this.name + "] " + string);
        }
    }

    private static synchronized void log(String string) {
        if (log == null) {
            out.println(string);
        } else {
            try {
                log.write(string);
                log.newLine();
            }
            catch (Exception exception) {
                Debug.closeLog();
                out.println(string);
            }
        }
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                ((DebugListener)listeners.get(i)).debugAction(string);
            }
        }
    }

    private static void closeLog() {
        try {
            if (flusher != null) {
                flusher.interrupt();
            }
            if (log != null) {
                log.flush();
                log.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        log = null;
    }

    public static void logToFile(String string) throws IOException {
        if (log != null) {
            Debug.closeLog();
        }
        log = new BufferedWriter(new FileWriter(string), 8192);
        hook = new Thread(){

            @Override
            public void run() {
                Debug.closeLog();
            }
        };
        Runtime.getRuntime().addShutdownHook(hook);
        flusher = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        2.sleep(1000L);
                        log.flush();
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        flusher.start();
    }

    public static void logToStream(PrintStream printStream) {
        if (printStream == null) {
            throw new IllegalArgumentException("null");
        }
        Debug.closeLog();
        out = printStream;
    }

    public static void addListener(DebugListener debugListener) {
        if (listeners == null) {
            listeners = new Vector();
        }
        if (!listeners.contains(debugListener)) {
            listeners.add(debugListener);
        }
    }

    public static void removeListener(DebugListener debugListener) {
        if (listeners == null || !listeners.contains(debugListener)) {
            return;
        }
        listeners.remove(debugListener);
        if (listeners.size() == 0) {
            listeners = null;
        }
    }

    public static void removeAllListeners() {
        if (listeners != null) {
            listeners.setSize(0);
        }
    }

    static {
        Debug.setLevels(System.getProperty("debug"));
        lastLog = -1L;
    }
}

