/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFNodeState;
import com.neuron.app.tonto.Comm;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ITaskStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;

public class Firmware {
    private static int magicOffset = 8;
    private static byte[] magicCode = new byte[]{67, 79, 68, 69};
    private static byte[] magicNew = new byte[]{64, -91, 90, 64};
    private String file;
    private String desc;
    private int offBOOT;
    private int offPSOS;
    private int off_SYS;
    private int off_APP;
    private int off_CCF;
    private int off_UDB;
    private int lenBOOT;
    private int lenPSOS;
    private int len_SYS;
    private int len_APP;
    private int len_CCF;
    private int len_UDB;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Firmware [-x | -i] <file(s)>");
            System.exit(1);
        }
        int n = 0;
        boolean bl = false;
        if (stringArray[0].equals("-x")) {
            n = 1;
            bl = true;
        } else if (stringArray[0].equals("-i")) {
            Firmware.install(stringArray[1]);
            return;
        }
        Firmware.printHeader();
        for (int i = n; i < stringArray.length; ++i) {
            try {
                Firmware firmware = new Firmware(stringArray[i]);
                firmware.printDetail();
                if (!bl) continue;
                String string = firmware.getDescription().replace(' ', '_').replace(';', '_').toLowerCase();
                File file = new File("img_" + string);
                file.mkdirs();
                Firmware.writeSegment(file, "boot.img", firmware.getBOOT());
                Firmware.writeSegment(file, "psos.img", firmware.getPSOS());
                Firmware.writeSegment(file, "_app.img", firmware.get_APP());
                Firmware.writeSegment(file, "_sys.img", firmware.get_SYS());
                Firmware.writeSegment(file, "_ccf.img", firmware.get_CCF());
                Firmware.writeSegment(file, "_udb.img", firmware.get_UDB());
                Hashtable hashtable = Firmware.extractCIBs(firmware.get_APP());
                if (hashtable.size() <= 0) continue;
                file = new File(file, "cib");
                file.mkdirs();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    String string2 = (String)enumeration.nextElement();
                    Object v = hashtable.get(string2);
                    if (v instanceof CCFIcon) {
                        object = (CCFIcon)v;
                        if (string2.endsWith(".cib")) {
                            string2 = string2.substring(0, string2.length() - 4) + ".gif";
                        }
                        ((CCFIcon)object).saveGIF(new File(file, string2).toString());
                        continue;
                    }
                    if (!(v instanceof byte[])) continue;
                    object = new FileOutputStream(new File(file, string2));
                    ((FileOutputStream)object).write((byte[])v);
                    ((FileOutputStream)object).close();
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println("error firmware image ** " + stringArray[i] + " **");
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    private static void writeSegment(File file, String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(file, string));
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
    }

    private static void install(String string) throws Exception {
        Debug.logToFile("install.log");
        Debug.getInstance("comm").setLevel(3);
        Debug.getInstance("xmodem").setLevel(3);
        Comm comm = Comm.scanForPronto(null);
        comm.updateFirmware(new Firmware(string), new ITaskStatus(){

            @Override
            public void taskStatus(int n, String string) {
                System.out.println("ts: " + n + " " + string);
            }

            @Override
            public void taskError(Throwable throwable) {
                System.out.println("te: " + throwable);
            }

            @Override
            public void taskNotify(Object object) {
                System.out.println("tn: " + object);
            }
        });
        comm.close();
    }

    public Firmware(String string) throws IOException {
        this.file = string;
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        long l = randomAccessFile.length();
        randomAccessFile.seek(l - 18L);
        int n = this.readInt(randomAccessFile);
        this.offBOOT = this.readInt(randomAccessFile);
        randomAccessFile.seek(n);
        this.desc = this.readString(randomAccessFile);
        if (this.desc.startsWith("sys")) {
            this.offPSOS = this.offBOOT;
            this.offBOOT = 0;
        } else {
            randomAccessFile.seek(this.offBOOT);
            this.lenBOOT = this.readInt(randomAccessFile);
            this.offPSOS = this.offBOOT + this.lenBOOT + 4;
        }
        randomAccessFile.seek(this.offPSOS);
        this.lenPSOS = this.readInt(randomAccessFile);
        this.off_SYS = this.offPSOS + this.lenPSOS + 4;
        randomAccessFile.seek(this.off_SYS);
        this.len_SYS = this.readInt(randomAccessFile);
        this.off_APP = this.off_SYS + this.len_SYS + 4;
        randomAccessFile.seek(this.off_APP);
        this.len_APP = this.readInt(randomAccessFile);
        this.off_CCF = this.off_APP + this.len_APP + 4;
        if (!this.hasCode(randomAccessFile, this.off_CCF + 12, 1129268293)) {
            this.off_CCF = 0;
            randomAccessFile.close();
            return;
        }
        randomAccessFile.seek(this.off_CCF);
        this.len_CCF = this.readInt(randomAccessFile);
        this.off_UDB = this.off_CCF + this.len_CCF + 4;
        if (this.off_UDB > 0 && (long)this.off_UDB < l && (this.hasCode(randomAccessFile, this.off_UDB + 19, 1599423554) || this.hasCode(randomAccessFile, this.off_UDB + 12, 1129268293))) {
            randomAccessFile.seek(this.off_UDB);
            this.len_UDB = this.readInt(randomAccessFile);
        } else {
            this.off_UDB = 0;
        }
        randomAccessFile.close();
    }

    private boolean hasCode(RandomAccessFile randomAccessFile, int n, int n2) throws IOException {
        randomAccessFile.seek(n);
        return randomAccessFile.readInt() == n2;
    }

    public String getDescription() {
        return this.desc;
    }

    public String[][] getSegmentReport() {
        return new String[][]{{"BOOT", Integer.toString(this.offBOOT + 4), Integer.toString(this.lenBOOT)}, {"PSOS", Integer.toString(this.offPSOS + 4), Integer.toString(this.lenPSOS)}, {"_SYS", Integer.toString(this.off_SYS + 4), Integer.toString(this.len_SYS)}, {"_APP", Integer.toString(this.off_APP + 4), Integer.toString(this.len_APP)}, {"_CCF", Integer.toString(this.off_CCF + 4), Integer.toString(this.len_CCF)}, {"_UDB", Integer.toString(this.off_UDB + 4), Integer.toString(this.len_UDB)}};
    }

    public byte[] getBOOT() throws IOException {
        return this.lenBOOT > 0 ? this.readChunk(this.offBOOT + 4, this.lenBOOT) : null;
    }

    public byte[] getPSOS() throws IOException {
        return this.readChunk(this.offPSOS + 4, this.lenPSOS);
    }

    public byte[] get_SYS() throws IOException {
        return this.readChunk(this.off_SYS + 4, this.len_SYS);
    }

    public byte[] get_APP() throws IOException {
        return this.readChunk(this.off_APP + 4, this.len_APP);
    }

    public byte[] get_CCF() throws IOException {
        return this.len_CCF > 0 ? this.readChunk(this.off_CCF + 4, this.len_CCF) : null;
    }

    public byte[] get_UDB() throws IOException {
        return this.len_UDB > 0 ? this.readChunk(this.off_UDB + 4, this.len_UDB) : null;
    }

    public static Hashtable extractCIBs(byte[] byArray) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (byArray == null) {
            return hashtable;
        }
        byte[] byArray2 = new byte[]{46, 99, 105, 98, 0};
        CCFHeader cCFHeader = new CCFHeader();
        CCFNodeState cCFNodeState = new CCFNodeState(cCFHeader, null);
        int n = 0;
        while (n >= 0) {
            String string;
            int n2;
            if ((n = Firmware.findPattern(byArray, byArray2, n)) <= 0) continue;
            int n3 = 0;
            int n4 = n + 4;
            int n5 = 4 - n4 % 4;
            int n6 = n4 + n5;
            int n7 = (byArray[n6] & 0xFF) << 8 | byArray[n6 + 1] & 0xFF;
            int n8 = Math.max(0, n - Math.max(n7, 100));
            for (n2 = n; n2 > n8; --n2) {
                if (((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF) != n7) continue;
                n3 = n2;
                break;
            }
            String string2 = string = (n2 = n4 - n3 - 2) > 0 ? new String(byArray, n3 + 2, n4 - n3 - 2) : null;
            if (string == null || string.length() <= 4) break;
            n = n6 + n7 + 2;
            byte[] byArray3 = new byte[n7 + 2];
            System.arraycopy(byArray, n6, byArray3, 0, byArray3.length);
            try {
                cCFNodeState.setBuffer(byArray3);
                CCFIcon cCFIcon = new CCFIcon(cCFHeader);
                cCFIcon.decode(cCFNodeState);
                hashtable.put(string, cCFIcon);
            }
            catch (Exception exception) {
                System.out.println("Image decode error on '" + string + "'");
                exception.printStackTrace();
                hashtable.put(string, byArray3);
            }
        }
        return hashtable;
    }

    private static int findPattern(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        for (int i = n; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[n2]) {
                if (++n2 != byArray2.length) continue;
                return i - n2 + 1;
            }
            n2 = 0;
        }
        return -1;
    }

    private byte[] readChunk(int n, int n2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
        randomAccessFile.seek(n);
        byte[] byArray = new byte[n2];
        randomAccessFile.readFully(byArray);
        System.arraycopy(magicNew, 0, byArray, magicOffset, magicNew.length);
        return byArray;
    }

    public static void printHeader() {
        System.out.println("BOOT          PSOS          _SYS          _APP          _CCF          _UDB          Description");
    }

    public void printDetail() {
        System.out.println(Firmware.printLHex(this.offBOOT) + "," + Firmware.printRHex(this.lenBOOT) + " " + Firmware.printLHex(this.offPSOS) + "," + Firmware.printRHex(this.lenPSOS) + " " + Firmware.printLHex(this.off_SYS) + "," + Firmware.printRHex(this.len_SYS) + " " + Firmware.printLHex(this.off_APP) + "," + Firmware.printRHex(this.len_APP) + " " + Firmware.printLHex(this.off_CCF) + "," + Firmware.printRHex(this.len_CCF) + " " + Firmware.printLHex(this.off_UDB) + "," + Firmware.printRHex(this.len_UDB) + " " + this.desc);
    }

    private static String printLHex(int n) {
        return CCFNode.lpad(Integer.toHexString(n), 6);
    }

    private static String printRHex(int n) {
        return CCFNode.rpad(Integer.toHexString(n), 6);
    }

    private int readInt(RandomAccessFile randomAccessFile) throws IOException {
        return randomAccessFile.read() | randomAccessFile.read() << 8 | randomAccessFile.read() << 16 | randomAccessFile.read() << 24;
    }

    private String readString(RandomAccessFile randomAccessFile) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while ((n = randomAccessFile.read()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }
}

