/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.irdb.IRBurst;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;

class IRBurstGraph
extends JComponent {
    private IRBurst burst;
    private Dimension size;
    private int[] signal;
    private final int inset = 3;

    IRBurstGraph() {
        this.setBurst(null);
    }

    public void setBurst(IRBurst iRBurst) {
        this.burst = iRBurst;
        if (this.burst == null) {
            this.size = new Dimension(0, 30);
            this.signal = new int[0];
        } else {
            int[] nArray = this.burst.getPulseIndex().getIndexValues();
            int n = -1;
            for (int i = 0; i < nArray.length; ++i) {
                if (n != -1 && (nArray[i] >= n || nArray[i] <= 0)) continue;
                n = nArray[i];
            }
            int[] nArray2 = this.burst.getPulses();
            this.signal = new int[nArray2.length];
            int n2 = 0;
            int n3 = 0;
            int n4 = nArray.length - 1;
            for (int i = 0; i < nArray2.length; ++i) {
                this.signal[n3] = Math.min(nArray[Math.min(nArray2[i], n4)] / n + 2, 25);
                n2 += this.signal[n3++];
            }
            this.size = new Dimension(n2 + 6, 40);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.burst == null) {
            return;
        }
        int n = 3;
        int n2 = 3;
        int n3 = 3;
        int n4 = dimension.height - 1 - 3;
        for (int i = 0; i < this.signal.length; ++i) {
            graphics.drawLine(n2, n3, n2, n4);
            n2 += this.signal[i];
            if (i % 2 == 0) {
                graphics.drawLine(n, n3, n2, n3);
            } else {
                graphics.drawLine(n, n4, n2, n4);
            }
            n = n2;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }
}

