/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.IRBurstGraph;
import com.neuron.app.tonto.IRRemotePanel;
import com.neuron.app.tonto.IRSignalPanel;
import com.neuron.app.tonto.ui.AAPanel;
import com.neuron.irdb.IRBurst;
import com.neuron.irdb.IRBurstCode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class IRBurstPanel
extends AAPanel {
    private IRSignalPanel sig;
    private IRRemotePanel panel;
    private IRBurst burst;
    private IRBurstCode burstCode;
    private JTextArea pulses = new JTextArea(2, 40);
    private JTextField nbits = new JTextField(4);
    private JTextField value = new JTextField(6);
    private JTextField rbits = new JTextField();
    private JTextField bit0 = new JTextField(2);
    private JTextField bit1 = new JTextField(2);
    private JTextField head = new JTextField(2);
    private JTextField tail = new JTextField(2);
    private IRBurstGraph graph = new IRBurstGraph();

    IRBurstPanel(IRSignalPanel iRSignalPanel, IRRemotePanel iRRemotePanel) {
        this.sig = iRSignalPanel;
        this.panel = iRRemotePanel;
        JLabel jLabel = new JLabel("Pulses", 4);
        JLabel jLabel2 = new JLabel("NumBits", 4);
        JLabel jLabel3 = new JLabel("HexValue", 4);
        JLabel jLabel4 = new JLabel("BitValue", 4);
        JLabel jLabel5 = new JLabel("Bit-0", 4);
        JLabel jLabel6 = new JLabel("Bit-1", 4);
        JLabel jLabel7 = new JLabel("Head", 4);
        JLabel jLabel8 = new JLabel("Tail", 4);
        JLabel jLabel9 = new JLabel("Graph", 4);
        this.pulses.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.pulses, 22, 31);
        this.define('P', jLabel, "pad=3,3,3,3;fill=b");
        this.define('N', jLabel2, "pad=3,3,3,3;fill=b");
        this.define('V', jLabel3, "pad=3,3,3,3;fill=b");
        this.define('R', jLabel4, "pad=3,3,3,3;fill=b");
        this.define('2', jLabel5, "pad=3,3,3,3;fill=b");
        this.define('3', jLabel6, "pad=3,3,3,3;fill=b");
        this.define('H', jLabel7, "pad=3,3,3,3;fill=b");
        this.define('T', jLabel8, "pad=3,3,3,3;fill=b");
        this.define('G', jLabel9, "pad=3,3,3,3;fill=b");
        this.define('p', jScrollPane, "pad=3,3,3,3;fill=b;wx=1;wy=1");
        this.define('n', this.nbits, "pad=3,3,3,3;fill=b;wx=1");
        this.define('v', this.value, "pad=3,3,3,3;fill=b;wx=1");
        this.define('r', this.rbits, "pad=3,3,3,3;fill=b;wx=1");
        this.define('0', this.bit0, "pad=3,3,3,3;fill=b;wx=1");
        this.define('1', this.bit1, "pad=3,3,3,3;fill=b;wx=1");
        this.define('h', this.head, "pad=3,3,3,3;fill=b;wx=1");
        this.define('t', this.tail, "pad=3,3,3,3;fill=b;wx=1");
        this.define('g', this.graph, "pad=3,3,3,3;fill=b;wx=1");
        this.setLayout(new String[]{"P pppppppppppp", "N nn 2 00 3 11", "V vv H hh T tt", "R rrrrrrrrrrrr", "G gggggggggggg"});
        this.pulses.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            1.sleep(150L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        IRBurstPanel.this.updateFromPulses();
                    }
                }.start();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IRBurstPanel.this.updateFromCode();
            }
        };
        this.nbits.addActionListener(actionListener);
        this.value.addActionListener(actionListener);
        this.bit0.addActionListener(actionListener);
        this.bit1.addActionListener(actionListener);
        this.head.addActionListener(actionListener);
        this.tail.addActionListener(actionListener);
        this.rbits.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IRBurstPanel.this.updateFromRawBits();
            }
        });
    }

    void refresh() {
        this.setBurst(this.burst);
    }

    void setBurst(IRBurst iRBurst) {
        this.burst = iRBurst;
        if (iRBurst != null) {
            this.pulses.setText(iRBurst.toString());
            this.updateFromPulses();
            this.graph.setBurst(iRBurst);
        } else {
            this.graph.setBurst(null);
        }
    }

    void updateFromPulses() {
        this.burst.decodePulseString(this.pulses.getText());
        this.graph.setBurst(this.burst);
        this.burstCode = this.burst.getBurstCode();
        if (this.burstCode != null) {
            this.updateBurstCodeFields();
            if (this.panel != null) {
                this.panel.refresh();
            }
        } else {
            this.nbits.setText("");
            this.value.setText("");
            this.rbits.setText("");
            this.bit0.setText("");
            this.bit1.setText("");
            this.head.setText("");
            this.tail.setText("");
        }
    }

    void updateBurstCodeFields() {
        this.nbits.setText(this.burstCode.getBitCount() + "");
        this.value.setText(Long.toHexString(this.burstCode.getValue()));
        this.rbits.setText(this.burstCode.getBitString());
        this.bit0.setText(this.burstCode.getBit0().toString());
        this.bit1.setText(this.burstCode.getBit1().toString());
        this.head.setText(this.burstCode.getHeadString());
        this.tail.setText(this.burstCode.getTailString());
    }

    void updateFromCode() {
        if (this.burstCode == null) {
            this.burstCode = new IRBurstCode(this.burst);
        }
        this.burstCode.setBitCount(Integer.parseInt(this.nbits.getText()));
        this.burstCode.setValue(Long.parseLong(this.value.getText(), 16));
        this.burstCode.setBit0(IRBurstCode.parsePulsePair(this.bit0.getText()));
        this.burstCode.setBit1(IRBurstCode.parsePulsePair(this.bit1.getText()));
        this.burstCode.setHead(IRBurstCode.parsePulsePairs(this.head.getText()));
        this.burstCode.setTail(IRBurstCode.parsePulsePairs(this.tail.getText()));
        this.burst.setPulses(this.burstCode.getIRBurst().getPulses());
        this.setBurst(this.burst);
    }

    void updateFromRawBits() {
        if (this.burstCode == null) {
            this.burstCode = new IRBurstCode(this.burst);
        }
        String string = this.rbits.getText().trim();
        this.burstCode.setBitCount(string.length());
        this.burstCode.setValue(IRBurstCode.decodeBitString(string));
        this.updateBurstCodeFields();
        this.burst.setPulses(this.burstCode.getIRBurst().getPulses());
        this.setBurst(this.burst);
    }
}

