/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.IRDBPanel;
import com.neuron.app.tonto.IRRemotePanel;
import com.neuron.app.tonto.IRSignalPanel;
import com.neuron.app.tonto.ui.StackedDialog;
import com.neuron.irdb.IRRemote;
import com.neuron.irdb.IRSignal;
import javax.swing.JDialog;
import javax.swing.JSplitPane;

class IRDBDialog
extends StackedDialog {
    private IRDBPanel db = new IRDBPanel(this);
    private IRRemotePanel remote = new IRRemotePanel(this);
    private IRSignalPanel signal = new IRSignalPanel(this.remote);
    private JSplitPane ud = new JSplitPane(0, this.db, this.remote);
    private JSplitPane lr = new JSplitPane(1, this.ud, this.signal);

    IRDBDialog() {
        super("IR Database", false);
        this.ud.setOneTouchExpandable(true);
        this.lr.setOneTouchExpandable(true);
        this.setContentPane(this.lr);
    }

    @Override
    public void showHook(JDialog jDialog) {
        jDialog.setSize(800, 600);
        this.ud.setDividerLocation(250);
        this.lr.setDividerLocation(400);
    }

    void edit(IRRemote iRRemote) {
        this.remote.setRemote(iRRemote);
    }

    void edit(IRSignal iRSignal) {
        this.signal.setSignal(iRSignal);
    }

    void refresh() {
        this.db.refresh();
        this.remote.refresh();
        this.signal.refresh();
    }

    void refreshDB() {
        this.db.refresh();
    }

    void refreshRemotes() {
        this.remote.refresh();
    }
}

