/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFWalker;
import com.neuron.app.tonto.IRDBDialog;
import com.neuron.app.tonto.IRDBTable;
import com.neuron.app.tonto.Tonto;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.ui.AAPanel;
import com.neuron.app.tonto.ui.ActionButton;
import com.neuron.irdb.IRDatabase;
import com.neuron.irdb.IRRemote;
import com.neuron.irdb.IRSignal;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;

class IRDBPanel
extends AAPanel {
    private IRDatabase db;
    private IRDBTable tabl;
    private IRDBDialog dialog;

    IRDBPanel(IRDBDialog iRDBDialog) {
        this.dialog = iRDBDialog;
        try {
            this.db = Tonto.database();
        }
        catch (Exception exception) {
            Tonto.errorDialog(exception);
        }
        ActionButton actionButton = new ActionButton("CCF Import"){

            @Override
            public void action() {
                if (Tonto.ccf() == null) {
                    Tonto.errorDialog("Make sure a CCF is loaded first");
                    return;
                }
                try {
                    CCFWalker.irex(Tonto.ccf(), IRDBPanel.this.db);
                }
                catch (Exception exception) {
                    Tonto.errorDialog(exception);
                }
                IRDBPanel.this.tabl.refresh();
            }
        };
        ActionButton actionButton2 = new ActionButton("Add"){

            @Override
            public void action() {
                IRDBPanel.this.db.add(new IRRemote("NewModel", "unknown", "New Remote Model"));
                IRDBPanel.this.tabl.refresh();
                IRDBPanel.this.tabl.edit(IRDBPanel.this.db.size() - 1);
            }
        };
        ActionButton actionButton3 = new ActionButton("Dup"){

            @Override
            public void action() {
                int n = IRDBPanel.this.tabl.getSelectedRow();
                if (n >= 0) {
                    IRRemote iRRemote = IRDBPanel.this.db.getByIndex(n);
                    IRRemote iRRemote2 = new IRRemote(iRRemote.getModel(), iRRemote.getCompany(), "Copy " + iRRemote.getDescription());
                    Enumeration enumeration = iRRemote.getKeys();
                    while (enumeration.hasMoreElements()) {
                        iRRemote2.add(((IRSignal)enumeration.nextElement()).getClone());
                    }
                    IRDBPanel.this.db.add(iRRemote2);
                    IRDBPanel.this.tabl.refresh();
                    IRDBPanel.this.edit(iRRemote2);
                }
            }
        };
        ActionButton actionButton4 = new ActionButton("Delete"){

            @Override
            public void action() {
                int n = IRDBPanel.this.tabl.getSelectedRow();
                if (n < 0 || n >= IRDBPanel.this.db.size()) {
                    return;
                }
                IRDBPanel.this.db.remove(IRDBPanel.this.db.getByIndex(n));
                IRDBPanel.this.tabl.refresh();
                IRDBPanel.this.edit(null);
            }
        };
        ActionButton actionButton5 = new ActionButton("Clear"){

            @Override
            public void action() {
                IRDBPanel.this.clear();
            }
        };
        ActionButton actionButton6 = new ActionButton("Load"){

            @Override
            public void action() {
                File file = Tonto.getFile(true, "irdb (*.db)", new String[]{"db"});
                if (file == null || !file.exists()) {
                    return;
                }
                try {
                    IRDBPanel.this.db.read(file.toString());
                }
                catch (Exception exception) {
                    Tonto.errorDialog(exception);
                }
                IRDBPanel.this.tabl.refresh();
            }
        };
        ActionButton actionButton7 = new ActionButton("Save"){

            @Override
            public void action() {
                File file = Tonto.getFile(false, "irdb (*.db)", new String[]{"db"});
                if (file == null) {
                    return;
                }
                try {
                    String string = file.toString();
                    if (!string.toLowerCase().endsWith(".db")) {
                        string = string + ".db";
                    }
                    IRDBPanel.this.db.write(string);
                }
                catch (Exception exception) {
                    Tonto.errorDialog(exception);
                }
            }
        };
        this.tabl = new IRDBTable(this, this.db);
        this.tabl.setBorder(new EtchedBorder(1));
        JScrollPane jScrollPane = new JScrollPane(this.tabl);
        JLabel jLabel = new JLabel("Remote Control List", 0);
        JPanel jPanel = Util.panelWrap(jLabel);
        jPanel.setBackground(Color.darkGray);
        jLabel.setForeground(Color.white);
        jLabel.setFont(new Font("sansserif", 1, 14));
        this.define('T', jPanel, "pad=3,3,3,3;wx=1;fill=b;ix=2;iy=2");
        this.define('+', "pad=3,3,3,3");
        this.define('-', "pad=3,3,3,3");
        this.define('e', actionButton3, "pad=3,3,3,3");
        this.define('a', actionButton2, "pad=3,3,3,3");
        this.define('d', actionButton4, "pad=3,3,3,3");
        this.define('l', actionButton6, "pad=3,3,3,3");
        this.define('c', actionButton5, "pad=3,3,3,3");
        this.define('i', actionButton, "pad=3,3,3,3");
        this.define('s', actionButton7, "pad=3,3,3,3");
        this.define('t', jScrollPane, "fill=b;wx=1;wy=1;pad=3,3,3,3");
        this.setLayout(new String[]{"TTTTTTTT", "--------", "- aedi -", "--------", "tttttttt", "++++++++", "+ lcs  +", "++++++++"});
    }

    @Override
    public void clear() {
        this.db.clear();
        this.refresh();
    }

    public void edit(IRRemote iRRemote) {
        this.dialog.edit(iRRemote);
    }

    public void refresh() {
        this.tabl.refresh();
    }
}

