/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.IRDBPanel;
import com.neuron.app.tonto.RunInThread;
import com.neuron.irdb.IRDatabase;
import com.neuron.irdb.IRRemote;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

class IRDBTable
extends JTable {
    private IRDBPanel panel;
    private IRDatabase db;
    private AbstractTableModel model;
    private int lastIdx;

    IRDBTable(IRDBPanel iRDBPanel, IRDatabase iRDatabase) {
        this.panel = iRDBPanel;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                IRDBTable.this.edit(IRDBTable.this.getSelectedRow());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                new RunInThread(){

                    @Override
                    public void runIn() throws Exception {
                        1.sleep(250L);
                        IRDBTable.this.edit(IRDBTable.this.getSelectedRow());
                    }
                }.start();
            }
        });
        this.model = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                IRDatabase iRDatabase = IRDBTable.this.database();
                if (iRDatabase == null) {
                    return 0;
                }
                return iRDatabase.size();
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "Model";
                    }
                    case 1: {
                        return "Company";
                    }
                    case 2: {
                        return "Description";
                    }
                }
                return "invalid";
            }

            @Override
            public Object getValueAt(int n, int n2) {
                IRDatabase iRDatabase = IRDBTable.this.database();
                if (iRDatabase == null) {
                    return null;
                }
                IRRemote iRRemote = iRDatabase.getByIndex(n);
                switch (n2) {
                    case 0: {
                        return iRRemote.getModel();
                    }
                    case 1: {
                        return iRRemote.getCompany();
                    }
                    case 2: {
                        return iRRemote.getDescription();
                    }
                }
                return "invalid";
            }
        };
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.setDatabase(iRDatabase);
    }

    IRDatabase database() {
        return this.db;
    }

    void setDatabase(IRDatabase iRDatabase) {
        this.db = iRDatabase;
        this.refresh();
    }

    void refresh() {
        this.model.fireTableDataChanged();
        this.getSelectionModel().setSelectionInterval(this.lastIdx, this.lastIdx);
    }

    void edit(int n) {
        this.lastIdx = n;
        if (n >= 0) {
            this.panel.edit(this.db.getByIndex(n));
        } else {
            this.panel.edit(null);
        }
    }
}

