/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.ActionIRCode;
import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFFont;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFIconSet;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.IRDBDialog;
import com.neuron.app.tonto.IRRemoteTable;
import com.neuron.app.tonto.Tonto;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.ui.AAPanel;
import com.neuron.app.tonto.ui.ActionButton;
import com.neuron.irdb.IRRemote;
import com.neuron.irdb.IRSignal;
import com.neuron.irdb.impl.Pronto;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

class IRRemotePanel
extends AAPanel {
    private IRDBDialog dialog;
    private IRRemote remote;
    private IRRemoteTable tabl;
    private JTextField model = new JTextField();
    private JTextField comp = new JTextField();
    private JTextField desc = new JTextField();

    IRRemote remote() {
        return this.remote;
    }

    IRRemotePanel(IRDBDialog iRDBDialog) {
        this.dialog = iRDBDialog;
        JLabel jLabel = new JLabel("Model", 4);
        JLabel jLabel2 = new JLabel("Company", 4);
        JLabel jLabel3 = new JLabel("Description", 4);
        ActionButton actionButton = new ActionButton("Add"){

            @Override
            public void action() {
                IRSignal iRSignal = new IRSignal();
                iRSignal.setName("newKey");
                IRRemotePanel.this.remote().add(iRSignal);
                IRRemotePanel.this.tabl.refresh();
                IRRemotePanel.this.tabl.edit(IRRemotePanel.this.remote().numKeys() - 1);
            }
        };
        ActionButton actionButton2 = new ActionButton("Dup"){

            @Override
            public void action() {
                int n = IRRemotePanel.this.tabl.getSelectedRow();
                if (n >= 0) {
                    IRSignal iRSignal = IRRemotePanel.this.remote().getByIndex(n);
                    iRSignal = iRSignal.getClone();
                    iRSignal.setName("Copy_" + iRSignal.getName());
                    IRRemotePanel.this.remote().add(iRSignal);
                    IRRemotePanel.this.tabl.refresh();
                    IRRemotePanel.this.tabl.edit(IRRemotePanel.this.remote().numKeys() - 1);
                }
            }
        };
        ActionButton actionButton3 = new ActionButton("Delete"){

            @Override
            public void action() {
                int n = IRRemotePanel.this.tabl.getSelectedRow();
                if (n < 0 || n >= IRRemotePanel.this.remote().numKeys()) {
                    return;
                }
                IRRemotePanel.this.remote().remove(n);
                IRRemotePanel.this.tabl.refresh();
                IRRemotePanel.this.edit(null);
            }
        };
        ActionButton actionButton4 = new ActionButton("Cleanup"){

            @Override
            public void action() {
                IRRemotePanel.this.cleanup();
            }
        };
        ActionButton actionButton5 = new ActionButton("Create IR Panel"){

            @Override
            public void action() {
                if (Tonto.device() == null) {
                    Tonto.errorDialog("Please select a device or panel in the tree");
                    return;
                }
                IRRemotePanel.this.createIRPanels(Tonto.device());
            }
        };
        this.tabl = new IRRemoteTable(this);
        this.tabl.setBorder(new EtchedBorder(1));
        JScrollPane jScrollPane = new JScrollPane(this.tabl);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IRRemotePanel.this.updateDB();
            }
        };
        this.model.addActionListener(actionListener);
        this.comp.addActionListener(actionListener);
        this.desc.addActionListener(actionListener);
        JLabel jLabel4 = new JLabel("Remote Keys", 0);
        JPanel jPanel = Util.panelWrap(jLabel4);
        jPanel.setBackground(Color.darkGray);
        jLabel4.setForeground(Color.white);
        jLabel4.setFont(new Font("sansserif", 1, 14));
        this.define('T', jPanel, "pad=3,3,3,3;wx=1;fill=b;ix=2;iy=2");
        this.define('1', jLabel, "pad=3,3,3,3;fill=b");
        this.define('2', jLabel2, "pad=3,3,3,3;fill=b");
        this.define('3', jLabel3, "pad=3,3,3,3;fill=b");
        this.define('4', this.model, "pad=3,3,3,3;wx=1;fill=b");
        this.define('5', this.comp, "pad=3,3,3,3;wx=1;fill=b");
        this.define('6', this.desc, "pad=3,3,3,3;wx=1;fill=b");
        this.define('+', "pad=3,3,3,3;wx=1;fill=b");
        this.define('.', "pad=3,3,3,3");
        this.define(',', "pad=3,3,3,3");
        this.define('t', jScrollPane, "fill=b;wx=1;wy=1;pad=3,3,3,3");
        this.define('a', actionButton, "pad=3,3,3,3");
        this.define('e', actionButton2, "pad=3,3,3,3");
        this.define('d', actionButton3, "pad=3,3,3,3");
        this.define('C', actionButton4, "pad=3,3,5,3");
        this.define('P', actionButton5, "pad=3,3,3,3");
        this.setLayout(new String[]{"TTTTTTTTT", "++++++++", "+ 1 44 +", "+ 2 55 +", "+ 3 66 +", "++++++++", "........", ". aedp .", "........", "tttttttt", ",,,,,,,,", ",  CP  ,", ",,,,,,,,"});
        this.enable(false);
    }

    void createIRPanels(CCFDevice cCFDevice) {
        int n = this.remote.numKeys();
        double d = Math.sqrt((double)n / 2.0);
        int n2 = (int)d;
        int n3 = (int)((double)n / d);
        while (n3 * n2 < n) {
            ++n3;
        }
        Dimension dimension = Tonto.panelSize();
        int n4 = (dimension.width - 1) / n2;
        int n5 = (dimension.height - 1) / n3;
        String string = this.remote.getModel();
        CCFPanel cCFPanel = cCFDevice.createPanel(string);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2 && n6 < n; ++n6, ++j) {
                IRSignal iRSignal = this.remote.getByIndex(n6);
                CCFButton cCFButton = cCFPanel.createButton(iRSignal.getName());
                cCFButton.setLocation(new Point(j * n4 + 1, i * n5 + 1));
                cCFButton.setSize(new Dimension(n4 - 1, n5 - 1));
                cCFButton.setFont(CCFFont.SIZE_8);
                CCFIconSet cCFIconSet = cCFButton.getIconSet();
                boolean bl = Tonto.color();
                cCFIconSet.setBackground(2, CCFColor.getNamedColor(0, bl));
                cCFIconSet.setForeground(2, CCFColor.getNamedColor(3, bl));
                CCFActionList cCFActionList = new CCFActionList();
                cCFActionList.setActions(new CCFAction[]{new ActionIRCode(new CCFIRCode(Tonto.ccf().header(), iRSignal.getName(), new Pronto(iRSignal).encode(Tonto.irVersion())))});
                cCFButton.setActionList(cCFActionList);
                cCFPanel.addButton(cCFButton);
            }
        }
        cCFDevice.addPanel(cCFPanel);
        Tonto.state().refreshTreeDevice(cCFDevice);
        Tonto.infoDialog("Created '" + string + "' panel in device '" + cCFDevice.getName() + "'");
    }

    void edit(IRSignal iRSignal) {
        this.dialog.edit(iRSignal);
    }

    void setRemote(IRRemote iRRemote) {
        this.remote = iRRemote;
        if (iRRemote != null) {
            this.enable(true);
            this.model.setText(iRRemote.getModel());
            this.comp.setText(iRRemote.getCompany());
            this.desc.setText(iRRemote.getDescription());
            this.tabl.setRemote(iRRemote);
        } else {
            this.tabl.setRemote(null);
            this.enable(false);
            this.clear();
        }
    }

    void updateDB() {
        this.remote.setModel(this.model.getText());
        this.remote.setCompany(this.comp.getText());
        this.remote.setDescription(this.desc.getText());
        this.refresh();
    }

    void cleanup() {
        Enumeration enumeration = this.remote.getKeys();
        while (enumeration.hasMoreElements()) {
            ((IRSignal)enumeration.nextElement()).cleanup();
        }
        this.tabl.refresh();
        this.dialog.refresh();
    }

    void refresh() {
        this.tabl.refresh();
        this.dialog.refreshDB();
    }
}

