/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.IRRemotePanel;
import com.neuron.app.tonto.RunInThread;
import com.neuron.irdb.IRBurst;
import com.neuron.irdb.IRBurstCode;
import com.neuron.irdb.IRRemote;
import com.neuron.irdb.IRSignal;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

class IRRemoteTable
extends JTable {
    private IRRemotePanel panel;
    private IRRemote remote;
    private AbstractTableModel model;
    private int lastIdx;
    private int lastCol = -1;
    private boolean reverse = false;

    IRRemoteTable(IRRemotePanel iRRemotePanel) {
        this.panel = iRRemotePanel;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                IRRemoteTable.this.edit(IRRemoteTable.this.getSelectedRow());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                new RunInThread(){

                    @Override
                    public void runIn() throws Exception {
                        1.sleep(250L);
                        IRRemoteTable.this.edit(IRRemoteTable.this.getSelectedRow());
                    }
                }.start();
            }
        });
        this.model = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public int getRowCount() {
                IRRemote iRRemote = IRRemoteTable.this.remote();
                return iRRemote != null ? iRRemote.numKeys() : 0;
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return "Key";
                    }
                    case 1: {
                        return "Frequency";
                    }
                    case 2: {
                        return "PulseIndex";
                    }
                    case 3: {
                        return "Intro";
                    }
                    case 4: {
                        return "Repeat";
                    }
                }
                return "invalid";
            }

            @Override
            public Object getValueAt(int n, int n2) {
                IRSignal iRSignal = IRRemoteTable.this.remote().getByIndex(n);
                switch (n2) {
                    case 0: {
                        return iRSignal.getName();
                    }
                    case 1: {
                        return iRSignal.getFrequency() + "";
                    }
                    case 2: {
                        return iRSignal.getPulseIndex().toString();
                    }
                    case 3: {
                        return IRRemoteTable.this.printBurst(iRSignal.getIntro());
                    }
                    case 4: {
                        return IRRemoteTable.this.printBurst(iRSignal.getRepeat());
                    }
                }
                return "invalid";
            }
        };
        this.setModel(this.model);
        this.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(125);
        tableColumnModel.getColumn(1).setPreferredWidth(75);
        tableColumnModel.getColumn(2).setPreferredWidth(150);
        tableColumnModel.getColumn(3).setPreferredWidth(150);
        tableColumnModel.getColumn(4).setPreferredWidth(300);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                IRRemoteTable.this.sort(IRRemoteTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint()));
            }
        });
    }

    private void sort(int n) {
        this.reverse = n == this.lastCol ? !this.reverse : false;
        switch (n) {
            case 0: {
                this.remote.sort(1, this.reverse);
                break;
            }
            case 3: {
                this.remote.sort(2, this.reverse);
                break;
            }
            case 4: {
                this.remote.sort(3, this.reverse);
                break;
            }
            default: {
                return;
            }
        }
        this.lastCol = n;
        this.refresh();
    }

    private String printBurst(IRBurst iRBurst) {
        IRBurstCode iRBurstCode = iRBurst.getBurstCode();
        return iRBurstCode != null ? iRBurstCode.toShortString() : iRBurst.toString();
    }

    IRRemote remote() {
        return this.remote;
    }

    void setRemote(IRRemote iRRemote) {
        this.remote = iRRemote;
        this.edit(-1);
        this.refresh();
    }

    void refresh() {
        this.model.fireTableDataChanged();
        this.getSelectionModel().setSelectionInterval(this.lastIdx, this.lastIdx);
    }

    void edit(int n) {
        if (n == this.lastIdx) {
            return;
        }
        this.lastIdx = n;
        if (n >= 0) {
            this.panel.edit(this.remote.getByIndex(n));
        } else {
            this.panel.edit(null);
        }
    }
}

