/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.IRBurstPanel;
import com.neuron.app.tonto.IRRemotePanel;
import com.neuron.app.tonto.Tonto;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.ui.AAPanel;
import com.neuron.app.tonto.ui.ActionButton;
import com.neuron.irdb.IRSignal;
import com.neuron.irdb.PulseIndex;
import com.neuron.irdb.impl.Pronto;
import java.awt.Color;
import java.awt.Font;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class IRSignalPanel
extends AAPanel {
    private IRRemotePanel panel;
    private IRSignal sig;
    private JTextField name = new JTextField();
    private JTextField indx = new JTextField();
    private JTextField freq = new JTextField(5);
    private JTextField rept = new JTextField(3);
    private JComboBox type = new JComboBox();
    private IRBurstPanel intro;
    private IRBurstPanel repeat;
    private JButton learn;
    private JButton clean;

    IRSignalPanel() {
        this((IRRemotePanel)null);
    }

    IRSignalPanel(IRRemotePanel iRRemotePanel) {
        this.panel = iRRemotePanel;
        JLabel jLabel = new JLabel("Name", 4);
        JLabel jLabel2 = new JLabel("Frequency", 4);
        JLabel jLabel3 = new JLabel("Repeats", 4);
        JLabel jLabel4 = new JLabel("Index", 4);
        this.intro = new IRBurstPanel(this, iRRemotePanel);
        this.repeat = new IRBurstPanel(this, iRRemotePanel);
        this.type.addItem("Normal");
        this.type.addItem("Full");
        this.type.addItem("Once");
        JLabel jLabel5 = new JLabel("IR Signal", 0);
        JPanel jPanel = Util.panelWrap(jLabel5);
        jPanel.setBackground(Color.darkGray);
        jLabel5.setForeground(Color.white);
        jLabel5.setFont(new Font("sansserif", 1, 14));
        this.learn = new ActionButton("Learn"){

            @Override
            public void action() {
                IRSignalPanel.this.learn();
            }
        };
        this.clean = new ActionButton("Cleanup"){

            @Override
            public void action() {
                IRSignalPanel.this.cleanup();
            }
        };
        if (iRRemotePanel != null) {
            this.define('T', jPanel, "pad=3,3,3,3;wx=1;fill=b;ix=2;iy=2");
            this.define('N', jLabel, "pad=3,3,3,3;fill=b");
            this.define('n', this.name, "pad=3,3,3,3;fill=b;wx=1");
            this.define('l', this.learn, "pad=3,3,5,3");
            this.define('c', this.clean, "pad=3,3,5,3");
            this.define('-', "pad=0,0,0,0");
        }
        this.define('I', jLabel4, "pad=3,3,3,3;fill=b");
        this.define('F', jLabel2, "pad=3,3,3,3;fill=b");
        this.define('R', jLabel3, "pad=3,3,3,3;fill=b");
        this.define('i', this.indx, "pad=3,3,3,3;fill=b;wx=1");
        this.define('f', this.freq, "pad=3,3,3,3;fill=b;wx=1");
        this.define('r', this.rept, "pad=3,3,3,3;fill=b;wx=1");
        this.define('t', this.type, "pad=3,3,3,3;fill=b;wx=1");
        this.define('1', this.intro, "pad=3,3,3,3;fill=b;wx=1;wy=1");
        this.define('2', this.repeat, "pad=3,3,3,3;fill=b;wx=1;wy=1");
        Util.setLabelBorder("Intro Signal", this.intro);
        Util.setLabelBorder("Body Signal", this.repeat);
        this.setLayout(new String[]{"TTTTTTTTTTTTTTTTT", "NN nnnnnnnnnnnnnn", "FF ffff RR rr ttt", "II iiiiiiiiiiiiii", "11111111111111111", "22222222222222222", "-----------------", "- llllll cccccc -", "-----------------"});
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IRSignalPanel.this.updateSig();
                IRSignalPanel.this.updateDB();
            }
        };
        this.name.addActionListener(actionListener);
        this.indx.addActionListener(actionListener);
        this.freq.addActionListener(actionListener);
        this.rept.addActionListener(actionListener);
        this.type.addActionListener(actionListener);
        this.enable(false);
    }

    public void learn() {
        Pronto pronto = Tonto.learnIR();
        if (pronto != null) {
            String string = this.sig.getName();
            this.sig.copyFrom(pronto);
            this.sig.setName(string);
            this.refresh();
            this.intro.setBurst(this.sig.getIntro());
            this.repeat.setBurst(this.sig.getRepeat());
        }
    }

    public void updateDB() {
        if (this.panel != null) {
            this.panel.updateDB();
        }
    }

    public void updateSig() {
        this.sig.setName(this.name.getText());
        this.sig.setFrequency(Integer.parseInt(this.freq.getText().trim()));
        this.sig.setMinRepeat(Integer.parseInt(this.rept.getText().trim()));
        this.sig.setPulseIndex(PulseIndex.parseIndexString(this.indx.getText().trim()));
        this.sig.setRepeatType(this.type.getSelectedIndex());
    }

    public void refresh() {
        if (this.sig != null) {
            this.enable(true);
            this.name.setText(this.sig.getName());
            this.freq.setText(this.sig.getFrequency() + "");
            this.rept.setText(this.sig.getMinRepeat() + "");
            this.indx.setText(this.sig.getPulseIndex().toString());
            this.getToolkit().getSystemClipboard().setContents(new StringSelection(new Pronto(this.sig).encode()), null);
            this.intro.setBurst(this.sig.getIntro());
            this.repeat.setBurst(this.sig.getRepeat());
            this.type.setSelectedIndex(this.sig.getRepeatType());
        } else {
            this.enable(false);
            this.clear();
            this.intro.setBurst(null);
            this.repeat.setBurst(null);
        }
    }

    void setSignal(IRSignal iRSignal) {
        this.sig = iRSignal;
        this.refresh();
    }

    void cleanup() {
        this.sig.cleanup();
        this.refresh();
    }

    IRSignal getSignal() {
        return this.sig;
    }
}

