/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.Comm;
import com.neuron.app.tonto.ICommSerialPortID;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.Tonto;
import java.util.Enumeration;
import java.util.Vector;

class PortProbe {
    private Comm found;
    private int spawn;
    private UnsatisfiedLinkError error;
    private Vector threads = new Vector();

    PortProbe() throws Exception {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PortProbe(ICommSerialPortID iCommSerialPortID) throws Exception {
        final PortProbe portProbe = this;
        ICommSerialPortID[] iCommSerialPortIDArray = Comm.getSerialPorts();
        ITaskStatus iTaskStatus = new ITaskStatus(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void taskStatus(int n, String string) {
                PortProbe portProbe2 = portProbe;
                synchronized (portProbe2) {
                    if (--PortProbe.this.spawn == 0 || PortProbe.this.found != null) {
                        portProbe.notify();
                    }
                }
            }

            @Override
            public void taskError(Throwable throwable) {
                PortProbe.this.error = (UnsatisfiedLinkError)throwable;
            }

            @Override
            public void taskNotify(Object object) {
                PortProbe.this.found = (Comm)object;
            }
        };
        if (!Tonto.canScanThreaded()) {
            Comm.debug.log(0, "Using serialized port scan");
            for (int i = 0; i < iCommSerialPortIDArray.length; ++i) {
                ICommSerialPortID iCommSerialPortID2 = iCommSerialPortIDArray[i];
                if (!iCommSerialPortID2.isCurrentlyOwned()) {
                    try {
                        this.found = Comm.detectPronto(iCommSerialPortID2);
                        if (this.found == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                }
                Comm.debug.log(1, "port '" + iCommSerialPortID2 + "' in use");
            }
            return;
        }
        PortProbe portProbe2 = portProbe;
        synchronized (portProbe2) {
            this.spawn = iCommSerialPortIDArray.length;
            if (iCommSerialPortID != null) {
                ++this.spawn;
                Comm.debug.log(1, "Comm probe default " + iCommSerialPortID.getName());
                this.threads.add(new Detector(iTaskStatus, iCommSerialPortID));
            }
            for (int i = 0; i < iCommSerialPortIDArray.length; ++i) {
                if (iCommSerialPortIDArray[i] == iCommSerialPortID) {
                    --this.spawn;
                    continue;
                }
                ICommSerialPortID iCommSerialPortID3 = iCommSerialPortIDArray[i];
                Comm.debug.log(1, "Comm probe " + iCommSerialPortID3.getName());
                this.threads.add(new Detector(iTaskStatus, iCommSerialPortID3));
            }
        }
    }

    private void killall() {
        Enumeration enumeration = this.threads.elements();
        while (enumeration.hasMoreElements()) {
            ((Detector)enumeration.nextElement()).interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comm getComm() throws Exception {
        PortProbe portProbe = this;
        synchronized (portProbe) {
            if (this.spawn <= 0) {
                return this.found;
            }
            if (this.error != null) {
                this.killall();
                throw this.error;
            }
            this.wait();
            this.killall();
            return this.found;
        }
    }

    private class Detector
    extends Thread {
        private ITaskStatus target;
        private ICommSerialPortID id;

        Detector(ITaskStatus iTaskStatus, ICommSerialPortID iCommSerialPortID) {
            this.target = iTaskStatus;
            this.id = iCommSerialPortID;
            this.start();
        }

        @Override
        public void run() {
            if (this.id.isCurrentlyOwned()) {
                Comm.debug.log(1, this.id.getName() + " is in use by another program");
                this.target.taskStatus(0, "Port in use");
            }
            try {
                this.target.taskNotify(Comm.detectPronto(this.id));
                this.target.taskStatus(0, "Port found");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.target.taskError(unsatisfiedLinkError);
                this.target.taskStatus(0, "No Serial Communication Library");
            }
            catch (Throwable throwable) {
                this.target.taskStatus(0, throwable.toString());
            }
        }
    }
}

