/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;

class Preferences
extends Properties {
    Preferences() {
    }

    public void load(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        this.load(new FileInputStream(file));
    }

    public void save(File file) throws IOException {
        this.store(new FileOutputStream(file), "Tonto Preferences");
    }

    public Rectangle getRectangle(String string, Rectangle rectangle) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return rectangle;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        return new Rectangle(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
    }

    public Dimension getDimension(String string, Dimension dimension) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return dimension;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        return new Dimension(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
    }

    public int getInteger(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public double getDouble(String string, double d) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return d;
        }
        return Double.parseDouble(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equalsIgnoreCase("true");
    }

    @Override
    public Object setProperty(String string, String string2) {
        if (string2 == null) {
            this.remove(string);
            return null;
        }
        return super.setProperty(string, string2);
    }

    public void setProperty(String string, Rectangle rectangle) {
        this.put(string, rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height);
    }

    public void setProperty(String string, Dimension dimension) {
        this.put(string, dimension.width + "," + dimension.height);
    }

    public void setProperty(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public void setProperty(String string, double d) {
        this.put(string, Double.toString(d));
    }

    public void setProperty(String string, boolean bl) {
        this.put(string, bl ? "true" : "false");
    }
}

