/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import java.awt.Dimension;
import java.util.Vector;

public class ProntoModel {
    public static final int CUSTOM = 0;
    public static final int TS1000 = 1;
    public static final int TSU2000 = 2;
    public static final int TSU6000 = 3;
    public static final int RC5000 = 4;
    public static final int RC5000i = 5;
    public static final int RC5200 = 6;
    public static final int RC9200 = 7;
    public static final int RU890 = 8;
    public static final int RU940 = 9;
    public static final int RU970 = 10;
    public static final int USR5 = 11;
    public static final int RAV2K = 12;
    public static final int RAV2KZ1 = 13;
    private static final ProntoModel[] units = new ProntoModel[]{new ProntoModel(4, "RC5000", 1, 380, 240, 220), new ProntoModel(5, "RC5000i", 1, 1404, 240, 220), new ProntoModel(6, "RC5200", 2561, 1220, 240, 270), new ProntoModel(7, "RC9200", 2817, 6900, 240, 270), new ProntoModel(1, "TS1000", 131073, 380, 240, 220), new ProntoModel(2, "TSU2000", 393217, 960, 240, 220), new ProntoModel(3, "TSU6000", 393985, 5952, 240, 220), new ProntoModel(8, "RU890", 131073, 380, 240, 220), new ProntoModel(9, "RU940", 131073, 1404, 240, 220), new ProntoModel(10, "RU970", 393985, 5667, 240, 220), new ProntoModel(11, "USR5", 393729, 697, 240, 220), new ProntoModel(12, "RAV2000", 393217, 444, 240, 220), new ProntoModel(13, "RAV2000Z", 393217, 772, 240, 220), new ProntoModel(0, "CUSTOM", 16909057, 99999, 240, 320)};
    private String name;
    private int model;
    private int cap;
    private int mem;
    private Dimension screen;

    private ProntoModel(int n, String string, int n2, int n3, int n4, int n5) {
        this.model = n;
        this.name = string;
        this.cap = n2;
        this.mem = n3 * 1024;
        this.screen = new Dimension(n4, n5);
    }

    public static ProntoModel[] getModels() {
        return units;
    }

    public String getName() {
        return this.name;
    }

    public int getModel() {
        return this.model;
    }

    public int getCapability() {
        return this.cap;
    }

    public int getMemory() {
        return this.mem;
    }

    public Dimension getScreenSize() {
        return this.screen;
    }

    public static ProntoModel getModel(int n) {
        for (int i = 0; i < units.length; ++i) {
            if (ProntoModel.units[i].model != n) continue;
            return units[i];
        }
        throw new IllegalArgumentException();
    }

    public static ProntoModel getModelByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < units.length; ++i) {
            if (!ProntoModel.units[i].name.equals(string)) continue;
            return units[i];
        }
        return units[4];
    }

    public static ProntoModel[] getModelByCapability(int n) {
        Vector<ProntoModel> vector = new Vector<ProntoModel>();
        for (int i = 0; i < units.length; ++i) {
            if (ProntoModel.units[i].cap != n) continue;
            vector.add(units[i]);
        }
        Object[] objectArray = new ProntoModel[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isCustom() {
        return this.model == 0;
    }

    public boolean isMarantz() {
        return this.model == 4 || this.model == 5 || this.model == 6 || this.model == 7;
    }

    public String toString() {
        return this.name;
    }
}

