/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Regress {
    private File dir;
    private Hashtable errors = new Hashtable();

    public static void main(String[] stringArray) throws Exception {
        Regress regress = new Regress(stringArray[0]);
        regress.test();
        Hashtable hashtable = regress.getErrors();
        if (hashtable != null) {
            System.out.println("-- error summary --");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                Exception exception = (Exception)hashtable.get(file);
                System.out.println("fail: " + file + " --> " + exception);
            }
            System.exit(1);
        }
        System.out.println("-- all passed --");
    }

    public Regress(String string) throws IOException {
        this.dir = new File(string);
        if (!this.dir.exists()) {
            throw new FileNotFoundException(string);
        }
    }

    public void test() {
        this.test(this.dir);
    }

    private void test(File file) {
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.test(file2);
                continue;
            }
            if (!stringArray[i].toLowerCase().endsWith(".ccf")) continue;
            try {
                this.testCCF(file2);
                continue;
            }
            catch (Throwable throwable) {
                this.errors.put(file2, throwable);
            }
        }
    }

    public void testCCF(File file) throws Throwable {
        long l = file.length();
        long l2 = 0L;
        System.out.println("test : " + file);
        File file2 = File.createTempFile("out", "ccf");
        file2.delete();
        try {
            CCF cCF = new CCF();
            System.out.print("  read...");
            cCF.load(file.toString());
            System.out.print(" write...");
            cCF.save(file2.toString());
            System.out.print(" reread...");
            cCF.load(file2.toString());
            l2 = file2.length();
            if (Math.abs(l2 - l) > l / 20L) {
                throw new RuntimeException("size mismatch: " + l + " -> " + l2);
            }
        }
        catch (Throwable throwable) {
            System.out.print(" FAIL (" + throwable + ")");
            throw throwable;
        }
        finally {
            System.out.println();
            file2.delete();
        }
    }

    public Hashtable getErrors() {
        return this.errors.size() > 0 ? this.errors : null;
    }
}

