/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCF;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ICCFEditor;
import com.neuron.app.tonto.IEditAction;
import com.neuron.app.tonto.IListElement;
import com.neuron.app.tonto.RenderGrid;
import com.neuron.app.tonto.RenderPanel;
import com.neuron.app.tonto.Renderer;
import com.neuron.app.tonto.ui.AAPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RenderEditor
extends JFrame
implements ICCFEditor {
    private static final Debug debug = Debug.getInstance("editor");
    private final Color LABELBG = new Color(128, 128, 128);
    private final Color majorTick = Color.blue;
    private final Color minorTick = new Color(0, 128, 255);
    private CCF ccf;
    private Renderer render;
    private CCFNode[] clipboard;
    private JComboBox devType;
    private DeviceList devices;
    private PanelList panels;
    private PanelDisplay display;
    private PropEditor props;
    private ActEditor actions;
    private Stack doList;
    private Stack undoList;
    private boolean toggleGrid;
    private boolean toggleSnap;

    public static void main(String[] stringArray) throws Exception {
        CCF cCF = new CCF();
        cCF.load(stringArray[0]);
        RenderEditor renderEditor = new RenderEditor(cCF);
        renderEditor.show();
    }

    public RenderEditor(CCF cCF) {
        super("CCF Editor");
        this.ccf = cCF;
        this.render = new Renderer(cCF);
        this.devType = new JComboBox();
        this.devices = new DeviceList();
        this.panels = new PanelList();
        this.display = new PanelDisplay();
        this.props = new PropEditor();
        this.actions = new ActEditor();
        this.doList = new Stack();
        this.undoList = new Stack();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(1, 1));
        jPanel.add("North", this.label("Section", this.devType));
        jPanel.add("Center", this.label("Devices", this.scrollv(this.devices)));
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.label("Panels", this.scrollv(this.panels)));
        JSplitPane jSplitPane2 = new JSplitPane(0, this.label("Properties", this.props), this.label("Actions", this.actions));
        JSplitPane jSplitPane3 = new JSplitPane(1, this.scrollhv(this.display), jSplitPane2);
        JSplitPane jSplitPane4 = new JSplitPane(1, jSplitPane, jSplitPane3);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(jSplitPane4);
        this.pack();
        this.setSize(1000, 800);
        jSplitPane2.setDividerLocation(0.5);
        jSplitPane3.setResizeWeight(1.0);
        jSplitPane3.setDividerLocation(650);
        jSplitPane.setDividerLocation(200);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane4.setDividerLocation(150);
        this.devices.setRoot(cCF.getFirstHomeDevice());
        this.devType.addItem("System");
        this.devType.addItem("Home");
        this.devType.addItem("Devices");
        this.devType.addItem("Macros");
        this.devType.setSelectedIndex(1);
        this.devType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (RenderEditor.this.devType.getSelectedIndex()) {
                    case 0: {
                        RenderEditor.this.setDeviceRoot(null);
                        RenderEditor.this.setPanelRoot(RenderEditor.this.ccf().getMacroPanel());
                        break;
                    }
                    case 1: {
                        RenderEditor.this.setDeviceRoot(RenderEditor.this.ccf().getFirstHomeDevice());
                        break;
                    }
                    case 2: {
                        RenderEditor.this.setDeviceRoot(RenderEditor.this.ccf().getFirstDevice());
                        break;
                    }
                    case 3: {
                        RenderEditor.this.setDeviceRoot(RenderEditor.this.ccf().getFirstMacroDevice());
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyChar()) {
                    case '1': {
                        RenderEditor.this.display.setScale(1);
                        break;
                    }
                    case '2': {
                        RenderEditor.this.display.setScale(2);
                    }
                }
                switch (keyEvent.getKeyCode()) {
                    case 71: {
                        RenderEditor.this.toggleGrid = !RenderEditor.this.toggleGrid;
                        RenderEditor.this.display.setGrid(new RenderGrid(0, 0, 10, 10, RenderEditor.this.majorTick, RenderEditor.this.minorTick, 2), RenderEditor.this.toggleGrid);
                        break;
                    }
                    case 83: {
                        RenderEditor.this.toggleSnap = !RenderEditor.this.toggleSnap;
                        RenderEditor.this.display.snapGrid(RenderEditor.this.toggleSnap);
                        break;
                    }
                    case 81: {
                        RenderEditor.this.quit();
                    }
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RenderEditor.this.quit();
            }
        });
    }

    @Override
    public CCF ccf() {
        return this.ccf;
    }

    public void quit() {
        this.dispose();
    }

    public void setDeviceRoot(CCFDevice cCFDevice) {
        this.devices.setRoot(cCFDevice);
        this.setPanelRoot(null);
    }

    public void setPanelRoot(CCFPanel cCFPanel) {
        this.panels.setRoot(cCFPanel);
    }

    private JPanel label(String string, JComponent jComponent) {
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setForeground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.setBackground(this.LABELBG);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(2, 2));
        jPanel2.add("North", jPanel);
        jPanel2.add("Center", jComponent);
        return jPanel2;
    }

    private JScrollPane scrollhv(JComponent jComponent) {
        return new JScrollPane(jComponent, 20, 30);
    }

    private JScrollPane scrollv(JComponent jComponent) {
        return new JScrollPane(jComponent, 20, 31);
    }

    @Override
    public void setClipboard(CCFNode[] cCFNodeArray) {
        this.clipboard = cCFNodeArray;
    }

    @Override
    public CCFNode[] getClipboard() {
        return this.clipboard;
    }

    @Override
    public void pushEdit(IEditAction iEditAction) {
        debug.log(0, "pushEdit : " + iEditAction);
    }

    @Override
    public void setSelection(Object object, Enumeration enumeration) {
        this.display.clearSelections(object);
    }

    private abstract class ItemList
    extends JList {
        private Vector listeners = new Vector();

        ItemList() {
            this.setSelectionMode(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    ItemList.this.click(mouseEvent);
                }
            });
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ItemList.this.select();
                }
            });
            this.setModel(new ListModel(){

                @Override
                public void addListDataListener(ListDataListener listDataListener) {
                    ItemList.this.listeners.add(listDataListener);
                }

                @Override
                public void removeListDataListener(ListDataListener listDataListener) {
                    ItemList.this.listeners.remove(listDataListener);
                }

                public Object getElementAt(int n) {
                    return ItemList.this.getListElement(n);
                }

                @Override
                public int getSize() {
                    return ItemList.this.getListSize();
                }
            });
        }

        public void changeSize(int n, int n2) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ListDataListener listDataListener = (ListDataListener)enumeration.nextElement();
                listDataListener.intervalRemoved(new ListDataEvent(this, 2, 0, n));
                listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, n2));
            }
        }

        public Object getListElement(int n) {
            IListElement iListElement = this.getRootElement();
            for (int n2 = 0; iListElement != null && n2 < n; iListElement = iListElement.getNextElement(), ++n2) {
            }
            return iListElement;
        }

        public int getListSize() {
            IListElement iListElement = this.getRootElement();
            int n = 0;
            while (iListElement != null) {
                iListElement = iListElement.getNextElement();
                ++n;
            }
            return n;
        }

        public abstract IListElement getRootElement();

        public abstract void click(MouseEvent var1);

        public abstract void select();
    }

    private class PanelList
    extends ItemList {
        private CCFPanel root;

        private PanelList() {
        }

        public void setRoot(CCFPanel cCFPanel) {
            int n = this.getListSize();
            this.root = cCFPanel;
            this.changeSize(n, this.getListSize());
        }

        @Override
        public IListElement getRootElement() {
            return this.root;
        }

        @Override
        public void click(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                RenderEditor.this.display.addPanel((CCFPanel)this.getListElement(this.getSelectedIndex()));
            }
        }

        @Override
        public void select() {
        }
    }

    private class DeviceList
    extends ItemList {
        private CCFDevice root;

        private DeviceList() {
        }

        public void setRoot(CCFDevice cCFDevice) {
            int n = this.getListSize();
            this.root = cCFDevice;
            this.changeSize(n, this.getListSize());
        }

        @Override
        public IListElement getRootElement() {
            return this.root;
        }

        @Override
        public void click(MouseEvent mouseEvent) {
            this.select();
        }

        @Override
        public void select() {
            RenderEditor.this.setPanelRoot(((CCFDevice)this.getListElement(this.getSelectedIndex())).getFirstPanel());
        }
    }

    private class ActEditor
    extends JPanel {
        ActEditor() {
            this.setBackground(Color.white);
        }
    }

    private class PropEditor
    extends JPanel {
        PropEditor() {
            this.setBackground(Color.white);
        }
    }

    private class PanelDisplay
    extends AAPanel {
        private Vector panels = new Vector();
        private Hashtable windows = new Hashtable();
        private Hashtable renders = new Hashtable();
        private Hashtable pos = new Hashtable();
        private int xmax;
        private int ymax;
        private int scale = 1;

        PanelDisplay() {
            this.setBackground(Color.white);
            this.setScale(1);
        }

        public void clearSelections(Object object) {
            Enumeration enumeration = this.renders.elements();
            while (enumeration.hasMoreElements()) {
                RenderPanel renderPanel = (RenderPanel)enumeration.nextElement();
                if (renderPanel == object) continue;
                renderPanel.clearSelection();
            }
        }

        public void snapGrid(boolean bl) {
            Enumeration enumeration = this.renders.elements();
            while (enumeration.hasMoreElements()) {
                ((RenderPanel)enumeration.nextElement()).snapGrid(bl);
            }
        }

        public void setGrid(RenderGrid renderGrid, boolean bl) {
            Enumeration enumeration = this.renders.elements();
            while (enumeration.hasMoreElements()) {
                RenderPanel renderPanel = (RenderPanel)enumeration.nextElement();
                renderPanel.setGrid(renderGrid);
                renderPanel.showGrid(bl);
            }
            this.refresh(true);
        }

        public void setScale(int n) {
            this.scale = n;
            Enumeration enumeration = this.renders.elements();
            while (enumeration.hasMoreElements()) {
                ((RenderPanel)enumeration.nextElement()).setScale(n);
            }
            this.refresh(true);
        }

        public void refresh(boolean bl) {
            JComponent jComponent = (JComponent)this.getParent();
            if (jComponent != null) {
                jComponent.revalidate();
                if (bl) {
                    jComponent.repaint();
                }
            }
        }

        public void addPanel(CCFPanel cCFPanel) {
            if (!this.panels.contains(cCFPanel)) {
                JPanel jPanel = this.window(cCFPanel);
                this.panels.add(cCFPanel);
                this.windows.put(cCFPanel, jPanel);
                int n = 0;
                while (true) {
                    for (int i = 0; i < this.xmax; ++i) {
                        String string = "x=" + i + ";y=" + n + ";pad=5,5,5,5";
                        if (this.pos.get(string) != null) continue;
                        this.pos.put(string, cCFPanel);
                        this.pos.put(cCFPanel, string);
                        this.add((Component)jPanel, string);
                        this.refresh(false);
                        return;
                    }
                    ++n;
                }
            }
        }

        private JPanel window(CCFPanel cCFPanel) {
            final CCFPanel cCFPanel2 = cCFPanel;
            RenderPanel renderPanel = new RenderPanel(RenderEditor.this, RenderEditor.this.render, cCFPanel);
            renderPanel.setScale(this.scale);
            CCFDevice cCFDevice = cCFPanel.getParentDevice();
            String string = cCFDevice != null ? cCFDevice.getName() : "SYS";
            String string2 = string + " : " + cCFPanel.getName();
            JLabel jLabel = new JLabel(string2, 0);
            jLabel.setForeground(Color.white);
            JButton jButton = new JButton("x");
            jButton.setFocusPainted(false);
            jButton.setBorderPainted(false);
            jButton.setMargin(new Insets(1, 1, 1, 1));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    debug.log(0, "button : " + cCFPanel2);
                    PanelDisplay.this.removePanel(cCFPanel2);
                }
            });
            AAPanel aAPanel = new AAPanel();
            aAPanel.setBorder(new EtchedBorder(0));
            aAPanel.setBackground(RenderEditor.this.LABELBG);
            aAPanel.add((Component)jLabel, "x=1;y=1;pad=1,1,1,1;wx=1");
            aAPanel.add((Component)jButton, "x=2;y=1;pad=1,1,1,1;wx=0");
            aAPanel.add((Component)renderPanel, "x=1;y=2;pad=1,1,1,1;w=2;wx=1;xy=1");
            this.renders.put(cCFPanel, renderPanel);
            return aAPanel;
        }

        public void removePanel(CCFPanel cCFPanel) {
            this.panels.remove(cCFPanel);
            this.renders.remove(cCFPanel);
            this.remove((JComponent)this.windows.remove(cCFPanel));
            this.refresh(true);
            String string = (String)this.pos.remove(cCFPanel);
            this.pos.remove(string);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = RenderEditor.this.ccf().getScreenSize();
            this.xmax = Math.max(dimension.width / (dimension2.width * this.scale), 1);
            this.ymax = dimension.height / (dimension2.height * this.scale);
            super.paint(graphics);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            Enumeration enumeration = this.windows.elements();
            while (enumeration.hasMoreElements()) {
                rectangle = rectangle.union(((JComponent)enumeration.nextElement()).getBounds());
            }
            return new Dimension(rectangle.width, rectangle.height);
        }
    }
}

