/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ICCFEditor;
import com.neuron.app.tonto.RenderGrid;
import com.neuron.app.tonto.Renderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;

public class RenderPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private final Debug debug = Debug.getInstance("render");
    private ICCFEditor editor;
    private Renderer render;
    private CCFPanel panel;
    private Hashtable select;
    private Point last;
    private int scale;
    private RenderGrid grid;
    private boolean useGrid;
    private boolean useSnap;

    public RenderPanel(ICCFEditor iCCFEditor, Renderer renderer, CCFPanel cCFPanel) {
        this.editor = iCCFEditor;
        this.render = renderer;
        this.panel = cCFPanel;
        this.select = new Hashtable();
        this.scale = 1;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        Point point = mouseEvent.getPoint();
        point.x /= this.scale;
        point.y /= this.scale;
        this.last = point;
        CCFChild cCFChild = Renderer.getClick(this.panel, point);
        if (cCFChild != null && this.select.containsKey(cCFChild)) {
            return;
        }
        if (!mouseEvent.isShiftDown()) {
            this.clearSelection();
        }
        if (cCFChild != null) {
            this.select.put(cCFChild, mouseEvent.getPoint());
            this.repaint(cCFChild);
            this.editor.setSelection(this, this.select.keys());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.select.size() == 0) {
            return;
        }
        Rectangle rectangle = this.getBounds(this.select.keys());
        Point point = mouseEvent.getPoint();
        point.x /= this.scale;
        point.y /= this.scale;
        Enumeration enumeration = this.select.keys();
        while (enumeration.hasMoreElements()) {
            CCFChild cCFChild = (CCFChild)enumeration.nextElement();
            Point point2 = cCFChild.getLocation();
            point2.translate(point.x - this.last.x, point.y - this.last.y);
            cCFChild.setLocation(point2);
        }
        this.last = point;
        this.repaint(rectangle.union(this.getBounds(this.select.keys())));
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        boolean bl = keyEvent.isAltDown();
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isShiftDown();
        switch (keyEvent.getKeyCode()) {
            case 67: {
                if (!bl2) break;
                this.copy();
                break;
            }
            case 88: {
                if (!bl2) break;
                this.cut();
                break;
            }
            case 86: {
                if (!bl2) break;
                this.paste();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
        this.revalidate();
    }

    public Dimension scale(Dimension dimension) {
        return new Dimension(dimension.width * this.scale, dimension.height * this.scale);
    }

    public Rectangle scale(Rectangle rectangle) {
        return new Rectangle(rectangle.x * this.scale, rectangle.y * this.scale, rectangle.width * this.scale, rectangle.height * this.scale);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.scale(this.editor.ccf().getScreenSize());
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void repaint(CCFChild cCFChild) {
        this.repaint(this.scale(Renderer.getBounds(cCFChild)));
    }

    private Rectangle getBounds(Enumeration enumeration) {
        Rectangle rectangle = null;
        while (enumeration.hasMoreElements()) {
            Rectangle rectangle2 = this.scale(Renderer.getBounds((CCFChild)enumeration.nextElement()));
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle = rectangle.union(rectangle2);
        }
        return rectangle;
    }

    @Override
    public void repaint(Rectangle rectangle) {
        int n = this.scale - 1;
        rectangle.x -= n;
        rectangle.y -= n;
        rectangle.width += n * 2;
        rectangle.height += n * 2;
        super.repaint(rectangle);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        ((Graphics2D)graphics).scale(this.scale, this.scale);
        this.render.draw(graphics, this.panel, 0, 0);
        if (this.useGrid && this.grid != null) {
            int n;
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.35f));
            int n2 = 0;
            for (n = this.grid.offX; n < dimension.width; n += this.grid.spaceX) {
                graphics.setColor(n2++ % this.grid.minorTicks == 0 ? this.grid.major : this.grid.minor);
                graphics.drawLine(n, 0, n, dimension.height);
            }
            n2 = 0;
            for (n = this.grid.offY; n < dimension.height; n += this.grid.spaceY) {
                graphics.setColor(n2++ % this.grid.minorTicks == 0 ? this.grid.major : this.grid.minor);
                graphics.drawLine(0, n, dimension.width, n);
            }
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        Enumeration enumeration = this.select.keys();
        while (enumeration.hasMoreElements()) {
            CCFChild cCFChild = (CCFChild)enumeration.nextElement();
            Rectangle rectangle = Renderer.getBounds(cCFChild);
            graphics.setColor(Color.red);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    private CCFNode[] enumToNodes(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new CCFNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void clearSelection() {
        Enumeration enumeration = ((Hashtable)this.select.clone()).keys();
        this.select.clear();
        while (enumeration.hasMoreElements()) {
            this.repaint((CCFChild)enumeration.nextElement());
        }
    }

    public void setGrid(RenderGrid renderGrid) {
        this.grid = renderGrid;
    }

    public void showGrid(boolean bl) {
        this.useGrid = bl;
        this.revalidate();
    }

    public void snapGrid(boolean bl) {
        this.useSnap = bl;
    }

    public void cut() {
        this.debug.log(0, "CUT");
        this.editor.setClipboard(this.enumToNodes(this.select.keys()));
    }

    public void copy() {
        this.debug.log(0, "COPY");
        this.editor.setClipboard(this.enumToNodes(this.select.keys()));
    }

    public void paste() {
        this.debug.log(0, "PASTE");
        CCFNode[] cCFNodeArray = this.editor.getClipboard();
        for (int i = 0; cCFNodeArray != null && i < cCFNodeArray.length; ++i) {
            this.debug.log(0, "PASTE: " + cCFNodeArray[i]);
        }
    }

    public void valign() {
    }

    public void halign() {
    }

    public void vdist() {
    }

    public void hdist() {
    }

    public void group() {
    }

    public void ungroup() {
    }

    public void lock() {
    }

    public void unlock() {
    }
}

