/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFFont;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.ICCFProvider;
import com.neuron.app.tonto.ui.ImageFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class Renderer {
    private static final Debug debug = Debug.getInstance("render");
    private static final JPanel panel = new JPanel();
    private static ImageFont[] fonts;
    private ICCFProvider ccf;

    public Renderer(ICCFProvider iCCFProvider) {
        this.ccf = iCCFProvider;
    }

    public void draw(Graphics graphics, CCFPanel cCFPanel, int n, int n2) {
        if (cCFPanel == null) {
            return;
        }
        CCFPanel cCFPanel2 = cCFPanel.getTemplate();
        if (cCFPanel2 != null && this.ccf.ccf().getModel().isCustom()) {
            this.draw(graphics, cCFPanel.getTemplate(), n, n2);
        } else {
            graphics.setColor(Color.white);
            Dimension dimension = this.ccf.ccf().getScreenSize();
            if (dimension == null) {
                Rectangle rectangle = graphics.getClipBounds();
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else {
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        }
        this.draw(graphics, cCFPanel.getChildren(), n, n2);
    }

    public void draw(Graphics graphics, CCFChild[] cCFChildArray, int n, int n2) {
        if (cCFChildArray == null || cCFChildArray.length == 0) {
            return;
        }
        for (int i = 0; i < cCFChildArray.length; ++i) {
            this.draw(graphics, cCFChildArray[i], n, n2);
        }
    }

    public void draw(Graphics graphics, CCFChild cCFChild, int n, int n2) {
        if (cCFChild == null) {
            return;
        }
        if (!graphics.getClipBounds().intersects(Renderer.getBounds(cCFChild))) {
            return;
        }
        Point point = cCFChild.getLocation();
        switch (cCFChild.getType()) {
            case 1: {
                this.draw(graphics, cCFChild.getButton(), point.x + n, point.y + n2);
                break;
            }
            case 0: {
                this.draw(graphics, cCFChild.getFrame(), point.x + n, point.y + n2);
            }
        }
    }

    public void draw(Graphics graphics, CCFButton cCFButton, int n, int n2) {
        if (cCFButton == null) {
            return;
        }
        Dimension dimension = cCFButton.getSize();
        this.clear(graphics, cCFButton.getBackground(), n, n2, dimension.width, dimension.height);
        this.draw(graphics, cCFButton.getIconSet().getDefaultIcon(), n, n2, dimension.width, dimension.height);
        this.draw(graphics, cCFButton.getName(), cCFButton.getFont(), cCFButton.getForeground(), n, n2, dimension.width, dimension.height);
    }

    public void draw(Graphics graphics, CCFFrame cCFFrame, int n, int n2) {
        if (cCFFrame == null) {
            return;
        }
        Dimension dimension = cCFFrame.getSize();
        this.clear(graphics, cCFFrame.getBackground(), n, n2, dimension.width, dimension.height);
        this.draw(graphics, cCFFrame.getIcon(), n, n2, dimension.width, dimension.height);
        this.draw(graphics, cCFFrame.getName(), cCFFrame.getFont(), cCFFrame.getForeground(), n, n2, dimension.width, dimension.height);
        this.draw(graphics, cCFFrame.getChildren(), n, n2);
    }

    public void clear(Graphics graphics, CCFColor cCFColor, int n, int n2, int n3, int n4) {
        if (this.ccf.ccf().isTransparentColor(cCFColor)) {
            return;
        }
        graphics.setColor(cCFColor.getAWTColor(this.ccf.ccf().isColor()));
        graphics.fillRect(n, n2, n3, n4);
    }

    public void draw(Graphics graphics, String string, CCFFont cCFFont, CCFColor cCFColor, int n, int n2, int n3, int n4) {
        if (string == null || cCFFont == null || cCFFont == CCFFont.NONE) {
            return;
        }
        graphics.setColor(cCFColor.getAWTColor(this.ccf.ccf().isColor()));
        ImageFont imageFont = fonts[cCFFont.getFontSize() - 1];
        imageFont.draw(string, n + (n3 - imageFont.getStringWidth(string)) / 2, n2 + (n4 - imageFont.getHeight()) / 2, graphics);
    }

    public void draw(Graphics graphics, CCFIcon cCFIcon, int n, int n2, int n3, int n4) {
        if (cCFIcon == null) {
            return;
        }
        Image image = cCFIcon.getImage(panel);
        graphics.drawImage(image, n, n2, panel);
    }

    public static CCFChild getClick(CCFPanel cCFPanel, Point point) {
        return Renderer.getClick(cCFPanel.getChildren(), new Point(0, 0), point);
    }

    public static CCFChild getClick(CCFChild[] cCFChildArray, Point point, Point point2) {
        if (cCFChildArray == null || cCFChildArray.length == 0) {
            return null;
        }
        for (int i = cCFChildArray.length - 1; i >= 0; --i) {
            Rectangle rectangle = cCFChildArray[i].getBounds();
            rectangle.translate(point.x, point.y);
            if (!rectangle.contains(point2)) continue;
            if (cCFChildArray[i].isButton()) {
                return cCFChildArray[i];
            }
            point.x = rectangle.x;
            point.y = rectangle.y;
            CCFChild cCFChild = Renderer.getClick(cCFChildArray[i].getFrame().getChildren(), point, point2);
            return cCFChild != null ? cCFChild : cCFChildArray[i];
        }
        return null;
    }

    public static Rectangle getBounds(CCFChild cCFChild) {
        Point point = Renderer.getLocation(cCFChild, new Point(0, 0));
        Rectangle rectangle = cCFChild.getBounds();
        rectangle.x = point.x;
        rectangle.y = point.y;
        return rectangle;
    }

    private static Point getLocation(CCFNode cCFNode, Point point) {
        if (cCFNode == null || cCFNode instanceof CCFPanel) {
            return point;
        }
        if (cCFNode instanceof CCFChild) {
            Point point2 = ((CCFChild)cCFNode).getLocation();
            point.translate(point2.x, point2.y);
        }
        return Renderer.getLocation(cCFNode.getParent(), point);
    }

    static {
        Class<Renderer> clazz = Renderer.class;
        try {
            fonts = new ImageFont[]{new ImageFont(clazz.getResourceAsStream("/font/tonto-08.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-10.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-12.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-14.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-16.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-18.iff"))};
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

