/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import com.neuron.app.tonto.ActionAliasButton;
import com.neuron.app.tonto.ActionAliasDevice;
import com.neuron.app.tonto.ActionAliasKey;
import com.neuron.app.tonto.ActionBeep;
import com.neuron.app.tonto.ActionDelay;
import com.neuron.app.tonto.ActionIRCode;
import com.neuron.app.tonto.ActionJumpPanel;
import com.neuron.app.tonto.ActionTimer;
import com.neuron.app.tonto.BufferedFile;
import com.neuron.app.tonto.CCF;
import com.neuron.app.tonto.CCFAction;
import com.neuron.app.tonto.CCFActionList;
import com.neuron.app.tonto.CCFButton;
import com.neuron.app.tonto.CCFChild;
import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.CCFDevice;
import com.neuron.app.tonto.CCFException;
import com.neuron.app.tonto.CCFFont;
import com.neuron.app.tonto.CCFFrame;
import com.neuron.app.tonto.CCFHardKey;
import com.neuron.app.tonto.CCFHeader;
import com.neuron.app.tonto.CCFIRCode;
import com.neuron.app.tonto.CCFIcon;
import com.neuron.app.tonto.CCFIconSet;
import com.neuron.app.tonto.CCFNode;
import com.neuron.app.tonto.CCFPanel;
import com.neuron.app.tonto.CCFPorter;
import com.neuron.app.tonto.CCFTimer;
import com.neuron.app.tonto.CCFWalker;
import com.neuron.app.tonto.Comm;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.DebugListener;
import com.neuron.app.tonto.Firmware;
import com.neuron.app.tonto.IChildContainer;
import com.neuron.app.tonto.IRDBDialog;
import com.neuron.app.tonto.IRSignalPanel;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.IWalker;
import com.neuron.app.tonto.IWalker2;
import com.neuron.app.tonto.Preferences;
import com.neuron.app.tonto.ProntoModel;
import com.neuron.app.tonto.RenderEditor;
import com.neuron.app.tonto.RunInThread;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.Xmodem;
import com.neuron.app.tonto.ui.AAPanel;
import com.neuron.app.tonto.ui.AboutDialog;
import com.neuron.app.tonto.ui.ActionButton;
import com.neuron.app.tonto.ui.Browser;
import com.neuron.app.tonto.ui.ColorPicker;
import com.neuron.app.tonto.ui.ImageFont;
import com.neuron.app.tonto.ui.ImageFontLabel;
import com.neuron.app.tonto.ui.OKCancelDialog;
import com.neuron.app.tonto.ui.StackedDialog;
import com.neuron.app.tonto.ui.Task;
import com.neuron.app.tonto.ui.TaskList;
import com.neuron.app.tonto.ui.UIUtils;
import com.neuron.io.ByteOutputBuffer;
import com.neuron.irdb.IRBurst;
import com.neuron.irdb.IRDatabase;
import com.neuron.irdb.IRRemote;
import com.neuron.irdb.IRSignal;
import com.neuron.irdb.impl.Pronto;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.comm.DriverMac_OS_X;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class Tonto
implements ITaskStatus,
TreeSelectionListener {
    private static String version = null;
    private static boolean hasComm = Comm.isDriverOK();
    private static Debug debug = Debug.getInstance("tonto");
    private static Class class_xmodem = Xmodem.class;
    private static Class class_comm = Comm.class;
    private static Class class_node = CCFNode.class;
    private static final int BASE_FILE = 16;
    private static final int BASE_EDIT = 32;
    private static final int BASE_ADD = 64;
    private static final int BASE_MISC = 128;
    private static final int BASE_UTIL = 256;
    private static final int BASE_FILE_NEW = 512;
    private static final int BASE_CONVERT = 1024;
    private static final int BASE_OBJECT = 2048;
    private static final int BASE_KEY_ALIAS = 4096;
    private static final int BASE_KEY_PASTE = 8192;
    private static final int BASE_KEY_COPY_ACTIONS = 16384;
    private static final int BASE_KEY_PASTE_ACTIONS = 32768;
    private static final int FILE_NEW = 17;
    private static final int FILE_CLOSE = 18;
    private static final int FILE_LOAD = 19;
    private static final int FILE_SAVE = 20;
    private static final int FILE_SAVEAS = 21;
    private static final int FILE_CCF_GET = 22;
    private static final int FILE_CCF_PUT = 23;
    private static final int FILE_PREFERENCES = 24;
    private static final int FILE_EXIT = 25;
    private static final int FILE_WINDOW = 26;
    private static final int FILE_EXPORT = 27;
    private static final int FILE_CLOSE_PANEL = 28;
    private static final int FILE_CLOSE_WINDOW = 29;
    private static final int FILE_MERGE = 30;
    private static final int FILE_REVERT = 31;
    private static final int EDIT_UNDO = 33;
    private static final int EDIT_REDO = 34;
    private static final int EDIT_CUT = 35;
    private static final int EDIT_COPY = 36;
    private static final int EDIT_DELETE = 37;
    private static final int EDIT_PASTE = 38;
    private static final int EDIT_PROPERTY = 39;
    private static final int EDIT_SELECT_ALL = 40;
    private static final int EDIT_UNSELECT_ALL = 41;
    private static final int ADD_DEVICE = 65;
    private static final int ADD_PANEL = 66;
    private static final int ADD_FRAME = 67;
    private static final int ADD_BUTTON = 68;
    private static final int ABOUT = 129;
    private static final int TOGGLE_GRID = 131;
    private static final int TOGGLE_SNAP = 132;
    private static final int IR_DATABASE = 133;
    private static final int COPY_ICONS = 134;
    private static final int COPY_ACTIONS = 135;
    private static final int COPY_KEYS = 136;
    private static final int COPY_ALIAS = 137;
    private static final int PASTE_ICONS = 138;
    private static final int PASTE_ACTIONS = 139;
    private static final int PASTE_KEYS = 140;
    private static final int PASTE_ALIAS = 141;
    private static final int DOCS_MAIN = 142;
    private static final int DOCS_FAQ = 143;
    private static final int DOCS_CHANGES = 144;
    private static final int AUTOLOAD_ADD = 145;
    private static final int AUTOLOAD_REMOVE = 146;
    private static final int DEBUG_WINDOW = 147;
    private static final int ICON_LIBRARY = 148;
    private static final int ICON_REPLACE = 149;
    private static final int HELP_CCFS = 150;
    private static final int HELP_DISCRETE = 151;
    private static final int TREE_EXPAND_ALL = 152;
    private static final int TREE_COLLAPSE_ALL = 153;
    private static final int VIEW_HIDE_SELECT = 154;
    private static final int TAB_MASTER = 155;
    private static final int DOCS_TUTOR = 156;
    private static final int PASTE_REPLACE_ICONS = 157;
    private static final int THEME_MASTER = 158;
    private static final int OBJECT_RAISE = 2049;
    private static final int OBJECT_LOWER = 2050;
    private static final int OBJECT_TOP = 2051;
    private static final int OBJECT_BOTTOM = 2052;
    private static final int ALIGN_TOP = 2053;
    private static final int ALIGN_BOTTOM = 2054;
    private static final int ALIGN_LEFT = 2055;
    private static final int ALIGN_RIGHT = 2056;
    private static final int ALIGN_HCENTER = 2057;
    private static final int ALIGN_VCENTER = 2058;
    private static final int OBJECTS_GROUP = 2059;
    private static final int OBJECTS_UNGROUP = 2060;
    private static final int SNAP_TOP_LEFT = 2061;
    private static final int SNAP_TOP = 2062;
    private static final int SNAP_TOP_RIGHT = 2063;
    private static final int SNAP_RIGHT = 2064;
    private static final int SNAP_BOTTOM_RIGHT = 2065;
    private static final int SNAP_BOTTOM = 2066;
    private static final int SNAP_BOTTOM_LEFT = 2067;
    private static final int SNAP_LEFT = 2068;
    private static final int OBJECT_TRANSPARENT = 2069;
    private static final int UTIL_UPLOAD = 257;
    private static final int UTIL_DOWNLOAD = 258;
    private static final int EMAIL_LOGFILE = 259;
    private static final int UTIL_REBOOT = 260;
    private static final int UTIL_UNDEAD = 261;
    private static final int UTIL_LOCATE = 262;
    private static final int UTIL_NET_UPDATE = 263;
    private static final int UTIL_EMULATOR = 264;
    private static final int UTIL_EDITOR = 265;
    private static final int UTIL_FIRMWARE = 266;
    private static final Cursor CURSOR_DEFAULT = new Cursor(0);
    private static final Cursor CURSOR_MOVE = new Cursor(13);
    private static final Cursor CURSOR_WEST = new Cursor(10);
    private static final Cursor CURSOR_EAST = new Cursor(11);
    private static final Cursor CURSOR_NORTH = new Cursor(8);
    private static final Cursor CURSOR_SOUTH = new Cursor(9);
    private static final Cursor CURSOR_NW = new Cursor(6);
    private static final Cursor CURSOR_NE = new Cursor(7);
    private static final Cursor CURSOR_SW = new Cursor(4);
    private static final Cursor CURSOR_SE = new Cursor(5);
    private static final int NORTH = 1;
    private static final int SOUTH = 2;
    private static final int EAST = 4;
    private static final int WEST = 8;
    private static final int NW = 9;
    private static final int NE = 5;
    private static final int SW = 10;
    private static final int SE = 6;
    private static final int MAX_UNDO = 100;
    private static final String PREF_DEFAULT_MODEL = "model";
    private static final String PREF_GRID_SIZE = "grid";
    private static final String PREF_GRID_SNAP = "grid.snap";
    private static final String PREF_GRID_SHOW = "grid.show";
    private static final String PREF_GRID_MINOR_TICKS = "grid.minor.ticks";
    private static final String PREF_GRID_MAJOR_COLOR = "grid.minor.color";
    private static final String PREF_GRID_MINOR_COLOR = "grid.major.color";
    private static final String PREF_DEBUG_LEVELS = "debug";
    private static final String PREF_DEFAULT_PORT = "port";
    private static final String PREF_SCAN_OTHER_PORTS = "port.scan";
    private static final String PREF_SCAN_THREADED = "port.scan.threaded";
    private static final String PREF_SCAN_MODEMS = "port.scan.modems";
    private static final String PREF_COMM_TIMEOUTS = "comm";
    private static final String PREF_RECENT_FILES = "files";
    private static final String PREF_FONT_SCALING = "fontscale";
    private static final String PREF_FONT_SIZE = "tree.font.size";
    private static final String PREF_FONT_INTREE = "tree.font.pronto";
    private static final String PREF_LOG_TO_CONSOLE = "log.console";
    private static final String PREF_USE_AWT_DIALOG = "oldFileDialogs";
    private static final String PREF_OBEY_REMOTE_CAP = "obeyRemoteCapability";
    private static final String PREF_TEST_EMIT_IR = "testEmitIR";
    private static final String PREF_SHOW_DEV_PROPS = "show.device.properties";
    private static final String PREF_COLOR_MAP = "color.map";
    private static final String PREF_COLOR_WEBSAFE = "color.websafe";
    private static final String PREF_WORKING_DIR = "workingDir";
    private static final String PREF_IMAGE_DIR = "dir.images";
    private static final String PREF_IMAGE_EDITOR = "image.editor";
    private static final String PREF_AUTOLOAD_FILES = "autoload";
    private static final String PREF_SPLIT_HORIZONTAL = "split.horizontal";
    private static final String PREF_NETWORK_UPDATES = "network.update";
    private static final String PREF_UPDATE_ROOT = "network.url";
    private static final String PREF_UUID = "uuid";
    private static final String PREF_PREF_BOUNDS = "geom.prefs";
    private static final String PREF_WINDOW_BOUNDS = "geom.tonto";
    private static final String PREF_ICONLIB_BOUNDS = "geom.iconlib";
    private static final String PREF_FRAMEPROP_BOUNDS = "geom.frameprop";
    private static final String PREF_BUTTONPROP_BOUNDS = "geom.buttonprop";
    private static final String PREF_DEVICEPROP_BOUNDS = "geom.deviceprop";
    private static final String PREF_ALIAS_BOUNDS = "geom.alias";
    private static final String PREF_JUMP_BOUNDS = "geom.jump";
    private static final String PREF_IR_BOUNDS = "geom.ir";
    private static final String PREF_DEBUG_BOUNDS = "geom.debug";
    private static final String PREF_EMULATOR = "emulator.path";
    private static final String PREF_EDITOR = "editor.path";
    private static final String PREF_GRAY_TINT = "colors.gray.tint";
    private static final String PREF_CENTER_DIALOGS = "dialogs.center";
    private static final String ASK_NETWORK_UPDATE = "ask.network.update";
    private static final String PREF_SELECTION_LAST = "select.paint.last";
    private static final int[] numkey = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48};
    private static final int[][] fontIBM = new int[][]{{2, 100, 100}, {3, 100, 100}, {4, 100, 100}, {4, 100, 100}, {5, 100, 100}, {6, 100, 100}};
    private static final int[][] fontSUN = new int[][]{{1, 107, 100}, {2, 98, 100}, {3, 100, 100}, {2, 103, 105}, {2, 100, 100}, {3, 102, 104}};
    private static final int[][] fontMAC = new int[][]{{3, 100, 100}, {3, 100, 100}, {4, 100, 100}, {3, 100, 100}, {3, 100, 100}, {4, 100, 100}};
    private static final int[][] fontUnknown = new int[][]{{0, 100, 100}, {0, 100, 100}, {0, 100, 100}, {0, 100, 100}, {0, 100, 100}, {0, 100, 100}};
    private static Tonto current;
    private static JTabbedPane windows;
    private static JFrame jframe;
    private static JToolBar tbar;
    private static Hashtable tools;
    private static Hashtable menus;
    private static Hashtable popmenus;
    private static MenuItem fileNew;
    private static Menu fileNewMenu;
    private static Menu convertMenu;
    private static Menu revertMenu;
    private static Menu recentMenu;
    private static Menu snapMenu;
    private static Menu orderMenu;
    private static Menu alignMenu;
    private static JPopupMenu rcFrame;
    private static JPopupMenu rcPanel;
    private static JPopupMenu rcButton;
    private static JPopupMenu rcDGroup;
    private static JPopupMenu rcDevice;
    private static JMenu rcDeviceAliasKey;
    private static JMenu rcDevicePasteKey;
    private static JMenu rcDeviceCopyActions;
    private static JMenu rcDevicePasteActions;
    private static Comm comm;
    private static CCFButton defaultGrayButton;
    private static CCFButton defaultColorButton;
    private static IRDBDialog irdb;
    private static IRDatabase database;
    private static Vector recentFiles;
    private static Preferences prefs;
    private static PrefsDialog prefsDialog;
    private static TimerEditor timerEditor;
    private static NameDialog dialogName;
    private static NameDialog dialogName2;
    private static Object clipboard;
    private static ImageIcon iconFolderOpened;
    private static ImageIcon iconFolderClosed;
    private static ImageIcon iconPanel;
    private static ImageIcon iconProperties;
    private static Image imageTontoSmall;
    private static Font fontPronto;
    private static int[][] fontTable;
    private static ImageFont[] fonts;
    private static File jarDir;
    private static int exitCode;
    private static int nextAction;
    private static Hashtable tontos;
    private static LineBorder border;
    private static Image splash;
    private static Canvas csplash;
    private static File logFile;
    private static File homeDir;
    private static File prefDir;
    private static File altPrefDir;
    private static File prefFile;
    private static File dbDir;
    private static File logDir;
    private static File ccfDir;
    private static File moduleDir;
    private static File defaultDB;
    private static String commMsg;
    private static Throwable commErr;
    private static Vector autoLoad;
    private static DebugListener console;
    private static SnapInfo snaps;
    private static Thread updateThread;
    private static boolean initShared;
    private static boolean isUpdating;
    private static boolean sessionUpdate;
    private static boolean prefNetworkUpdate;
    private static boolean prefUseAWTFileDialogs;
    private static boolean prefLogToConsole;
    private static boolean prefObeyRemoteCap;
    private static boolean prefUseProntoFont;
    private static boolean prefEmitIR;
    private static boolean prefShowWebSafe;
    private static boolean prefShowDeviceProps;
    private static boolean prefScanOtherPorts;
    private static boolean prefScanThreaded;
    private static boolean prefScanModems;
    private static boolean prefCenterDialogs;
    private static boolean prefSelectionLast;
    private static String prefUpdateRoot;
    private static int prefTreeFontSize;
    private static int prefHSplitPos;
    private static File prefWorkingDir;
    private static File prefImageDir;
    private static String prefEditor;
    private static String prefImageEditor;
    private static String prefCommPort;
    private static String prefUUID;
    private static Rectangle prefGrid;
    private static boolean prefGridSnap;
    private static boolean prefGridShow;
    private static int prefGridMinorTicks;
    private static CCFColor prefGridMinorColor;
    private static CCFColor prefGridMajorColor;
    private static ProntoModel prefDefaultModel;
    private static CCFColor[] prefColorMap;
    private CCF ccf;
    private WeakHashMap wrappers = new WeakHashMap();
    private Hashtable panels;
    private String fileName;
    private Point nextPosition;
    private Stack undoStack;
    private Stack redoStack;
    private Dimension panelSize;
    private JTree tree;
    private JScrollPane treeScroll;
    private JTModel model;
    private JSplitPane split;
    private JLabel statusText;
    private JDesktopPane work;
    private Object treeSelection;
    private Component dragSelection;
    private ObjectPanel objectStatus;
    private Vector multiSelect;
    private IconLibrary icons;
    private SystemProps systemProps;
    private SystemProps xSystemProps;
    private DeviceProps deviceProps;
    private PanelProps panelProps;
    private FrameProps frameProps;
    private ButtonProps buttonProps;
    private ButtonPasteDialog buttonPaste;
    private Object lastAlias;
    private boolean isnew;
    private boolean changed;
    private boolean hideSelection;
    private int nextDoID;
    private CCF newCCF;
    private TreeNode treeDrag;
    private Object treeTarget;
    private Border treeBorder;
    private boolean treeBefore;
    private CCFDevice currentDevice;
    private CCFPanel currentPanel;
    private JFrame debugFrame;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            try {
                Socket socket = new Socket(InetAddress.getLocalHost(), 9911);
                OutputStream outputStream = socket.getOutputStream();
                outputStream.write("load ".getBytes());
                for (int i = 0; i < stringArray.length; ++i) {
                    outputStream.write(URLEncoder.encode(stringArray[i]).getBytes());
                    outputStream.write(32);
                }
                outputStream.flush();
                socket.close();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        splash = Tonto.loadImage("images/splash.jpg");
        Window window = new Window(new Frame("splash screen"));
        Dimension dimension = window.getToolkit().getScreenSize();
        MediaTracker mediaTracker = new MediaTracker(window);
        mediaTracker.addImage(splash, 1);
        window.add(Tonto.getTitleCanvas());
        window.pack();
        window.setLocation(dimension.width / 2 - 120, dimension.height / 2 - 100);
        mediaTracker.waitForAll();
        window.show();
        Tonto tonto = new Tonto();
        window.dispose();
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                Tonto.load(stringArray[i], autoLoad.size() > 0 || i > 0);
            }
        }
    }

    private Tonto() {
        String string = Tonto.init();
        this.systemProps = new SystemProps(false);
        this.xSystemProps = new SystemProps(true);
        this.deviceProps = new DeviceProps();
        this.panelProps = new PanelProps();
        this.buttonProps = new ButtonProps();
        this.frameProps = new FrameProps();
        this.buttonPaste = new ButtonPasteDialog();
        this.isnew = false;
        this.changed = false;
        this.panelSize = new Dimension(240, 220);
        this.nextPosition = new Point(2, 2);
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.multiSelect = new Vector();
        StackedDialog.setDefaultParent(jframe);
        this.statusText = this.newLabel("                                   ");
        this.icons = new IconLibrary();
        this.model = new JTModel();
        this.panels = new Hashtable();
        this.treeBorder = new DragBorder();
        this.tree = new JTree(this.model);
        Font font = this.tree.getFont();
        if (prefUseProntoFont) {
            this.tree.setFont(Tonto.getPFont());
        }
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (object instanceof TreeProperties) {
                    jLabel.setIcon(iconProperties);
                    jLabel.setForeground(new Color(0, 0, 100));
                } else if (object instanceof CCFTreePanel) {
                    jLabel.setIcon(iconPanel);
                }
                if (!bl3) {
                    jLabel.setIcon(bl2 ? iconFolderOpened : iconFolderClosed);
                }
                if (object == Tonto.this.treeTarget) {
                    jLabel.setBorder(Tonto.this.treeBorder);
                } else {
                    jLabel.setBorder(null);
                }
                return jLabel;
            }
        });
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(this);
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n' && Tonto.this.treeSelection instanceof CCFTreePanel) {
                    debug.log(2, "show panel : " + Util.nickname(Tonto.this.treeSelection));
                    Tonto.this.showDeskPanel(((CCFTreePanel)Tonto.this.treeSelection).getPanel());
                }
            }
        });
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Object object;
                Object object2 = Tonto.this.treeTarget;
                boolean bl = Tonto.this.treeBefore;
                Point point = mouseEvent.getPoint();
                TreePath treePath = Tonto.this.tree.getPathForLocation(point.x, point.y);
                Rectangle rectangle = Tonto.this.tree.getPathBounds(treePath);
                if (rectangle != null) {
                    Tonto.this.treeBefore = point.y - rectangle.y < rectangle.height / 2;
                }
                Object object3 = object = treePath != null ? treePath.getLastPathComponent() : null;
                if (Tonto.this.treeDrag == null && object instanceof TreeNode) {
                    if (!(object instanceof Deletable)) {
                        return;
                    }
                    Tonto.this.treeDrag = (TreeNode)object;
                } else if (object != null && object != Tonto.this.treeDrag && (object.getClass() == Tonto.this.treeDrag.getClass() || Tonto.this.treeDrag.getParent().getClass() == object.getClass())) {
                    if (object.getClass() != Tonto.this.treeDrag.getClass()) {
                        Tonto.this.treeBefore = false;
                    }
                    Tonto.this.tree.setCursor(CURSOR_MOVE);
                    Tonto.this.treeTarget = object;
                } else {
                    Tonto.this.treeTarget = null;
                    Tonto.this.tree.setCursor(CURSOR_DEFAULT);
                }
                if (Tonto.this.treeTarget != object2 || Tonto.this.treeBefore != bl) {
                    Tonto.this.tree.repaint();
                }
                JViewport jViewport = Tonto.this.treeScroll.getViewport();
                Rectangle rectangle2 = jViewport.getViewRect();
                Dimension dimension = jViewport.getViewSize();
                int n = rectangle2.y;
                int n2 = rectangle2.y + rectangle2.height - 30;
                if (n > 0 && point.y - 30 < n) {
                    jViewport.setViewPosition(new Point(rectangle2.x, Math.max(0, rectangle2.y - 10)));
                } else if (point.y + 30 > n2 && n2 < dimension.height) {
                    jViewport.setViewPosition(new Point(rectangle2.x, Math.min(dimension.height - rectangle2.height, rectangle2.y + 10)));
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (Tonto.this.treeDrag != null && Tonto.this.treeTarget != null) {
                    if (Tonto.this.treeDrag instanceof CCFTreePanel) {
                        CCFDevice cCFDevice = null;
                        CCFPanel cCFPanel = null;
                        if (Tonto.this.treeTarget instanceof CCFTreeDevice) {
                            cCFDevice = ((CCFTreeDevice)Tonto.this.treeTarget).getDevice();
                            cCFPanel = cCFDevice.firstPanel;
                            while (cCFPanel != null && cCFPanel.next != null) {
                                cCFPanel = cCFPanel.next;
                            }
                        } else {
                            cCFPanel = ((CCFTreePanel)Tonto.this.treeTarget).getPanel();
                            cCFDevice = cCFPanel.getParentDevice();
                        }
                        CCFTreePanel cCFTreePanel = (CCFTreePanel)Tonto.this.treeDrag;
                        CCFPanel cCFPanel2 = cCFTreePanel.getPanel();
                        if (cCFDevice != null && cCFPanel2.getParentDevice() != null) {
                            TreeNode treeNode = cCFTreePanel.getParent();
                            TreeNode treeNode2 = (TreeNode)Tonto.this.treeTarget;
                            cCFPanel2.delete();
                            if (cCFPanel == null) {
                                cCFDevice.addPanel(cCFPanel2);
                            } else if (Tonto.this.treeBefore) {
                                cCFPanel.insertBefore(cCFPanel2);
                            } else {
                                cCFPanel.insertAfter(cCFPanel2);
                            }
                            if (treeNode2 instanceof CCFTreePanel) {
                                treeNode2.getParent().refresh();
                            } else {
                                treeNode2.refresh();
                            }
                            treeNode.refresh();
                            Tonto.this.setCCFChanged();
                        }
                    } else if (Tonto.this.treeDrag instanceof CCFTreeDevice) {
                        CCFDevice cCFDevice = null;
                        if (Tonto.this.treeTarget instanceof CCFTreeDeviceFolder) {
                            cCFDevice = ((CCFTreeDeviceFolder)Tonto.this.treeTarget).getRootDevice();
                        } else {
                            cCFDevice = ((CCFTreeDevice)Tonto.this.treeTarget).getDevice();
                            if (cCFDevice == null) {
                                Tonto.this.treeTarget = ((CCFTreeDevice)Tonto.this.treeTarget).getParent();
                            }
                        }
                        CCFTreeDevice cCFTreeDevice = (CCFTreeDevice)Tonto.this.treeDrag;
                        CCFDevice cCFDevice2 = cCFTreeDevice.getDevice();
                        TreeNode treeNode = cCFTreeDevice.getParent();
                        TreeNode treeNode3 = (TreeNode)Tonto.this.treeTarget;
                        cCFDevice2.delete();
                        if (cCFDevice == null) {
                            ((CCFTreeDeviceFolder)Tonto.this.treeTarget).setRootDevice(cCFDevice2);
                        } else if (Tonto.this.treeBefore) {
                            cCFDevice.insertBefore(cCFDevice2);
                        } else {
                            cCFDevice.insertAfter(cCFDevice2);
                        }
                        if (treeNode3 instanceof CCFTreeDevice) {
                            treeNode3.getParent().refresh();
                        } else {
                            treeNode3.refresh();
                        }
                        treeNode.refresh();
                        Tonto.this.setCCFChanged();
                    }
                }
                Tonto.this.treeDrag = null;
                Tonto.this.treeTarget = null;
                Tonto.this.tree.setCursor(CURSOR_DEFAULT);
                Tonto.this.tree.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = Tonto.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = Tonto.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    Tonto.this.setTreeSelection(treePath.getLastPathComponent());
                    Tonto.this.tree.setSelectionRow(n);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = Tonto.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = Tonto.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    Tonto.this.setTreeSelection(treePath.getLastPathComponent());
                    if (mouseEvent.getClickCount() == 1) {
                        if (Tonto.isRightClick(mouseEvent) && Tonto.this.ccf != null) {
                            Tonto.this.rightClickMenu(Tonto.this.treeSelection, mouseEvent.getPoint());
                        }
                    } else if (mouseEvent.getClickCount() == 2) {
                        if (Tonto.this.treeSelection instanceof CCFTreePanel) {
                            Tonto.this.showDeskPanel(((CCFTreePanel)Tonto.this.treeSelection).getPanel());
                        } else if (Tonto.this.treeSelection instanceof CCFTreeDeviceProperty) {
                            Tonto.this.setTreeSelection(treePath.getPathComponent(treePath.getPathCount() - 2));
                            Tonto.sendEvent(39);
                        } else if (Tonto.this.treeSelection instanceof CCFTreeSystemProperty) {
                            Tonto.this.editSystemProperties();
                        }
                    }
                }
            }
        });
        this.work = new JDesktopPane();
        this.work.setBackground(Color.lightGray);
        this.objectStatus = new ObjectPanel();
        this.treeScroll = new JScrollPane(this.tree);
        this.bindActionKeys(this.work);
        this.split = new JSplitPane(1, true, this.treeScroll, this.work);
        this.split.setDividerLocation(prefHSplitPos);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", this.split);
        jPanel.add("South", this.objectStatus);
        Tonto.addWorkspace(this, jPanel);
        if (string != null) {
            this.load(string);
        } else {
            this.file_new();
        }
    }

    private static void addWorkspace(Tonto tonto, JComponent jComponent) {
        tontos.put(jComponent, tonto);
        tontos.put(tonto, jComponent);
        int n = windows.getSelectedIndex();
        windows.add(jComponent, "<unnamed>", n + 1);
        windows.setSelectedComponent(jComponent);
    }

    public static int irVersion() {
        return Tonto.ccf().usesUDB() ? 2 : 1;
    }

    public static int iconMode() {
        return Tonto.custom() ? 3 : (Tonto.color() ? 2 : 1);
    }

    public static NameDialog nameDialog() {
        if (!Tonto.custom()) {
            return dialogName;
        }
        if (dialogName2 == null) {
            dialogName2 = new NameDialog(false);
        }
        return dialogName2;
    }

    public static boolean custom() {
        return Tonto.ccf().getConformsTo(prefDefaultModel).isCustom();
    }

    public static boolean color() {
        return Tonto.ccf().header().hasColor();
    }

    public static boolean udb() {
        return Tonto.ccf().usesUDB();
    }

    public static CCFHeader header() {
        return Tonto.ccf().header();
    }

    public static CCF ccf() {
        return Tonto.state().ccf;
    }

    public static Tonto state() {
        return current;
    }

    public static IRDatabase database() {
        return database;
    }

    public static CCFDevice device() {
        return Tonto.state().getCurrentDevice();
    }

    public static CCFPanel panel() {
        return Tonto.state().getCurrentPanel();
    }

    public static Dimension panelSize() {
        return Tonto.state().panelSize;
    }

    private static void browseForFile(String string, JTextField jTextField) {
        File file = Tonto.getFile(true, string, null);
        if (file != null && file.exists()) {
            jTextField.setText(file.toString());
        }
    }

    private static String init() {
        if (initShared) {
            return null;
        }
        Tonto.startCommandListener();
        tontos = new Hashtable();
        prefUseAWTFileDialogs = true;
        prefGrid = new Rectangle(0, 0, 5, 5);
        homeDir = new File(Util.sysprop("user.home"));
        prefDir = new File(homeDir, Util.onWindows() || Util.onMacintosh() ? "tonto" : ".tonto");
        altPrefDir = new File(homeDir, ".tonto");
        prefFile = new File(prefDir, "preferences");
        dbDir = new File(prefDir, "db");
        logDir = new File(prefDir, "logs");
        ccfDir = new File(prefDir, "ccf");
        moduleDir = new File(prefDir, "module");
        prefWorkingDir = prefDir;
        prefImageDir = prefDir;
        defaultDB = new File(dbDir, "default.db");
        recentFiles = new Vector();
        autoLoad = new Vector();
        menus = new Hashtable();
        popmenus = new Hashtable();
        tools = new Hashtable();
        border = new LineBorder(Color.black, 1);
        sessionUpdate = true;
        recentMenu = new Menu("Recent Files");
        snaps = new SnapInfo(0.0, 0.0);
        if (Util.onMacintosh() && altPrefDir.exists() && !prefDir.exists()) {
            altPrefDir.renameTo(prefDir);
        }
        prefDir.mkdirs();
        dbDir.mkdirs();
        logDir.mkdirs();
        ccfDir.mkdirs();
        moduleDir.mkdirs();
        Tonto.clearLogs();
        Tonto.setFontTable();
        Tonto.loadPreferences();
        Tonto.setLogging(prefLogToConsole);
        debug.log(0, "Tonto " + Tonto.version() + " started " + new Date());
        debug.log(1, "os = " + Util.sysprop("os.name") + " " + Util.sysprop("os.arch") + " " + Util.sysprop("os.version"));
        debug.log(0, "java = " + Util.sysprop("java.vm.vendor") + " " + Util.sysprop("java.vm.version"));
        debug.log(1, "prefs = " + prefDir);
        Tonto.setupMacSpecific();
        Tonto.loadFonts();
        Tonto.loadGalleryCCF();
        UIManager.put("InternalFrame.font", new FontUIResource(Tonto.getPFont()));
        UIManager.put("InternalFrame.titleFont", new FontUIResource(Tonto.getPFont()));
        UIManager.getLookAndFeelDefaults().put("InternalFrame.font", new FontUIResource(Tonto.getPFont()));
        UIManager.getLookAndFeelDefaults().put("InternalFrame.titleFont", new FontUIResource(Tonto.getPFont()));
        try {
            if (!defaultDB.exists()) {
                defaultDB.createNewFile();
            }
        }
        catch (Exception exception) {
            Tonto.debug(exception);
        }
        try {
            database = IRDatabase.open(defaultDB.toString());
        }
        catch (Exception exception) {
            Tonto.debug(exception);
        }
        dialogName = new NameDialog();
        timerEditor = new TimerEditor();
        prefsDialog = new PrefsDialog();
        irdb = new IRDBDialog();
        iconFolderOpened = Tonto.loadIcon("/images/iconFolderOpened.gif");
        iconFolderClosed = Tonto.loadIcon("/images/iconFolderClosed.gif");
        iconProperties = Tonto.loadIcon("/images/iconProperties.gif");
        iconPanel = Tonto.loadIcon("/images/iconPanel.gif");
        imageTontoSmall = Tonto.loadImage("/images/tonto.gif");
        MenuBar menuBar = new MenuBar();
        fileNewMenu = new Menu("New With Type");
        convertMenu = new Menu("Convert Type");
        ProntoModel[] prontoModelArray = ProntoModel.getModels();
        for (int i = 0; i < prontoModelArray.length; ++i) {
            fileNewMenu.add(Tonto.newMenuItem(prontoModelArray[i].getName(), -1, 512 + prontoModelArray[i].getModel(), true));
            convertMenu.add(Tonto.newMenuItem(prontoModelArray[i].getName(), -1, 1024 + prontoModelArray[i].getModel(), true));
        }
        convertMenu.setEnabled(false);
        Tonto.buildRevertMenu();
        fileNew = Tonto.newMenuItem("New " + prefDefaultModel.getName(), 78, 17);
        Menu menu = new Menu("Auto Load");
        menu.add(Tonto.newMenuItem("Add this file", -1, 145, true));
        menu.add(Tonto.newMenuItem("Remove this file", -1, 146, true));
        Menu menu2 = new Menu("File");
        menu2.add(fileNew);
        menu2.add(fileNewMenu);
        menu2.add(Tonto.newMenuItem("Close", -1, 29, true));
        menu2.addSeparator();
        menu2.add(Tonto.newMenuItem("Open...", 79, 19, true));
        menu2.add(Tonto.newMenuItem("Merge...", 77, 30, true));
        menu2.add(Tonto.newMenuItem("Revert", -1, 31));
        menu2.add(Tonto.newMenuItem("Upload from Remote", 85, 22, hasComm));
        menu2.addSeparator();
        menu2.add(Tonto.newMenuItem("Save", 83, 20));
        menu2.add(Tonto.newMenuItem("Save As...", -1, 21));
        menu2.add(Tonto.newMenuItem("Download to Remote", 68, 23, false));
        menu2.addSeparator();
        menu2.add(Tonto.newMenuItem("Export Zip...", -1, 27));
        menu2.addSeparator();
        menu2.add(recentMenu);
        menu2.add(menu);
        menu2.addSeparator();
        menu2.add(Tonto.newMenuItem("Preferences...", -1, 24, true));
        menu2.addSeparator();
        menu2.add(Tonto.newMenuItem("Exit", 81, 25, true));
        Menu menu3 = new Menu("Edit");
        menu3.add(Tonto.newMenuItem("Undo", 90, 33));
        menu3.add(Tonto.newMenuItem("Redo", 82, 34));
        menu3.addSeparator();
        menu3.add(Tonto.newMenuItem("Cut", 88, 35));
        menu3.add(Tonto.newMenuItem("Copy", 67, 36));
        menu3.add(Tonto.newMenuItem("Delete", 127, 37));
        menu3.add(Tonto.newMenuItem("Paste", 86, 38));
        menu3.addSeparator();
        menu3.add(Tonto.newMenuItem("Select All", 65, 40));
        menu3.add(Tonto.newMenuItem("Unselect All", -1, 41));
        menu3.addSeparator();
        menu3.add(Tonto.newMenuItem("Copy Alias", -1, 137, false, true));
        menu3.add(Tonto.newMenuItem("Paste Alias", -1, 141, false, true));
        menu3.addSeparator();
        menu3.add(Tonto.newMenuItem("Properties...", 80, 39));
        snapMenu = new Menu("Snap");
        snapMenu.add(Tonto.newMenuItem("Top Left", -1, 2061, true));
        snapMenu.add(Tonto.newMenuItem("Top Right", -1, 2063, true));
        snapMenu.add(Tonto.newMenuItem("Bottom Right", -1, 2065, true));
        snapMenu.add(Tonto.newMenuItem("Bottom Left", -1, 2067, true));
        orderMenu = new Menu("Order");
        orderMenu.add(Tonto.newMenuItem("Bring to Front", -1, 2051, true));
        orderMenu.add(Tonto.newMenuItem("Send to Back", -1, 2052, true));
        orderMenu.add(Tonto.newMenuItem("Bring Forward", -1, 2049, true));
        orderMenu.add(Tonto.newMenuItem("Send Backward", -1, 2050, true));
        alignMenu = new Menu("Align");
        alignMenu.add(Tonto.newMenuItem("Top", -1, 2053, true));
        alignMenu.add(Tonto.newMenuItem("Bottom", -1, 2054, true));
        alignMenu.add(Tonto.newMenuItem("Left", -1, 2055, true));
        alignMenu.add(Tonto.newMenuItem("Right", -1, 2056, true));
        alignMenu.add(Tonto.newMenuItem("H-Center", -1, 2057, true));
        alignMenu.add(Tonto.newMenuItem("V-Center", -1, 2058, true));
        Menu menu4 = new Menu("Object");
        menu4.add(Tonto.newMenuItem("Add Device", 68, 65, false, true));
        menu4.add(Tonto.newMenuItem("Add Panel", 80, 66, false, true));
        menu4.add(Tonto.newMenuItem("Add Frame", 70, 67, false, true));
        menu4.add(Tonto.newMenuItem("Add Button", 66, 68, false, true));
        menu4.addSeparator();
        menu4.add(snapMenu);
        menu4.add(orderMenu);
        menu4.add(alignMenu);
        menu4.addSeparator();
        menu4.add(Tonto.newMenuItem("Group", 71, 2059, false, true));
        menu4.add(Tonto.newMenuItem("Ungroup", 85, 2060, false, true));
        menu4.addSeparator();
        menu4.add(Tonto.newMenuItem("Transparent", 84, 2069, false, true));
        Menu menu5 = new Menu("Remote");
        menu5.add(Tonto.newMenuItem("Raw Download...", -1, 258, hasComm));
        menu5.add(Tonto.newMenuItem("Raw Upload...", -1, 257, hasComm));
        menu5.addSeparator();
        menu5.add(Tonto.newMenuItem("Locate Remote...", 70, 262, hasComm));
        menu5.add(Tonto.newMenuItem("Reboot Remote", -1, 260, hasComm));
        menu5.addSeparator();
        menu5.add(Tonto.newMenuItem("Undead Remote...", -1, 261, hasComm));
        menu5.add(Tonto.newMenuItem("Update Firmware...", -1, 266, hasComm));
        Menu menu6 = new Menu("View");
        menu6.add(Tonto.newMenuItem("Expand All", -1, 152, true));
        menu6.add(Tonto.newMenuItem("Collapse All", -1, 153, true));
        menu6.addSeparator();
        menu6.add(Tonto.newMenuItem("Toggle Grid", -1, 131, false));
        menu6.add(Tonto.newMenuItem("Toggle Snap", -1, 132, false));
        menu6.addSeparator();
        menu6.add(Tonto.newMenuItem("Toggle Selection", 72, 154, true));
        Menu menu7 = new Menu("Utility");
        menu7.add(convertMenu);
        menu7.addSeparator();
        menu7.add(Tonto.newMenuItem("Launch Emulator", 69, 264, false));
        menu7.add(Tonto.newMenuItem("Launch Editor", 75, 265, false));
        menu7.addSeparator();
        menu7.add(Tonto.newMenuItem("Check For Update", -1, 263, true));
        menu7.add(revertMenu);
        Menu menu8 = new Menu("Modules");
        menu8.add(Tonto.newMenuItem("IR Database", 73, 133, true));
        menu8.addSeparator();
        menu8.add(Tonto.newMenuItem("Icon Library", -1, 148, false));
        menu8.add(Tonto.newMenuItem("Icon Replace", -1, 149, false));
        menu8.addSeparator();
        menu8.add(Tonto.newMenuItem("Theme Master", -1, 158, false));
        menu8.add(Tonto.newMenuItem("Tab Master", -1, 155, false));
        Menu menu9 = new Menu("Links");
        menu9.add(Tonto.newMenuItem("FAQ", -1, 143, true));
        menu9.add(Tonto.newMenuItem("Guide", -1, 142, true));
        menu9.add(Tonto.newMenuItem("Tutorials", -1, 156, true));
        menu9.add(Tonto.newMenuItem("Changelog", -1, 144, true));
        menu9.addSeparator();
        menu9.add(Tonto.newMenuItem("CCF Library", -1, 150, true));
        menu9.add(Tonto.newMenuItem("Discrete Codes", -1, 151, true));
        Menu menu10 = new Menu("Help");
        menu10.add(Tonto.newMenuItem("About Tonto", -1, 129, true));
        menu10.addSeparator();
        menu10.add(Tonto.newMenuItem("Email Logfile", -1, 259, true));
        menu10.add(Tonto.newMenuItem("Log Window", -1, 147, true));
        menuBar.add(menu2);
        menuBar.add(menu3);
        menuBar.add(menu4);
        menuBar.add(menu5);
        menuBar.add(menu6);
        menuBar.add(menu7);
        menuBar.add(menu8);
        menuBar.add(menu9);
        menuBar.setHelpMenu(menu10);
        Tonto.menuEnable(17, true);
        orderMenu.setEnabled(false);
        alignMenu.setEnabled(false);
        rcDeviceAliasKey = new JMenu("Copy Alias", true);
        rcDevicePasteKey = new JMenu("Paste Alias", true);
        rcDeviceCopyActions = new JMenu("Copy Actions", true);
        rcDevicePasteActions = new JMenu("Paste Actions", true);
        rcDevice = new JPopupMenu();
        rcDevice.add(Tonto.newPopMenuItem("Add Panel", 66));
        rcDevice.add(new JSeparator());
        rcDevice.add(rcDeviceCopyActions);
        rcDevice.add(rcDeviceAliasKey);
        rcDevice.add(Tonto.newPopMenuItem("Copy Keys", 136));
        rcDevice.add(new JSeparator());
        rcDevice.add(rcDevicePasteActions);
        rcDevice.add(rcDevicePasteKey);
        rcDevice.add(Tonto.newPopMenuItem("Paste Keys", 140));
        rcDevice.add(new JSeparator());
        rcDevice.add(Tonto.newPopMenuItem("Properties...", 39));
        rcDevice.add(new JSeparator());
        rcDevice.add(Tonto.newPopMenuItem("Delete", 37));
        rcFrame = new JPopupMenu();
        rcFrame.add(Tonto.newPopMenuItem("Add Frame", 67));
        rcFrame.add(Tonto.newPopMenuItem("Add Button", 68));
        rcFrame.add(new JSeparator());
        rcFrame.add(Tonto.newPopToggleMenuItem("Show Grid", 131));
        rcFrame.add(Tonto.newPopToggleMenuItem("Snap To Grid", 132));
        rcFrame.add(new JSeparator());
        rcFrame.add(Tonto.newPopMenuItem("Group", 2059));
        rcFrame.add(Tonto.newPopMenuItem("UnGroup", 2060));
        rcFrame.add(new JSeparator());
        rcFrame.add(Tonto.newPopMenuItem("Properties...", 39));
        rcFrame.add(new JSeparator());
        rcFrame.add(Tonto.newPopMenuItem("Delete", 37));
        rcPanel = new JPopupMenu();
        rcPanel.add(Tonto.newPopMenuItem("Add Frame", 67));
        rcPanel.add(Tonto.newPopMenuItem("Add Button", 68));
        rcPanel.add(new JSeparator());
        rcPanel.add(Tonto.newPopToggleMenuItem("Show Grid", 131));
        rcPanel.add(Tonto.newPopToggleMenuItem("Snap To Grid", 132));
        rcPanel.add(new JSeparator());
        rcPanel.add(Tonto.newPopMenuItem("Properties...", 39));
        rcPanel.add(new JSeparator());
        rcPanel.add(Tonto.newPopMenuItem("Delete", 37));
        rcButton = new JPopupMenu();
        rcButton.add(Tonto.newPopMenuItem("Copy Alias", 137));
        rcButton.add(Tonto.newPopMenuItem("Copy Icons", 134));
        rcButton.add(Tonto.newPopMenuItem("Copy Actions", 135));
        rcButton.add(new JSeparator());
        rcButton.add(Tonto.newPopMenuItem("Paste Alias", 141));
        rcButton.add(Tonto.newPopMenuItem("Paste Icons", 138));
        rcButton.add(Tonto.newPopMenuItem("Paste Actions", 139));
        rcButton.add(Tonto.newPopMenuItem("Paste Replace Icons", 157));
        rcButton.add(new JSeparator());
        rcButton.add(Tonto.newPopMenuItem("Group", 2059));
        rcButton.add(new JSeparator());
        rcButton.add(Tonto.newPopToggleMenuItem("Show Grid", 131));
        rcButton.add(Tonto.newPopToggleMenuItem("Snap To Grid", 132));
        rcButton.add(new JSeparator());
        rcButton.add(Tonto.newPopMenuItem("Properties...", 39));
        rcButton.add(new JSeparator());
        rcButton.add(Tonto.newPopMenuItem("Delete", 37));
        rcDGroup = new JPopupMenu();
        rcDGroup.add(Tonto.newPopMenuItem("Add Device", 65));
        jframe = new JFrame("Tonto " + Tonto.version());
        jframe.setIconImage(imageTontoSmall);
        jframe.setDefaultCloseOperation(0);
        jframe.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Tonto.exitAll();
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
        JComponent jComponent = (JComponent)jframe.getContentPane();
        EventAction eventAction = new EventAction(28);
        Tonto.bindAction(jComponent, 87, 4, eventAction);
        Tonto.bindAction(jComponent, 87, 2, eventAction);
        Tonto.bindAction(jComponent, 127, 0, new EventAction(37));
        windows = new JTabbedPane();
        windows.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Tonto.tabSelect();
            }
        });
        tbar = new JToolBar();
        tbar.setFloatable(false);
        Tonto.addTool("New", "New", 26, "New Tab");
        Tonto.addTool("Close", "Close", 29, "Close");
        Tonto.addTool();
        Tonto.addTool("Open", "Open", 19, "Open a File");
        Tonto.addTool("Save", "Save", 20, "Save File");
        Tonto.addTool("SaveAs", "SaveAs", 21, "Save File As");
        Tonto.addTool();
        Tonto.addTool("Upload", "Export", 22, "Upload from Remote");
        Tonto.addTool("Download", "Import", 23, "Download to Remote");
        Tonto.addTool();
        Tonto.addTool("Undo", "Undo", 33, "Undo");
        Tonto.addTool("Redo", "Redo", 34, "Redo");
        Tonto.addTool();
        Tonto.addTool("Cut", "Cut", 35, "Cut");
        Tonto.addTool("Copy", "Copy", 36, "Copy");
        Tonto.addTool("Paste", "Paste", 38, "Paste");
        Tonto.addTool("Delete", "Delete", 37, "Delete");
        Tonto.addTool("Properties", "Properties", 39, "Properties");
        Tonto.addTool();
        Tonto.addTool("Group", "Group", 2059, "Group");
        Tonto.addTool("UnGroup", "UnGroup", 2060, "UnGroup");
        Tonto.addTool("Grid", "Grid", 131, "Toggle Grid");
        Tonto.addTool("GridSnap", "GridSnap", 132, "Toggle Grid Snap");
        Tonto.addTool();
        Tonto.addTool("Top", "AlignTop", 2053, "Align Top");
        Tonto.addTool("Bottom", "AlignBottom", 2054, "Align Bottom");
        Tonto.addTool("Left", "AlignLeft", 2055, "Align Left");
        Tonto.addTool("Right", "AlignRight", 2056, "Align Right");
        Tonto.addTool("Horiz", "AlignJustifyVertical", 2057, "Center Horizontal");
        Tonto.addTool("Vert", "AlignJustifyHorizontal", 2058, "Center Vertical");
        Tonto.addTool();
        Tonto.addTool("Preferences", "Preferences", 24, "Preferences");
        Tonto.addTool("Emulator", "Emulator", 264, "Emulator");
        Tonto.addTool("Editor", "Editor", 265, "Editor");
        Tonto.addTool();
        Tonto.addTool("Logfile", "ComposeMail", 259, "Send Logfile");
        Tonto.addTool("Help", "Help", 143, "FAQ");
        jComponent.setLayout(new BorderLayout());
        jComponent.add("North", tbar);
        jComponent.add("Center", windows);
        jframe.setMenuBar(menuBar);
        jframe.pack();
        jframe.setSize(900, 700);
        Rectangle rectangle = prefs.getRectangle(PREF_WINDOW_BOUNDS, jframe.getBounds());
        jframe.setBounds(rectangle);
        jframe.setVisible(true);
        if (!jframe.getBounds().equals(rectangle)) {
            debug.log(3, "0: window bounds mismatch: " + jframe.getBounds() + " != " + rectangle);
        }
        jframe.setBounds(rectangle);
        if (!jframe.getBounds().equals(rectangle)) {
            debug.log(3, "1: window bounds mismatch: " + jframe.getBounds() + " != " + rectangle);
        }
        if (!hasComm) {
            Tonto.infoDialog("Tonto cannot find the serial communication\nLibraries. Upload/Downoad has been disabled.");
        }
        Tonto.setupNetworkUpdates();
        initShared = true;
        String string = null;
        if (autoLoad.size() > 0) {
            for (int i = 0; i < autoLoad.size() - 1; ++i) {
                Tonto tonto = new Tonto();
                tonto.load((String)autoLoad.get(i));
            }
            string = (String)autoLoad.get(autoLoad.size() - 1);
        }
        debug.log(0, "initialized shared state");
        return string;
    }

    private static void buildRevertMenu() {
        File file = Tonto.getJar();
        Vector<Object> vector = new Vector<Object>();
        revertMenu = new Menu("Revert Tonto");
        revertMenu.setEnabled(true);
        File file2 = Tonto.getJarDir();
        if (file2 != null && file2.isDirectory()) {
            Object object;
            Object object2;
            int n;
            String[] stringArray = file2.list();
            block0: for (n = 0; n < stringArray.length; ++n) {
                object2 = stringArray[n].toLowerCase();
                if (!((String)object2).startsWith("tonto-") || !((String)object2).endsWith(".jar") || ((File)(object = new File(file2, stringArray[n]))).equals(file)) continue;
                for (int i = 0; i < vector.size(); ++i) {
                    if (((File)object).lastModified() <= ((File)vector.get(i)).lastModified()) continue;
                    vector.insertElementAt(object, i);
                    continue block0;
                }
                vector.add(object);
            }
            for (n = 0; n < vector.size(); ++n) {
                object2 = (File)vector.get(n);
                if (n < 5) {
                    object = ((File)object2).getName();
                    object = ((String)object).substring(6, ((String)object).lastIndexOf("."));
                    revertMenu.add(Tonto.newMenuItem((String)object, new RevertMenuAction((File)object2, (String)object)));
                    continue;
                }
                debug.log(0, "deleting old version: " + object2);
                ((File)object2).delete();
            }
        }
    }

    private static void addTool() {
        tbar.addSeparator();
    }

    private static void addTool(String string, String string2, int n, String string3) {
        ToolAction toolAction = new ToolAction(string, "/toolbar/general/" + string2 + "16.gif", n, string3);
        tools.put(new Integer(n), toolAction);
        tbar.add(toolAction);
    }

    private static void tabSelect() {
        Component component;
        int n = windows.getSelectedIndex();
        if (n >= 0 && (current = (Tonto)tontos.get(component = windows.getSelectedComponent())) != null) {
            current.updateCCFInfo();
            current.updateMenuState();
            debug.log(3, "tab change: " + n + " current=" + Util.nickname(current));
        }
    }

    private static void setupMacSpecific() {
        if (!Util.onMacintosh()) {
            return;
        }
        try {
            MRJApplicationUtils.registerPrefsHandler(new MRJPrefsHandler(){

                @Override
                public void handlePrefs() {
                    Tonto.sendEvent(24);
                }
            });
            MRJApplicationUtils.registerAboutHandler(new MRJAboutHandler(){

                @Override
                public void handleAbout() {
                    Tonto.sendEvent(129);
                }
            });
            MRJApplicationUtils.registerOpenDocumentHandler(new MRJOpenDocumentHandler(){

                @Override
                public void handleOpenFile(File file) {
                    Tonto.load(file.toString(), true);
                }
            });
            MRJApplicationUtils.registerQuitHandler(new MRJQuitHandler(){

                @Override
                public void handleQuit() {
                    Tonto.exitAll();
                }
            });
            MRJFileUtils.setDefaultFileCreator(new MRJOSType("TNTO"));
            MRJFileUtils.setDefaultFileType(new MRJOSType("CCF "));
        }
        catch (Throwable throwable) {
            Tonto.debug(throwable);
        }
    }

    private static void loadPreferences() {
        try {
            StringTokenizer stringTokenizer;
            Object object;
            Object object2;
            Object object3;
            prefs = new Preferences();
            prefs.load(prefFile);
            prefUpdateRoot = prefs.getProperty(PREF_UPDATE_ROOT, "http://giantlaser.com/tonto/tonto");
            prefDefaultModel = ProntoModel.getModelByName(prefs.getProperty(PREF_DEFAULT_MODEL, "TS1000"));
            prefGrid = prefs.getRectangle(PREF_GRID_SIZE, prefGrid);
            prefGridSnap = prefs.getBoolean(PREF_GRID_SNAP, true);
            prefGridShow = prefs.getBoolean(PREF_GRID_SHOW, false);
            prefGridMinorTicks = prefs.getInteger(PREF_GRID_MINOR_TICKS, 4);
            prefGridMinorColor = new CCFColor(prefs.getInteger(PREF_GRID_MINOR_COLOR, 222));
            prefGridMajorColor = new CCFColor(prefs.getInteger(PREF_GRID_MAJOR_COLOR, 180));
            Debug.setLevels(prefs.getProperty(PREF_DEBUG_LEVELS, "comm=2,xmodem=2,ccf=1,tonto=2"));
            prefCommPort = prefs.getProperty(PREF_DEFAULT_PORT);
            prefScanOtherPorts = prefs.getBoolean(PREF_SCAN_OTHER_PORTS, true);
            prefScanThreaded = prefs.getBoolean(PREF_SCAN_THREADED, !Util.onMacintosh() && !Util.onWindows98());
            prefScanModems = prefs.getBoolean(PREF_SCAN_MODEMS, false);
            String string = prefs.getProperty(PREF_COMM_TIMEOUTS);
            if (string != null && ((StringTokenizer)(object3 = new StringTokenizer(string, ","))).countTokens() >= 3) {
                Comm.setCommandDelay(Integer.parseInt(((StringTokenizer)object3).nextToken()));
                Comm.setAttentionDelay(Integer.parseInt(((StringTokenizer)object3).nextToken()));
                Comm.setLoadDelay(Integer.parseInt(((StringTokenizer)object3).nextToken()));
            }
            if ((object3 = prefs.getProperty(PREF_RECENT_FILES)) != null) {
                object2 = new StringTokenizer((String)object3, File.pathSeparator);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    Tonto.addRecentFile(((StringTokenizer)object2).nextToken());
                }
            }
            if ((object2 = prefs.getProperty(PREF_FONT_SCALING)) != null) {
                fontTable = Tonto.cloneFontTable();
                object = new StringTokenizer((String)object2, ",");
                for (int i = 0; i < 18 && ((StringTokenizer)object).hasMoreTokens(); ++i) {
                    Tonto.fontTable[i / 3][i % 3] = Integer.parseInt(((StringTokenizer)object).nextToken());
                }
            }
            prefTreeFontSize = prefs.getInteger(PREF_FONT_SIZE, 10);
            prefUseProntoFont = prefs.getBoolean(PREF_FONT_INTREE, Util.isJDK14() || !Util.isSunJDK());
            prefLogToConsole = prefs.getBoolean(PREF_LOG_TO_CONSOLE, false);
            prefUseAWTFileDialogs = prefs.getBoolean(PREF_USE_AWT_DIALOG, true);
            prefObeyRemoteCap = prefs.getBoolean(PREF_OBEY_REMOTE_CAP, false);
            prefEmitIR = prefs.getBoolean(PREF_TEST_EMIT_IR, false);
            prefShowDeviceProps = prefs.getBoolean(PREF_SHOW_DEV_PROPS, true);
            prefShowWebSafe = prefs.getBoolean(PREF_COLOR_WEBSAFE, true);
            object = prefs.getProperty(PREF_COLOR_MAP);
            prefColorMap = CCFColor.defaultMap;
            if (object != null && (stringTokenizer = new StringTokenizer((String)object, ",")).countTokens() >= 4) {
                prefColorMap = new CCFColor[]{new CCFColor(Integer.parseInt(stringTokenizer.nextToken())), new CCFColor(Integer.parseInt(stringTokenizer.nextToken())), new CCFColor(Integer.parseInt(stringTokenizer.nextToken())), new CCFColor(Integer.parseInt(stringTokenizer.nextToken()))};
            }
            if (!(prefWorkingDir = new File(prefs.getProperty(PREF_WORKING_DIR, prefWorkingDir.toString()))).exists()) {
                prefWorkingDir = prefDir;
            }
            if (!(prefImageDir = new File(prefs.getProperty(PREF_IMAGE_DIR, prefImageDir.toString()))).exists()) {
                prefImageDir = prefDir;
            }
            prefEditor = prefs.getProperty(PREF_EDITOR);
            prefImageEditor = prefs.getProperty(PREF_IMAGE_EDITOR);
            String string2 = prefs.getProperty(PREF_AUTOLOAD_FILES, "");
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            while (stringTokenizer2.hasMoreTokens()) {
                autoLoad.add(stringTokenizer2.nextToken());
            }
            prefHSplitPos = prefs.getInteger(PREF_SPLIT_HORIZONTAL, 180);
            prefUUID = prefs.getProperty(PREF_UUID);
            if (prefUUID == null) {
                prefUUID = Tonto.genUUID();
                prefs.put(PREF_UUID, prefUUID);
            }
            prefNetworkUpdate = prefs.getBoolean(PREF_NETWORK_UPDATES, false);
            CCFColor.setGrayTint(prefs.getInteger(PREF_GRAY_TINT, CCFColor.getGrayTint()));
            prefCenterDialogs = prefs.getBoolean(PREF_CENTER_DIALOGS, true);
            prefSelectionLast = prefs.getBoolean(PREF_SELECTION_LAST, false);
        }
        catch (Exception exception) {
            Tonto.debug(exception);
        }
    }

    private static void savePreferences() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = recentFiles.size(); i > 0; --i) {
                stringBuffer.append(recentFiles.get(i - 1));
                stringBuffer.append(File.pathSeparator);
            }
            String string = stringBuffer.toString();
            stringBuffer.setLength(0);
            for (int i = 0; i < fontTable.length; ++i) {
                stringBuffer.append(fontTable[i][0] + "," + fontTable[i][1] + "," + fontTable[i][2] + ",");
            }
            String string2 = stringBuffer.toString();
            stringBuffer.setLength(0);
            for (int i = 0; i < autoLoad.size(); ++i) {
                stringBuffer.append(autoLoad.get(i) + (i < autoLoad.size() - 1 ? "," : ""));
            }
            String string3 = stringBuffer.toString();
            prefs.setProperty(PREF_UPDATE_ROOT, prefUpdateRoot);
            prefs.setProperty(PREF_DEFAULT_MODEL, prefDefaultModel.getName());
            prefs.setProperty(PREF_GRID_SIZE, prefGrid);
            prefs.setProperty(PREF_GRID_SNAP, prefGridSnap);
            prefs.setProperty(PREF_GRID_SHOW, prefGridShow);
            prefs.setProperty(PREF_GRID_MINOR_TICKS, prefGridMinorTicks);
            prefs.setProperty(PREF_GRID_MINOR_COLOR, prefGridMinorColor.getColorIndex());
            prefs.setProperty(PREF_GRID_MAJOR_COLOR, prefGridMajorColor.getColorIndex());
            prefs.setProperty(PREF_DEBUG_LEVELS, Debug.getLevels());
            prefs.setProperty(PREF_DEFAULT_PORT, prefCommPort != null ? prefCommPort : "");
            prefs.setProperty(PREF_SCAN_OTHER_PORTS, prefScanOtherPorts);
            prefs.setProperty(PREF_SCAN_THREADED, prefScanThreaded);
            prefs.setProperty(PREF_SCAN_MODEMS, prefScanModems);
            prefs.setProperty(PREF_COMM_TIMEOUTS, Comm.getCommandDelay() + "," + Comm.getAttentionDelay() + "," + Comm.getLoadDelay());
            prefs.setProperty(PREF_WINDOW_BOUNDS, jframe.getBounds());
            prefs.setProperty(PREF_RECENT_FILES, string);
            prefs.setProperty(PREF_FONT_SCALING, string2);
            prefs.setProperty(PREF_FONT_INTREE, prefUseProntoFont);
            prefs.setProperty(PREF_FONT_SIZE, prefTreeFontSize);
            prefs.setProperty(PREF_LOG_TO_CONSOLE, prefLogToConsole);
            prefs.setProperty(PREF_COLOR_WEBSAFE, prefShowWebSafe);
            prefs.setProperty(PREF_COLOR_MAP, prefColorMap[0].getColorIndex() + "," + prefColorMap[1].getColorIndex() + "," + prefColorMap[2].getColorIndex() + "," + prefColorMap[3].getColorIndex());
            prefs.setProperty(PREF_USE_AWT_DIALOG, prefUseAWTFileDialogs);
            prefs.setProperty(PREF_WORKING_DIR, prefWorkingDir.toString());
            prefs.setProperty(PREF_IMAGE_DIR, prefImageDir.toString());
            prefs.setProperty(PREF_OBEY_REMOTE_CAP, prefObeyRemoteCap);
            prefs.setProperty(PREF_TEST_EMIT_IR, prefEmitIR);
            prefs.setProperty(PREF_SHOW_DEV_PROPS, prefShowDeviceProps);
            prefs.setProperty(PREF_EDITOR, prefEditor);
            prefs.setProperty(PREF_IMAGE_EDITOR, prefImageEditor);
            prefs.setProperty(PREF_AUTOLOAD_FILES, string3);
            prefs.setProperty(PREF_SPLIT_HORIZONTAL, Tonto.state().split.getDividerLocation());
            prefs.setProperty(PREF_NETWORK_UPDATES, prefNetworkUpdate);
            prefs.setProperty(PREF_GRAY_TINT, CCFColor.getGrayTint());
            prefs.setProperty(PREF_CENTER_DIALOGS, prefCenterDialogs);
            prefs.setProperty(PREF_SELECTION_LAST, prefSelectionLast);
            prefs.save(prefFile);
        }
        catch (Exception exception) {
            Tonto.debug(exception);
        }
    }

    private static void setLogging(boolean bl) {
        try {
            logFile = new File(logDir, "current.log");
            if (logFile.exists()) {
                new File(logDir, "current.log").renameTo(new File(logDir, Util.time() + ".log"));
            }
            Debug.logToFile(logFile.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Debug.logToStream(System.out);
        }
        if (bl) {
            if (console == null) {
                console = new DebugListener(){

                    @Override
                    public void debugAction(String string) {
                        System.out.println(string);
                    }
                };
            }
            Debug.addListener(console);
        } else if (console != null) {
            Debug.removeListener(console);
        }
    }

    private static void loadGalleryCCF() {
        debug.log(2, "loading gray gallery");
        try {
            CCF cCF = new CCF();
            byte[] byArray = ByteOutputBuffer.readFully(Tonto.class.getResourceAsStream("/ccf/gallery-gray.ccf"));
            cCF.decode(byArray);
            defaultGrayButton = cCF.getDeviceByName("buttons").getPanelByName("default").getButtonByID("default");
            cCF = new CCF();
            byArray = ByteOutputBuffer.readFully(Tonto.class.getResourceAsStream("/ccf/gallery-color.ccf"));
            cCF.decode(byArray);
            defaultColorButton = cCF.getDeviceByName("buttons").getPanelByName("default").getButtonByID("default");
        }
        catch (Exception exception) {
            Tonto.errorDialog(exception);
        }
    }

    private static void clearLogs() {
        long l = Util.time();
        String[] stringArray = logDir.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(logDir, stringArray[i]);
            long l2 = file.lastModified();
            if (l - l2 <= 604800000L) continue;
            debug.log(0, "deleting old log " + file);
            file.delete();
        }
    }

    private static void startCommandListener() {
        if (Util.onMacintosh()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(9911, 5, InetAddress.getLocalHost());
                    while (true) {
                        Socket socket;
                        String string;
                        StringTokenizer stringTokenizer;
                        if ((stringTokenizer = new StringTokenizer(string = new String(Util.readFully((socket = serverSocket.accept()).getInputStream())))).countTokens() >= 2 && stringTokenizer.nextToken().equals("load")) {
                            while (stringTokenizer.hasMoreTokens()) {
                                Tonto.load(URLDecoder.decode(stringTokenizer.nextToken()), true);
                            }
                        }
                        socket.close();
                    }
                }
                catch (Exception exception) {
                    Tonto.debug(exception);
                    return;
                }
            }
        }.start();
    }

    private static void setupNetworkUpdates() {
        jarDir = Tonto.getJarDir();
        if (!prefNetworkUpdate && prefs.getProperty(ASK_NETWORK_UPDATE) == null) {
            if (Tonto.confirmDialog("Enable Network Updates?", "Tonto has a feature to enable automatic updates\nover the network when a new version is detected.\nWould you like to enable this feature?")) {
                prefNetworkUpdate = true;
                sessionUpdate = true;
            }
            prefs.setProperty(ASK_NETWORK_UPDATE, "true");
        }
        if (sessionUpdate && prefNetworkUpdate && jarDir != null) {
            if (updateThread != null) {
                return;
            }
            updateThread = new Thread(){

                @Override
                public void run() {
                    debug.log(0, "Network updates started");
                    Util.safeSleep(10000);
                    while (prefNetworkUpdate && sessionUpdate) {
                        Tonto.checkForUpdates(false);
                        Util.safeSleep(3600000);
                    }
                }
            };
            updateThread.setDaemon(true);
            updateThread.start();
        } else {
            prefNetworkUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkForUpdates(boolean bl) {
        Class<Tonto> clazz = Tonto.class;
        synchronized (Tonto.class) {
            if (isUpdating) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            debug.log(3, "Looking for Tonto updates");
            try {
                URL uRL = new URL(prefUpdateRoot + "/VERSION?" + prefUUID);
                InputStream inputStream = uRL.openStream();
                String string = new String(Util.readFully(inputStream)).trim();
                double d = Double.parseDouble(string);
                double d2 = Double.parseDouble(Tonto.version());
                debug.log(3, "Current Tonto version: " + d);
                if (d2 < d) {
                    if (Tonto.confirmDialog("Upgrade to v" + string + "?", "A newer version of Tonto is available\nWould you like to update now?\nThis will be done in the background\n")) {
                        isUpdating = true;
                        Tonto.networkUpdate(string);
                    } else {
                        sessionUpdate = false;
                    }
                } else if (bl) {
                    Tonto.infoDialog("Tonto is up to date");
                }
            }
            catch (Exception exception) {
                Tonto.debug(exception);
            }
            return;
        }
    }

    private static void networkUpdate(String string) {
        final String string2 = string;
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    File file;
                    URL uRL = new URL(prefUpdateRoot + "/bin/tonto.jar?" + prefUUID);
                    URLConnection uRLConnection = uRL.openConnection();
                    int n = uRLConnection.getContentLength();
                    debug.log(0, "Network update " + Tonto.version() + " to " + string2 + ", size=" + n);
                    InputStream inputStream = uRLConnection.getInputStream();
                    File file2 = new File(jarDir, "download.tmp");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    Util.readFully(inputStream, fileOutputStream);
                    fileOutputStream.close();
                    int n2 = 1;
                    while (true) {
                        if (!(file = new File(jarDir, "tonto-" + string2 + "-" + n2 + ".jar")).exists()) break;
                        ++n2;
                    }
                    file2.renameTo(file);
                    debug.log(0, "Network update saved '" + file + "'");
                    inputStream.close();
                    Tonto.infoDialog("Tonto update complete. Restart Tonto\nto use the new version.");
                }
                catch (Exception exception) {
                    Tonto.debug(exception);
                    Tonto.errorDialog("Network update failed");
                }
                finally {
                    Class<Tonto> clazz = Tonto.class;
                    synchronized (Tonto.class) {
                        isUpdating = false;
                        // ** MonitorExit[var1_3] (shouldn't be in output)
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkUpdating() {
        Class<Tonto> clazz = Tonto.class;
        synchronized (Tonto.class) {
            if (isUpdating) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return Tonto.confirmDialog("Updating", "Tonto is updating. Cancel the update and exit?");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return true;
        }
    }

    private static Enumeration getAllTontos() {
        return new TontoEnum();
    }

    private static boolean isFileOpen(String string) {
        Enumeration enumeration = Tonto.getAllTontos();
        while (enumeration.hasMoreElements()) {
            String string2 = ((Tonto)enumeration.nextElement()).fileName;
            if (string2 == null || string == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static void clearAllGrayIconCaches() {
        Enumeration enumeration = Tonto.getAllTontos();
        while (enumeration.hasMoreElements()) {
            Tonto tonto = (Tonto)enumeration.nextElement();
            tonto.icons.clearIconCaches();
            tonto.refreshAllPanels();
        }
    }

    private static void refreshAllTreeModels() {
        Enumeration enumeration = Tonto.getAllTontos();
        while (enumeration.hasMoreElements()) {
            ((Tonto)enumeration.nextElement()).refreshTreeModel();
        }
    }

    private static void refreshAllMenus() {
        Enumeration enumeration = Tonto.getAllTontos();
        while (enumeration.hasMoreElements()) {
            ((Tonto)enumeration.nextElement()).updateMenuState();
        }
    }

    private static void exitAll() {
        if (!Tonto.checkUpdating()) {
            return;
        }
        while (windows.getTabCount() > 0) {
            Component component = windows.getComponentAt(windows.getTabCount() - 1);
            Tonto tonto = (Tonto)tontos.get(component);
            if (tonto.close()) continue;
            return;
        }
        Tonto.savePreferences();
        jframe.dispose();
        System.exit(exitCode);
    }

    public static String version() {
        if (version != null) {
            return version;
        }
        InputStream inputStream = Tonto.class.getResourceAsStream("/version");
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = new byte[20];
            int n = inputStream.read(byArray);
            version = new String(byArray, 0, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return version;
    }

    public static synchronized Component getTitleCanvas() {
        if (csplash == null) {
            csplash = new Canvas(){

                @Override
                public void paint(Graphics graphics) {
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(0, 0, 244, 204);
                    graphics.drawImage(splash, 2, 2, null);
                }

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(244, 204);
                }

                @Override
                public Dimension getPreferredSize() {
                    return this.getMinimumSize();
                }
            };
        }
        return csplash;
    }

    public static int getExitCode() {
        return exitCode;
    }

    public static boolean canScanThreaded() {
        return prefScanThreaded;
    }

    public static void debug(Throwable throwable) {
        if (throwable != null) {
            ByteOutputBuffer byteOutputBuffer = new ByteOutputBuffer();
            PrintWriter printWriter = new PrintWriter(byteOutputBuffer);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            debug.log(0, new String(byteOutputBuffer.toByteArray()));
        }
    }

    private void buttonLink() {
        debug.log(0, "button linking : " + clipboard + " to " + this.treeSelection);
        if (this.treeSelection instanceof ButtonBox && clipboard instanceof ButtonBox) {
            CCFButton cCFButton = ((ButtonBox)this.treeSelection).getButton();
            CCFButton cCFButton2 = ((ButtonBox)clipboard).getButton();
            cCFButton.appendAction(new ActionAliasButton(cCFButton2));
        }
    }

    private void buttonLearnIR() {
        if (this.treeSelection instanceof ButtonBox) {
            CCFButton cCFButton = ((ButtonBox)this.treeSelection).getButton();
            Pronto pronto = Tonto.learnIR();
            if (pronto != null) {
                cCFButton.appendAction(new ActionIRCode(new CCFIRCode(Tonto.ccf().header(), "Learned", pronto.encode(Tonto.irVersion()))));
            }
        }
    }

    private static void addRecentMenu(String string) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.state();
                Tonto.load(actionEvent.getActionCommand(), true);
            }
        });
        recentMenu.insert(menuItem, 0);
    }

    private static void addRecentFile(String string) {
        if (string == null || string.length() == 0 || !new File(string).exists() || string.toLowerCase().endsWith(".old")) {
            return;
        }
        int n = recentFiles.indexOf(string);
        if (n >= 0) {
            recentFiles.removeElementAt(n);
            recentMenu.remove(n);
        }
        while (recentFiles.size() > 10) {
            recentFiles.removeElementAt(10);
            recentMenu.remove(10);
        }
        recentFiles.insertElementAt(string, 0);
        Tonto.addRecentMenu(string);
    }

    private static String genUUID() {
        long l = Util.time();
        long l2 = new Random().nextLong();
        for (File file = jarDir; file != null; file = file.getParentFile()) {
            debug.log(0, "using dir '" + file + "' for uuid");
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                l2 *= fileArray[i].lastModified() + 13L;
            }
        }
        return Long.toHexString(l) + "-" + Long.toHexString(l2);
    }

    private static File getJar() {
        try {
            return new File(Util.unURL(Tonto.class.getProtectionDomain().getCodeSource().getLocation().getFile()));
        }
        catch (Exception exception) {
            Tonto.debug(exception);
            Tonto.errorDialog("Unable to locate running jar");
            return null;
        }
    }

    private static File getJarDir() {
        try {
            return Tonto.getJar().getParentFile();
        }
        catch (Exception exception) {
            Tonto.debug(exception);
            Tonto.errorDialog("Unable to find install dir for dynamic updates");
            return null;
        }
    }

    private void editSystemProperties() {
        if (Tonto.custom()) {
            this.xSystemProps.updateSystem();
        } else {
            this.systemProps.updateSystem();
        }
    }

    private Rectangle visibleBounds(Component component, Rectangle rectangle) {
        Dimension dimension = component != null ? component.getSize() : this.panelSize;
        return new Rectangle(Util.bound(-rectangle.width + 1, dimension.width - 1, rectangle.x), Util.bound(-rectangle.height + 1, dimension.height - 1, rectangle.y), rectangle.width, rectangle.height);
    }

    private Rectangle getSelectionBounds() {
        Rectangle rectangle = null;
        for (int i = 0; i < this.multiSelect.size(); ++i) {
            Component component = (Component)this.multiSelect.get(i);
            Rectangle rectangle2 = component.getBounds();
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    private void runEditor() {
        this.runWithCCF(prefEditor);
    }

    private String getEmulator() {
        if (this.ccf == null) {
            return null;
        }
        String string = prefs.getProperty("emulator.path." + this.ccf.getConformsTo(prefDefaultModel).getName(), "").trim();
        return string.length() > 0 ? string : null;
    }

    private void runEmulator() {
        String string = this.getEmulator();
        if (string != null) {
            this.runWithCCF(string);
        }
    }

    private void runWithCCF(String string) {
        if (string == null || this.ccf == null) {
            return;
        }
        try {
            final File file = File.createTempFile("tonto", ".ccf");
            this.ccf.save(file.toString());
            final Process process = Runtime.getRuntime().exec(string + " " + file.toString());
            new Thread(){

                @Override
                public void run() {
                    try {
                        process.waitFor();
                        17.sleep(2000L);
                        file.delete();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            Tonto.debug(exception);
        }
    }

    private void iconReplace(CCFIcon cCFIcon, CCFIcon cCFIcon2) {
        if (cCFIcon == null) {
            return;
        }
        final CCFIcon cCFIcon3 = cCFIcon;
        final CCFIcon cCFIcon4 = cCFIcon2;
        new CCFWalker(this.ccf).walk(new IWalker(){

            @Override
            public void onNode(CCFNode cCFNode) {
                if (cCFNode == null) {
                    return;
                }
                boolean bl = false;
                try {
                    Field[] fieldArray = cCFNode.getClass().getDeclaredFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        if (fieldArray[i].getType() != CCFIcon.class || fieldArray[i].get(cCFNode) != cCFIcon3) continue;
                        fieldArray[i].set(cCFNode, cCFIcon4);
                    }
                }
                catch (Exception exception) {
                    Tonto.debug(exception);
                }
                if (bl) {
                    Tonto.this.setCCFChanged();
                }
            }
        });
        this.setCCFChanged();
    }

    private CCFDevice getCurrentDevice() {
        return this.currentDevice;
    }

    private CCFPanel getCurrentPanel() {
        return this.currentPanel;
    }

    private Dimension max(Dimension dimension, int n, int n2) {
        return new Dimension(n > 0 ? Math.max(dimension.width, n) : dimension.width, n2 > 0 ? Math.max(dimension.height, n2) : dimension.height);
    }

    private boolean close() {
        if (this.checkChanges()) {
            Component component = (Component)tontos.get(this);
            tontos.remove(this);
            tontos.remove(component);
            windows.remove(component);
            Tonto.tabSelect();
            return true;
        }
        return false;
    }

    private void exit() {
        this.exit(0);
    }

    private void exit(int n) {
        if (this.close()) {
            exitCode = n;
            if (tontos.size() == 0 && Tonto.checkUpdating()) {
                Tonto.savePreferences();
                jframe.dispose();
                System.exit(n);
            }
        }
    }

    private int startMultiDo() {
        DoStart doStart = new DoStart();
        this.pushDo(doStart);
        return doStart.id;
    }

    private void endMultiDo(int n) {
        this.pushDo(new DoEnd(n));
    }

    private void pushDo(Doable doable) {
        this.pushDo(doable, true);
    }

    private Doable pushDo(Doable doable, boolean bl) {
        Doable doable2;
        this.undoStack.push(doable);
        doable.doIt();
        if (bl) {
            this.redoStack.setSize(0);
        }
        if (this.undoStack.size() > 100 && (doable2 = (Doable)this.undoStack.remove(0)) instanceof DoStart) {
            Doable doable3;
            int n = ((DoStart)doable2).id;
            while (!((doable3 = (Doable)this.undoStack.remove(0)) instanceof DoEnd) || ((DoEnd)doable3).id != n) {
            }
        }
        this.setCCFChanged();
        this.updateMenuState();
        return doable;
    }

    private Doable popDo() {
        Doable doable = null;
        if (!this.undoStack.empty()) {
            doable = (Doable)this.undoStack.pop();
            doable.undoIt();
            this.redoStack.push(doable);
            if (doable instanceof DoEnd) {
                Doable doable2;
                int n = ((DoEnd)doable).id;
                while (!((doable2 = this.popDo()) instanceof DoStart) || ((DoStart)doable2).id != n) {
                }
            }
        }
        this.updateMenuState();
        this.objectStatus.updateAll();
        return doable;
    }

    private void reDo() {
        if (!this.redoStack.empty() && this.pushDo((Doable)this.redoStack.pop(), false) instanceof DoStart) {
            while (!(this.pushDo((Doable)this.redoStack.pop(), false) instanceof DoEnd)) {
            }
        }
        this.objectStatus.updateAll();
    }

    private static void closeComm() {
        if (comm != null) {
            comm.close();
            comm = null;
        }
    }

    static Pronto learnIR() {
        if (Tonto.getComm() == null) {
            Tonto.showCommError();
            return null;
        }
        IRCapture iRCapture = new IRCapture();
        if (!iRCapture.invoke()) {
            debug.log(2, "signal rejected");
            return null;
        }
        debug.log(2, "signal accepted");
        Pronto pronto = iRCapture.getIRCode();
        if (pronto != null) {
            jframe.getToolkit().getSystemClipboard().setContents(new StringSelection(pronto.encode()), null);
        }
        return pronto;
    }

    private static void showCommError() {
        if (commMsg != null) {
            Tonto.errorDialog(commMsg, commErr);
        }
    }

    private static void setCommError(String string, Throwable throwable) {
        commMsg = string;
        commErr = throwable;
    }

    private Task getCommTask(boolean bl) {
        final boolean bl2 = bl;
        return new Task("Locate Remote"){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    iTaskStatus.taskStatus(0, "Scanning for Remote");
                    if (comm == null) {
                        if (prefCommPort != null && !prefScanOtherPorts) {
                            Tonto.comm = Comm.detectPronto(prefCommPort);
                        } else {
                            Tonto.comm = Comm.scanForPronto(iTaskStatus, prefCommPort);
                        }
                    }
                    if (bl2 && comm != null) {
                        iTaskStatus.taskStatus(35, "Checking Pronto Status");
                        comm.queryPronto();
                        iTaskStatus.taskStatus(65, "Checking Pronto Capability");
                        comm.getCCFPossible();
                    }
                    if (comm != null) {
                        Tonto.this.updateMenuState();
                        prefCommPort = comm.getPortName();
                        iTaskStatus.taskStatus(100, "Complete");
                    } else {
                        Tonto.setCommError("Remote was not located on any ports", null);
                        iTaskStatus.taskError(new Exception("Remote was not located on any ports"));
                    }
                }
                catch (Throwable throwable) {
                    iTaskStatus.taskError(throwable);
                    Tonto.handleCommError(throwable);
                }
            }
        };
    }

    private static void handleCommError(Throwable throwable) {
        Tonto.setCommError("The Pronto is not responding", throwable);
        throwable.printStackTrace();
    }

    private static Comm getCommLink() {
        if (comm == null) {
            throw new RuntimeException("comm uninitialized");
        }
        return comm;
    }

    private static Comm getComm() {
        return Tonto.getComm(false);
    }

    private static Comm getComm(boolean bl) {
        try {
            if (comm == null) {
                final boolean bl2 = bl;
                final TransferDialog transferDialog = new TransferDialog("Scanning for Remote");
                new DialogThread(transferDialog){

                    @Override
                    public void body() throws Exception {
                        if (prefCommPort != null && !prefScanOtherPorts) {
                            Tonto.comm = Comm.detectPronto(prefCommPort);
                        } else {
                            Tonto.comm = Comm.scanForPronto(transferDialog, prefCommPort);
                        }
                        if (comm == null) {
                            return;
                        }
                        if (bl2) {
                            transferDialog.taskStatus(35, "Checking Pronto Status");
                            comm.queryPronto();
                            transferDialog.taskStatus(65, "Checking Pronto Capability");
                            comm.getCCFPossible();
                        }
                        transferDialog.taskStatus(100, "Complete");
                    }
                }.checkError();
            }
            if (comm != null) {
                Tonto.state().updateMenuState();
                prefCommPort = comm.getPortName();
            } else {
                Tonto.setCommError("Remote was not located on any ports", null);
            }
        }
        catch (Throwable throwable) {
            Tonto.handleCommError(throwable);
        }
        return comm;
    }

    private ImageFont getIFont(int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= 8) {
            n = (n - 8) / 2;
        }
        return fonts[n];
    }

    private ImageFontLabel getFontLabel(String string, int n, int n2) {
        return new ImageFontLabel(this.getIFont(n2), string, n);
    }

    private static void loadFonts() {
        Class<Tonto> clazz = Tonto.class;
        try {
            fonts = new ImageFont[]{new ImageFont(clazz.getResourceAsStream("/font/tonto-08.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-10.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-12.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-14.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-16.iff")), new ImageFont(clazz.getResourceAsStream("/font/tonto-18.iff"))};
            fontPronto = Font.createFont(0, Tonto.getTontoFontStream());
            if (!fontPronto.getFamily().equalsIgnoreCase("Pronto2")) {
                Tonto.errorDialog("Tonto font is not accessible to the JVM.");
            }
        }
        catch (Throwable throwable) {
            Tonto.debug(throwable);
        }
        debug.log(1, "font = " + fontPronto);
    }

    private static InputStream getTontoFontStream() {
        return Tonto.class.getResourceAsStream("/font/map.pronto2");
    }

    private static InputStream getProntoFontStream() {
        return Tonto.class.getResourceAsStream("/font/map.pronto");
    }

    private static void setFontTable() {
        if (Util.onMacintosh()) {
            fontTable = fontMAC;
            debug.log(2, "font.table = Mac");
        } else if (Util.isIBMJDK()) {
            fontTable = fontIBM;
            debug.log(2, "font.table = IBM");
        } else if (Util.isSunJDK()) {
            fontTable = fontSUN;
            debug.log(2, "font.table = Sun");
        } else {
            fontTable = fontUnknown;
            debug.log(2, "font.table = Unknown");
        }
    }

    private static int[][] cloneFontTable() {
        int[][] nArray = new int[fontTable.length][3];
        for (int i = 0; i < fontTable.length; ++i) {
            nArray[i][0] = fontTable[i][0];
            nArray[i][1] = fontTable[i][1];
            nArray[i][2] = fontTable[i][2];
        }
        return nArray;
    }

    private void printKS(JComponent jComponent) {
        int n;
        debug.log(0, "printKS(" + jComponent + ")");
        InputMap inputMap = jComponent.getInputMap(0);
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        for (n = 0; keyStrokeArray != null && n < keyStrokeArray.length; ++n) {
            debug.log(0, "1) ks[" + n + "] = " + keyStrokeArray[n]);
        }
        inputMap = jComponent.getInputMap(2);
        keyStrokeArray = inputMap.allKeys();
        for (n = 0; keyStrokeArray != null && n < keyStrokeArray.length; ++n) {
            debug.log(0, "2) ks[" + n + "] = " + keyStrokeArray[n]);
        }
        inputMap = jComponent.getInputMap(1);
        keyStrokeArray = inputMap.allKeys();
        for (n = 0; keyStrokeArray != null && n < keyStrokeArray.length; ++n) {
            debug.log(0, "3) ks[" + n + "] = " + keyStrokeArray[n]);
        }
    }

    void addTabAdvance(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap(2);
        ActionMap actionMap = jComponent.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(9, 0, false), "TAB");
        inputMap.put(KeyStroke.getKeyStroke(9, 0, true), "TAB");
        actionMap.put("TAB", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Tonto.this.treeSelection instanceof ChildPanel) {
                    CCFChild cCFChild = ((ChildPanel)Tonto.this.treeSelection).getSource();
                    Tonto.this.setTreeSelection(Tonto.this.getChildPanel(cCFChild.getParentPanel().getNext(cCFChild)));
                }
            }
        });
    }

    private static void bindAction(JComponent jComponent, int n, int n2, Action action) {
        String string = "bind-" + nextAction++;
        jComponent.getInputMap(2).put(KeyStroke.getKeyStroke(n, n2, true), string);
        jComponent.getActionMap().put(string, action);
    }

    private void bindActionKeys(JComponent jComponent) {
        Tonto.bindAction(jComponent, 36, 0, new TabSelect(windows, 0));
        Tonto.bindAction(jComponent, 35, 0, new TabSelect(windows, -1));
        Tonto.bindAction(jComponent, 33, 0, new TabPager(windows, -1));
        Tonto.bindAction(jComponent, 34, 0, new TabPager(windows, 1));
        Tonto.bindAction(jComponent, 67, 8, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCFChild[] cCFChildArray;
                if (Tonto.this.dragSelection instanceof PanelPanel) {
                    CCFChild[] cCFChildArray2 = ((PanelPanel)Tonto.this.dragSelection).getPanel().getChildren();
                    if (cCFChildArray2 != null && cCFChildArray2.length > 0) {
                        ChildPanel childPanel = Tonto.this.getUIWrapper(cCFChildArray2[0]);
                        Tonto.this.setDragSelection(childPanel);
                    }
                } else if (Tonto.this.dragSelection instanceof FrameBox && (cCFChildArray = ((FrameBox)Tonto.this.dragSelection).getFrame().getChildren()) != null && cCFChildArray.length > 0) {
                    ChildPanel childPanel = Tonto.this.getUIWrapper(cCFChildArray[0]);
                    Tonto.this.setDragSelection(childPanel);
                }
            }
        });
        Tonto.bindAction(jComponent, 80, 8, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Tonto.this.dragSelection != null) {
                    Tonto.this.setDragSelection(Tonto.this.dragSelection.getParent());
                }
            }
        });
        Tonto.bindAction(jComponent, 73, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Tonto.this.treeSelection instanceof CCFTreeDevice) {
                    ((CCFTreeDevice)Tonto.this.treeSelection).getDevice().dump();
                    ((CCFTreeDevice)Tonto.this.treeSelection).getDevice().traceParents();
                } else if (Tonto.this.treeSelection instanceof CCFTreePanel) {
                    ((CCFTreePanel)Tonto.this.treeSelection).getPanel().dump();
                    ((CCFTreePanel)Tonto.this.treeSelection).getPanel().traceParents();
                } else if (Tonto.this.treeSelection instanceof PanelPanel) {
                    ((PanelPanel)Tonto.this.treeSelection).getPanel().dump();
                    ((PanelPanel)Tonto.this.treeSelection).getPanel().traceParents();
                } else if (Tonto.this.treeSelection instanceof ChildPanel) {
                    ((ChildPanel)Tonto.this.treeSelection).getSource().dump();
                    ((ChildPanel)Tonto.this.treeSelection).getSource().traceParents();
                }
            }
        });
        Tonto.bindAction(jComponent, 72, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.eventViewHideSelection();
            }
        });
        Tonto.bindAction(jComponent, 88, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.eventObjectTransparency();
            }
        });
        Tonto.bindAction(jComponent, 76, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Tonto.this.treeSelection instanceof CCFTreeDevice) {
                    CCFDevice cCFDevice = ((CCFTreeDevice)Tonto.this.treeSelection).getDevice();
                    CCFPanel cCFPanel = cCFDevice.createPanel("colors");
                    cCFDevice.addPanel(cCFPanel);
                    for (int i = 0; i < 16; ++i) {
                        CCFFrame cCFFrame = cCFPanel.createFrame(".");
                        cCFPanel.addFrame(cCFFrame);
                        cCFFrame.setLocation(new Point(0, i * 12));
                        cCFFrame.setSize(new Dimension(224, 12));
                        for (int j = 0; j < 16; ++j) {
                            CCFFrame cCFFrame2 = cCFFrame.createFrame(".");
                            cCFFrame.addFrame(cCFFrame2);
                            cCFFrame2.setSize(new Dimension(14, 12));
                            cCFFrame2.setLocation(new Point(j * 14, 0));
                            cCFFrame2.setBackground(new CCFColor(j * 16 + i));
                            cCFFrame2.setFont(CCFFont.SIZE_8);
                        }
                    }
                    ((CCFTreeDevice)Tonto.this.treeSelection).refresh();
                }
            }
        });
        Tonto.bindAction(jComponent, 77, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CCFDevice cCFDevice = Tonto.device();
                if (cCFDevice == null) {
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    CCFPanel cCFPanel = cCFDevice.createPanel("symbols:" + i);
                    for (int j = 0; j < 10; ++j) {
                        for (int k = 0; k < 10; ++k) {
                            int n = i * 100 + j * 10 + k;
                            if (n >= 256) continue;
                            CCFButton cCFButton = cCFPanel.createButton(new String(new char[]{(char)n}));
                            CCFIconSet cCFIconSet = cCFButton.getIconSet();
                            int[] nArray = cCFIconSet.getValidStates();
                            for (int i2 = 0; i2 < nArray.length; ++i2) {
                                cCFIconSet.setForeground(nArray[i2], new CCFColor(0));
                                cCFIconSet.setBackground(nArray[i2], new CCFColor(245));
                            }
                            cCFButton.setLocation(new Point(k * 24, j * 22));
                            cCFButton.setSize(new Dimension(23, 21));
                            cCFButton.setFont(CCFFont.SIZE_12);
                            cCFButton.appendAction(new ActionDelay(100));
                            cCFPanel.addButton(cCFButton);
                        }
                    }
                    cCFDevice.addPanel(cCFPanel);
                }
                Tonto.this.refreshTreeDevice(cCFDevice);
            }
        });
        Tonto.bindAction(jComponent, 120, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new RenderEditor(Tonto.ccf()).show();
            }
        });
        Tonto.bindAction(jComponent, 113, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.objectStatus.editName();
            }
        });
        Tonto.bindAction(jComponent, 114, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.buttonLink();
            }
        });
        Tonto.bindAction(jComponent, 76, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.buttonLearnIR();
            }
        });
        Tonto.bindAction(jComponent, 27, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.setDragSelection(null);
            }
        });
        Tonto.bindAction(jComponent, 84, 2, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.tilePanels();
            }
        });
        Tonto.bindAction(jComponent, 87, 3, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.this.closeAllPanels();
            }
        });
    }

    private void closeAllPanels() {
        Enumeration enumeration = this.panels.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof DeskPanel)) continue;
            try {
                ((DeskPanel)v).dispose();
            }
            catch (Exception exception) {}
        }
        this.nextPosition = new Point(2, 2);
    }

    private void tabMaster() {
        CCFPanel cCFPanel = Tonto.panel();
        if (cCFPanel == null) {
            return;
        }
        new TabMaster(cCFPanel);
    }

    private void themeMaster() {
        new ThemeMaster();
    }

    private void tilePanels() {
        Dimension dimension = null;
        Dimension dimension2 = this.work.getSize();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = this.panels.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof DeskPanel)) continue;
            DeskPanel deskPanel = (DeskPanel)v;
            if (dimension == null) {
                dimension = deskPanel.getSize();
                n3 = dimension2.width / dimension.width;
                n4 = dimension2.height / dimension.height;
            }
            deskPanel.setLocation(n * dimension.width + n5, n2 * dimension.height + n5);
            deskPanel.moveToFront();
            if (++n < n3) continue;
            n = 0;
            if (++n2 < n4) continue;
            n2 = 0;
            n5 += 25;
        }
        if (dimension != null) {
            this.nextPosition = new Point(n * dimension.width + n5, n2 * dimension.height + n5);
        }
    }

    private void setClipboard(Object object) {
        debug.log(2, "set clipboard " + Util.nickname(object));
        clipboard = object;
        this.updateMenuState();
    }

    private void setDragSelectionWithFocus(Component component) {
        this.setDragSelection(component, false);
        component.requestFocus();
    }

    private void setDragSelection(Component component) {
        this.setDragSelection(component, false);
    }

    private void setDragSelection(Component component, boolean bl) {
        if (component == this.dragSelection && !bl) {
            return;
        }
        this.hideSelection = false;
        debug.log(3, "set drag selection " + Util.nickname(component));
        this.tree.clearSelection();
        if (bl && this.dragSelection instanceof Selectable && component instanceof Selectable) {
            if (component.getParent() != this.dragSelection.getParent()) {
                return;
            }
            if (this.multiSelect.contains(component)) {
                ((Selectable)((Object)component)).unselect();
                this.multiSelect.remove(component);
                component = this.multiSelect.size() > 0 ? (Component)this.multiSelect.get(0) : null;
            } else {
                ((Selectable)((Object)component)).select(false);
                this.dragSelection = component;
                this.multiSelect.add(component);
            }
        } else {
            if (component != null && this.multiSelect.size() > 1 && this.multiSelect.contains(component)) {
                return;
            }
            if (this.dragSelection != component && this.dragSelection instanceof Selectable) {
                ((Selectable)((Object)this.dragSelection)).unselect();
                for (int i = 0; i < this.multiSelect.size(); ++i) {
                    ((Selectable)this.multiSelect.get(i)).unselect();
                }
            }
            this.multiSelect.setSize(0);
            this.dragSelection = component;
            if (this.dragSelection instanceof Selectable) {
                this.multiSelect.add(component);
                ((Selectable)((Object)component)).select(true);
            }
            if (component != null) {
                this.setTreeSelection(component);
            } else {
                this.objectStatus.setObject(null);
            }
        }
        this.updateMenuState();
    }

    private void setTreeSelection(Object object) {
        if (object == this.treeSelection) {
            return;
        }
        debug.log(3, "set tree selection " + Util.nickname(object));
        this.treeSelection = object;
        this.updateMenuState();
        if (this.treeSelection instanceof CCFTreeDevice) {
            this.currentDevice = ((CCFTreeDevice)this.treeSelection).getDevice();
        } else if (this.treeSelection instanceof CCFTreePanel) {
            this.currentDevice = ((CCFTreePanel)this.treeSelection).getPanel().getParentDevice();
            this.currentPanel = ((CCFTreePanel)this.treeSelection).getPanel();
        } else if (this.treeSelection instanceof ChildPanel) {
            CCFChild cCFChild = ((ChildPanel)this.treeSelection).getSource();
            if (cCFChild != null) {
                this.currentDevice = cCFChild.getParentDevice();
                this.currentPanel = cCFChild.getParentPanel();
            }
        } else {
            this.currentDevice = null;
            this.currentPanel = null;
        }
        if (!(object instanceof Component)) {
            this.setDragSelection(null);
        }
        this.objectStatus.setObject(object);
    }

    private void updateTreeSelection() {
        if (this.treeSelection instanceof TreeFolder) {
            ((TreeFolder)this.treeSelection).fireRereadContents();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isRightClick(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 4) != 0) return true;
        if ((n & (8 | 8)) == 0) return false;
        return true;
    }

    private void rightClickMenu(Object object, Point point) {
        if (object instanceof Component) {
            Component component = (Component)object;
            int n = point.x;
            int n2 = point.y;
            if (object instanceof ChildPanel) {
                Tonto.menuEnable(131, true);
                Tonto.menuEnable(132, true);
                Tonto.menuToggle(131, ((ChildPanel)object).isGridShowing());
                Tonto.menuToggle(132, ((ChildPanel)object).isSnapped());
            }
            if (object instanceof FrameBox) {
                rcFrame.show(component, n, n2);
            } else if (object instanceof PanelPanel) {
                rcPanel.show(component, n, n2);
            } else if (object instanceof ButtonBox) {
                rcButton.show(component, n, n2);
            }
        } else if (object instanceof CCFTreePanel) {
            rcPanel.show(this.tree, point.x, point.y);
            boolean bl = this.isPanelShowing(((CCFTreePanel)object).getPanel());
            Tonto.menuEnable(68, bl);
            Tonto.menuEnable(67, bl);
            Tonto.menuEnable(131, bl);
            Tonto.menuEnable(132, bl);
            if (bl) {
                PanelPanel panelPanel = this.getPanelPanel(((CCFTreePanel)object).getPanel());
                Tonto.menuToggle(131, panelPanel.isGridShowing());
                Tonto.menuToggle(132, panelPanel.isSnapped());
            }
        } else if (object instanceof CCFTreeDevice) {
            rcDevice.show(this.tree, point.x, point.y);
        } else if (object instanceof CCFTreeDeviceFolder) {
            rcDGroup.show(this.tree, point.x, point.y);
        }
    }

    private void setFileName(String string) {
        this.fileName = string;
    }

    private void updateTitle() {
        String string = this.ccf != null ? this.ccf.getConformsTo(prefDefaultModel).getName() : "";
        String string2 = (this.fileName != null ? new File(this.fileName).getName() : "<unnamed>") + (this.changed ? " *" : "");
        jframe.setTitle("Tonto " + Tonto.version() + " (" + string2 + ") " + string);
        windows.setTitleAt(windows.getSelectedIndex(), string2);
    }

    private void updateCCFInfo() {
        this.updateTitle();
        rcDeviceAliasKey.removeAll();
        rcDevicePasteKey.removeAll();
        rcDeviceCopyActions.removeAll();
        rcDevicePasteActions.removeAll();
        if (this.ccf == null) {
            return;
        }
        CCFHeader cCFHeader = this.ccf.header();
        String[] stringArray = cCFHeader.isNewMarantz() ? CCFAction.MarantzKeys : (cCFHeader.hasColor() ? CCFAction.ProntoProKeys : CCFAction.ProntoKeys);
        rcDevicePasteKey.add(Tonto.newPopMenuItem("On Select", 8192));
        rcDeviceCopyActions.add(Tonto.newPopMenuItem("On Select", 16384));
        rcDevicePasteActions.add(Tonto.newPopMenuItem("On Select", 32768));
        for (int i = 0; i < stringArray.length; ++i) {
            rcDeviceAliasKey.add(Tonto.newPopMenuItem(stringArray[i], 4096 + i));
            rcDevicePasteKey.add(Tonto.newPopMenuItem(stringArray[i], 8192 + i + 1));
            rcDeviceCopyActions.add(Tonto.newPopMenuItem(stringArray[i], 16384 + i + 1));
            rcDevicePasteActions.add(Tonto.newPopMenuItem(stringArray[i], 32768 + i + 1));
        }
    }

    private String getProntoName(String string) {
        return Tonto.nameDialog().getText(string);
    }

    private String getProntoName(String string, boolean bl) {
        return Tonto.nameDialog().getText(string, bl);
    }

    private String getProntoName(String string, String string2) {
        return Tonto.nameDialog().getText(string, string2);
    }

    private JLabel newLabel(String string) {
        return this.newLabel(string, true);
    }

    private JLabel newLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel(string);
        jLabel.setText(string);
        jLabel.setFont(new Font("Helvetica", 0, 10));
        jLabel.setForeground(Color.black);
        if (bl) {
            jLabel.setBorder(new BevelBorder(1));
        }
        return jLabel;
    }

    private static Font getPFont() {
        return Tonto.getPFont(prefTreeFontSize);
    }

    private static Font getPFont(int n) {
        int n2 = 0;
        switch (n) {
            case 8: {
                n2 = 0;
                break;
            }
            case 10: {
                n2 = 1;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
            case 14: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 4;
                break;
            }
            case 18: {
                n2 = 5;
                break;
            }
            default: {
                return fontPronto.deriveFont(0, n);
            }
        }
        Font font = fontPronto.deriveFont(0, (float)fontTable[n2][0] + (float)n);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale((float)fontTable[n2][1] / 100.0f, (float)fontTable[n2][2] / 100.0f);
        return font.deriveFont(affineTransform);
    }

    private static Image loadImage(String string) {
        URL uRL = Tonto.class.getClassLoader().getResource(string);
        if (uRL != null) {
            Image image = Toolkit.getDefaultToolkit().createImage(uRL);
            if (image == null && !string.startsWith("/")) {
                return Tonto.loadImage("/" + string);
            }
            return image;
        }
        if (!string.startsWith("/")) {
            return Tonto.loadImage("/" + string);
        }
        return null;
    }

    private static ImageIcon loadIcon(String string) {
        URL uRL = Tonto.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    private static void menuEnable(int n, boolean bl) {
        Integer n2 = new Integer(n);
        Tonto.menuEnable(menus.get(n2), bl);
        Tonto.menuEnable(popmenus.get(n2), bl);
        ToolAction toolAction = (ToolAction)tools.get(n2);
        if (toolAction != null) {
            toolAction.setEnabled(bl);
        }
    }

    private static void menuEnable(Object object, boolean bl) {
        if (object instanceof MenuItem) {
            ((MenuItem)object).setEnabled(bl);
        } else if (object instanceof JMenuItem) {
            ((JMenuItem)object).setEnabled(bl);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Tonto.menuEnable(enumeration.nextElement(), bl);
            }
        }
    }

    private static void menuToggle(int n, boolean bl) {
        Vector vector = (Vector)popmenus.get(new Integer(n));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e instanceof JCheckBoxMenuItem) {
                ((JCheckBoxMenuItem)e).setSelected(bl);
                continue;
            }
            if (!(e instanceof Vector)) continue;
            Vector vector2 = (Vector)e;
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                ((JCheckBoxMenuItem)enumeration2.nextElement()).setSelected(bl);
            }
        }
    }

    private boolean checkChanges() {
        if (this.changed) {
            String string = this.fileName != null ? "'" + new File(this.fileName).getName() + "' " : "";
            switch (JOptionPane.showConfirmDialog(StackedDialog.parent(), "Do you wish to save your changes?", "CCF " + string + "was modified", 1)) {
                case 0: {
                    return this.save();
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    private File getCCFLoad() {
        return Tonto.getFile(true, "CCF Files (*.ccf, *.zcf)", new String[]{"ccf", "zcf"});
    }

    private boolean load() {
        if (!this.checkChanges()) {
            return false;
        }
        File file = this.getCCFLoad();
        if (file != null) {
            this.load(file.getAbsolutePath());
            this.clearDesktop();
            return true;
        }
        return false;
    }

    public static void load(boolean bl) {
        Tonto.load(null, bl);
    }

    public static void load(String string, boolean bl) {
        if (bl) {
            boolean bl2;
            if (Tonto.isFileOpen(string) && !Tonto.confirmDialog("Already open", "'" + string + "' is already open. Open Again?")) {
                return;
            }
            Tonto tonto = new Tonto();
            boolean bl3 = !(string == null ? tonto.load() : tonto.load(string)) ? true : (bl2 = false);
            if (bl2) {
                tonto.exit();
            }
        } else if (string == null) {
            Tonto.state().load();
        } else {
            Tonto.state().load(string);
        }
    }

    private boolean load(String string) {
        TransferDialog transferDialog = new TransferDialog("Loading CCF", true);
        try {
            final String string2 = string;
            final boolean bl = string.toLowerCase().endsWith(".zcf");
            new DialogThread(transferDialog){

                @Override
                public void body() throws Exception {
                    if (bl) {
                        Tonto.this.newCCF = CCFPorter.importZip(string2, (ITaskStatus)((Object)this.dialog));
                    } else {
                        Tonto.this.newCCF = new CCF();
                        Tonto.this.newCCF.setNotify((ITaskStatus)((Object)this.dialog));
                        Tonto.this.newCCF.load(string2);
                    }
                }
            }.checkError();
            if (!this.checkMerge()) {
                this.setFileName(string);
            }
            this.setTreeSelection(null);
            Tonto.addRecentFile(string);
            this.updateCCFInfo();
            this.updateMenuState();
            this.isnew = false;
            return true;
        }
        catch (Throwable throwable) {
            autoLoad.remove(string);
            Tonto.errorDialog("'" + string + "' is not a valid CCF file", throwable);
            return false;
        }
    }

    private boolean canRevert() {
        return this.fileName != null && new File(this.fileName + ".old").exists();
    }

    private void revert() {
        if (this.canRevert() && Tonto.confirmDialog("Revert", "Revert to last saved version of '" + new File(this.fileName).getName() + "'?")) {
            String string = this.fileName;
            this.ccf = null;
            this.load(this.fileName + ".old");
            this.setFileName(string);
            this.updateTitle();
        }
    }

    private void save(String string) {
        if (string == null || this.ccf == null) {
            return;
        }
        String string2 = string.toLowerCase();
        if (!string2.endsWith(".ccf") && !string2.endsWith(".zcf")) {
            string = string + ".ccf";
        }
        if (!(!new File(string).exists() || this.fileName != null && string.equals(this.fileName) || Tonto.confirmDialog("Overwrite Existing", "File already exists. Overwrite?"))) {
            return;
        }
        TransferDialog transferDialog = new TransferDialog("Saving CCF", false);
        try {
            final String string3 = string;
            final boolean bl = string.toLowerCase().endsWith(".zcf");
            new DialogThread(transferDialog){

                @Override
                public void body() throws Exception {
                    if (bl) {
                        CCFPorter.exportZip(Tonto.this.ccf, string3, (ITaskStatus)((Object)this.dialog));
                    } else {
                        Tonto.this.ccf.setNotify((ITaskStatus)((Object)this.dialog));
                        Tonto.this.ccf.save(string3);
                    }
                }
            }.checkError();
            this.setCCFClean();
            Tonto.addRecentFile(string);
            this.setFileName(string);
            this.updateCCFInfo();
            this.updateMenuState();
        }
        catch (Throwable throwable) {
            Tonto.errorDialog("error writing to '" + string + "'", throwable);
            return;
        }
    }

    private boolean save() {
        if (this.fileName == null) {
            return this.saveAs();
        }
        this.save(this.fileName);
        return true;
    }

    private File getCCFSave() {
        return Tonto.getFile(false, "CCF Files (*.ccf, *.zcf)", new String[]{"ccf", "zcf"}, prefWorkingDir, this.fileName != null ? new File(this.fileName) : null);
    }

    private boolean saveAs() {
        File file = this.getCCFSave();
        if (file != null) {
            this.save(file.getAbsolutePath());
            return true;
        }
        return false;
    }

    private boolean checkMerge() {
        if (this.newCCF == null) {
            debug.log(0, "No new CCF for merge");
            return false;
        }
        boolean bl = true;
        if (!this.isnew && this.ccf != null && new MergeDialog().getValue()) {
            this.ccf.merge(this.newCCF);
            this.setCCFChanged();
        } else {
            this.ccf = this.newCCF;
            this.clearDesktop();
            this.setCCFClean();
            bl = false;
            this.isnew = false;
        }
        this.newCCF = null;
        this.updateMenuState();
        this.refreshTreeModel();
        this.icons.load(this.ccf);
        this.panelSize = this.ccf.getScreenSize(prefDefaultModel);
        return bl;
    }

    static File getFileOld(boolean bl, String string, String[] stringArray, File file, File file2) {
        String[] stringArray2 = stringArray;
        FileDialog fileDialog = new FileDialog((Frame)jframe, bl ? "Open" : "Save", bl ? 0 : 1);
        fileDialog.setDirectory(file.toString());
        fileDialog.setFilenameFilter(new MyFileFilter(stringArray, string));
        if (file2 != null) {
            fileDialog.setFile(file2.getName());
        }
        fileDialog.show();
        String string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string2 != null && string3 != null) {
            File file3 = new File(string2, string3);
            if (file == prefWorkingDir) {
                prefWorkingDir = file3.getParentFile();
            } else if (file == prefImageDir) {
                prefImageDir = file3.getParentFile();
            }
            return file3;
        }
        return null;
    }

    static File getFile(boolean bl, String string, String[] stringArray) {
        return Tonto.getFile(bl, string, stringArray, prefWorkingDir);
    }

    static File getFile(boolean bl, String string, String[] stringArray, File file) {
        return Tonto.getFile(bl, string, stringArray, file, null);
    }

    static File getFile(boolean bl, String string, String[] stringArray, File file, File file2) {
        if (prefUseAWTFileDialogs) {
            return Tonto.getFileOld(bl, string, stringArray, file, file2);
        }
        JFileChooser jFileChooser = new JFileChooser(file);
        if (file2 != null) {
            jFileChooser.setSelectedFile(file2);
        }
        jFileChooser.setFileFilter(new MyFileFilter(stringArray, string));
        int n = bl ? jFileChooser.showOpenDialog(jframe) : jFileChooser.showSaveDialog(jframe);
        if (n == 0) {
            File file3 = jFileChooser.getSelectedFile();
            if (file == prefWorkingDir) {
                prefWorkingDir = file3.getParentFile();
            } else if (file == prefImageDir) {
                prefImageDir = file3.getParentFile();
            }
            return file3;
        }
        return null;
    }

    static File[] getFiles(String string, String[] stringArray, File file) {
        if (prefUseAWTFileDialogs) {
            File file2 = Tonto.getFileOld(true, string, stringArray, file, null);
            if (file2 == null) {
                return null;
            }
            return new File[]{file2};
        }
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileFilter(new MyFileFilter(stringArray, string));
        int n = jFileChooser.showOpenDialog(jframe);
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            if (file == prefWorkingDir) {
                prefWorkingDir = fileArray[0].getParentFile();
            } else if (file == prefImageDir) {
                prefImageDir = fileArray[0].getParentFile();
            }
            return fileArray;
        }
        return null;
    }

    private void setCCFClean() {
        this.changed = false;
    }

    private void setCCFChanged() {
        boolean bl = !this.changed;
        this.isnew = false;
        this.changed = true;
        this.ccf.setModified();
        if (bl) {
            this.updateTitle();
        }
    }

    private void emailLogfile() {
        if (Tonto.confirmDialog("Email Logfile", "Do you want to send the current log to stewart@neuron.com?")) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        String string = Util.sysprop("user.name");
                        String string2 = prefs.getProperty("email", "");
                        string2 = CCFNode.rpad(string2, 30);
                        StringValueDialog stringValueDialog = new StringValueDialog("Return Email Address", string2, 0);
                        if (!stringValueDialog.invoke()) {
                            return;
                        }
                        string2 = stringValueDialog.getValue().trim();
                        if (string2.length() == 0 || string2.indexOf("@") < 0) {
                            string2 = "stewart@neuron.com";
                        } else {
                            prefs.put("email", string2);
                        }
                        debug.log(0, "Emailing logfile to stewart@neuron.com");
                        Socket socket = new Socket("209.61.186.37", 25);
                        InputStream inputStream = socket.getInputStream();
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream());
                        outputStreamWriter.write("HELO neuron\n");
                        outputStreamWriter.write("MAIL FROM: tonto-debug@giantlaser.com\n");
                        outputStreamWriter.write("RCPT TO: stewart@neuron.com\n");
                        outputStreamWriter.write("DATA\n");
                        outputStreamWriter.write("To: stewart@neuron.com\n");
                        outputStreamWriter.write("Reply-To: " + string2 + "\n");
                        outputStreamWriter.write("Subject: tonto log from <" + string);
                        outputStreamWriter.write("@" + InetAddress.getLocalHost().getHostName() + ">\n\n");
                        outputStreamWriter.write("=======( email: " + string2 + " )=======\n");
                        Tonto.this.writeHash(prefs, outputStreamWriter, "Preferences");
                        Tonto.this.writeHash(System.getProperties(), outputStreamWriter, "System Properties");
                        outputStreamWriter.write("\n========( Log File )========\n");
                        outputStreamWriter.write("");
                        if (logFile != null) {
                            byte[] byArray = new BufferedFile(logFile.toString(), "r").toByteArray();
                            outputStreamWriter.write(new String(byArray));
                        } else {
                            outputStreamWriter.write("file logging disabled");
                        }
                        outputStreamWriter.write("\n.\n");
                        ((Writer)outputStreamWriter).flush();
                        int n = 0;
                        byte[] byArray = new byte[1024];
                        while (inputStream.read(byArray) >= 0 && n++ < 10) {
                        }
                        ((Writer)outputStreamWriter).close();
                        inputStream.close();
                        socket.close();
                        Tonto.infoDialog("Logfile sent to stewart@neuron.com");
                    }
                    catch (Exception exception) {
                        debug.log(0, "Error emailing logfile: " + exception);
                        Tonto.errorDialog(exception);
                    }
                }
            }.start();
        }
    }

    private void writeHash(Hashtable hashtable, Writer writer, String string) throws IOException {
        writer.write("\n========( " + string + " )========\n");
        Vector vector = new Vector(hashtable.size());
        Object[] objectArray = hashtable.keys();
        while (objectArray.hasMoreElements()) {
            vector.add(objectArray.nextElement());
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            writer.write((String)objectArray[i] + " = " + hashtable.get(objectArray[i]) + "\n");
        }
    }

    private void upload(boolean bl) {
        if (bl) {
            Tonto tonto = new Tonto();
            if (!tonto.upload()) {
                tonto.exit();
            }
        } else {
            this.upload();
        }
    }

    private boolean upload() {
        if (!this.checkChanges()) {
            return false;
        }
        TaskList taskList = new TaskList("Load CCF From Remote"){

            @Override
            public void doCancel() {
                this.taskError(new Exception("Upload Cancelled"));
                Tonto.this.newCCF = null;
                Tonto.closeComm();
            }
        };
        taskList.addTasks(new Task[]{this.getCommTask(false), new Task("Loading CCF", 14){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    Comm comm = Tonto.getCommLink();
                    Tonto.this.newCCF = new CCF();
                    Tonto.this.newCCF.setNotify(iTaskStatus);
                    Tonto.this.newCCF.loadFromPronto(comm);
                }
                catch (Exception exception) {
                    iTaskStatus.taskError(exception);
                    Tonto.this.newCCF = null;
                }
            }
        }});
        taskList.invoke();
        this.checkMerge();
        this.updateCCFInfo();
        return !this.isnew;
    }

    private void rawUpload() {
        TaskList taskList = new TaskList("Load CCF From Remote"){

            @Override
            public void doCancel() {
                this.taskError(new Exception("Upload Cancelled"));
                Tonto.this.newCCF = null;
                Tonto.closeComm();
            }
        };
        taskList.addTasks(new Task[]{this.getCommTask(false), new Task("Loading CCF", 10){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    Comm comm = Tonto.getCommLink();
                    byte[] byArray = comm.getCCF(iTaskStatus);
                    File file = Tonto.this.getCCFSave();
                    if (file != null) {
                        new FileOutputStream(file).write(byArray);
                    }
                }
                catch (Exception exception) {
                    iTaskStatus.taskError(exception);
                }
            }
        }});
        taskList.invoke();
    }

    private void downloadFirmware(Firmware firmware, boolean bl) {
        if (prefCommPort == null) {
            Tonto.errorDialog("Default port is not set in preferences");
            return;
        }
        final Firmware firmware2 = firmware;
        final boolean bl2 = bl;
        class FWTaskList
        extends TaskList {
            private Comm comm;

            FWTaskList() {
                super("Firmware Update");
            }

            @Override
            public void doCancel() {
                this.taskError(new Exception("Firmware Flash Cancelled"));
                if (this.comm != null) {
                    this.comm.close();
                }
            }
        }
        FWTaskList fWTaskList = new FWTaskList();
        fWTaskList.addTasks(new Task[]{new Task("Flashing", 10){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    Tonto.closeComm();
                    Tonto.comm = new Comm(prefCommPort);
                    comm.updateFirmware(firmware2, Tonto.this.isnew ? null : Tonto.this.ccf, bl2, iTaskStatus);
                    Tonto.infoDialog("The Remote will now reboot");
                }
                catch (Exception exception) {
                    iTaskStatus.taskError(exception);
                }
            }
        }});
        fWTaskList.invoke();
    }

    private void download() {
        TaskList taskList = new TaskList("Save CCF To Remote"){

            @Override
            public void doCancel() {
                this.taskError(new Exception("Upload Cancelled"));
                Tonto.closeComm();
            }
        };
        taskList.addTasks(new Task[]{this.getCommTask(false), new Task("Check CCF"){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    Comm comm = Tonto.getCommLink();
                    if (comm.isCCFDirty() && !Tonto.confirmDialog("CCF Has Changed", "The CCF on the Remote has changed\nwithout being saved. Do you wish to\nproceed with the Download?")) {
                        iTaskStatus.taskError(new Exception("aborted"));
                    }
                }
                catch (Exception exception) {
                    iTaskStatus.taskError(exception);
                    Tonto.closeComm();
                }
            }
        }, new Task("Sending CCF", 10){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    Comm comm = Tonto.getCommLink();
                    Tonto.this.ccf.setUseRemoteCapability(prefObeyRemoteCap);
                    Tonto.this.ccf.setNotify(iTaskStatus);
                    Tonto.this.ccf.saveToPronto(comm);
                }
                catch (CCFException cCFException) {
                    iTaskStatus.taskError(cCFException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    iTaskStatus.taskError(exception);
                }
                finally {
                    Tonto.closeComm();
                }
            }
        }});
        if (taskList.invoke()) {
            Tonto.infoDialog("The Remote will now reboot");
            this.updateMenuState();
        }
    }

    private void rawDownload() {
        TaskList taskList = new TaskList("Load CCF From Remote"){

            @Override
            public void doCancel() {
                this.taskError(new Exception("Upload Cancelled"));
                Tonto.closeComm();
            }
        };
        taskList.addTasks(new Task[]{this.getCommTask(false), new Task("Check CCF"){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                if (!Tonto.confirmDialog("CCF Has Changed", "The CCF on the Remote has changed\nwithout being saved. Do you wish to\nproceed with the Download?")) {
                    iTaskStatus.taskError(new Exception("aborted"));
                }
            }
        }, new Task("Sending CCF", 11){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    File file = Tonto.this.getCCFLoad();
                    if (file == null || !file.exists()) {
                        iTaskStatus.taskError(new Exception("aborted"));
                        return;
                    }
                    Comm comm = Tonto.getCommLink();
                    byte[] byArray = new BufferedFile(file.toString(), "r").toByteArray();
                    comm.setCCF(byArray, iTaskStatus);
                }
                catch (Exception exception) {
                    iTaskStatus.taskError(exception);
                }
                finally {
                    Tonto.closeComm();
                }
            }
        }});
        if (taskList.invoke()) {
            Tonto.infoDialog("The Remote will now reboot");
            this.updateMenuState();
        }
    }

    private void rebootPronto() {
        TaskList taskList = new TaskList("Reboot Remote");
        taskList.addTasks(new Task[]{this.getCommTask(false), new Task("Sending Reboot"){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                try {
                    Comm comm = Tonto.getCommLink();
                    iTaskStatus.taskStatus(50, "Send Command");
                    comm.rebootPronto();
                    iTaskStatus.taskStatus(100, "Command Sent");
                }
                catch (Exception exception) {
                    iTaskStatus.taskError(exception);
                    Tonto.closeComm();
                }
            }
        }});
        if (taskList.invoke()) {
            Tonto.infoDialog("The Remote will now reboot");
            Tonto.closeComm();
        }
    }

    private void firmware() {
        File file = Tonto.getFile(true, "Firmware Updater", new String[]{"exe"});
        if (file != null) {
            try {
                new FirmwareDialog(file).show();
            }
            catch (Exception exception) {
                Tonto.errorDialog("Invalid Firmware Update", exception);
            }
        }
    }

    private void fileNew() {
        this.fileNew(prefDefaultModel.getModel());
    }

    private void fileNew(int n) {
        new Tonto().file_new(n);
    }

    private void file_new() {
        this.file_new(prefDefaultModel.getModel());
    }

    private void file_new(int n) {
        if (!this.checkChanges()) {
            return;
        }
        this.ccf = new CCF(ProntoModel.getModel(n));
        this.panelSize = this.ccf.getScreenSize(prefDefaultModel);
        this.setFileName(null);
        this.nextPosition = new Point(2, 2);
        this.clearDesktop();
        this.updateCCFInfo();
        this.updateMenuState();
        this.icons.load(this.ccf);
        this.setTreeSelection(null);
        this.setCCFClean();
        this.isnew = true;
    }

    private void file_close() {
        if (!this.checkChanges()) {
            return;
        }
    }

    public boolean enableMenuPaste() {
        return this.treeSelection instanceof JTextComponent || this.canPaste(this.treeSelection) || this.treeSelection instanceof Parental && this.canPaste(((Parental)this.treeSelection).getMyParent());
    }

    private boolean canPaste(Object object) {
        return object instanceof Pastable && ((Pastable)object).acceptPaste(clipboard);
    }

    private void updateMenuState() {
        CCFChild[] cCFChildArray = null;
        boolean bl = this.multiSelect.size() > 1;
        boolean bl2 = this.fileName != null && !autoLoad.contains(this.fileName);
        boolean bl3 = this.dragSelection instanceof ChildPanel || this.treeSelection instanceof CCFTreePanel && ((CCFTreePanel)this.treeSelection).isPanelShowing();
        orderMenu.setEnabled(this.dragSelection instanceof ChildPanel && !(this.dragSelection instanceof PanelPanel));
        alignMenu.setEnabled(bl);
        convertMenu.setEnabled(this.isLoaded());
        rcDevicePasteKey.setEnabled(clipboard instanceof CCFAction);
        rcDevicePasteActions.setEnabled(clipboard instanceof CCFActionList);
        Tonto.menuEnable(31, this.canRevert());
        Tonto.menuEnable(20, this.isLoaded());
        Tonto.menuEnable(21, this.isLoaded());
        Tonto.menuEnable(27, this.isLoaded());
        Tonto.menuEnable(22, hasComm);
        Tonto.menuEnable(23, hasComm && this.isLoaded());
        Tonto.menuEnable(29, tontos.size() > 2);
        Tonto.menuEnable(33, !this.undoStack.empty());
        Tonto.menuEnable(34, !this.redoStack.empty());
        Tonto.menuEnable(35, this.treeSelection instanceof Deletable);
        Tonto.menuEnable(36, this.treeSelection instanceof Copyable || this.treeSelection instanceof JTextComponent);
        Tonto.menuEnable(38, this.enableMenuPaste());
        Tonto.menuEnable(37, this.treeSelection instanceof Deletable);
        Tonto.menuEnable(39, this.ccf != null && this.treeSelection instanceof Configurable);
        Tonto.menuEnable(40, this.dragSelection instanceof ChildPanel);
        Tonto.menuEnable(41, this.dragSelection != null);
        Tonto.menuEnable(65, this.ccf != null && this.treeSelection instanceof CCFTreeDeviceFolder);
        Tonto.menuEnable(66, this.treeSelection instanceof CCFTreeDevice);
        Tonto.menuEnable(67, this.treeSelection instanceof FrameHost);
        Tonto.menuEnable(68, this.treeSelection instanceof ButtonHost);
        Tonto.menuEnable(148, this.isLoaded());
        Tonto.menuEnable(149, this.isLoaded());
        Tonto.menuEnable(155, this.currentDevice != null && this.currentPanel != null);
        Tonto.menuEnable(158, this.currentDevice != null);
        Tonto.menuEnable(137, this.treeSelection instanceof ButtonBox || this.treeSelection instanceof CCFTreePanel || this.treeSelection instanceof CCFTreeDevice);
        Tonto.menuEnable(141, this.treeSelection instanceof ButtonBox && clipboard instanceof CCFAction);
        Tonto.menuEnable(264, this.getEmulator() != null);
        Tonto.menuEnable(265, prefEditor != null);
        Tonto.menuEnable(266, hasComm);
        Tonto.menuEnable(261, hasComm);
        Tonto.menuEnable(145, bl2);
        Tonto.menuEnable(146, !bl2 && this.fileName != null);
        Tonto.menuEnable(2059, bl);
        Tonto.menuEnable(2060, this.dragSelection instanceof FrameBox && (cCFChildArray = ((FrameBox)this.dragSelection).getFrame().getChildren()) != null && cCFChildArray.length > 0);
        Tonto.menuEnable(2053, bl);
        Tonto.menuEnable(2054, bl);
        Tonto.menuEnable(2055, bl);
        Tonto.menuEnable(2056, bl);
        Tonto.menuEnable(2057, bl);
        Tonto.menuEnable(2058, bl);
        Tonto.menuEnable(139, clipboard instanceof CCFActionList);
        Tonto.menuEnable(157, clipboard instanceof CCFIconSet);
        Tonto.menuEnable(138, clipboard instanceof CCFIconSet);
        Tonto.menuEnable(140, clipboard instanceof CCFHardKey[]);
        Tonto.menuEnable(131, bl3);
        Tonto.menuEnable(132, bl3);
        Tonto.menuEnable(2069, this.dragSelection instanceof ButtonBox || this.dragSelection instanceof FrameBox);
    }

    private boolean isConnected() {
        return comm != null;
    }

    private boolean isLoaded() {
        return this.ccf != null;
    }

    private static void setRCMenu(JTextComponent jTextComponent) {
        jTextComponent.addMouseListener(new TextRCMenu(jTextComponent));
    }

    private static JMenuItem newPopMenuItem(String string, int n) {
        MenuAction menuAction = new MenuAction(n);
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(menuAction);
        jMenuItem.addMenuKeyListener(menuAction);
        jMenuItem.setEnabled(true);
        popmenus.put(new Integer(n), jMenuItem);
        return jMenuItem;
    }

    private static JCheckBoxMenuItem newPopToggleMenuItem(String string, int n) {
        MenuAction menuAction = new MenuAction(n);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jCheckBoxMenuItem.addActionListener(menuAction);
        jCheckBoxMenuItem.addMenuKeyListener(menuAction);
        jCheckBoxMenuItem.setEnabled(true);
        Integer n2 = new Integer(n);
        Vector<JCheckBoxMenuItem> vector = (Vector<JCheckBoxMenuItem>)popmenus.get(n2);
        if (vector == null) {
            vector = new Vector<JCheckBoxMenuItem>();
            popmenus.put(n2, vector);
        }
        vector.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    private static MenuItem newMenuItem(String string, int n, int n2) {
        return Tonto.newMenuItem(string, n, n2, false);
    }

    private static MenuItem newMenuItem(String string, int n, int n2, boolean bl) {
        return Tonto.newMenuItem(string, n, n2, bl, false);
    }

    private static MenuItem newMenuItem(String string, int n, int n2, boolean bl, boolean bl2) {
        MenuAction menuAction = new MenuAction(n2);
        MenuItem menuItem = n >= 0 ? new MenuItem(string, new MenuShortcut(n, bl2)) : new MenuItem(string);
        menuItem.addActionListener(menuAction);
        menuItem.setEnabled(bl);
        menus.put(new Integer(n2), menuItem);
        return menuItem;
    }

    private static MenuItem newMenuItem(String string, ActionListener actionListener) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    private void clearDesktop() {
        Enumeration enumeration = this.panels.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (!(v instanceof JInternalFrame)) continue;
            ((JInternalFrame)v).dispose();
        }
        this.panels.clear();
        this.refreshTreeModel();
    }

    private boolean isPanelShowing(CCFPanel cCFPanel) {
        DeskPanel deskPanel = this.getDeskPanel(cCFPanel);
        return deskPanel != null && deskPanel.isShowing();
    }

    private PanelPanel getPanelPanel(CCFPanel cCFPanel) {
        DeskPanel deskPanel = this.getDeskPanel(cCFPanel);
        return deskPanel != null ? deskPanel.getPanel() : null;
    }

    private DeskPanel getDeskPanel(CCFPanel cCFPanel) {
        return (DeskPanel)this.panels.get(cCFPanel);
    }

    private void showDeskPanel(CCFPanel cCFPanel) {
        if (cCFPanel == null) {
            return;
        }
        DeskPanel deskPanel = (DeskPanel)this.panels.get(cCFPanel);
        if (deskPanel != null) {
            deskPanel.moveToFront();
            return;
        }
        PanelPanel panelPanel = new PanelPanel(cCFPanel);
        String string = cCFPanel.getName();
        deskPanel = new DeskPanel(panelPanel);
        this.panels.put(cCFPanel, deskPanel);
        this.panels.put(deskPanel, cCFPanel);
        this.work.add(deskPanel);
        try {
            deskPanel.setSelected(true);
        }
        catch (Exception exception) {
            Tonto.errorDialog(exception);
        }
        Dimension dimension = deskPanel.getSize();
        Dimension dimension2 = this.work.getSize();
        if (this.nextPosition.x + dimension.width > dimension2.width) {
            this.nextPosition.move(2, this.nextPosition.y);
        }
        if (this.nextPosition.y + dimension.height > dimension2.height) {
            this.nextPosition.move(this.nextPosition.x, 2);
        }
        deskPanel.setLocation(this.nextPosition);
        this.nextPosition.translate(25, 25);
        deskPanel.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
                CCFPanel cCFPanel = (CCFPanel)Tonto.this.panels.get(internalFrameEvent.getSource());
                Tonto.this.removePanel(cCFPanel, false);
                debug.log(3, "closing desk panel " + cCFPanel);
            }
        });
        this.updateMenuState();
        if (cCFPanel != null && cCFPanel.isTemplate()) {
            this.repaintAllPanels();
        }
    }

    private Object getTreeWrapper(Object object) {
        return this.wrappers.get(object);
    }

    private ChildPanel getChildPanel(CCFChild cCFChild) {
        DeskPanel deskPanel;
        CCFPanel cCFPanel = cCFChild.getParentPanel();
        if (cCFPanel != null && (deskPanel = (DeskPanel)this.panels.get(cCFPanel)) != null) {
            PanelPanel panelPanel = deskPanel.getPanel();
            ChildPanel childPanel = panelPanel.findChild(cCFChild);
            return childPanel;
        }
        return null;
    }

    private void refreshTreeModel() {
        this.model.refresh();
    }

    void refreshTreeDevice(CCFDevice cCFDevice) {
        Object object = this.getTreeWrapper(cCFDevice);
        if (object != null && object instanceof TreeFolder) {
            ((TreeFolder)object).refresh();
            this.tree.expandPath(((TreeFolder)object).getTreePath());
            debug.log(2, "refreshTreeDevice: " + cCFDevice);
        }
    }

    private void refreshTreePanel(CCFPanel cCFPanel) {
        Object object = this.getTreeWrapper(cCFPanel);
        if (object != null) {
            if (object instanceof TreeFolder) {
                ((TreeFolder)object).refresh();
            }
            this.tree.expandPath(((TreeFolder)object).getTreePath());
            debug.log(2, "refreshTreePanel: " + cCFPanel);
        }
    }

    private void repaintPanel(CCFPanel cCFPanel) {
        DeskPanel deskPanel = (DeskPanel)this.panels.get(cCFPanel);
        if (deskPanel != null) {
            deskPanel.repaint();
        }
    }

    private void refreshPanel(CCFPanel cCFPanel) {
        DeskPanel deskPanel = (DeskPanel)this.panels.get(cCFPanel);
        if (deskPanel != null) {
            deskPanel.updateTitle();
            deskPanel.refresh();
            debug.log(3, "refreshPanel: " + cCFPanel);
        }
    }

    private void repaintAllPanels() {
        Enumeration enumeration = this.panels.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof CCFPanel)) continue;
            this.repaintPanel((CCFPanel)k);
        }
    }

    private void refreshAllPanels() {
        Enumeration enumeration = this.panels.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof CCFPanel)) continue;
            this.refreshPanel((CCFPanel)k);
        }
    }

    private void closePanel() {
        JInternalFrame jInternalFrame = this.work.getSelectedFrame();
        if (jInternalFrame != null) {
            jInternalFrame.dispose();
        }
    }

    private ChildPanel getUIWrapper(CCFChild cCFChild) {
        return (ChildPanel)this.wrappers.get(cCFChild);
    }

    private void removePanel(CCFPanel cCFPanel, boolean bl) {
        DeskPanel deskPanel = (DeskPanel)this.panels.get(cCFPanel);
        if (deskPanel == null) {
            return;
        }
        if (bl) {
            deskPanel.dispose();
        }
        this.panels.remove(cCFPanel);
        this.panels.remove(deskPanel);
    }

    private CCFButton addNewButton(CCFPanel cCFPanel) {
        boolean bl = Tonto.color();
        CCFButton cCFButton = cCFPanel.createButton("New");
        cCFButton.copyColors(bl ? defaultColorButton : defaultGrayButton);
        cCFButton.copyIcons(bl ? defaultColorButton : defaultGrayButton);
        this.pushDo(new DoAdd(cCFButton.getChildWrapper(), cCFPanel));
        return cCFButton;
    }

    private CCFFrame addNewFrame(CCFPanel cCFPanel) {
        CCFFrame cCFFrame = cCFPanel.createFrame("New");
        this.pushDo(new DoAdd(cCFFrame.getChildWrapper(), cCFPanel));
        return cCFFrame;
    }

    private void addNewButton(CCFFrame cCFFrame) {
        boolean bl = Tonto.color();
        CCFButton cCFButton = cCFFrame.createButton("New");
        cCFButton.copyColors(bl ? defaultColorButton : defaultGrayButton);
        cCFButton.copyIcons(bl ? defaultColorButton : defaultGrayButton);
        this.pushDo(new DoAdd(cCFButton.getChildWrapper(), cCFFrame));
    }

    private void addNewFrame(CCFFrame cCFFrame) {
        CCFFrame cCFFrame2 = cCFFrame.createFrame("New");
        this.pushDo(new DoAdd(cCFFrame2.getChildWrapper(), cCFFrame));
    }

    private JButton newButton(String string, int n) {
        MenuAction menuAction = new MenuAction(n);
        JButton jButton = new JButton(string);
        jButton.addActionListener(menuAction);
        return jButton;
    }

    private JButton newButton(String string, ActionListener actionListener, int n) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        Tonto.bindAction(jButton, n, 0, new ButtonAction(jButton));
        return jButton;
    }

    static void infoDialog(String string) {
        JOptionPane.showMessageDialog(StackedDialog.parent(), string, "FYI", 1);
    }

    static void errorDialog(String string) {
        Util.errorDialog(string, null);
    }

    static void errorDialog(Throwable throwable) {
        Tonto.debug(throwable);
        Util.errorDialog(throwable.toString(), null);
    }

    static void errorDialog(String string, Throwable throwable) {
        Tonto.debug(throwable);
        Util.errorDialog(string, throwable);
    }

    static boolean confirmDialog(String string, String string2) {
        return Util.confirmDialog(string, string2);
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.setTreeSelection(treeSelectionEvent.getPath().getLastPathComponent());
    }

    @Override
    public void taskStatus(int n, String string) {
        this.statusText.setText(string);
        this.statusText.repaint();
    }

    @Override
    public void taskError(Throwable throwable) {
        Tonto.errorDialog(throwable);
    }

    @Override
    public void taskNotify(Object object) {
        if (object instanceof Integer) {
            Tonto.sendEvent((Integer)object);
        } else {
            debug.log(0, "task object: " + object);
        }
    }

    private void eventNewTonto() {
        new Tonto();
    }

    private void eventCloseTonto() {
        this.exit();
    }

    private void eventFileNew() {
        this.fileNew();
    }

    private void eventFileLoad() {
        Tonto.load(true);
    }

    private void eventFileMerge() {
        Tonto.load(false);
    }

    private void eventFileRevert() {
        this.revert();
    }

    private void eventFileSave() {
        this.save();
    }

    private void eventFileSaveAs() {
        this.saveAs();
    }

    private void eventFileClose() {
        this.file_close();
    }

    private void eventFileClosePanel() {
        this.closePanel();
    }

    private void eventFileUpload() {
        this.upload(true);
    }

    private void eventFileDownload() {
        this.download();
    }

    private void eventFilePreferences() {
        prefsDialog.show();
    }

    private void eventFileExit() {
        Tonto.exitAll();
    }

    private void eventFileExport() {
        File file = Tonto.getFile(false, "Zip Files (*.zcf)", new String[]{"zcf"});
        if (file != null) {
            String string = file.toString();
            if (!string.toLowerCase().endsWith(".zcf")) {
                string = string + ".zcf";
            }
            this.save(string);
        }
    }

    private void eventEditUndo() {
        this.popDo();
    }

    private void eventEditRedo() {
        this.reDo();
    }

    private void eventEditCut() {
        debug.log(2, "edit|cut " + Util.nickname(this.treeSelection));
        if (this.treeSelection instanceof Deletable) {
            int n = this.startMultiDo();
            this.setClipboard(this.treeSelection);
            if (!this.multiSelect.contains(this.treeSelection)) {
                ((Deletable)this.treeSelection).delete();
            }
            Object[] objectArray = this.multiSelect.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Deletable)objectArray[i]).delete();
            }
            this.setTreeSelection(null);
            this.endMultiDo(n);
        }
    }

    private void eventEditCopy() {
        debug.log(2, "edit|copy " + Util.nickname(this.treeSelection));
        if (this.treeSelection instanceof Copyable) {
            this.setClipboard(((Copyable)this.treeSelection).copy());
        }
    }

    private void eventEditPaste() {
        this.pasteClipboardTo(this.treeSelection);
    }

    private void eventEditDelete() {
        debug.log(2, "edit|delete " + Util.nickname(this.treeSelection));
        if (this.treeSelection instanceof Deletable) {
            int n = this.startMultiDo();
            if (!this.multiSelect.contains(this.treeSelection)) {
                ((Deletable)this.treeSelection).delete();
            }
            Object[] objectArray = this.multiSelect.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                ((Deletable)objectArray[i]).delete();
            }
            this.setTreeSelection(null);
            this.endMultiDo(n);
        }
    }

    private void eventEditProperty() {
        if (this.treeSelection instanceof Configurable) {
            ((Configurable)this.treeSelection).editProperties();
        }
    }

    private void eventEditSelectAll() {
        if (this.dragSelection instanceof ChildPanel) {
            if (this.dragSelection instanceof ButtonBox) {
                ((ChildPanel)this.dragSelection.getParent()).selectAll();
            } else {
                ((ChildPanel)this.dragSelection).selectAll();
            }
        }
    }

    private void eventEditUnselectAll() {
        this.setDragSelection(null);
    }

    private void eventEditCopyAlias() {
        if (this.treeSelection instanceof CCFTreeDevice) {
            this.setClipboard(new ActionAliasDevice(((CCFTreeDevice)this.treeSelection).getDevice()));
        } else if (this.treeSelection instanceof CCFTreePanel) {
            this.setClipboard(new ActionJumpPanel(((CCFTreePanel)this.treeSelection).getPanel(), Tonto.header().isNewMarantz()));
        } else if (this.treeSelection instanceof ButtonBox) {
            this.setClipboard(new ActionAliasButton(((ButtonBox)this.treeSelection).getButton()));
        }
    }

    private void eventEditPasteAlias() {
        if (this.treeSelection instanceof ButtonBox && clipboard instanceof CCFAction) {
            ((ButtonBox)this.treeSelection).getButton().appendAction((CCFAction)((CCFAction)clipboard).getClone());
            ((ButtonBox)this.treeSelection).refreshDeskPanel();
        }
    }

    private void eventPasteKeyAlias(int n) {
        CCFDevice cCFDevice = ((CCFTreeDevice)this.treeSelection).getDevice();
        if (n == 0) {
            if (cCFDevice.action == null) {
                cCFDevice.action = new CCFActionList();
            }
            cCFDevice.action.appendAction((CCFAction)clipboard);
        } else {
            CCFHardKey[] cCFHardKeyArray = cCFDevice.getHardKeys();
            CCFActionList cCFActionList = cCFHardKeyArray[n - 1].getActionList();
            if (cCFActionList == null) {
                cCFActionList = new CCFActionList();
            }
            cCFActionList.appendAction((CCFAction)clipboard);
            cCFHardKeyArray[n - 1].setActionList(cCFActionList);
        }
    }

    private void eventUndeadPronto() {
        if (this.isnew) {
            Tonto.errorDialog("You must load a valid CCF before\nperforming an 'Undead' operation");
        } else {
            new UndeadDialog().show();
        }
    }

    private void eventLocatePronto() {
        try {
            new CommStatusDialog();
        }
        catch (Exception exception) {
            Tonto.errorDialog(exception);
        }
    }

    private void eventRebootPronto() {
        this.rebootPronto();
    }

    private void eventRemoteFirmware() {
        this.firmware();
    }

    private void eventRunEmulator() {
        this.runEmulator();
    }

    private void eventRunEditor() {
        this.runEditor();
    }

    private void eventNetworkUpdate() {
        Tonto.checkForUpdates(true);
    }

    private void eventRawUpload() {
        this.rawUpload();
    }

    private void eventRawDownload() {
        this.rawDownload();
    }

    private void eventEmailLogfile() {
        this.emailLogfile();
    }

    private void eventAutoloadAdd() {
        if (this.fileName != null && !autoLoad.contains(this.fileName)) {
            autoLoad.add(this.fileName);
            this.updateMenuState();
        }
    }

    private void eventAutoloadRemove() {
        if (this.fileName != null && autoLoad.contains(this.fileName)) {
            autoLoad.remove(this.fileName);
            this.updateMenuState();
        }
    }

    private void eventConvertCCF(int n) {
        try {
            this.ccf.header().setColorMap(prefColorMap);
            this.ccf.conformTo(ProntoModel.getModel(n));
            this.panelSize = this.ccf.getScreenSize(prefDefaultModel);
            this.setCCFChanged();
            this.updateCCFInfo();
            this.refreshAllPanels();
            this.refreshTreeModel();
        }
        catch (Exception exception) {
            debug.log(0, "No ProntoModel matching type '" + n + "' for conversion");
        }
    }

    private void eventModuleIRDB() {
        irdb.show();
    }

    private void eventModuleIcons() {
        this.icons.invoke();
    }

    private void eventModuleIconSwap() {
        new IconReplace().show();
    }

    private void eventModuleTabMaster() {
        this.tabMaster();
    }

    private void eventModuleThemeMaster() {
        this.themeMaster();
    }

    private void eventHelpAbout() {
        new AboutDialog(this).show();
    }

    private void eventHelpDocs() {
        Browser.displayURL("http://giantlaser.com/tonto/?x=doc_guide&y=1");
    }

    private void eventHelpTutorial() {
        Browser.displayURL("http://giantlaser.com/tonto/?x=doc_tutor&y=1");
    }

    private void eventHelpFAQ() {
        Browser.displayURL("http://giantlaser.com/tonto/?x=doc_faq&y=1");
    }

    private void eventHelpChanges() {
        Browser.displayURL("http://giantlaser.com/tonto/tonto/changelog.txt?y=1");
    }

    private void eventHelpCCFs() {
        Browser.displayURL("http://remotecentral.com/cgi-bin/files/rcfiles.cgi?area=pronto&db=devices&br=&fc=");
    }

    private void eventHelpDiscrete() {
        Browser.displayURL("http://remotecentral.com/cgi-bin/files/rcfiles.cgi?area=pronto&db=discrete&br=&fc=");
    }

    private void eventHelpDebug() {
        JFrame jFrame;
        if (this.debugFrame != null) {
            this.debugFrame.show();
            return;
        }
        this.debugFrame = jFrame = new JFrame("Debug Window");
        final JTextArea jTextArea = new JTextArea(10, 70);
        final DebugListener debugListener = new DebugListener(){

            @Override
            public void debugAction(String string) {
                jTextArea.append(string + "\n");
                jTextArea.scrollRectToVisible(new Rectangle(0, jTextArea.getHeight() - 2, 1, 1));
            }
        };
        Debug.addListener(debugListener);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jFrame.getContentPane().add("Center", jScrollPane);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                prefs.setProperty(Tonto.PREF_DEBUG_BOUNDS, Tonto.this.debugFrame.getBounds());
                Tonto.this.debugFrame = null;
                Debug.removeListener(debugListener);
            }
        });
        jFrame.setDefaultCloseOperation(2);
        jFrame.pack();
        Rectangle rectangle = prefs.getRectangle(PREF_DEBUG_BOUNDS, null);
        if (rectangle != null) {
            jFrame.setBounds(rectangle);
        }
        jFrame.show();
    }

    private void eventObjectAddDevice() {
        if (this.treeSelection instanceof CCFTreeDeviceFolder) {
            ((CCFTreeDeviceFolder)this.treeSelection).newDevice();
            this.tree.expandPath(((CCFTreeDeviceFolder)this.treeSelection).getTreePath());
            this.setCCFChanged();
        }
    }

    private void eventObjectAddPanel() {
        if (this.treeSelection instanceof CCFTreeDevice) {
            ((CCFTreeDevice)this.treeSelection).newPanel();
            this.tree.expandPath(((CCFTreeDevice)this.treeSelection).getTreePath());
            this.setCCFChanged();
        }
    }

    private void eventObjectAddFrame() {
        if (this.treeSelection instanceof FrameHost) {
            ((FrameHost)this.treeSelection).addFrame();
            this.setCCFChanged();
        }
    }

    private void eventObjectAddButton() {
        if (this.treeSelection instanceof ButtonHost) {
            ((ButtonHost)this.treeSelection).addButton();
            this.setCCFChanged();
        }
    }

    private void eventObjectTop() {
        if (this.dragSelection instanceof ChildPanel) {
            ((ChildPanel)this.dragSelection).getSource().top();
            ((ChildPanel)this.dragSelection).refreshDeskPanel();
        }
    }

    private void eventObjectBottom() {
        if (this.dragSelection instanceof ChildPanel) {
            ((ChildPanel)this.dragSelection).getSource().bottom();
            ((ChildPanel)this.dragSelection).refreshDeskPanel();
        }
    }

    private void eventObjectRaise() {
        if (this.dragSelection instanceof ChildPanel) {
            ((ChildPanel)this.dragSelection).getSource().raise();
            ((ChildPanel)this.dragSelection).refreshDeskPanel();
        }
    }

    private void eventObjectLower() {
        if (this.dragSelection instanceof ChildPanel) {
            ((ChildPanel)this.dragSelection).getSource().lower();
            ((ChildPanel)this.dragSelection).refreshDeskPanel();
        }
    }

    private void eventObjectTransparency() {
        if (this.treeSelection instanceof FrameBox) {
            FrameBox frameBox = (FrameBox)this.treeSelection;
            CCFFrame cCFFrame = frameBox.getFrame();
            PanelPanel panelPanel = frameBox.getRootPanel();
            CCFIcon cCFIcon = panelPanel.getPicture(frameBox);
            CCFIcon cCFIcon2 = CCFIcon.composite(cCFFrame.getIcon(), cCFIcon);
            DoNodeUpdate doNodeUpdate = new DoNodeUpdate(cCFFrame);
            cCFFrame.setIcon(cCFIcon2);
            doNodeUpdate.pushDoNewState();
            this.refreshPanel(cCFFrame.getParentPanel());
        } else if (this.treeSelection instanceof ButtonBox) {
            ButtonBox buttonBox = (ButtonBox)this.treeSelection;
            CCFButton cCFButton = buttonBox.getButton();
            PanelPanel panelPanel = buttonBox.getRootPanel();
            CCFIconSet cCFIconSet = cCFButton.getIconSet().getClone();
            CCFIcon cCFIcon = panelPanel.getPicture(buttonBox);
            Hashtable<CCFIcon, CCFIcon> hashtable = new Hashtable<CCFIcon, CCFIcon>();
            int[] nArray = new int[]{3, 2, 1, 0};
            for (int i = 0; i < nArray.length; ++i) {
                CCFIcon cCFIcon3;
                CCFIcon cCFIcon4 = cCFIconSet.getIcon(i);
                CCFIcon cCFIcon5 = cCFIcon3 = cCFIcon4 == null ? null : (CCFIcon)hashtable.get(cCFIcon4);
                if (cCFIcon3 == null) {
                    cCFIcon3 = CCFIcon.composite(cCFIcon4, cCFIcon);
                    if (cCFIcon4 != null) {
                        hashtable.put(cCFIcon4, cCFIcon3);
                    }
                }
                cCFIconSet.setIcon(i, cCFIcon3);
            }
            DoNodeUpdate doNodeUpdate = new DoNodeUpdate(cCFButton);
            cCFButton.setIconSet(cCFIconSet);
            doNodeUpdate.pushDoNewState();
            this.refreshPanel(cCFButton.getParentPanel());
        }
    }

    private void eventPanelToggleGrid() {
        PanelPanel panelPanel;
        if (this.treeSelection instanceof ChildPanel) {
            ((ChildPanel)this.treeSelection).toggleGrid();
        } else if (this.treeSelection instanceof CCFTreePanel && (panelPanel = this.getPanelPanel(((CCFTreePanel)this.treeSelection).getPanel())) != null) {
            panelPanel.toggleGrid();
        }
    }

    private void eventPanelToggleSnap() {
        PanelPanel panelPanel;
        if (this.treeSelection instanceof ChildPanel) {
            ((ChildPanel)this.treeSelection).toggleSnap();
        } else if (this.treeSelection instanceof CCFTreePanel && (panelPanel = this.getPanelPanel(((CCFTreePanel)this.treeSelection).getPanel())) != null) {
            panelPanel.toggleSnap();
        }
    }

    private void eventTreeExpandAll() {
        this.eventTreeDeviceFolders(true);
    }

    private void eventTreeCollapseAll() {
        this.eventTreeDeviceFolders(false);
    }

    private void eventTreeDeviceFolders(boolean bl) {
        this.eventTreeDeviceFolders(Tonto.ccf().header().firstHome, bl);
        this.eventTreeDeviceFolders(Tonto.ccf().header().firstDevice, bl);
        this.eventTreeDeviceFolders(Tonto.ccf().header().firstMacro, bl);
    }

    private void eventTreeDeviceFolders(CCFDevice cCFDevice, boolean bl) {
        while (cCFDevice != null) {
            TreeNode treeNode = (TreeNode)this.getTreeWrapper(cCFDevice);
            if (cCFDevice != null) {
                if (bl) {
                    this.tree.expandPath(treeNode.getTreePath());
                } else {
                    this.tree.collapsePath(treeNode.getTreePath());
                }
            }
            cCFDevice = cCFDevice.next;
        }
    }

    private void eventButtonCopyIcons() {
        if (this.treeSelection instanceof ButtonBox) {
            this.setClipboard(((ButtonBox)this.treeSelection).getButton().getIconSet());
        }
    }

    private void eventButtonPasteIcons() {
        if (this.treeSelection instanceof ButtonBox && clipboard instanceof CCFIconSet) {
            CCFButton cCFButton = ((ButtonBox)this.treeSelection).getButton();
            cCFButton.setIconSet((CCFIconSet)clipboard);
            this.refreshPanel(cCFButton.getParentPanel());
            this.setDragSelection(this.getChildPanel((CCFChild)cCFButton.getParent()));
        }
    }

    private void eventButtonPasteReplaceIcons() {
        if (this.treeSelection instanceof ButtonBox && clipboard instanceof CCFIconSet) {
            CCFButton cCFButton = ((ButtonBox)this.treeSelection).getButton();
            CCFIconSet cCFIconSet = (CCFIconSet)clipboard;
            CCFIconSet cCFIconSet2 = cCFButton.getIconSet();
            if (Tonto.confirmDialog("Global Icon Replace", "Proceed with globally replacing all matching icons?")) {
                int[] nArray = CCFIconSet.getValidStates();
                for (int i = 0; i < nArray.length; ++i) {
                    this.iconReplace(cCFIconSet2.getIcon(nArray[i]), cCFIconSet.getIcon(nArray[i]));
                }
            }
            this.refreshAllPanels();
        }
    }

    private void eventButtonCopyActions() {
        CCFButton cCFButton;
        CCFActionList cCFActionList;
        if (this.treeSelection instanceof ButtonBox && (cCFActionList = (cCFButton = ((ButtonBox)this.treeSelection).getButton()).getActionList()) != null) {
            this.setClipboard(cCFActionList.getClone());
        }
    }

    private void eventButtonPasteActions() {
        if (this.treeSelection instanceof ButtonBox && clipboard instanceof CCFActionList) {
            CCFButton cCFButton = ((ButtonBox)this.treeSelection).getButton();
            cCFButton.setActionList((CCFActionList)((CCFActionList)clipboard).getClone());
            this.refreshPanel(cCFButton.getParentPanel());
        }
    }

    private void eventDeviceCopyKeys() {
        if (this.treeSelection instanceof CCFTreeDevice) {
            this.setClipboard(((CCFTreeDevice)this.treeSelection).getDevice().getHardKeys());
        }
    }

    private void eventButtonPasteKeys() {
        if (this.treeSelection instanceof CCFTreeDevice && clipboard instanceof CCFHardKey[]) {
            CCFDevice cCFDevice = ((CCFTreeDevice)this.treeSelection).getDevice();
            cCFDevice.setKeyActions((CCFHardKey[])clipboard);
        }
    }

    private void eventDeviceKeyAlias(int n) {
        if (this.treeSelection instanceof CCFTreeDevice) {
            this.setClipboard(new ActionAliasKey(((CCFTreeDevice)this.treeSelection).getDevice(), n));
        }
    }

    private void eventDeviceCopyKeyActions(int n) {
        if (this.treeSelection instanceof CCFTreeDevice) {
            CCFActionList cCFActionList = null;
            CCFDevice cCFDevice = ((CCFTreeDevice)this.treeSelection).getDevice();
            cCFActionList = n == 0 ? cCFDevice.action : cCFDevice.getHardKeys()[n - 1].getActionList();
            if (cCFActionList != null) {
                this.setClipboard((CCFActionList)cCFActionList.getClone());
            }
        }
    }

    private void eventDevicePasteKeyActions(int n) {
        if (clipboard instanceof CCFActionList) {
            CCFActionList cCFActionList = (CCFActionList)((CCFActionList)clipboard).getClone();
            CCFDevice cCFDevice = ((CCFTreeDevice)this.treeSelection).getDevice();
            if (n == 0) {
                cCFDevice.action = cCFActionList;
            } else {
                cCFDevice.getHardKeys()[n - 1].setActionList(cCFActionList);
            }
        }
    }

    private void eventViewHideSelection() {
        this.hideSelection = !this.hideSelection;
        this.repaintAllPanels();
    }

    private void eventObjectsAlign(int n) {
        if (this.multiSelect.size() < 2) {
            return;
        }
        Rectangle rectangle = this.getSelectionBounds();
        MultiDo multiDo = new MultiDo();
        for (int i = 0; i < this.multiSelect.size(); ++i) {
            Component component = (Component)this.multiSelect.get(i);
            Rectangle rectangle2 = component.getBounds();
            Rectangle rectangle3 = null;
            switch (n) {
                case 2053: {
                    rectangle3 = new Rectangle(rectangle2.x, rectangle.y, rectangle2.width, rectangle2.height);
                    break;
                }
                case 2054: {
                    rectangle3 = new Rectangle(rectangle2.x, rectangle.y + rectangle.height - rectangle2.height, rectangle2.width, rectangle2.height);
                    break;
                }
                case 2055: {
                    rectangle3 = new Rectangle(rectangle.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    break;
                }
                case 2056: {
                    rectangle3 = new Rectangle(rectangle.x + rectangle.width - rectangle2.width, rectangle2.y, rectangle2.width, rectangle2.height);
                    break;
                }
                case 2057: {
                    rectangle3 = new Rectangle(rectangle.x + rectangle.width / 2 - rectangle2.width / 2, rectangle2.y, rectangle2.width, rectangle2.height);
                    break;
                }
                case 2058: {
                    rectangle3 = new Rectangle(rectangle2.x, rectangle.y + rectangle.height / 2 - rectangle2.height / 2, rectangle2.width, rectangle2.height);
                }
            }
            multiDo.add(new DoBounds(component, rectangle2, rectangle3));
        }
        this.pushDo(multiDo);
    }

    private void eventObjectSnap(int n) {
        switch (n) {
            case 2061: {
                snaps = new SnapInfo(0.0, 0.0);
                break;
            }
            case 2062: {
                snaps = new SnapInfo(0.5, 0.0);
                break;
            }
            case 2063: {
                snaps = new SnapInfo(1.0, 0.0);
                break;
            }
            case 2064: {
                snaps = new SnapInfo(1.0, 0.5);
                break;
            }
            case 2065: {
                snaps = new SnapInfo(1.0, 1.0);
                break;
            }
            case 2066: {
                snaps = new SnapInfo(0.5, 1.0);
                break;
            }
            case 2067: {
                snaps = new SnapInfo(0.0, 1.0);
                break;
            }
            case 2068: {
                snaps = new SnapInfo(0.0, 0.5);
            }
        }
    }

    private void eventObjectsGroup() {
        CCFPanel cCFPanel;
        if (this.multiSelect.size() < 2) {
            return;
        }
        Rectangle rectangle = this.getSelectionBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        ChildPanel childPanel = (ChildPanel)((ChildPanel)this.multiSelect.get(0)).getParent();
        CCFChild cCFChild = childPanel.getSource();
        CCFPanel cCFPanel2 = cCFPanel = cCFChild != null ? cCFChild.getParentPanel() : ((PanelPanel)childPanel).getPanel();
        while (!(childPanel instanceof PanelPanel)) {
            Point point = childPanel.getLocation();
            rectangle.x += point.x;
            rectangle.y += point.y;
            childPanel = (ChildPanel)childPanel.getParent();
        }
        int n = this.startMultiDo();
        this.pushDo(new DoRefresher(cCFPanel, false));
        DoNodeUpdate doNodeUpdate = cCFChild != null ? new DoNodeUpdate(cCFChild.child) : null;
        DoNodeUpdate doNodeUpdate2 = new DoNodeUpdate(cCFPanel);
        CCFFrame cCFFrame = cCFPanel.createFrame("");
        CCFChild cCFChild2 = cCFFrame.getChildWrapper();
        cCFChild2.setBounds(rectangle);
        CCFChild[] cCFChildArray = new CCFChild[this.multiSelect.size()];
        for (int i = 0; i < this.multiSelect.size(); ++i) {
            CCFChild cCFChild3 = ((ChildPanel)this.multiSelect.get(i)).getSource();
            this.pushDo(new DoBounds(cCFChild3, -rectangle2.x, -rectangle2.y, 0, 0));
            cCFChildArray[i] = cCFChild3;
            cCFChild3.delete();
        }
        this.appendChildren(cCFFrame, cCFChildArray);
        cCFPanel.addFrame(cCFFrame);
        doNodeUpdate2.getNewState();
        this.pushDo(doNodeUpdate2);
        if (doNodeUpdate != null) {
            doNodeUpdate.getNewState();
            this.pushDo(doNodeUpdate);
        }
        this.pushDo(new DoRefresher(cCFPanel, true));
        this.endMultiDo(n);
        this.setDragSelection(this.getUIWrapper(cCFChild2));
    }

    private void eventObjectsUngroup() {
        int n;
        if (!(this.dragSelection instanceof FrameBox)) {
            return;
        }
        FrameBox frameBox = (FrameBox)this.dragSelection;
        CCFFrame cCFFrame = frameBox.getFrame();
        CCFPanel cCFPanel = cCFFrame.getParentPanel();
        CCFChild[] cCFChildArray = cCFFrame.getChildren();
        if (cCFChildArray == null || cCFChildArray.length == 0) {
            return;
        }
        CCFChild cCFChild = cCFFrame.getChildWrapper();
        IChildContainer iChildContainer = (IChildContainer)((Object)cCFChild.getParent());
        int n2 = this.startMultiDo();
        this.pushDo(new DoRefresher(cCFPanel, false));
        DoNodeUpdate doNodeUpdate = new DoNodeUpdate(cCFFrame);
        DoNodeUpdate doNodeUpdate2 = new DoNodeUpdate(cCFPanel);
        for (n = 0; n < cCFChildArray.length; ++n) {
            this.pushDo(new DoBounds(cCFChildArray[n], cCFChild.intX, cCFChild.intY, 0, 0));
            cCFChildArray[n].delete();
        }
        frameBox.delete();
        this.appendChildren(iChildContainer, cCFChildArray);
        doNodeUpdate.getNewState();
        doNodeUpdate2.getNewState();
        this.pushDo(doNodeUpdate);
        this.pushDo(doNodeUpdate2);
        this.pushDo(new DoRefresher(cCFPanel, true));
        this.updateMenuState();
        this.endMultiDo(n2);
        this.setDragSelection(null);
        for (n = 0; n < cCFChildArray.length; ++n) {
            ChildPanel childPanel = this.getUIWrapper(cCFChildArray[n]);
            this.multiSelect.add(childPanel);
            childPanel.select(false);
        }
        this.dragSelection = (Component)this.multiSelect.get(0);
    }

    private void appendChildren(IChildContainer iChildContainer, CCFChild[] cCFChildArray) {
        CCFChild[] cCFChildArray2 = iChildContainer.getChildren();
        if (cCFChildArray2 == null) {
            cCFChildArray2 = new CCFChild[]{};
        }
        CCFChild[] cCFChildArray3 = new CCFChild[cCFChildArray.length + cCFChildArray2.length];
        System.arraycopy(cCFChildArray2, 0, cCFChildArray3, 0, cCFChildArray2.length);
        System.arraycopy(cCFChildArray, 0, cCFChildArray3, cCFChildArray2.length, cCFChildArray.length);
        iChildContainer.setChildren(cCFChildArray3);
    }

    public static void sendEvent(int n) {
        debug.log(3, "<" + Util.nickname(current) + "> sendEvent " + n);
        switch (n) {
            case 26: {
                Tonto.state().eventNewTonto();
                break;
            }
            case 29: {
                Tonto.state().eventCloseTonto();
                break;
            }
            case 17: {
                Tonto.state().eventFileNew();
                break;
            }
            case 18: {
                Tonto.state().eventFileClose();
                break;
            }
            case 28: {
                Tonto.state().eventFileClosePanel();
                break;
            }
            case 19: {
                Tonto.state().eventFileLoad();
                break;
            }
            case 30: {
                Tonto.state().eventFileMerge();
                break;
            }
            case 31: {
                Tonto.state().eventFileRevert();
                break;
            }
            case 20: {
                Tonto.state().eventFileSave();
                break;
            }
            case 21: {
                Tonto.state().eventFileSaveAs();
                break;
            }
            case 22: {
                Tonto.state().eventFileUpload();
                break;
            }
            case 23: {
                Tonto.state().eventFileDownload();
                break;
            }
            case 24: {
                Tonto.state().eventFilePreferences();
                break;
            }
            case 25: {
                Tonto.state().eventFileExit();
                break;
            }
            case 27: {
                Tonto.state().eventFileExport();
                break;
            }
            case 33: {
                Tonto.state().eventEditUndo();
                break;
            }
            case 34: {
                Tonto.state().eventEditRedo();
                break;
            }
            case 35: {
                Tonto.state().eventEditCut();
                break;
            }
            case 36: {
                Tonto.state().eventEditCopy();
                break;
            }
            case 38: {
                Tonto.state().eventEditPaste();
                break;
            }
            case 37: {
                Tonto.state().eventEditDelete();
                break;
            }
            case 39: {
                Tonto.state().eventEditProperty();
                break;
            }
            case 40: {
                Tonto.state().eventEditSelectAll();
                break;
            }
            case 41: {
                Tonto.state().eventEditUnselectAll();
                break;
            }
            case 133: {
                Tonto.state().eventModuleIRDB();
                break;
            }
            case 148: {
                Tonto.state().eventModuleIcons();
                break;
            }
            case 149: {
                Tonto.state().eventModuleIconSwap();
                break;
            }
            case 155: {
                Tonto.state().eventModuleTabMaster();
                break;
            }
            case 158: {
                Tonto.state().eventModuleThemeMaster();
                break;
            }
            case 65: {
                Tonto.state().eventObjectAddDevice();
                break;
            }
            case 66: {
                Tonto.state().eventObjectAddPanel();
                break;
            }
            case 67: {
                Tonto.state().eventObjectAddFrame();
                break;
            }
            case 68: {
                Tonto.state().eventObjectAddButton();
                break;
            }
            case 131: {
                Tonto.state().eventPanelToggleGrid();
                break;
            }
            case 132: {
                Tonto.state().eventPanelToggleSnap();
                break;
            }
            case 152: {
                Tonto.state().eventTreeExpandAll();
                break;
            }
            case 153: {
                Tonto.state().eventTreeCollapseAll();
                break;
            }
            case 154: {
                Tonto.state().eventViewHideSelection();
                break;
            }
            case 134: {
                Tonto.state().eventButtonCopyIcons();
                break;
            }
            case 138: {
                Tonto.state().eventButtonPasteIcons();
                break;
            }
            case 157: {
                Tonto.state().eventButtonPasteReplaceIcons();
                break;
            }
            case 135: {
                Tonto.state().eventButtonCopyActions();
                break;
            }
            case 139: {
                Tonto.state().eventButtonPasteActions();
                break;
            }
            case 136: {
                Tonto.state().eventDeviceCopyKeys();
                break;
            }
            case 140: {
                Tonto.state().eventButtonPasteKeys();
                break;
            }
            case 262: {
                Tonto.state().eventLocatePronto();
                break;
            }
            case 261: {
                Tonto.state().eventUndeadPronto();
                break;
            }
            case 257: {
                Tonto.state().eventRawUpload();
                break;
            }
            case 258: {
                Tonto.state().eventRawDownload();
                break;
            }
            case 259: {
                Tonto.state().eventEmailLogfile();
                break;
            }
            case 145: {
                Tonto.state().eventAutoloadAdd();
                break;
            }
            case 146: {
                Tonto.state().eventAutoloadRemove();
                break;
            }
            case 260: {
                Tonto.state().eventRebootPronto();
                break;
            }
            case 264: {
                Tonto.state().eventRunEmulator();
                break;
            }
            case 265: {
                Tonto.state().eventRunEditor();
                break;
            }
            case 263: {
                Tonto.state().eventNetworkUpdate();
                break;
            }
            case 266: {
                Tonto.state().eventRemoteFirmware();
                break;
            }
            case 2069: {
                Tonto.state().eventObjectTransparency();
                break;
            }
            case 129: {
                Tonto.state().eventHelpAbout();
                break;
            }
            case 143: {
                Tonto.state().eventHelpFAQ();
                break;
            }
            case 142: {
                Tonto.state().eventHelpDocs();
                break;
            }
            case 156: {
                Tonto.state().eventHelpTutorial();
                break;
            }
            case 144: {
                Tonto.state().eventHelpChanges();
                break;
            }
            case 147: {
                Tonto.state().eventHelpDebug();
                break;
            }
            case 150: {
                Tonto.state().eventHelpCCFs();
                break;
            }
            case 151: {
                Tonto.state().eventHelpDiscrete();
                break;
            }
            case 2051: {
                Tonto.state().eventObjectTop();
                break;
            }
            case 2052: {
                Tonto.state().eventObjectBottom();
                break;
            }
            case 2049: {
                Tonto.state().eventObjectRaise();
                break;
            }
            case 2050: {
                Tonto.state().eventObjectLower();
                break;
            }
            case 2053: 
            case 2054: 
            case 2055: 
            case 2056: 
            case 2057: 
            case 2058: {
                Tonto.state().eventObjectsAlign(n);
                break;
            }
            case 2061: 
            case 2062: 
            case 2063: 
            case 2064: 
            case 2065: 
            case 2066: 
            case 2067: 
            case 2068: {
                Tonto.state().eventObjectSnap(n);
                break;
            }
            case 2059: {
                Tonto.state().eventObjectsGroup();
                break;
            }
            case 2060: {
                Tonto.state().eventObjectsUngroup();
                break;
            }
            case 137: {
                Tonto.state().eventEditCopyAlias();
                break;
            }
            case 141: {
                Tonto.state().eventEditPasteAlias();
            }
        }
        if ((n & 0x400) == 1024) {
            Tonto.state().eventConvertCCF(n ^ 0x400);
        } else if ((n & 0x200) == 512) {
            Tonto.state().fileNew(n ^ 0x200);
        } else if ((n & 0x1000) == 4096) {
            Tonto.state().eventDeviceKeyAlias(n ^ 0x1000);
        } else if ((n & 0x2000) == 8192) {
            Tonto.state().eventPasteKeyAlias(n ^ 0x2000);
        } else if ((n & 0x4000) == 16384) {
            Tonto.state().eventDeviceCopyKeyActions(n ^ 0x4000);
        } else if ((n & 0x8000) == 32768) {
            Tonto.state().eventDevicePasteKeyActions(n ^ 0x8000);
        }
    }

    private void pasteClipboardTo(Object object) {
        Pastable pastable;
        debug.log(2, "edit|paste " + Util.nickname(clipboard) + " into " + Util.nickname(object));
        if (object instanceof Pastable && (pastable = (Pastable)object).acceptPaste(clipboard)) {
            if (clipboard instanceof ChildPanel) {
                CCFChild cCFChild = ((ChildPanel)clipboard).getSource();
                Rectangle rectangle = cCFChild.getBounds();
                Dimension dimension = pastable instanceof ChildPanel ? ((ChildPanel)((Object)pastable)).getSize() : this.panelSize;
                rectangle.x = Math.min(rectangle.x, dimension.width - rectangle.width);
                rectangle.y = Math.min(rectangle.y, dimension.height - rectangle.height);
                cCFChild.setLocation(new Point(rectangle.x, rectangle.y));
            }
            pastable.paste(clipboard);
            this.setCCFChanged();
            if (clipboard instanceof Copyable) {
                this.setClipboard(((Copyable)clipboard).copy());
            } else if (clipboard instanceof CCFNode) {
                this.setClipboard(((CCFNode)clipboard).getClone());
            } else {
                this.setClipboard(null);
            }
            return;
        }
        if (object instanceof Parental) {
            debug.log(0, "edit|paste re-attempt paste to parent of " + object);
            this.pasteClipboardTo(((Parental)object).getMyParent());
        }
    }

    static /* synthetic */ Hashtable access$3100() {
        return tontos;
    }

    static {
        initShared = false;
        isUpdating = false;
    }

    static class VectorListModel
    extends AbstractListModel {
        private Vector list;

        VectorListModel(Vector vector) {
            this.list = vector;
        }

        @Override
        public Object getElementAt(int n) {
            return this.list.get(n);
        }

        @Override
        public int getSize() {
            return this.list.size();
        }

        public void refresh() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    static class ToolAction
    extends AbstractAction {
        private int action;
        private String desc;

        ToolAction(String string, String string2, int n, String string3) {
            super(string, Tonto.loadIcon(string2));
            this.action = n;
            this.desc = string3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tonto.sendEvent(this.action);
        }

        @Override
        public Object getValue(String string) {
            if (string == "ShortDescription") {
                return this.desc;
            }
            return super.getValue(string);
        }
    }

    static class SnapInfo {
        private double w;
        private double h;

        SnapInfo(double d, double d2) {
            this.w = d;
            this.h = d2;
        }
    }

    static abstract class MemoryDialog
    extends OKCancelDialog {
        private JDialog dialog;
        private String sizepref;

        MemoryDialog(String string, String string2) {
            super(string);
            this.sizepref = string2;
        }

        public Rectangle defaultSize() {
            return null;
        }

        @Override
        public void showHook(JDialog jDialog) {
            this.dialog = jDialog;
            this.fixSize();
        }

        private void fixSize() {
            Dimension dimension = this.dialog.getPreferredSize();
            Dimension dimension2 = this.dialog.getToolkit().getScreenSize();
            Rectangle rectangle = prefs.getRectangle(this.sizepref, this.defaultSize());
            Dimension dimension3 = rectangle != null ? rectangle.getSize() : dimension;
            dimension3 = new Dimension(Util.bound(dimension.width, dimension2.width - 50, dimension3.width), Util.bound(dimension.height, dimension2.height - 50, dimension3.height));
            this.dialog.setSize(dimension3.width, dimension3.height);
            if (!prefCenterDialogs && rectangle != null) {
                this.dialog.setLocation(new Point(rectangle.x, rectangle.y));
            } else {
                this.dialog.setLocationRelativeTo(jframe);
            }
        }

        @Override
        public void repack() {
            super.repack();
            this.fixSize();
        }

        @Override
        public void dispose() {
            prefs.setProperty(this.sizepref, this.dialog.getBounds());
            super.dispose();
        }
    }

    class TabPager
    extends AbstractAction {
        private int inc;
        private JTabbedPane tabs;

        TabPager(JTabbedPane jTabbedPane, int n) {
            this.tabs = jTabbedPane;
            this.inc = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.tabs.getSelectedIndex() + this.inc;
            if (n < 0) {
                n = this.tabs.getTabCount() - 1;
            } else if (n >= this.tabs.getTabCount()) {
                n = 0;
            }
            this.tabs.setSelectedIndex(n);
        }
    }

    static class TabSelect
    extends AbstractAction {
        private int idx;
        private JTabbedPane tabs;

        TabSelect(JTabbedPane jTabbedPane, int n) {
            this.tabs = jTabbedPane;
            this.idx = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.tabs.getTabCount();
            if (n > 0) {
                if (this.idx < 0) {
                    this.tabs.setSelectedIndex(n - 1);
                } else {
                    this.tabs.setSelectedIndex(this.idx);
                }
            }
        }
    }

    static class EventAction
    extends AbstractAction {
        private int evid;

        EventAction(int n) {
            this.evid = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tonto.sendEvent(this.evid);
        }
    }

    static class RevertMenuAction
    implements ActionListener {
        private File touch;
        private String name;

        RevertMenuAction(File file, String string) {
            this.touch = file;
            this.name = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.touch.setLastModified(Util.time());
            Tonto.infoDialog("Restart Tonto to use version " + this.name);
        }
    }

    static class FileBrowse
    extends ActionButton {
        private String title;
        private JTextField target;

        FileBrowse(String string, JTextField jTextField) {
            super("Browse");
            this.title = string;
            this.target = jTextField;
        }

        @Override
        public void action() {
            Tonto.browseForFile(this.title, this.target);
        }
    }

    class MultiDo
    implements Doable {
        private Vector dos;

        MultiDo() {
            this.dos = new Vector();
        }

        MultiDo(Doable[] doableArray) {
            this.dos = this.dos;
            this.dos = new Vector(doableArray.length);
            for (int i = 0; i < doableArray.length; ++i) {
                this.dos.add(doableArray[i]);
            }
        }

        MultiDo(Vector vector) {
            this.dos = vector;
        }

        public void add(Doable doable) {
            this.dos.add(doable);
        }

        @Override
        public void doIt() {
            for (int i = 0; i < this.dos.size(); ++i) {
                ((Doable)this.dos.get(i)).doIt();
            }
        }

        @Override
        public void undoIt() {
            for (int i = 0; i < this.dos.size(); ++i) {
                ((Doable)this.dos.get(i)).undoIt();
            }
        }
    }

    class DoBounds
    implements Doable {
        private CCFChild child;
        private Component box;
        private Rectangle start;
        private Rectangle end;

        DoBounds(CCFChild cCFChild, int n, int n2, int n3, int n4) {
            this.child = cCFChild;
            this.start = cCFChild.getBounds();
            this.end = new Rectangle(this.start.x + n, this.start.y + n2, this.start.width + n3, this.start.height + n4);
        }

        DoBounds(CCFChild cCFChild, Rectangle rectangle, Rectangle rectangle2) {
            this.child = cCFChild;
            this.start = rectangle;
            this.end = rectangle2;
        }

        DoBounds(Component component, Rectangle rectangle, Rectangle rectangle2) {
            this.box = component;
            this.start = rectangle;
            this.end = rectangle2;
        }

        @Override
        public void doIt() {
            if (this.box != null) {
                this.box.setBounds(this.end);
            }
            if (this.child != null) {
                this.child.setBounds(this.end);
            }
        }

        @Override
        public void undoIt() {
            if (this.box != null) {
                this.box.setBounds(this.start);
            }
            if (this.child != null) {
                this.child.setBounds(this.start);
            }
        }
    }

    class DoRemoveDependencies
    implements Doable,
    IWalker {
        private CCF ccf;
        private CCFNode node;
        private Hashtable clones;

        DoRemoveDependencies(CCF cCF, CCFNode cCFNode) {
            this.ccf = cCF;
            this.node = cCFNode;
        }

        @Override
        public void doIt() {
            this.clones = new Hashtable();
            if (this.ccf != null) {
                new CCFWalker(this.ccf).walk(this);
            }
        }

        @Override
        public void undoIt() {
            Enumeration enumeration = this.clones.keys();
            while (enumeration.hasMoreElements()) {
                CCFActionList cCFActionList = (CCFActionList)enumeration.nextElement();
                CCFAction[] cCFActionArray = (CCFAction[])this.clones.get(cCFActionList);
                cCFActionList.setActions(cCFActionArray);
            }
        }

        @Override
        public void onNode(CCFNode cCFNode) {
            if (cCFNode instanceof CCFActionList) {
                CCFActionList cCFActionList = (CCFActionList)cCFNode;
                this.clones.put(cCFActionList, cCFActionList.getActions());
                if (cCFActionList.deleteMatching(this.node)) {
                    debug.log(1, "rmdep: remove matching " + Util.nickname(cCFNode.getParent()));
                    new Exception("Trace").printStackTrace();
                }
            }
        }
    }

    class DoDeleteDevice
    implements Doable {
        private CCFDevice before;
        private CCFDevice device;
        private CCFHeader header;
        private CCFTreeDeviceFolder folder;
        private Vector showing;
        private int type;
        private final int HOME = 1;
        private final int DEVICE = 2;
        private final int MACRO = 3;

        DoDeleteDevice(CCFDevice cCFDevice, CCFTreeDeviceFolder cCFTreeDeviceFolder) {
            this.device = cCFDevice;
            this.folder = cCFTreeDeviceFolder;
            this.type = cCFDevice.isHomeDevice() ? 1 : (cCFDevice.isNormalDevice() ? 2 : 3);
        }

        @Override
        public void doIt() {
            this.showing = new Vector();
            for (CCFPanel cCFPanel = this.device.getFirstPanel(); cCFPanel != null; cCFPanel = cCFPanel.getNextPanel()) {
                if (Tonto.this.panels.get(cCFPanel) != null) {
                    this.showing.add(cCFPanel);
                }
                Tonto.this.removePanel(cCFPanel, true);
            }
            this.before = this.device.next;
            this.header = this.device.getHeader();
            this.folder.setRootDevice(this.device.delete());
            this.folder.refresh();
        }

        @Override
        public void undoIt() {
            if (this.before == null) {
                switch (this.type) {
                    case 1: {
                        if (this.header.firstHome != null) {
                            this.header.firstHome.appendDevice(this.device);
                            break;
                        }
                        this.header.firstHome = this.device;
                        break;
                    }
                    case 2: {
                        if (this.header.firstDevice != null) {
                            this.header.firstDevice.appendDevice(this.device);
                            break;
                        }
                        this.header.firstDevice = this.device;
                        break;
                    }
                    case 3: {
                        if (this.header.firstMacro != null) {
                            this.header.firstMacro.appendDevice(this.device);
                            break;
                        }
                        this.header.firstMacro = this.device;
                    }
                }
            } else {
                this.header.insertBefore(this.before, this.device);
            }
            this.folder.refresh();
            for (int i = 0; i < this.showing.size(); ++i) {
                Tonto.this.showDeskPanel((CCFPanel)this.showing.get(i));
            }
        }
    }

    class DoDeletePanel
    implements Doable {
        private CCFPanel before;
        private CCFPanel panel;
        private TreeNode treeParent;
        private CCFDevice device;
        private boolean showing;

        DoDeletePanel(CCFPanel cCFPanel) {
            this.panel = cCFPanel;
        }

        @Override
        public void doIt() {
            this.treeParent = ((CCFTreePanel)Tonto.this.getTreeWrapper(this.panel)).getParent();
            this.before = this.panel.next;
            this.device = this.panel.getParentDevice();
            this.showing = Tonto.this.panels.get(this.panel) != null;
            Tonto.this.removePanel(this.panel, true);
            this.panel.delete();
            this.treeParent.refresh();
        }

        @Override
        public void undoIt() {
            this.device.insertBefore(this.before, this.panel);
            this.treeParent.refresh();
            if (this.showing) {
                Tonto.this.showDeskPanel(this.panel);
            }
        }
    }

    class DoDeleteChild
    implements Doable {
        private CCFChild child;
        private IChildContainer parent;
        private CCFChild[] clone;
        private Component oldDS;

        public String toString() {
            return "DoDeleteChild:" + this.child;
        }

        DoDeleteChild(CCFChild cCFChild) {
            this.child = cCFChild;
            this.parent = (IChildContainer)((Object)cCFChild.getParent());
        }

        @Override
        public void doIt() {
            this.clone = this.parent.getChildren();
            if (this.child.type == 0) {
                this.child.getFrame().delete();
            } else {
                this.child.getButton().delete();
            }
            Tonto.this.refreshPanel(this.child.getParentPanel());
            Tonto.this.setCCFChanged();
            Tonto.this.setDragSelection(null);
        }

        @Override
        public void undoIt() {
            this.parent.setChildren(this.clone);
            Tonto.this.refreshPanel(this.child.getParentPanel());
        }
    }

    class DoAddPanel
    implements Doable {
        private CCFPanel panel;
        private CCFDevice device;
        private CCFTreeDevice node;
        private boolean show;

        DoAddPanel(CCFTreeDevice cCFTreeDevice, CCFDevice cCFDevice, CCFPanel cCFPanel, boolean bl) {
            this.node = cCFTreeDevice;
            this.device = cCFDevice;
            this.panel = cCFPanel;
            this.show = bl;
        }

        @Override
        public void doIt() {
            this.device.addPanel(this.panel);
            this.node.refresh();
            if (this.show) {
                Tonto.this.showDeskPanel(this.panel);
            }
        }

        @Override
        public void undoIt() {
            Tonto.this.removePanel(this.panel, true);
            this.panel.delete();
            this.node.refresh();
        }
    }

    class DoAdd
    implements Doable {
        private CCFChild child;
        private IChildContainer parent;
        private CCFChild[] clone;
        private Component oldDS;

        DoAdd(CCFChild cCFChild, IChildContainer iChildContainer) {
            this.child = cCFChild;
            this.parent = iChildContainer;
        }

        @Override
        public void doIt() {
            this.clone = this.parent.getChildren();
            if (this.child.type == 0) {
                this.parent.addFrame(this.child.getFrame());
                Tonto.this.icons.addFrame(this.child.getFrame());
            } else {
                this.parent.addButton(this.child.getButton());
                Tonto.this.icons.addButton(this.child.getButton());
            }
            Tonto.this.refreshPanel(this.child.getParentPanel());
            this.oldDS = Tonto.this.dragSelection;
            Tonto.this.setDragSelection(Tonto.this.getUIWrapper(this.child));
        }

        @Override
        public void undoIt() {
            this.parent.setChildren(this.clone);
            Tonto.this.refreshPanel(this.child.getParentPanel());
            Tonto.this.setDragSelection(this.oldDS);
        }
    }

    class DoRefresher
    implements Doable {
        private CCFPanel panel;
        private boolean ondo;

        DoRefresher(CCFPanel cCFPanel, boolean bl) {
            this.panel = cCFPanel;
            this.ondo = bl;
        }

        @Override
        public void doIt() {
            if (this.ondo) {
                Tonto.this.refreshPanel(this.panel);
            }
        }

        @Override
        public void undoIt() {
            if (!this.ondo) {
                Tonto.this.refreshPanel(this.panel);
            }
        }
    }

    class DoNodeUpdate
    implements Doable {
        private CCFNode node;
        private Hashtable oldState;
        private Hashtable newState;
        private boolean lastWasDo;

        DoNodeUpdate(CCFNode cCFNode) {
            this.node = cCFNode;
            this.lastWasDo = false;
            this.getOldState();
        }

        @Override
        public void doIt() {
            if (!this.lastWasDo) {
                this.setNewState();
                this.reread();
                CCFPanel cCFPanel = this.node.getParentPanel();
                if (cCFPanel != null) {
                    Tonto.this.refreshPanel(cCFPanel);
                }
            }
            this.lastWasDo = true;
        }

        private void reread() {
            FrameBox frameBox;
            if (this.node instanceof CCFButton) {
                ButtonBox buttonBox = (ButtonBox)Tonto.this.getUIWrapper(((CCFButton)this.node).getChildWrapper());
                if (buttonBox != null) {
                    buttonBox.readButton();
                }
            } else if (this.node instanceof CCFFrame && (frameBox = (FrameBox)Tonto.this.getUIWrapper(((CCFFrame)this.node).getChildWrapper())) != null) {
                frameBox.readFrame();
            }
        }

        @Override
        public void undoIt() {
            if (this.lastWasDo) {
                this.setOldState();
                this.reread();
                Tonto.this.refreshPanel(this.node.getParentPanel());
            }
            this.lastWasDo = false;
        }

        private Hashtable getState() {
            Hashtable<Field, Object> hashtable = new Hashtable<Field, Object>();
            try {
                Field[] fieldArray = this.node.getClass().getDeclaredFields();
                for (int i = 0; i < fieldArray.length; ++i) {
                    try {
                        hashtable.put(fieldArray[i], fieldArray[i].get(this.node));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return hashtable;
        }

        private void setState(Hashtable hashtable) {
            try {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    try {
                        Field field = (Field)enumeration.nextElement();
                        Object v = hashtable.get(field);
                        field.set(this.node, v);
                        if (!(v instanceof CCFChild[])) continue;
                        CCFChild[] cCFChildArray = (CCFChild[])v;
                        for (int i = 0; i < cCFChildArray.length; ++i) {
                            cCFChildArray[i].setParent(this.node);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void getOldState() {
            this.oldState = this.getState();
        }

        public void setOldState() {
            this.setState(this.oldState);
        }

        public void getNewState() {
            this.newState = this.getState();
        }

        public void setNewState() {
            this.setState(this.newState);
        }

        public void pushDoNewState() {
            this.getNewState();
            Tonto.this.pushDo(this);
        }
    }

    static interface TreeProperties {
    }

    static interface Doable {
        public void doIt();

        public void undoIt();
    }

    static interface Parental {
        public Object getMyParent();
    }

    static interface Pastable {
        public boolean acceptPaste(Object var1);

        public void paste(Object var1);
    }

    static interface Movable {
        public Point getLocation();

        public void setLocation(Point var1);
    }

    static interface Resizable {
        public boolean isResizable();

        public Dimension getSize();

        public void setSize(Dimension var1);
    }

    static interface Namable {
        public String getName();

        public void setName(String var1);
    }

    static interface FrameHost {
        public void addFrame();
    }

    static interface ButtonHost {
        public void addButton();
    }

    static interface Configurable {
        public void editProperties();
    }

    static interface Deletable {
        public void delete();
    }

    static interface Copyable {
        public Object copy();
    }

    class JumpWrapper {
        private int value;

        JumpWrapper(int n) {
            this.value = n;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object object) {
            return object instanceof JumpWrapper && ((JumpWrapper)object).value == this.value;
        }

        public String toString() {
            return " (( " + CCFAction.getJumpSpecialString(this.value) + " ))";
        }
    }

    class PanelWrapper {
        private CCFPanel panel;

        PanelWrapper(CCFPanel cCFPanel) {
            this.panel = cCFPanel;
        }

        public int hashCode() {
            return this.panel.hashCode();
        }

        public boolean equals(Object object) {
            return object instanceof PanelWrapper && ((PanelWrapper)object).panel == this.panel;
        }

        public String toString() {
            return this.panel != null ? " " + this.panel.getFQN() : "";
        }
    }

    static class DeviceKey {
        private CCFDevice device;
        private int key;
        private String name;

        DeviceKey(CCFDevice cCFDevice, int n) {
            this(cCFDevice, n, cCFDevice.getHardKeys()[n].getName());
        }

        DeviceKey(CCFDevice cCFDevice, int n, String string) {
            this.device = cCFDevice;
            this.key = n;
            this.name = string;
        }

        public int hashCode() {
            return this.device.hashCode() + this.key;
        }

        public boolean equals(Object object) {
            if (object instanceof DeviceKey) {
                DeviceKey deviceKey = (DeviceKey)object;
                return deviceKey.device == this.device && deviceKey.key == this.key;
            }
            return false;
        }

        public String toString() {
            if (this.name != null) {
                return this.device + " : " + CCFAction.getKeyName(this.device, this.key) + " (" + this.name + ")";
            }
            return this.device + " : " + CCFAction.getKeyName(this.device, this.key);
        }
    }

    class UndeadDialog
    extends StackedDialog {
        private JTextField port;

        UndeadDialog() {
            super("Undead Remote");
            this.port = new JTextField(15);
            this.port.setText(prefCommPort != null ? prefCommPort : "");
            JTextArea jTextArea = new JTextArea(20, 55);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setText("READ THIS FIRST!!!\n\nIf your remote is rebooting after a failed CCF download, then this utility may just be able to help. If your remote is rebooting after a failed firmware update, then use the 'Firmware Update' menu instead. Here's what to do:\n\n (1) Load the CCF into Tonto that you want send to the Pronto\n (2) Type the name of the device your Pronto is attached to into the 'port' field below. This may have already been detected.\n (3) Click 'Undead'.\n (4) If your Pronto isn't already resetting itself, insert a paperclip into the 'reset' hole on the back of the Pronto or remove and re-add the batteries to force a cold start.\n (5) Wait and Watch. It may take a couple of minutes.\n\nIf your hardware is not completely terminal and the correct port was specified, then there is a good chance your Pronto will soon live again. The most common problem with 'Undeading' a Pronto is getting the right port name. On Windows, it's COM1-COM4. On Unix, it's usually /dev/something.");
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 31);
            ActionButton actionButton = new ActionButton("Undead"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void action() {
                    final String string = Util.time() + ".ccf";
                    final TransferDialog transferDialog = new TransferDialog("Undead");
                    File file = new File(string);
                    try {
                        if (Tonto.this.ccf == null) {
                            Tonto.errorDialog("You must first load a CCF");
                            return;
                        }
                        Tonto.this.ccf.save(string);
                        new DialogThread(transferDialog){

                            @Override
                            public void body() throws Exception {
                                Tonto.closeComm();
                                Comm comm = new Comm(UndeadDialog.this.port.getText().trim());
                                try {
                                    comm.undeadPronto(string, transferDialog);
                                    Tonto.infoDialog("Undead Upload Succeeded!");
                                    if (prefCommPort == null) {
                                        prefCommPort = UndeadDialog.this.port.getText().trim();
                                    }
                                    UndeadDialog.this.dispose();
                                }
                                finally {
                                    comm.close();
                                }
                            }
                        }.checkError();
                    }
                    catch (Throwable throwable) {
                        Tonto.errorDialog("Undead failed", throwable);
                    }
                    finally {
                        file.delete();
                        transferDialog.dispose();
                    }
                }
            };
            ActionButton actionButton2 = new ActionButton("Cancel"){

                @Override
                public void action() {
                    UndeadDialog.this.dispose();
                }
            };
            JLabel jLabel = new JLabel("Port", 4);
            AAPanel aAPanel = new AAPanel(true);
            Util.setLabelBorder("Undead", aAPanel);
            this.define('x', aAPanel, "wx=1;wy=1;fill=b;pad=5,5,3,5");
            this.define('t', jScrollPane, "wx=1;wy=1;fill=b;pad=5,5,3,5");
            this.define('l', jLabel, "wx=0;fill=b;pad=3,3,3,3");
            this.define('p', this.port, "wx=1;fill=b;pad=3,3,3,3");
            this.define('u', actionButton, "wx=1;fill=b;pad=3,3,3,3");
            this.define('c', actionButton2, "wx=1;fill=b;pad=3,3,3,3");
            this.setLayout(new String[]{"xxxxxxxxx", "xtttttttx", "xl pppppx", "xxxxxxxxx", " uuu ccc "});
        }
    }

    class MergeDialog
    extends StackedDialog {
        private boolean merge;

        MergeDialog() {
            super("Merge or Replace");
            this.merge = false;
            JLabel jLabel = new JLabel("Would you like to merge the new file into");
            JLabel jLabel2 = new JLabel("the existing file or replace it?");
            ActionButton actionButton = new ActionButton("Merge"){

                @Override
                public void action() {
                    MergeDialog.this.merge = true;
                    MergeDialog.this.dispose();
                }
            };
            ActionButton actionButton2 = new ActionButton("Replace"){

                @Override
                public void action() {
                    MergeDialog.this.merge = false;
                    MergeDialog.this.dispose();
                }
            };
            this.define('1', jLabel, "wx=1;wy=1;fill=b;pad=5,5,3,5");
            this.define('2', jLabel2, "wx=1;wy=1;fill=b;pad=0,5,5,5");
            this.define('m', actionButton, "wx=1;fill=b;pad=3,3,3,3");
            this.define('r', actionButton2, "wx=1;fill=b;pad=3,3,3,3");
            this.setLayout(new String[]{"1111111", "2222222", "mmm rrr"});
        }

        public boolean getValue() {
            this.show();
            return this.merge;
        }
    }

    class TextDialog
    extends StackedDialog
    implements ActionListener {
        TextDialog(String string, String string2) {
            Object object;
            super(string);
            JButton jButton = new JButton("OK");
            jButton.addActionListener(this);
            JTextArea jTextArea = new JTextArea(30, 80);
            jTextArea.setFont(new Font("Courier", 0, 12));
            jTextArea.setEditable(false);
            Tonto.setRCMenu(jTextArea);
            InputStream inputStream = this.getClass().getResourceAsStream(string2);
            try {
                if (inputStream != null) {
                    object = new byte[1024];
                    int n = 0;
                    while ((n = inputStream.read((byte[])object)) >= 0) {
                        jTextArea.append(new String((byte[])object, 0, n));
                    }
                } else {
                    debug.log(1, "can't find resource '" + string2 + "'");
                }
            }
            catch (Exception exception) {
                Tonto.errorDialog(exception);
            }
            jTextArea.setCaretPosition(0);
            object = new JScrollPane(jTextArea);
            this.add((Component)object, "x=0;y=0;fill=b;pad=3,3,3,3;wx=1;wy=1");
            this.add((Component)jButton, "x=0;y=1;fill=b;pad=5,5,5,5;wx=0;wy=0");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.dispose();
        }
    }

    class CommStatusDialog
    extends StackedDialog
    implements ActionListener {
        CommStatusDialog() throws Exception {
            super("Remote Status");
            Comm comm = Tonto.getComm(true);
            if (comm == null) {
                Tonto.showCommError();
                return;
            }
            JButton jButton = new JButton("OK");
            jButton.addActionListener(this);
            ActionButton actionButton = new ActionButton("Refresh"){

                @Override
                public void action() {
                    CommStatusDialog.this.dispose();
                    Tonto.closeComm();
                    Tonto.sendEvent(262);
                }
            };
            AAPanel aAPanel = new AAPanel(true);
            Util.setLabelBorder("Remote", aAPanel);
            AAPanel aAPanel2 = new AAPanel(true);
            Util.setLabelBorder("CCF", aAPanel2);
            JLabel jLabel = this.label("Port");
            JLabel jLabel2 = this.label("Feature");
            JTextField jTextField = this.data(comm.getPortName());
            JTextField jTextField2 = this.data("0x" + Integer.toString(comm.getPossible(), 16));
            JLabel jLabel3 = this.label("Size");
            JLabel jLabel4 = this.label("Date");
            JLabel jLabel5 = this.label("Time");
            JLabel jLabel6 = this.label("State");
            JTextField jTextField3 = this.data(Integer.toString(comm.getCCFSize()));
            JTextField jTextField4 = this.data(comm.getCCFDate());
            JTextField jTextField5 = this.data(comm.getCCFTime());
            JTextField jTextField6 = this.data((comm.isCCFDirty() ? "" : "un") + "changed");
            this.define('o', jButton, "pad=5,5,5,5;fill=b;wx=1");
            this.define('r', actionButton, "pad=5,5,5,5;fill=b;wx=1");
            this.define('.', aAPanel, "pad=3,3,3,3;fill=b;wx=1;wy=1");
            this.define(',', aAPanel2, "pad=3,3,3,3;fill=b;wx=1;wy=1");
            this.define('-', "pad=3,3,3,3");
            this.define('1', jLabel, "pad=3,3,3,3;fill=b");
            this.define('2', jTextField, "pad=3,3,3,3;fill=b;wx=1");
            this.define('3', jLabel2, "pad=3,3,3,3;fill=b");
            this.define('4', jTextField2, "pad=3,3,3,3;fill=b;wx=1");
            this.define('5', jLabel3, "pad=3,3,3,3;fill=b");
            this.define('6', jTextField3, "pad=3,3,3,3;fill=b;wx=1");
            this.define('7', jLabel4, "pad=3,3,3,3;fill=b");
            this.define('8', jTextField4, "pad=3,3,3,3;fill=b;wx=1");
            this.define('9', jLabel5, "pad=3,3,3,3;fill=b");
            this.define('0', jTextField5, "pad=3,3,3,3;fill=b;wx=1");
            this.define('a', jLabel6, "pad=3,3,3,3;fill=b");
            this.define('b', jTextField6, "pad=3,3,3,3;fill=b;wx=1");
            this.setLayout(new String[]{"...............", ".111 222222222.", ".333 444444444.", "...............", ",,,,,,,,,,,,,,,", ",555 666666666,", ",777 888888888,", ",999 000000000,", ",aaa bbbbbbbbb,", ",,,,,,,,,,,,,,,", "---------------", "-     o r     -", "---------------"});
            new RunInThread(){

                @Override
                public void runIn() {
                    CommStatusDialog.this.show();
                }
            }.start();
        }

        private JLabel label(String string) {
            return new JLabel(string, 4);
        }

        private JTextField data(String string) {
            JTextField jTextField = new JTextField(string);
            jTextField.setEditable(false);
            return jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.dispose();
        }
    }

    class IRValueDialog
    extends MemoryDialog
    implements KeyListener {
        private CCFIRCode ircode;
        private NameAttr name;
        private JTextArea text;
        private IRGraph graph;
        private JComboBox dbase;
        private boolean ready;

        IRValueDialog(CCFIRCode cCFIRCode) {
            super("IR Signal", Tonto.PREF_IR_BOUNDS);
            this.ircode = cCFIRCode;
            String string = cCFIRCode.getName();
            this.name = new NameAttr();
            this.name.setName(string != null ? string : "Learned");
            this.text = new MyTextArea(8, 40);
            this.text.setFont(new Font("Courier", 0, 12));
            this.text.setLineWrap(true);
            this.text.setWrapStyleWord(true);
            this.text.addKeyListener(this);
            Tonto.setRCMenu(this.text);
            this.graph = new IRGraph(null);
            this.dbase = new JComboBox();
            this.dbase.addActionListener(this);
            AAPanel aAPanel = new AAPanel();
            LabelBox labelBox = new LabelBox("Data", new JScrollPane(this.text));
            LabelBox labelBox2 = new LabelBox("Signal", new JScrollPane(this.graph, 21, 30));
            LabelBox labelBox3 = new LabelBox("Database", this.dbase);
            aAPanel.add((Component)this.name, "x=0;y=0;fill=b;wx=1;wy=0;pad=5,5,5,5");
            aAPanel.add((Component)labelBox, "x=0;y=1;fill=b;wx=1;wy=2;pad=5,5,5,5");
            aAPanel.add((Component)labelBox2, "x=0;y=2;fill=b;wx=1;wy=1;pad=0,5,5,5");
            aAPanel.add((Component)labelBox3, "x=0;y=3;fill=b;wx=1;wy=0;pad=0,5,5,5");
            this.setContents(aAPanel);
            this.setText(new Pronto(cCFIRCode.getCode(), cCFIRCode.hasUDB()).encode());
        }

        @Override
        public JComponent getButtons() {
            return UIUtils.getOtherOKCancel(new String[]{"Learn", "Expert"}, this);
        }

        private void setText(String string) {
            this.text.setText(string);
            this.updateCode();
        }

        private String getText() {
            return this.text.getText().trim();
        }

        @Override
        public boolean handleCmd(String string) {
            if (string != null) {
                if (string.equals("Learn")) {
                    Pronto pronto = Tonto.learnIR();
                    if (pronto != null) {
                        this.setText(pronto.encode());
                    }
                    return false;
                }
                if (string.equals("Expert")) {
                    IRSignal iRSignal = null;
                    try {
                        iRSignal = new IRSignalDialog(new Pronto(this.getText(), 1)).getValue();
                    }
                    catch (Exception exception) {
                        iRSignal = new IRSignalDialog(new IRSignal()).getValue();
                    }
                    if (iRSignal != null) {
                        this.setText(new Pronto(iRSignal).encode());
                    }
                }
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.text) {
                this.doOK();
                this.dispose();
                return;
            }
            if (this.ready && actionEvent.getSource() == this.dbase) {
                debug.log(3, "dbase item selected: " + this.dbase.getSelectedItem());
                IRSel iRSel = (IRSel)this.dbase.getSelectedItem();
                if (iRSel != null) {
                    this.setText(new Pronto(iRSel.sig).encode());
                }
            }
            super.actionPerformed(actionEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(150L);
                        IRValueDialog.this.updateCode();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.start();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public boolean invoke() {
            this.ready = false;
            this.dbase.removeAllItems();
            if (database != null) {
                Enumeration enumeration = database.getRemotes();
                while (enumeration.hasMoreElements()) {
                    IRRemote iRRemote = (IRRemote)enumeration.nextElement();
                    Enumeration enumeration2 = iRRemote.getKeys();
                    while (enumeration2.hasMoreElements()) {
                        IRSignal iRSignal = (IRSignal)enumeration2.nextElement();
                        this.dbase.addItem(new IRSel(iRRemote, iRSignal));
                    }
                }
            }
            this.dbase.setSelectedItem(null);
            this.ready = true;
            return super.invoke();
        }

        @Override
        public void doOK() {
            this.ircode.setName(this.name.getName());
            this.ircode.setCode((this.ircode.hasUDB() ? "0000 0000 0000 " : "") + this.text.getText().trim());
        }

        @Override
        public void doCancel() {
        }

        public void updateCode() {
            this.setCode(this.text.getText().trim());
        }

        public void setCode(String string) {
            Pronto pronto = new Pronto(string.trim(), 1);
            this.graph.setSignal(pronto.isRawSignal() ? null : pronto);
        }

        class IRSel {
            private IRRemote rem;
            private IRSignal sig;

            IRSel(IRRemote iRRemote, IRSignal iRSignal) {
                this.rem = iRRemote;
                this.sig = iRSignal;
            }

            public String toString() {
                return this.rem.getModel() + "-" + this.sig.getName();
            }
        }
    }

    class ProntoScanDialog
    extends TransferDialog
    implements Runnable {
        private boolean running;
        private Comm comm;

        ProntoScanDialog() {
            super("Scanning for Remote");
        }

        @Override
        public void run() {
            int n = 1;
            int n2 = 1;
            while (this.running) {
                if (n <= 0 || n >= 100) {
                    n2 = -n2;
                }
                this.progress(n += n2);
                try {
                    Thread.currentThread();
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public void show() {
            this.running = true;
            new Thread(this).start();
            super.show();
        }

        @Override
        public void dispose() {
            this.running = false;
            super.dispose();
        }
    }

    static class TimerEditor
    extends OKCancelDialog {
        private CCFTimer timer;
        private TimerEvent start;
        private TimerEvent end;

        TimerEditor() {
            super("Timer");
            AAPanel aAPanel = new AAPanel();
            this.setContents(aAPanel);
            this.start = new TimerEvent();
            this.end = new TimerEvent();
            aAPanel.add((Component)new LabelBox("Start", this.start), "x=0;y=0;pad=2,2,2,2;fill=b;wx=1;wy=1");
            aAPanel.add((Component)new LabelBox("End", this.end), "x=0;y=1;pad=2,2,2,2;fill=b;wx=1;wy=1");
        }

        public boolean invoke(CCFTimer cCFTimer) {
            if (cCFTimer == null) {
                cCFTimer = new CCFTimer();
            }
            this.timer = cCFTimer;
            this.start.update(this.timer.startDays, this.timer.startTime, this.timer.startAction);
            this.end.update(this.timer.endDays, this.timer.endTime, this.timer.endAction);
            return this.invoke();
        }

        public CCFTimer getTimer() {
            return this.timer;
        }

        @Override
        public void doOK() {
            this.start.update();
            this.end.update();
            this.timer.startDays = this.start.days;
            this.timer.startTime = this.start.time;
            this.timer.startAction = this.start.action;
            this.timer.endDays = this.end.days;
            this.timer.endTime = this.end.time;
            this.timer.endAction = this.end.action;
        }

        @Override
        public void doCancel() {
        }
    }

    class IconLibrary
    extends MemoryDialog {
        private JList list;
        private CCFIcon selected;
        private ActionButton edit;
        private Hashtable hash;
        private NoIcon noIcon;
        private LineBorder b1;
        private LineBorder b2;
        private Vector items;
        private VectorListModel model;
        private JLabel geom;
        private JLabel size;
        private JLabel bits;
        private JCheckBox comp;

        IconLibrary() {
            super("Icon Library", Tonto.PREF_ICONLIB_BOUNDS);
            this.hash = new Hashtable();
            this.noIcon = new NoIcon();
            this.b1 = new LineBorder(Color.black, 1);
            this.b2 = new LineBorder(Color.gray, 1);
            this.items = new Vector();
            this.model = new VectorListModel(this.items);
            this.geom = new MyLabel("000x000");
            this.size = new MyLabel("000000");
            this.bits = new MyLabel("00");
            this.comp = new JCheckBox("compressed");
            this.load(null);
            ActionButton actionButton = new ActionButton("Load"){

                @Override
                public void action() {
                    IconLibrary.this.iconLoad();
                }
            };
            ActionButton actionButton2 = new ActionButton("Save"){

                @Override
                public void action() {
                    IconLibrary.this.iconSave();
                }
            };
            this.edit = new ActionButton("Edit"){

                @Override
                public void action() {
                    IconLibrary.this.iconEdit();
                }
            };
            this.model = new VectorListModel(this.items);
            this.list = new JList(this.model);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    IconLibrary.this.selected = (CCFIcon)IconLibrary.this.items.get(n);
                    NoIcon noIcon = IconLibrary.this.selected != null ? (JComponent)IconLibrary.this.hash.get(IconLibrary.this.selected) : IconLibrary.this.noIcon;
                    noIcon.setBorder(bl ? IconLibrary.this.b1 : IconLibrary.this.b2);
                    noIcon.setBackground(bl && noIcon != IconLibrary.this.noIcon ? IconLibrary.this.noIcon.getForeground() : Color.lightGray);
                    return noIcon;
                }
            });
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    IconLibrary.this.updateStats(IconLibrary.this.list.getSelectedValue());
                }
            });
            this.comp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = IconLibrary.this.comp.isSelected();
                    if (bl != IconLibrary.this.selected.isCompressed()) {
                        IconLibrary.this.selected.setCompressed(bl);
                        IconLibrary.this.updateStats(IconLibrary.this.selected);
                    }
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.list, 22, 31);
            AAPanel aAPanel = new AAPanel();
            JLabel jLabel = new JLabel("Dim");
            jLabel.setForeground(Color.black);
            JLabel jLabel2 = new JLabel("Size");
            jLabel2.setForeground(Color.black);
            JLabel jLabel3 = new JLabel("Bits");
            jLabel3.setForeground(Color.black);
            AAPanel aAPanel2 = new AAPanel(true);
            aAPanel2.setBorder(new EtchedBorder(1));
            aAPanel.define('0', "fill=b;pad=3,3,3,3");
            aAPanel.define('1', (Component)aAPanel2, "fill=h;pad=3,3,3,3");
            aAPanel.define('x', (Component)jScrollPane, "fill=b;pad=3,3,3,3;wx=1;wy=1");
            aAPanel.define('l', (Component)actionButton, "pad=3,3,3,3");
            aAPanel.define('s', (Component)actionButton2, "pad=3,3,3,3");
            aAPanel.define('e', (Component)this.edit, "pad=3,3,3,3");
            aAPanel.define('2', (Component)this.geom, "pad=3,3,3,3");
            aAPanel.define('3', (Component)this.size, "pad=3,3,3,3");
            aAPanel.define('4', (Component)this.bits, "pad=3,3,3,3");
            aAPanel.define('5', (Component)jLabel2, "pad=3,3,3,3;fill=b");
            aAPanel.define('6', (Component)jLabel3, "pad=3,3,3,3;fill=b");
            aAPanel.define('7', (Component)this.comp, "pad=3,6,3,3;fill=b");
            aAPanel.define('8', (Component)jLabel, "pad=3,3,3,3;fill=b");
            aAPanel.setLayout(new String[]{"00000000000000000", "0 lll  sss  eee 0", "00000000000000000", "11111111111111111", "1 8 2 5 3 6 4 7 1", "11111111111111111", " xxxxxxxxxxxxxxx "});
            this.setContents(aAPanel);
        }

        void updateStats(Object object) {
            if (object instanceof CCFIcon) {
                CCFIcon cCFIcon = (CCFIcon)object;
                this.geom.setText(cCFIcon.width + "x" + cCFIcon.height);
                this.size.setText(Integer.toString(cCFIcon.data.length + 8));
                this.bits.setText(cCFIcon.isFullColor() ? "32" : (cCFIcon.isColor() ? "8" : (cCFIcon.isGray() ? "2" : "1")));
                this.comp.setSelected(cCFIcon.isCompressed());
                this.comp.setEnabled(cCFIcon.isCompressible());
            } else {
                this.geom.setText("0x0");
                this.size.setText("0");
                this.bits.setText("0");
                this.comp.setSelected(false);
                this.comp.setEnabled(false);
            }
        }

        boolean invoke(CCFIcon cCFIcon) {
            this.selected = cCFIcon;
            this.list.setSelectedValue(cCFIcon, true);
            return this.invoke();
        }

        public void clearIconCaches() {
            if (Tonto.color()) {
                return;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                Object e = this.items.get(i);
                debug.log(0, "icon@" + i + "=" + e);
                if (!(e instanceof CCFIcon)) continue;
                ((CCFIcon)e).clearCache();
            }
        }

        @Override
        public boolean invoke() {
            this.edit.setEnabled(prefImageEditor != null);
            this.model.refresh();
            return super.invoke();
        }

        void iconLoad() {
            File[] fileArray = Tonto.getFiles("images (*.gif, *.jpg, *.bmp, *.png)", new String[]{"gif", "jpg", "bmp", "png"}, prefImageDir);
            if (fileArray != null && fileArray.length > 0) {
                for (int i = 0; i < fileArray.length; ++i) {
                    try {
                        CCFIcon cCFIcon = CCFIcon.create(fileArray[i].getAbsolutePath(), Tonto.iconMode());
                        if (!this.items.contains(cCFIcon)) {
                            if (cCFIcon.width > ((Tonto)Tonto.this).panelSize.width * 2 || cCFIcon.height > ((Tonto)Tonto.this).panelSize.height * 2) {
                                Tonto.errorDialog("Icon is too large");
                                return;
                            }
                            this.addIcon(cCFIcon);
                            this.model.refresh();
                            Tonto.this.refreshTreeModel();
                        }
                        this.list.setSelectedValue(cCFIcon, true);
                        continue;
                    }
                    catch (Exception exception) {
                        Tonto.debug(exception);
                    }
                }
            }
        }

        void iconSave() {
            CCFIcon cCFIcon = (CCFIcon)this.list.getSelectedValue();
            if (cCFIcon == null) {
                return;
            }
            File file = Tonto.getFile(false, "images (*.gif)", new String[]{"gif"}, prefImageDir);
            if (file != null) {
                try {
                    if (!file.toString().toLowerCase().endsWith(".gif")) {
                        file = new File(file.toString() + ".gif");
                    }
                    cCFIcon.saveGIF(file.toString());
                }
                catch (Exception exception) {
                    Tonto.debug(exception);
                }
            }
        }

        void iconEdit() {
            CCFIcon cCFIcon = (CCFIcon)this.list.getSelectedValue();
            if (cCFIcon != null && prefImageEditor != null) {
                try {
                    final File file = File.createTempFile("tonto", ".gif");
                    cCFIcon.saveGIF(file.toString());
                    final Process process = Runtime.getRuntime().exec(prefImageEditor + " " + file.toString());
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                process.waitFor();
                                7.sleep(2000L);
                                file.delete();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }.start();
                }
                catch (Exception exception) {
                    Tonto.debug(exception);
                }
            }
        }

        void load(CCF cCF) {
            this.selected = null;
            this.hash.clear();
            this.items.setSize(0);
            this.items.add(null);
            this.append(cCF);
            this.model.refresh();
        }

        void append(CCF cCF) {
            if (cCF != null) {
                CCFHeader cCFHeader = cCF.header();
                this.addDevice(cCFHeader.firstHome);
                this.addDevice(cCFHeader.firstDevice);
                this.addDevice(cCFHeader.firstMacro);
                this.addPanel(cCFHeader.macroPanel);
                Tonto.this.refreshTreeModel();
            }
        }

        void addDevice(CCFDevice cCFDevice) {
            if (cCFDevice != null) {
                this.addPanel(cCFDevice.getFirstPanel());
                this.addDevice(cCFDevice.getNextDevice());
                this.addIcon(cCFDevice.iconSelected);
                this.addIcon(cCFDevice.iconUnselected);
            }
        }

        void addPanel(CCFPanel cCFPanel) {
            if (cCFPanel != null) {
                this.addChildren(cCFPanel.getChildren());
                this.addPanel(cCFPanel.getNextPanel());
            }
        }

        void addChildren(CCFChild[] cCFChildArray) {
            if (cCFChildArray != null) {
                for (int i = 0; i < cCFChildArray.length; ++i) {
                    this.addChild(cCFChildArray[i]);
                }
            }
        }

        void addChild(CCFChild cCFChild) {
            if (cCFChild != null) {
                switch (cCFChild.getType()) {
                    case 0: {
                        this.addFrame(cCFChild.getFrame());
                        break;
                    }
                    case 1: {
                        this.addButton(cCFChild.getButton());
                    }
                }
            }
        }

        void addFrame(CCFFrame cCFFrame) {
            if (cCFFrame != null) {
                this.addIcon(cCFFrame.getIcon());
                this.addChildren(cCFFrame.getChildren());
            }
        }

        void addButton(CCFButton cCFButton) {
            if (cCFButton != null) {
                this.addCCFIconSet(cCFButton.getIconSet());
            }
        }

        void addCCFIconSet(CCFIconSet cCFIconSet) {
            for (int i = 0; i < 4; ++i) {
                this.addIcon(cCFIconSet.icons[i]);
            }
        }

        void addIcon(CCFIcon cCFIcon) {
            if (cCFIcon != null && this.hash.get(cCFIcon) == null) {
                this.hash.put(cCFIcon, new IconButton(cCFIcon));
                this.items.add(cCFIcon);
                if (Tonto.color()) {
                    cCFIcon.convertToColor();
                } else {
                    cCFIcon.convertToGray();
                }
            }
        }

        public CCFIcon getSelected() {
            return this.selected;
        }

        @Override
        public void doOK() {
            this.selected = (CCFIcon)this.items.get(this.list.getSelectedIndex());
        }

        @Override
        public void doCancel() {
        }

        @Override
        public Dimension getMinimumSize() {
            return Tonto.this.max(super.getMinimumSize(), 350, 350);
        }

        @Override
        public Dimension getPreferredSize() {
            return Tonto.this.max(super.getPreferredSize(), 350, 350);
        }

        @Override
        public Dimension getMaximumSize() {
            return Tonto.this.max(super.getMaximumSize(), 350, 350);
        }

        class NoIcon
        extends JLabel {
            NoIcon() {
                super("No Icon", 0);
            }

            @Override
            public Dimension getMinimumSize() {
                return Tonto.this.max(super.getMinimumSize(), 0, 30);
            }

            @Override
            public Dimension getPreferredSize() {
                return Tonto.this.max(super.getPreferredSize(), 0, 30);
            }

            @Override
            public Dimension getMaximumSize() {
                return Tonto.this.max(super.getMaximumSize(), 0, 30);
            }
        }
    }

    class IconReplace
    extends OKCancelDialog {
        private IconButton oldButton;
        private IconButton newButton;

        IconReplace() {
            super("Replace Icon");
            this.oldButton = new MyIconButton(this);
            this.newButton = new MyIconButton(this);
            AAPanel aAPanel = new AAPanel();
            ActionButton actionButton = new ActionButton("Replace"){

                @Override
                public void action() {
                    IconReplace.this.doOK();
                }
            };
            JLabel jLabel = new JLabel("Replace Old Icon with New", 0);
            aAPanel.define('0', "fill=b;pad=3,3,3,3");
            aAPanel.define('t', (Component)jLabel, "fill=b;pad=3,3,3,3");
            aAPanel.define('-', (Component)new JLabel("-->"), "fill=b;pad=3,3,3,3");
            aAPanel.define('o', (Component)this.oldButton, "fill=b;pad=3,3,3,3;wx=1");
            aAPanel.define('n', (Component)this.newButton, "fill=b;pad=3,3,3,3;wx=1");
            aAPanel.define('r', (Component)actionButton, "fill=b;pad=3,3,3,3;wx=0");
            aAPanel.setLayout(new String[]{"0000000000000", "0 ttttttttt 0", "0 ooo - nnn 0", "0 rrrrrrrrr 0", "0000000000000"});
            this.setContents(aAPanel);
        }

        @Override
        public void doOK() {
            debug.log(0, "replace OK");
            Tonto.this.iconReplace(this.oldButton.getCCFIcon(), this.newButton.getCCFIcon());
            Tonto.this.refreshAllPanels();
        }

        @Override
        public void doCancel() {
        }

        @Override
        public Dimension getMinimumSize() {
            return Tonto.this.max(super.getMinimumSize(), 350, 350);
        }

        @Override
        public Dimension getPreferredSize() {
            return Tonto.this.max(super.getPreferredSize(), 350, 350);
        }

        @Override
        public Dimension getMaximumSize() {
            return Tonto.this.max(super.getMaximumSize(), 350, 350);
        }
    }

    class JumpChoice
    extends MemoryDialog {
        private JScrollPane scroll;
        private JList combo;
        private Object sel;

        JumpChoice(CCFAction cCFAction) {
            super("Choose JumpTo Panel", Tonto.PREF_JUMP_BOUNDS);
            this.sel = cCFAction.isSpecialJump() ? new JumpWrapper(cCFAction.p2) : new PanelWrapper((CCFPanel)cCFAction.action2);
            Vector<JumpWrapper> vector = new Vector<JumpWrapper>();
            vector.addElement(new JumpWrapper(-572662307));
            vector.addElement(new JumpWrapper(-286331154));
            vector.addElement(new JumpWrapper(-1));
            if (Tonto.this.ccf.header().isMarantz()) {
                vector.addElement(new JumpWrapper(-1145324613));
                vector.addElement(new JumpWrapper(-858993460));
            }
            this.addPanelJumps(vector, Tonto.this.ccf.getFirstHomeDevice());
            this.addPanelJumps(vector, Tonto.this.ccf.getFirstDevice());
            this.addPanelJumps(vector, Tonto.this.ccf.getFirstMacroDevice());
            this.combo = new JList(new VectorListModel(vector));
            this.combo.setSelectionMode(0);
            this.combo.setVisibleRowCount(10);
            this.combo.setFont(Tonto.getPFont());
            this.combo.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        JumpChoice.this.enterOK();
                    }
                }
            });
            this.scroll = new JScrollPane(this.combo, 22, 31);
            this.combo.setSelectedValue(this.sel, true);
            this.setVisible();
            this.setContents(this.scroll);
        }

        @Override
        public Rectangle defaultSize() {
            return new Rectangle(0, 0, 400, 200);
        }

        private void setVisible() {
            int n = this.combo.getSelectedIndex();
            JViewport jViewport = this.scroll.getViewport();
            Rectangle rectangle = this.combo.getCellBounds(n, Math.min(n + 1, this.combo.getModel().getSize() - 1));
            if (rectangle != null) {
                jViewport.scrollRectToVisible(rectangle);
            }
        }

        @Override
        public void showHook(JDialog jDialog) {
            jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    JumpChoice.this.setVisible();
                }
            });
            super.showHook(jDialog);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMiminumSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.min(250, dimension.width), dimension.height);
        }

        private void addPanelJumps(Vector vector, CCFDevice cCFDevice) {
            while (cCFDevice != null) {
                CCFPanel[] cCFPanelArray = cCFDevice.getPanels();
                for (int i = 0; i < cCFPanelArray.length; ++i) {
                    PanelWrapper panelWrapper = new PanelWrapper(cCFPanelArray[i]);
                    if (this.sel.equals(cCFPanelArray[i])) {
                        this.sel = panelWrapper;
                    }
                    vector.addElement(panelWrapper);
                }
                cCFDevice = cCFDevice.next;
            }
        }

        @Override
        public void doOK() {
            this.sel = this.combo.getSelectedValue();
        }

        @Override
        public void doCancel() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean setActionValue(CCFAction cCFAction) {
            if (cCFAction == null || this.sel == null) {
                return false;
            }
            cCFAction.p1 = 0;
            cCFAction.p2 = 0;
            cCFAction.action1 = null;
            cCFAction.action2 = null;
            if (this.sel instanceof PanelWrapper) {
                CCFPanel cCFPanel = ((PanelWrapper)this.sel).panel;
                if (cCFPanel == null) return false;
                cCFAction.action1 = cCFPanel.getParentDevice();
                cCFAction.action2 = cCFPanel;
                return true;
            } else {
                if (this.sel == null) return false;
                cCFAction.p2 = ((JumpWrapper)this.sel).value;
            }
            return true;
        }
    }

    static class AliasChoice
    extends MemoryDialog {
        private CCFAction act;
        private JList combo;
        private Object sel;
        private JScrollPane scroll;

        AliasChoice(CCFAction cCFAction) {
            super("Choose Action Alias", Tonto.PREF_ALIAS_BOUNDS);
            this.act = cCFAction;
            Vector vector = new Vector();
            this.combo = new JList(new VectorListModel(vector));
            this.combo.setSelectionMode(0);
            this.combo.setVisibleRowCount(10);
            this.combo.setFont(Tonto.getPFont());
            this.combo.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        AliasChoice.this.enterOK();
                    }
                }
            });
            CCFHeader cCFHeader = Tonto.ccf().header().getHeader();
            this.addDeviceAliases(vector, cCFHeader.firstHome);
            this.addDeviceAliases(vector, cCFHeader.firstDevice);
            this.addDeviceAliases(vector, cCFHeader.firstMacro);
            Object object = Tonto.state().lastAlias;
            if (cCFAction.action1 != null || object == null) {
                switch (cCFAction.type) {
                    case 5: {
                        this.combo.setSelectedValue(new DeviceKey((CCFDevice)cCFAction.action1, cCFAction.p2), true);
                        break;
                    }
                    case 2: {
                        this.combo.setSelectedValue(cCFAction.action2, true);
                        break;
                    }
                    case 6: {
                        this.combo.setSelectedValue(cCFAction.action1, true);
                    }
                }
            } else {
                this.combo.setSelectedValue(object, true);
            }
            this.scroll = new JScrollPane(this.combo, 22, 31);
            this.setVisible();
            this.setContents(this.scroll);
        }

        private void setVisible() {
            int n = this.combo.getSelectedIndex();
            JViewport jViewport = this.scroll.getViewport();
            Rectangle rectangle = this.combo.getCellBounds(n, Math.min(n + 1, this.combo.getModel().getSize() - 1));
            if (rectangle != null) {
                jViewport.scrollRectToVisible(rectangle);
            }
        }

        @Override
        public Rectangle defaultSize() {
            return new Rectangle(0, 0, 400, 200);
        }

        @Override
        public void showHook(JDialog jDialog) {
            jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    AliasChoice.this.setVisible();
                }
            });
            super.showHook(jDialog);
        }

        private void addDeviceAliases(Vector vector, CCFDevice cCFDevice) {
            if (cCFDevice == null) {
                return;
            }
            vector.addElement(cCFDevice);
            CCFHardKey[] cCFHardKeyArray = cCFDevice.getHardKeys();
            for (int i = 0; i < cCFHardKeyArray.length; ++i) {
                vector.addElement(new DeviceKey(cCFDevice, i, cCFHardKeyArray[i].getName()));
            }
            CCFPanel[] cCFPanelArray = cCFDevice.getPanels();
            for (int i = 0; i < cCFPanelArray.length; ++i) {
                CCFButton[] cCFButtonArray = cCFPanelArray[i].getButtons();
                for (int j = 0; j < cCFButtonArray.length; ++j) {
                    vector.addElement(cCFButtonArray[j]);
                }
            }
            this.addDeviceAliases(vector, cCFDevice.next);
        }

        @Override
        public void doOK() {
            this.sel = this.combo.getSelectedValue();
            if (this.sel instanceof CCFButton) {
                CCFButton cCFButton = (CCFButton)this.sel;
                this.act.type = 2;
                this.act.action1 = cCFButton.getParentDevice();
                this.act.action2 = cCFButton;
            } else if (this.sel instanceof DeviceKey) {
                DeviceKey deviceKey = (DeviceKey)this.sel;
                this.act.type = 5;
                this.act.action1 = deviceKey.device;
                this.act.p2 = deviceKey.key;
            } else if (this.sel instanceof CCFDevice) {
                this.act.type = 6;
                this.act.action1 = (CCFDevice)this.sel;
            }
            Tonto.state().lastAlias = this.sel;
        }

        @Override
        public boolean invoke() {
            return super.invoke() && this.act.action1 != null;
        }

        public boolean invoke(CCFActionList cCFActionList) {
            return super.invoke() && this.act.action1 != null && !this.actionReferences(this.act, cCFActionList);
        }

        @Override
        public void doCancel() {
        }

        public Object getValue() {
            return this.sel;
        }

        private boolean actionReferences(CCFAction cCFAction, CCFActionList cCFActionList) {
            CCFActionList cCFActionList2 = null;
            switch (cCFAction.type) {
                case 2: {
                    cCFActionList2 = ((CCFButton)cCFAction.action2).actions;
                    break;
                }
                case 6: {
                    cCFActionList2 = ((CCFDevice)cCFAction.action1).action;
                    break;
                }
                case 5: {
                    cCFActionList2 = ((CCFDevice)cCFAction.action1).getHardKeys()[cCFAction.p2].getActionList();
                }
            }
            if (cCFActionList2 == cCFActionList) {
                Tonto.errorDialog("Alias denied. This would create\nan infinite recursive loop.");
                debug.log(0, "attempted recursive alias: (" + cCFAction + ") references (" + cCFActionList + ")");
                return true;
            }
            if (cCFActionList2 != null && cCFActionList2.action != null) {
                for (int i = 0; i < cCFActionList2.action.length; ++i) {
                    if (!this.actionReferences(cCFActionList2.action[i], cCFActionList)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class StringValueDialog
    extends OKCancelDialog {
        private JTextComponent text;
        private String value;

        StringValueDialog(String string, String string2, int n) {
            super(string);
            if (n > 0) {
                this.text = new JTextArea(7, n);
                this.text.setFont(new Font("Courier", 0, 10));
            } else {
                this.text = new JTextField(string2 != null ? string2.length() : 10);
                ((JTextField)this.text).addActionListener(this);
            }
            Tonto.setRCMenu(this.text);
            this.setValue(string2);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(5, 5));
            jPanel.add("West", new JLabel(string));
            if (n > 0) {
                jPanel.add("Center", new JScrollPane(this.text));
            } else {
                jPanel.add("Center", this.text);
            }
            jPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
            this.setContents(jPanel);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.text) {
                this.enterOK();
                return;
            }
            super.actionPerformed(actionEvent);
        }

        @Override
        public void doOK() {
            this.value = this.text.getText();
        }

        @Override
        public void doCancel() {
        }

        public void setValue(String string) {
            this.text.setText(string != null ? string.trim() : "");
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }

    class BeepValueDialog
    extends OKCancelDialog {
        private ActionBeep beep;
        private JSlider dur;
        private JSlider freq;
        private JSlider cycle;

        BeepValueDialog(ActionBeep actionBeep) {
            super("Beep");
            this.beep = actionBeep;
            this.dur = new JSlider(0, 2550, actionBeep.getDuration());
            this.freq = new JSlider(200, 10000, actionBeep.getFrequency());
            this.cycle = new JSlider(0, 99, actionBeep.getDutyCycle());
            this.dur.setPaintLabels(true);
            this.freq.setPaintLabels(true);
            this.cycle.setPaintLabels(true);
            MyLabel myLabel = new MyLabel("000");
            MyLabel myLabel2 = new MyLabel("00000");
            JLabel jLabel = new JLabel("ms");
            JLabel jLabel2 = new JLabel("Hz");
            this.dur.addChangeListener(myLabel);
            this.freq.addChangeListener(myLabel2);
            AAPanel aAPanel = new AAPanel();
            aAPanel.define('1', (Component)myLabel, "pad=5,5,3,3;fill=h");
            aAPanel.define('2', (Component)myLabel2, "pad=5,5,3,3;fill=h");
            aAPanel.define('3', (Component)jLabel, "pad=5,3,3,3;fill=h");
            aAPanel.define('4', (Component)jLabel2, "pad=5,3,3,3;fill=h");
            aAPanel.define('D', (Component)new JLabel("Duration", 4), "pad=5,5,3,3;fill=h");
            aAPanel.define('F', (Component)new JLabel("Frequency", 4), "pad=5,5,3,3;fill=h");
            aAPanel.define('C', (Component)new JLabel("Volume", 4), "pad=5,5,3,3;fill=h");
            aAPanel.define('d', (Component)this.dur, "pad=5,3,3,5;wx=1;fill=h");
            aAPanel.define('f', (Component)this.freq, "pad=5,3,3,5;wx=1;fill=h");
            aAPanel.define('c', (Component)this.cycle, "pad=5,3,3,5;wx=1;fill=h");
            aAPanel.setLayout(new String[]{" DD ddddd 11 33 ", " FF fffff 22 44 ", " CC ccccc       "});
            this.setContents(aAPanel);
            myLabel.setText(Integer.toString(this.dur.getValue()));
            myLabel2.setText(Integer.toString(this.freq.getValue()));
        }

        @Override
        public void doOK() {
        }

        @Override
        public void doCancel() {
        }

        public int getBeepValue() {
            return this.beep.createBeep(this.dur.getValue(), this.freq.getValue(), this.cycle.getValue());
        }
    }

    static class NameDialog
    extends OKCancelDialog
    implements ActionListener {
        private JTextComponent field;
        private String result = "";
        private JTabbedPane tabs;

        NameDialog() {
            this(true);
        }

        NameDialog(boolean bl) {
            super("Object Name", bl);
            AAPanel aAPanel = new AAPanel();
            this.field = !bl ? new JTextArea(2, 30) : new JTextField("");
            this.field.setFont(Tonto.getPFont());
            Tonto.setRCMenu(this.field);
            this.tabs = new JTabbedPane();
            Font font = Tonto.getPFont();
            for (int i = 0; i < 7; ++i) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new GridLayout(6, 6, 2, 2));
                for (int j = 0; j < 32; ++j) {
                    ActionButton actionButton = new ActionButton((char)(j + i * 32 + 32) + ""){

                        @Override
                        public void action() {
                            NameDialog.this.insert(this.getText());
                        }
                    };
                    actionButton.addActionListener(this);
                    actionButton.setFont(font);
                    actionButton.setForeground(Color.black);
                    jPanel.add(actionButton);
                }
                this.tabs.add("Set" + (i + 1), jPanel);
            }
            if (bl) {
                aAPanel.define('f', (Component)this.field, "pad=5,5,5,5;fill=b;wx=1");
            } else {
                aAPanel.define('f', (Component)new JScrollPane(this.field), "pad=5,5,5,5;fill=b;wx=1");
            }
            aAPanel.define('t', (Component)this.tabs, "pad=0,5,5,5;fill=b;wy=1");
            aAPanel.setLayout(new String[]{"f", "t"});
            this.setContents(aAPanel);
            Dimension dimension = this.getSize();
            this.setSize(dimension.width + 75, dimension.height);
        }

        public void insert(String string) {
            this.field.replaceSelection(string);
        }

        @Override
        public void doOK() {
            this.result = this.field.getText();
        }

        @Override
        public void doCancel() {
        }

        public String getText(String string) {
            return this.getText("Object Name", string, true);
        }

        public String getText(String string, boolean bl) {
            return this.getText("Object Name", string, bl);
        }

        public String getText(String string, String string2) {
            return this.getText(string, string2, true);
        }

        public String getText(String string, String string2, boolean bl) {
            bl = bl || Tonto.color() || Tonto.header().isNewMarantz();
            this.setTitle(string);
            this.result = string2 != null ? string2 : "";
            this.field.setText(this.result);
            this.field.setCaretPosition(this.result.length());
            for (int i = 3; i < 7; ++i) {
                this.tabs.setEnabledAt(i, bl);
            }
            this.show();
            return this.result;
        }

        @Override
        public void showHook(JDialog jDialog) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NameDialog.this.field.requestFocus();
                    NameDialog.this.field.setSelectionStart(0);
                    NameDialog.this.field.setSelectionEnd(NameDialog.this.result.length());
                }
            });
            jDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    NameDialog.this.field.requestFocus();
                    NameDialog.this.field.setSelectionStart(0);
                    NameDialog.this.field.setSelectionEnd(NameDialog.this.result.length());
                }

                @Override
                public void windowOpened(WindowEvent windowEvent) {
                    NameDialog.this.field.requestFocus();
                    NameDialog.this.field.setSelectionStart(0);
                    NameDialog.this.field.setSelectionEnd(NameDialog.this.result.length());
                }
            });
        }
    }

    class ButtonProps
    extends MemoryDialog {
        private boolean did;
        private ButtonBox box;
        private CCFButton button;
        private JTabbedPane tabs;
        private NameFontAttr name;
        private NameAttr idtag;
        private GeomPanel geom;
        private ActionPanel action;
        private IconButton IAUSIcon;
        private IconButton IASEIcon;
        private IconButton ACUSIcon;
        private IconButton ACSEIcon;
        private ColorChooser IAUSColor;
        private ColorChooser IASEColor;
        private ColorChooser ACUSColor;
        private ColorChooser ACSEColor;

        ButtonProps() {
            super("... Actions", Tonto.PREF_BUTTONPROP_BOUNDS);
            this.tabs = new JTabbedPane();
            this.name = new NameFontAttr();
            this.idtag = new NameAttr("ID Tag");
            this.geom = new GeomPanel();
            this.action = new ActionPanel();
            this.IAUSIcon = new MyIconButton(this, 100, 50);
            this.IASEIcon = new MyIconButton(this, 100, 50);
            this.ACUSIcon = new MyIconButton(this, 100, 50);
            this.ACSEIcon = new MyIconButton(this, 100, 50);
            this.IAUSColor = new ColorChooser();
            this.IASEColor = new ColorChooser();
            this.ACUSColor = new ColorChooser();
            this.ACSEColor = new ColorChooser();
            JTabbedPane jTabbedPane = new JTabbedPane(1);
            JPanel jPanel = new JPanel(new GridLayout(1, 2, 2, 2));
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 2, 2));
            jPanel2.add(this.getButton("Selected", this.IASEIcon, this.IASEColor));
            jPanel2.add(this.getButton("Unselected", this.IAUSIcon, this.IAUSColor));
            jPanel.add(this.getButton("Selected", this.ACSEIcon, this.ACSEColor));
            jPanel.add(this.getButton("Unselected", this.ACUSIcon, this.ACUSColor));
            jTabbedPane.add("Active", jPanel);
            jTabbedPane.add("Inactive", jPanel2);
            AAPanel aAPanel = new AAPanel();
            aAPanel.add((Component)this.name, "y=0;fill=b;wx=1;wy=0");
            aAPanel.add((Component)this.geom, "y=1;fill=b;wx=1;wy=0");
            aAPanel.add((Component)jTabbedPane, "y=2;fill=b;wx=1;wy=1");
            aAPanel.add((Component)this.idtag, "y=3;fill=b;wx=1;wy=0");
            this.tabs.addTab("Properties", aAPanel);
            this.tabs.addTab("Actions", this.action);
            this.tabs.setSelectedIndex(1);
            Tonto.bindAction(this.tabs, numkey[0], 8, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonProps.this.tabs.setSelectedIndex(0);
                }
            });
            Tonto.bindAction(this.tabs, numkey[1], 8, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ButtonProps.this.tabs.setSelectedIndex(1);
                }
            });
            this.setContents(this.tabs);
        }

        @Override
        public JComponent getButtons() {
            return UIUtils.getOtherOKCancel(new String[]{"Apply"}, this);
        }

        @Override
        public boolean handleCmd(String string) {
            if (string != null && string.equals("Apply")) {
                this.doOK();
                return false;
            }
            return false;
        }

        @Override
        public void doOK() {
            if (this.did) {
                Tonto.this.popDo();
            }
            int n = Tonto.this.startMultiDo();
            DoNodeUpdate doNodeUpdate = new DoNodeUpdate(this.button);
            try {
                this.button.setName(this.name.getName());
                this.button.setFont(this.name.getCCFFont());
                this.button.setIDTag(this.idtag.getName());
                this.button.setTextAlignment(this.name.getAlignment());
                this.button.setTextWrap(this.name.getWrap());
                this.button.actions = this.action.save();
                this.button.iconIU = this.IAUSIcon.getCCFIcon();
                this.button.iconIS = this.IASEIcon.getCCFIcon();
                this.button.iconAU = this.ACUSIcon.getCCFIcon();
                this.button.iconAS = this.ACSEIcon.getCCFIcon();
                this.button.colorIU = this.IAUSColor.getColors();
                this.button.colorIS = this.IASEColor.getColors();
                this.button.colorAU = this.ACUSColor.getColors();
                this.button.colorAS = this.ACSEColor.getColors();
                this.geom.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            doNodeUpdate.getNewState();
            Tonto.this.pushDo(doNodeUpdate);
            Tonto.this.endMultiDo(n);
            Tonto.this.objectStatus.setObject(this.box);
            this.did = true;
        }

        @Override
        public void doCancel() {
            if (this.did) {
                Tonto.this.popDo();
            }
        }

        private JComponent getButton(String string, IconButton iconButton, ColorChooser colorChooser) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(2, 2));
            jPanel.add("Center", iconButton);
            jPanel.add("South", colorChooser);
            return new LabelBox(string, jPanel);
        }

        public void updateButton(ButtonBox buttonBox, CCFButton cCFButton) {
            this.did = false;
            this.box = buttonBox;
            this.button = cCFButton;
            String string = cCFButton.getName();
            this.setTitle("Button " + (string != null ? "'" + string + "' " : "") + "Properties");
            this.action.update(cCFButton.actions);
            this.name.setName(cCFButton.getName());
            this.name.setCCFFont(cCFButton.getFont());
            this.name.setAlignment(cCFButton.getTextAlignment());
            this.name.setWrap(cCFButton.getTextWrap());
            this.idtag.setName(cCFButton.getIDTag());
            this.geom.setChild(buttonBox);
            this.IAUSIcon.initButton(cCFButton.iconIU);
            this.IASEIcon.initButton(cCFButton.iconIS);
            this.ACUSIcon.initButton(cCFButton.iconAU);
            this.ACSEIcon.initButton(cCFButton.iconAS);
            this.IAUSColor.setColors(cCFButton.colorIU);
            this.IASEColor.setColors(cCFButton.colorIS);
            this.ACUSColor.setColors(cCFButton.colorAU);
            this.ACSEColor.setColors(cCFButton.colorAS);
            this.IAUSColor.setWebSafe(prefShowWebSafe);
            this.IASEColor.setWebSafe(prefShowWebSafe);
            this.ACUSColor.setWebSafe(prefShowWebSafe);
            this.ACSEColor.setWebSafe(prefShowWebSafe);
            this.show();
        }
    }

    class FrameProps
    extends MemoryDialog {
        private boolean did;
        private FrameBox box;
        private CCFFrame frame;
        private GeomPanel geom;
        private NameFontAttr name;
        private IconButton icon;
        private ColorChooser color;

        FrameProps() {
            super("... Actions", Tonto.PREF_FRAMEPROP_BOUNDS);
            this.geom = new GeomPanel();
            this.name = new NameFontAttr();
            this.icon = new IconButton();
            this.color = new ColorChooser();
            JComponent jComponent = this.getButton("Icon and Color", this.icon, this.color);
            AAPanel aAPanel = new AAPanel();
            aAPanel.add((Component)this.name, "y=0;fill=b;wx=1");
            aAPanel.add((Component)this.geom, "y=1;fill=b;wx=1");
            aAPanel.add((Component)jComponent, "y=2;fill=b;wx=1;wy=1");
            this.setContents(aAPanel);
        }

        @Override
        public JComponent getButtons() {
            return UIUtils.getOtherOKCancel(new String[]{"Apply"}, this);
        }

        @Override
        public boolean handleCmd(String string) {
            if (string != null && string.equals("Apply")) {
                this.doOK();
                return false;
            }
            return false;
        }

        @Override
        public void doOK() {
            if (this.did) {
                Tonto.this.popDo();
            }
            int n = Tonto.this.startMultiDo();
            DoNodeUpdate doNodeUpdate = new DoNodeUpdate(this.frame);
            this.frame.name = this.name.getName();
            this.frame.icon = this.icon.getCCFIcon();
            this.frame.setFont(this.name.getCCFFont());
            this.frame.setForeground(this.color.getFG());
            this.frame.setBackground(this.color.getBG());
            this.frame.setTextAlignment(this.name.getAlignment());
            this.frame.setTextWrap(this.name.getWrap());
            this.geom.commit();
            doNodeUpdate.getNewState();
            Tonto.this.pushDo(doNodeUpdate);
            Tonto.this.endMultiDo(n);
            Tonto.this.objectStatus.setObject(this.box);
            this.did = true;
        }

        @Override
        public void doCancel() {
            if (this.did) {
                Tonto.this.popDo();
            }
        }

        private JComponent getButton(String string, IconButton iconButton, ColorChooser colorChooser) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(2, 2));
            jPanel.add("Center", iconButton);
            jPanel.add("South", colorChooser);
            return new LabelBox(string, jPanel);
        }

        public void updateFrame(FrameBox frameBox, CCFFrame cCFFrame) {
            this.did = false;
            this.box = frameBox;
            this.frame = cCFFrame;
            String string = cCFFrame.getName();
            this.setTitle("Frame " + (string != null ? "'" + string + "' " : "") + "Properties");
            this.name.setName(cCFFrame.getName());
            this.name.setCCFFont(cCFFrame.getFont());
            this.name.setAlignment(cCFFrame.getTextAlignment());
            this.name.setWrap(cCFFrame.getTextWrap());
            this.geom.setChild(frameBox);
            this.icon.initButton(cCFFrame.icon);
            this.color.setColors(cCFFrame.colors);
            this.color.setWebSafe(prefShowWebSafe);
            this.show();
        }
    }

    class PanelProps
    extends OKCancelDialog {
        private CCFPanel panel;
        private NameAttr name;
        private JCheckBox hidden;

        PanelProps() {
            super("... Actions");
            this.name = new NameAttr();
            this.hidden = new JCheckBox("Hidden");
            AAPanel aAPanel = new AAPanel();
            aAPanel.add((Component)this.hidden, "x=0;y=0;fill=b;wx=1");
            Util.setLabelBorder("Flags", aAPanel);
            AAPanel aAPanel2 = new AAPanel();
            aAPanel2.add((Component)this.name, "x=0;y=0;fill=b;wx=1");
            aAPanel2.add((Component)aAPanel, "x=0;y=1;fill=b;wx=1");
            aAPanel2.add((Component)new JPanel(), "x=0;y=2;fill=b;wx=1;wy=1");
            this.setContents(aAPanel2);
        }

        @Override
        public void doOK() {
            this.panel.setName(this.name.getName());
            this.panel.setHidden(this.hidden.isSelected());
            Tonto.this.refreshPanel(this.panel);
            ((CCFTreePanel)Tonto.this.getTreeWrapper(this.panel)).getParent().refresh();
            Tonto.this.setCCFChanged();
            Tonto.this.updateTreeSelection();
        }

        @Override
        public void doCancel() {
        }

        public void updatePanel(CCFPanel cCFPanel) {
            this.panel = cCFPanel;
            this.setTitle(cCFPanel.getName() + " Properties");
            this.name.setName(cCFPanel.getName());
            this.hidden.setSelected(cCFPanel.isHidden());
            this.show();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            return new Dimension(Math.max(dimension.width, 200), Math.max(dimension.height, 125));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(Math.max(dimension.width, 200), Math.max(dimension.height, 125));
        }
    }

    class DeviceProps
    extends MemoryDialog {
        private CCFDevice dev;
        private JTabbedPane tabs;
        private NameAttr name;
        private JComboBox extender;
        private AAPanel flags;
        private ActionPanel action;
        private JCB dev_ro;
        private JCB dev_sp;
        private JCB dev_tm;
        private JCB dev_tg;
        private JCB dev_np;
        private JPanel icons;
        private IconButton selIcon;
        private IconButton unsIcon;
        private Hashtable panels;
        private int state;

        DeviceProps() {
            super("... Actions", Tonto.PREF_DEVICEPROP_BOUNDS);
            this.tabs = new JTabbedPane();
            this.name = new NameAttr();
            this.extender = new JComboBox();
            this.flags = new AAPanel();
            this.action = new ActionPanel();
            this.dev_ro = new JCB("Read Only", 1);
            this.dev_sp = new JCB("Separator", 32);
            this.dev_tm = new JCB("Template", 64);
            this.dev_tg = new JCB("Timer Group", 2);
            this.dev_np = new JCB("Needs Programming", 16);
            this.icons = new JPanel();
            this.selIcon = new IconButton();
            this.unsIcon = new IconButton();
            this.panels = new Hashtable();
            this.state = 0;
            this.flags.add((Component)this.dev_ro, "x=0;y=0;fill=b;wx=1");
            this.flags.add((Component)this.dev_tm, "x=0;y=1;fill=b;wx=1");
            this.flags.add((Component)this.dev_np, "x=0;y=2;fill=b;wx=1");
            this.flags.add((Component)this.dev_tg, "x=0;y=3;fill=b;wx=1");
            this.flags.add((Component)this.dev_sp, "x=0;y=4;fill=b;wx=1");
            Util.setLabelBorder("Flags", this.flags);
            this.extender.addItem("IR - No Extender");
            this.extender.addItem("RF - Extender 0");
            this.extender.addItem("RF - Extender 1");
            this.extender.addItem("RF - Extender 2");
            this.extender.addItem("RF - Extender 3");
            this.extender.addItem("RF - Extender 4");
            this.extender.addItem("RF - Extender 5");
            this.extender.addItem("RF - Extender 6");
            this.extender.addItem("RF - Extender 7");
            this.extender.addItem("RF - Extender 8");
            this.extender.addItem("RF - Extender 9");
            this.extender.addItem("RF - Extender A");
            this.extender.addItem("RF - Extender B");
            this.extender.addItem("RF - Extender C");
            this.extender.addItem("RF - Extender D");
            this.extender.addItem("RF - Extender E");
            this.extender.addItem("RF - Extender F");
            Util.setLabelBorder("RF Extender", this.extender);
            this.icons.setLayout(new GridLayout(2, 1, 2, 2));
            this.icons.add(new LabelBox("Selected Icon", this.selIcon));
            this.icons.add(new LabelBox("Unselected Icon", this.unsIcon));
            this.tabs.setTabPlacement(4);
            this.setContents(this.tabs);
            Tonto.bindAction(this.tabs, 33, 0, new TabPager(this.tabs, -1));
            Tonto.bindAction(this.tabs, 34, 0, new TabPager(this.tabs, 1));
        }

        private void checkTabs() {
            CCFHeader cCFHeader = Tonto.this.ccf.header();
            int n = cCFHeader.isMarantz() ? 3 : (cCFHeader.hasColor() ? 2 : 1);
            if (n != this.state) {
                this.state = n;
                this.panels.clear();
                AAPanel aAPanel = new AAPanel();
                aAPanel.add((Component)this.name, "x=0;y=0;fill=b;wx=1");
                aAPanel.add((Component)this.flags, "x=0;y=1;fill=b;wx=1");
                aAPanel.add((Component)this.extender, "x=0;y=2;fill=b;wx=1");
                aAPanel.add((Component)this.icons, "x=0;y=3;fill=b;wx=1");
                aAPanel.add((Component)new JPanel(), "x=0;y=4;fill=b;wx=1;wy=1");
                this.tabs.removeAll();
                this.tabs.addTab("Properties", aAPanel);
                this.tabs.addTab("On Select", this.action);
                Tonto.bindAction(this.tabs, numkey[0], 8, new TabSelect(this.tabs, 0));
                Tonto.bindAction(this.tabs, numkey[1], 8, new TabSelect(this.tabs, 1));
                CCFHardKey[] cCFHardKeyArray = this.dev.getHardKeys();
                for (int i = 0; i < cCFHardKeyArray.length; ++i) {
                    ActionPanel actionPanel = new ActionPanel(cCFHardKeyArray[i].isNamable());
                    this.panels.put(cCFHardKeyArray[i].getLabel(), actionPanel);
                    this.tabs.addTab(cCFHardKeyArray[i].getLabel(), actionPanel);
                    if (i + 2 < numkey.length) {
                        Tonto.bindAction(this.tabs, numkey[i + 2], 8, new TabSelect(this.tabs, i + 2));
                        continue;
                    }
                    Tonto.bindAction(this.tabs, numkey[i + 2 - numkey.length], 9, new TabSelect(this.tabs, i + 2));
                }
                Tonto.bindAction(this.tabs, 36, 0, new TabSelect(this.tabs, 0));
                Tonto.bindAction(this.tabs, 35, 0, new TabSelect(this.tabs, this.tabs.getTabCount() - 1));
                this.tabs.setSelectedIndex(0);
            }
        }

        @Override
        public void doOK() {
            this.dev.name = this.name.getName();
            this.dev.action = this.action.save();
            this.dev.rfExtender = this.extender.getSelectedIndex();
            CCFHardKey[] cCFHardKeyArray = this.dev.getHardKeys();
            for (int i = 0; i < cCFHardKeyArray.length; ++i) {
                ActionPanel actionPanel = (ActionPanel)this.panels.get(cCFHardKeyArray[i].getLabel());
                if (actionPanel == null) continue;
                cCFHardKeyArray[i].setActionList(actionPanel.save());
                if (!cCFHardKeyArray[i].isNamable()) continue;
                cCFHardKeyArray[i].setName(actionPanel.getName());
            }
            this.dev.iconSelected = this.selIcon.getCCFIcon();
            this.dev.iconUnselected = this.unsIcon.getCCFIcon();
            this.dev_ro.ok();
            this.dev_sp.ok();
            this.dev_tm.ok();
            this.dev_tg.ok();
            this.dev_np.ok();
            Tonto.this.setCCFChanged();
            Tonto.this.updateTreeSelection();
        }

        @Override
        public void doCancel() {
        }

        public void updateDevice(CCFDevice cCFDevice) {
            this.dev = cCFDevice;
            this.checkTabs();
            this.setTitle(cCFDevice.getName() + " Properties");
            this.name.setName(cCFDevice.getName());
            this.action.update(cCFDevice.action);
            this.extender.setEnabled(Tonto.color() || Tonto.header().isNewMarantz());
            this.extender.setSelectedIndex(cCFDevice.rfExtender);
            CCFHardKey[] cCFHardKeyArray = cCFDevice.getHardKeys();
            for (int i = 0; i < cCFHardKeyArray.length; ++i) {
                ActionPanel actionPanel = (ActionPanel)this.panels.get(cCFHardKeyArray[i].getLabel());
                if (actionPanel == null) continue;
                if (cCFHardKeyArray[i].isNamable()) {
                    actionPanel.update(cCFHardKeyArray[i].getActionList(), cCFHardKeyArray[i].getName());
                    continue;
                }
                actionPanel.update(cCFHardKeyArray[i].getActionList());
            }
            this.selIcon.initButton(cCFDevice.iconSelected);
            this.unsIcon.initButton(cCFDevice.iconUnselected);
            this.tabs.setSelectedIndex(0);
            this.dev_ro.setEnabled(cCFDevice.isNormalDevice());
            this.dev_ro.update();
            this.dev_tm.setEnabled(cCFDevice.isNormalDevice());
            this.dev_tm.update();
            this.dev_np.setEnabled(cCFDevice.isNormalDevice());
            this.dev_np.update();
            this.dev_sp.setEnabled(!cCFDevice.isHomeDevice());
            this.dev_sp.update();
            this.dev_tg.setEnabled(cCFDevice.isMacroDevice());
            this.dev_tg.update();
            this.show();
        }

        class JCB
        extends JCheckBox {
            private int prop;

            JCB(String string, int n) {
                super(string);
                this.prop = n;
            }

            public void update() {
                this.setSelected(DeviceProps.this.dev.getFlag(this.prop));
            }

            public void ok() {
                DeviceProps.this.dev.setFlag(this.prop, this.isSelected());
            }
        }
    }

    class SystemProps
    extends OKCancelDialog
    implements ActionListener {
        private JCheckBox factory;
        private JCheckBox config;
        private JCheckBox home;
        private JTextField version;
        private IconButton icon;
        private JComboBox channel;
        private JTextField width;
        private JTextField height;
        private ColorPicker tcolor;

        SystemProps(boolean bl) {
            super("System Properties");
            this.factory = new JCheckBox("Default Configuration (restored after crash)");
            this.config = new JCheckBox("Configuration is write protected");
            this.home = new JCheckBox("Home panels are write protected");
            this.version = new JTextField(12);
            this.icon = new IconButton();
            this.channel = new JComboBox();
            this.width = new JTextField(3);
            this.height = new JTextField(3);
            this.tcolor = new ColorPicker(CCFColor.getNamedColor(0, true));
            this.channel.addItem("IR");
            this.channel.addItem("RF Channel 0");
            this.channel.addItem("RF Channel 1");
            this.channel.addItem("RF Channel 2");
            this.channel.addItem("RF Channel 3");
            JLabel jLabel = new JLabel("Version");
            JLabel jLabel2 = new JLabel("Remote");
            JLabel jLabel3 = new JLabel("Width");
            JLabel jLabel4 = new JLabel("Height");
            AAPanel aAPanel = new AAPanel();
            aAPanel.define('f', (Component)this.factory, "fill=b;pad=3,3,3,3");
            aAPanel.define('c', (Component)this.config, "fill=b;pad=3,3,3,3");
            aAPanel.define('m', (Component)this.home, "fill=b;pad=3,3,3,3");
            aAPanel.define('V', (Component)jLabel, "fill=b;pad=3,3,3,3");
            aAPanel.define('v', (Component)this.version, "fill=b;pad=3,3,3,3");
            aAPanel.setLayout(new String[]{"ffffffff", "cccccccc", "mmmmmmmm", "VV vvvvv"});
            AAPanel aAPanel2 = new AAPanel();
            aAPanel2.define('W', (Component)jLabel3, "fill=b;pad=3,3,3,3");
            aAPanel2.define('H', (Component)jLabel4, "fill=b;pad=3,3,3,3");
            aAPanel2.define('w', (Component)this.width, "fill=b;pad=3,3,3,3");
            aAPanel2.define('h', (Component)this.height, "fill=b;pad=3,3,3,3");
            aAPanel2.setLayout(new String[]{"WW w HH h"});
            AAPanel aAPanel3 = new AAPanel();
            aAPanel3.define('T', (Component)this.tcolor, "fill=b;pad=3,3,3,3");
            aAPanel3.setLayout(new String[]{"T"});
            AAPanel aAPanel4 = new AAPanel();
            aAPanel4.add((Component)new LabelBox("Channel ID", this.channel), "x=0;y=1;pad=3,3,0,3;fill=b;wx=1;wy=1");
            aAPanel4.add((Component)new LabelBox("Settings", aAPanel), "x=0;y=2;pad=3,3,0,3;fill=b;wx=1");
            if (bl) {
                aAPanel4.add((Component)new LabelBox("Panel Size", aAPanel2), "x=0;y=3;pad=3,3,0,3;fill=b;wx=1");
                aAPanel4.add((Component)new LabelBox("Transparent Color", aAPanel3), "x=0;y=4;pad=3,3,0,3;fill=b;wx=1");
            }
            aAPanel4.add((Component)new LabelBox("Home Icon", this.icon), "x=0;y=5;pad=3,3,0,3;fill=b;wx=1;wy=1");
            this.setContents(aAPanel4);
        }

        @Override
        public void doOK() {
            Tonto.this.ccf.setFactoryCCF(this.factory.isSelected());
            Tonto.this.ccf.setConfigReadOnly(this.config.isSelected());
            Tonto.this.ccf.setHomeReadOnly(this.home.isSelected());
            Tonto.this.ccf.setVersionString(this.version.getText());
            ((Tonto)Tonto.this).ccf.getFirstHomeDevice().iconUnselected = this.icon.getCCFIcon();
            ((Tonto)Tonto.this).ccf.header().channelID = this.channel.getSelectedIndex();
            Tonto.this.setCCFChanged();
            Tonto.this.updateTreeSelection();
            if (Tonto.this.ccf.getConformsTo(prefDefaultModel).isCustom()) {
                Tonto.this.panelSize = new Dimension(Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText()));
                if (!Tonto.this.panelSize.equals(Tonto.this.ccf.getScreenSize(prefDefaultModel))) {
                    Tonto.this.ccf.setScreenSize(((Tonto)Tonto.this).panelSize.width, ((Tonto)Tonto.this).panelSize.height);
                    Tonto.this.refreshAllPanels();
                }
            }
            Tonto.this.ccf.setTransparentColor(this.tcolor.getColor());
        }

        @Override
        public void doCancel() {
            this.icon.revert();
        }

        public Object getValue() {
            return null;
        }

        public void updateSystem() {
            if (Tonto.this.ccf == null) {
                return;
            }
            this.factory.setSelected(Tonto.this.ccf.isFactoryCCF());
            this.config.setSelected(Tonto.this.ccf.isConfigReadOnly());
            this.home.setSelected(Tonto.this.ccf.isHomeReadOnly());
            this.version.setText(Tonto.this.ccf.getVersionString());
            this.channel.setEnabled(Tonto.color() || Tonto.header().isNewMarantz());
            this.channel.setSelectedIndex(Math.min(((Tonto)Tonto.this).ccf.header().channelID, 3));
            if (Tonto.this.ccf.getFirstHomeDevice() != null) {
                this.icon.initButton(((Tonto)Tonto.this).ccf.getFirstHomeDevice().iconUnselected);
            }
            ProntoModel prontoModel = Tonto.this.ccf.getConformsTo(prefDefaultModel);
            this.width.setEditable(prontoModel.isCustom());
            this.height.setEditable(prontoModel.isCustom());
            this.tcolor.setEditable(prontoModel.isCustom());
            Dimension dimension = Tonto.this.ccf.getScreenSize(prefDefaultModel);
            this.width.setText(Integer.toString(dimension.width));
            this.height.setText(Integer.toString(dimension.height));
            this.tcolor.setColor(Tonto.this.ccf.getTransparentColor(), Tonto.color());
            this.show();
        }
    }

    static class TransferDialog
    extends StackedDialog
    implements ITaskStatus {
        private JProgressBar bar = new JProgressBar(0, 100);
        private JTextField text;
        private Runnable run;
        private Thread thread;

        TransferDialog(String string) {
            this(string, true);
        }

        TransferDialog(String string, boolean bl) {
            super(string, bl);
            this.bar.setBorder(new EtchedBorder(1));
            this.bar.setStringPainted(true);
            this.text = new JTextField(20);
            this.text.setEditable(false);
            this.text.setText(string);
            ActionButton actionButton = new ActionButton("Cancel"){

                @Override
                public void action() {
                    if (TransferDialog.this.thread != null) {
                        TransferDialog.this.thread.interrupt();
                    }
                    TransferDialog.this.dispose();
                    Tonto.closeComm();
                }
            };
            this.add((Component)this.bar, "x=0;y=0;wx=1;wy=1;fill=b;pad=5,5,5,5");
            this.add((Component)this.text, "x=0;y=1;wx=1;wy=1;fill=b;pad=5,5,5,5");
            this.add((Component)actionButton, "x=0;y=2;wx=1;wy=0;fill=b;pad=5,5,5,5");
        }

        @Override
        public void taskStatus(int n, String string) {
            int n2 = n;
            int n3 = this.bar.getValue();
            if (n2 - n3 > 10) {
                for (int i = n3; i <= n2; i += 10) {
                    this.progress(i);
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.progress(n2);
            if (string != null) {
                this.text.setText(string);
            }
        }

        @Override
        public void taskError(Throwable throwable) {
            debug.log(1, "task err: " + throwable);
        }

        @Override
        public void taskNotify(Object object) {
            if (object instanceof Integer) {
                this.progress((Integer)object);
            }
        }

        public void progress(int n) {
            n = Math.min(n, 100);
            this.bar.setValue(n);
            this.bar.setString(n + "%");
        }

        @Override
        public void showHook(JDialog jDialog) {
            if (this.thread != null) {
                final Thread thread = this.thread;
                jDialog.addWindowListener(new WindowAdapter(){
                    private int i = 0;

                    @Override
                    public void windowActivated(WindowEvent windowEvent) {
                        if (this.i++ == 0) {
                            thread.start();
                        }
                    }
                });
            }
        }

        public void show(Thread thread) {
            this.thread = thread;
            this.show();
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    static class IRCapture
    extends OKCancelDialog
    implements Runnable {
        private Pronto learned;
        private JButton start = new JButton("Start");
        private JButton cancel = new JButton("Cancel");
        private JTextArea work = new JTextArea(8, 40);
        private JComboBox num = new JComboBox();
        private JPanel sign = new JPanel();
        private Thread thread;

        IRCapture() {
            super("Capture IR");
            AAPanel aAPanel = new AAPanel(true);
            JTextArea jTextArea = new JTextArea();
            jTextArea.setBorder(new BevelBorder(1));
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setText("We will sample the key at least two times to insure the signal is clean. If the signals do not match, you may be asked to press it a couple more times until it does. The best signal will be chosen in the case of no matches.");
            this.work.setBorder(new BevelBorder(1));
            this.work.setEditable(false);
            this.start.setEnabled(true);
            this.cancel.setEnabled(true);
            this.start.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IRCapture.this.start();
                }
            });
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IRCapture.this.stop();
                }
            });
            JScrollPane jScrollPane = new JScrollPane(this.work);
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            JLabel jLabel = new JLabel("Max Retries", 4);
            for (int i = 1; i < 8; ++i) {
                this.num.addItem(new Integer(i));
            }
            this.num.setSelectedItem(new Integer(4));
            aAPanel.define('0', (Component)this.start, "pad=5,5,0,0;fill=b;wx=1");
            aAPanel.define('1', (Component)this.cancel, "pad=5,5,0,5;fill=b;wx=1");
            aAPanel.define('a', (Component)jLabel, "pad=5,5,0,5;fill=b");
            aAPanel.define('b', (Component)this.num, "pad=5,5,0,5;fill=b");
            aAPanel.define('2', (Component)jTextArea, "pad=5,5,0,5;fill=b");
            aAPanel.define('3', (Component)jScrollPane, "pad=5,5,0,5;fill=b;wx=1;wy=1");
            aAPanel.define('4', (Component)this.sign, "pad=5,5,5,5;fill=b");
            aAPanel.setLayout(new String[]{" 0 1 a b ", " 2222222 ", " 3333333 ", " 4444444 "});
            this.setContents(aAPanel);
        }

        private void start() {
            this.work.setText("");
            this.start.setEnabled(false);
            this.cancel.setEnabled(true);
            this.thread = new Thread(this);
            this.thread.start();
        }

        private void stop() {
            this.start.setEnabled(true);
            this.cancel.setEnabled(false);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        @Override
        public void doOK() {
        }

        @Override
        public void doCancel() {
            Tonto.closeComm();
        }

        private int len(Pronto pronto) {
            if (pronto.isRawSignal()) {
                return pronto.getRawSignal().length;
            }
            return pronto.getIntro().length() + pronto.getRepeat().length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Pronto pronto = null;
            Vector<Pronto> vector = new Vector<Pronto>();
            try {
                int n = (Integer)this.num.getSelectedItem();
                for (int i = 0; i < n; ++i) {
                    new RunInThread(){

                        @Override
                        public void runIn() throws Exception {
                            comm.waitLearning();
                            IRCapture.this.work.append("Press Remote Key... ");
                        }
                    }.start();
                    Pronto pronto2 = null;
                    try {
                        pronto2 = new Pronto(comm.learnIR(Tonto.state()));
                    }
                    catch (Exception exception) {
                        Tonto.debug(exception);
                    }
                    debug.log(2, "sig = " + pronto2);
                    if (pronto2 == null || pronto2.getPulseIndex().getIndexValues().length == 0) {
                        this.work.append("Invalid IR Signal\n");
                    } else {
                        if (pronto2.isRawSignal()) {
                            this.work.append("Captured IR Signal (" + pronto2.getRawSignal().length + ")\n");
                        } else {
                            this.work.append("Captured IR Signal (" + pronto2.getIntro().length() + "," + pronto2.getRepeat().length() + ")\n");
                        }
                        for (int j = 0; j < vector.size(); ++j) {
                            if (!vector.get(j).equals(pronto2)) continue;
                            this.work.append("Signal Match!\n");
                            this.learned = pronto2;
                            return;
                        }
                        vector.add(pronto2);
                        if (pronto == null || this.len(pronto2) < this.len(pronto)) {
                            pronto = pronto2;
                        }
                    }
                    this.work.setCaretPosition(this.work.getText().length());
                }
                this.learned = pronto;
                if (pronto == null) {
                    this.work.append("No good signals were captured. Try again.");
                } else {
                    this.work.append("You may want to try this again until you get a clean signal match.\n");
                }
            }
            catch (Throwable throwable) {
                Tonto.debug(throwable);
            }
            finally {
                this.stop();
                this.work.setCaretPosition(this.work.getText().length());
            }
        }

        public Pronto getIRCode() {
            return this.learned;
        }
    }

    class IRSignalDialog
    extends OKCancelDialog {
        private IRSignalPanel sp;

        IRSignalDialog(IRSignal iRSignal) {
            super("IR Signal");
            this.sp = new IRSignalPanel();
            this.sp.setSignal(iRSignal);
            this.setContents(this.sp);
        }

        @Override
        public JComponent getButtons() {
            return UIUtils.getOtherOKCancel(new String[]{"Cleanup"}, this);
        }

        @Override
        public boolean handleCmd(String string) {
            if (string != null && string.equals("Cleanup")) {
                this.sp.cleanup();
                return false;
            }
            return false;
        }

        @Override
        public void doOK() {
        }

        @Override
        public void doCancel() {
        }

        @Override
        public void bindOK() {
        }

        public IRSignal getValue() {
            if (this.invoke()) {
                return this.sp.getSignal();
            }
            return null;
        }
    }

    class DragBorder
    implements Border {
        DragBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.black);
            if (Tonto.this.treeBefore) {
                graphics.drawLine(n, n2, n + n3, n2);
            } else {
                graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
        }
    }

    static class PrefsDialog
    extends MemoryDialog {
        private ProntoModel[] models = ProntoModel.getModels();
        private JTextField[] emulators = new JTextField[this.models.length];
        private Hashtable dval = new Hashtable();
        private JTextField[] gval = new JTextField[5];
        private ColorPicker[] cmap = new ColorPicker[4];
        private ColorPicker gridMa = new ColorPicker(new CCFColor(0), true, true);
        private ColorPicker gridMi = new ColorPicker(new CCFColor(0), true, true);
        private JSlider grayTint = this.getSlider("Gray Tint", 0, 100, 0, 50, 10, false);
        private JSlider[] vdebug = new JSlider[Debug.getActiveLoggers()];
        private JSlider commLOD = this.getSlider("Load Delay", 0, 1000, 250, 250, 50);
        private JSlider commCMD = this.getSlider("Command Delay", 0, 500, 0, 100, 25);
        private JSlider commATN = this.getSlider("Attention Delay", 0, 500, 25, 100, 25);
        private JComboBox coDefaultModel = new JComboBox();
        private JComboBox coFontSize = new JComboBox();
        private JCheckBox ckFontUsage = new JCheckBox("Use Pronto font in tree view");
        private JCheckBox ckTermLogging = new JCheckBox("Log to Console");
        private JCheckBox ckOldDialogs = new JCheckBox("Use Old-style File Dialogs");
        private JCheckBox ckObeyRemote = new JCheckBox("Use remote reported capability");
        private JCheckBox ckTestEmitIR = new JCheckBox("Emit IR during button test");
        private JCheckBox ckShowDevProp = new JCheckBox("Show Device Properties in Tree");
        private JCheckBox ckNetUpdate = new JCheckBox("Enable network updates");
        private JCheckBox ckScanOtherPorts = new JCheckBox("Scan other ports");
        private JCheckBox ckScanThreaded = new JCheckBox("Scan ports in parallel");
        private JCheckBox ckScanModems = new JCheckBox("Scan modem ports (dangerous)");
        private JCheckBox ckCenterDialog = new JCheckBox("Center Dialogs on parent");
        private JCheckBox ckGridSnap = new JCheckBox("Default snap to grid");
        private JCheckBox ckGridShow = new JCheckBox("Default show grid");
        private JCheckBox ckWebSafe = new JCheckBox("Show extended colors");
        private JCheckBox ckSelectLast = new JCheckBox("Paint selection on top");
        private JTextField defaultPort = new JTextField(20);
        private JTextField ceditor = new JTextField(20);
        private JTextField ieditor = new JTextField(20);
        private FileBrowse fbCCF = new FileBrowse("CCF Editor", this.ceditor);
        private FileBrowse fbIMG = new FileBrowse("Image Editor", this.ieditor);
        private boolean warnFontUse = false;
        private boolean warnFontSize = false;
        private int oldTint;

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.ckFontUsage && !this.warnFontUse) {
                Tonto.infoDialog("This change will take effect after Tonto restarts");
                this.warnFontUse = true;
            } else if (actionEvent.getSource() == this.coFontSize && !this.warnFontSize) {
                if ((Integer)this.coFontSize.getSelectedItem() != prefTreeFontSize) {
                    Tonto.infoDialog("This change will take effect after Tonto restarts");
                    this.warnFontSize = true;
                }
            } else {
                super.actionPerformed(actionEvent);
            }
        }

        PrefsDialog() {
            super("Preferences", Tonto.PREF_PREF_BOUNDS);
            Object object;
            Object object2;
            int n;
            JTabbedPane jTabbedPane = new JTabbedPane();
            ProntoModel[] prontoModelArray = ProntoModel.getModels();
            for (n = 0; n < prontoModelArray.length; ++n) {
                this.coDefaultModel.addItem(prontoModelArray[n].getName());
            }
            for (n = 8; n <= 18; n += 2) {
                this.coFontSize.addItem(new Integer(n));
            }
            for (n = 0; n < this.gval.length; ++n) {
                this.gval[n] = new JTextField(3);
            }
            AAPanel aAPanel = new AAPanel();
            AAPanel aAPanel2 = new AAPanel(true);
            AAPanel aAPanel3 = new AAPanel(true);
            AAPanel aAPanel4 = new AAPanel(true);
            AAPanel aAPanel5 = new AAPanel(true);
            AAPanel aAPanel6 = new AAPanel(true);
            JLabel jLabel = new JLabel("Image Editor");
            JLabel jLabel2 = new JLabel("CCF Editor");
            JLabel jLabel3 = new JLabel("Tick Colors");
            JLabel jLabel4 = new JLabel("moved to the Helper tabs", 2);
            aAPanel.define('$', "wx=1;fill=b");
            aAPanel.define('=', "wx=1;fill=b");
            aAPanel.define(',', (Component)aAPanel6, "wx=1;fill=b");
            aAPanel.define('+', (Component)aAPanel4, "wx=1;fill=b");
            aAPanel.define('.', (Component)aAPanel2, "wx=1;fill=b");
            aAPanel.define(':', (Component)aAPanel3, "wx=1;fill=b");
            aAPanel.define('-', (Component)aAPanel5, "wx=1;fill=b");
            aAPanel.define('p', (Component)this.coDefaultModel, "pad=3,3,3,3");
            aAPanel.define('t', (Component)this.coFontSize, "pad=3,3,3,3");
            aAPanel.define('X', (Component)this.label("X Offset"), "pad=3,3,3,3");
            aAPanel.define('Y', (Component)this.label("Y Offset"), "pad=3,3,3,3");
            aAPanel.define('W', (Component)this.label("Width"), "pad=3,3,3,3");
            aAPanel.define('H', (Component)this.label("Height"), "pad=3,3,3,3");
            aAPanel.define('R', (Component)this.label("Minor Ticks"), "pad=3,3,3,3");
            aAPanel.define('x', (Component)this.gval[0], "pad=3,3,3,3;fill=h");
            aAPanel.define('y', (Component)this.gval[1], "pad=3,3,3,3;fill=h");
            aAPanel.define('w', (Component)this.gval[2], "pad=3,3,3,3;fill=h");
            aAPanel.define('h', (Component)this.gval[3], "pad=3,3,3,3;fill=h");
            aAPanel.define('r', (Component)this.gval[4], "pad=3,3,3,3;fill=h");
            aAPanel.define('l', (Component)this.ckTermLogging, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('d', (Component)this.ckOldDialogs, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('f', (Component)this.ckFontUsage, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('o', (Component)this.ckObeyRemote, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('i', (Component)this.ckTestEmitIR, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('s', (Component)this.ckShowDevProp, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('n', (Component)this.ckNetUpdate, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('e', (Component)this.ckCenterDialog, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('k', (Component)this.ckGridSnap, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('g', (Component)this.ckGridShow, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('b', (Component)this.ckWebSafe, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('S', (Component)this.ckSelectLast, "pad=0,3,3,3;fill=h;wx=1");
            aAPanel.define('1', (Component)this.gridMa, "pad=3,3,3,3;fill=h");
            aAPanel.define('2', (Component)this.gridMi, "pad=3,3,3,3;fill=h");
            aAPanel.define('3', (Component)jLabel3, "pad=3,3,3,3;fill=h");
            aAPanel.define('N', (Component)jLabel4, "pad=3,3,3,3;fill=h");
            aAPanel.setLayout(new String[]{"....... :::::::::::", ". ppp . : ttt     :", "....... :::::::::::", "+++++++++++++++++++", "+ X x Y y = kkkkk +", "+ W w H h = ggggg +", "+ R r     = 1 2 3 +", "+++++++++++++++++++", "-------------------", "- ddddd ooooo     -", "- fffff iiiii     -", "- sssss nnnnn     -", "- eeeee lllll     -", "- bbbbb SSSSS     -", "-------------------", ",,,,,,,,,,,,,,,,,,,", ", NNNNNNNNNNNNNNN ,", ",,,,,,,,,,,,,,,,,,,"});
            Util.setLabelBorder("Default Model", aAPanel2);
            Util.setLabelBorder("Tree Font Size", aAPanel3);
            Util.setLabelBorder("Panel Grid", aAPanel4);
            Util.setLabelBorder("Options", aAPanel5);
            Util.setLabelBorder("Emulators/Editors", aAPanel6);
            AAPanel aAPanel7 = new AAPanel();
            aAPanel7.add((Component)new JLabel("0=off   1=light   2=verbose   3=all", 0), "fill=b;pad=3,3,6,3;wx=1;x=0;y=0");
            Enumeration enumeration = Debug.getLoggerNames();
            for (int i = 0; i < this.vdebug.length; ++i) {
                object2 = (String)enumeration.nextElement();
                object = Debug.getInstance((String)object2);
                this.vdebug[i] = this.getSlider((String)object2, 0, 3, ((Debug)object).getLevel(), 1, 1);
                this.dval.put(object2, this.vdebug[i]);
                aAPanel7.add((Component)this.vdebug[i], "fill=b;pad=3,3,3,3;wx=1;x=0;y=" + (i + 1));
            }
            AAPanel aAPanel8 = new AAPanel();
            object2 = new JLabel("All times in milliseconds", 0);
            object = new AAPanel(true);
            aAPanel8.define('.', "fill=b;wx=1");
            aAPanel8.define(',', (Component)object, "fill=b;pad=3,3,3,3");
            aAPanel8.define(':', "fill=b");
            aAPanel8.define('D', (Component)new JLabel("Port"), "fill=b;pad=3,3,3,3");
            aAPanel8.define('d', (Component)this.defaultPort, "fill=b;pad=3,3,3,3;wx=1");
            aAPanel8.define('x', (Component)this.ckScanOtherPorts, "fill=b;pad=3,3,3,3;wx=1");
            aAPanel8.define('T', (Component)this.ckScanThreaded, "fill=b;pad=3,3,3,3;wx=1");
            if (Util.onMacintosh()) {
                aAPanel8.define('m', (Component)this.ckScanModems, "fill=b;pad=3,3,3,3;wx=1");
            }
            aAPanel8.define('t', (Component)object2, "fill=b;pad=3,3,3,3;wx=1");
            aAPanel8.define('c', (Component)this.commCMD, "fill=b;pad=3,3,3,3;wx=1");
            aAPanel8.define('a', (Component)this.commATN, "fill=b;pad=3,3,3,3;wx=1");
            aAPanel8.define('l', (Component)this.commLOD, "fill=b;pad=3,3,3,3;wx=1");
            Util.setLabelBorder("Default Comm Port", (JComponent)object);
            this.ckScanOtherPorts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PrefsDialog.this.checkScanOptions();
                }
            });
            aAPanel8.setLayout(new String[]{".................", ". ,,,,,,,,,,,,, .", ". , DDD ddddd , .", ". , xxxxxxxxx , .", ". , TTTTTTTTT , .", ". , mmmmmmmmm , .", ". ,,,,,,,,,,,,, .", ".               .", ". ttttttttttttt .", ".               .", ". aaaaaaaaaaaaa .", ". ccccccccccccc .", ". lllllllllllll .", "................."});
            AAPanel aAPanel9 = new AAPanel(true);
            AAPanel aAPanel10 = new AAPanel(true);
            AAPanel aAPanel11 = new AAPanel(true);
            Util.setLabelBorder("CCF Color Mapping", aAPanel10);
            Util.setLabelBorder("Grid line colors", aAPanel11);
            ColorPicker colorPicker = new ColorPicker(CCFColor.getNamedColor(0, false), false, false);
            final ColorPicker colorPicker2 = new ColorPicker(CCFColor.getNamedColor(1, false), false, false);
            final ColorPicker colorPicker3 = new ColorPicker(CCFColor.getNamedColor(2, false), false, false);
            final ColorPicker colorPicker4 = new ColorPicker(CCFColor.getNamedColor(3, false), false, false);
            ActionButton actionButton = new ActionButton("Use Defaults"){

                @Override
                public void action() {
                    for (int i = 0; i < 4; ++i) {
                        PrefsDialog.this.cmap[i].setColor(CCFColor.defaultMap[i], true);
                        PrefsDialog.this.grayTint.setValue(0);
                    }
                }
            };
            JLabel jLabel5 = new JLabel("Simulate the greenish tint for gray models", 0);
            JLabel jLabel6 = new JLabel("Set the color mapping for conversion", 0);
            JLabel jLabel7 = new JLabel("of greyscale icons to color", 0);
            for (int i = 0; i < 4; ++i) {
                this.cmap[i] = new ColorPicker();
            }
            aAPanel9.define('+', (Component)aAPanel10, "pad=3,3,3,3;wx=1;fill=b");
            aAPanel9.define('.', "align=c");
            aAPanel9.define('-', "pad=6,6,20,6");
            aAPanel9.define('G', (Component)jLabel5, "fill=h;pad=3,3,3,3");
            aAPanel9.define('T', (Component)jLabel6, "fill=h;pad=3,3,3,3");
            aAPanel9.define('t', (Component)jLabel7, "fill=h;pad=3,3,8,3");
            aAPanel9.define('l', "wx=1;fill=b");
            aAPanel9.define('r', "wx=1;fill=b");
            aAPanel9.define('0', (Component)colorPicker, "pad=3,3,3,3");
            aAPanel9.define('2', (Component)colorPicker2, "pad=3,3,3,3");
            aAPanel9.define('4', (Component)colorPicker3, "pad=3,3,3,3");
            aAPanel9.define('6', (Component)colorPicker4, "pad=3,3,3,3");
            aAPanel9.define('1', (Component)this.cmap[0], "pad=3,3,3,3");
            aAPanel9.define('3', (Component)this.cmap[1], "pad=3,3,3,3");
            aAPanel9.define('5', (Component)this.cmap[2], "pad=3,3,3,3");
            aAPanel9.define('7', (Component)this.cmap[3], "pad=3,3,3,3");
            aAPanel9.define('a', (Component)new JLabel("-->"), "pad=3,3,3,3");
            aAPanel9.define('b', (Component)new JLabel("-->"), "pad=3,3,3,3");
            aAPanel9.define('c', (Component)new JLabel("-->"), "pad=3,3,3,3");
            aAPanel9.define('d', (Component)new JLabel("-->"), "fill=h;pad=3,3,3,3");
            aAPanel9.define('z', (Component)actionButton, "pad=10,3,10,3");
            aAPanel9.define('g', (Component)this.grayTint, "wx=1;fill=b");
            aAPanel9.setLayout(new String[]{"+++++++++++++", "+-----------+", "+- GGGGGGG -+", "+- ggggggg -+", "+-----------+", "+TTTTTTTTTTT+", "+ttttttttttt+", "+l 00 a 11 r+", "+l 22 b 33 r+", "+l 44 c 55 r+", "+l 66 d 77 r+", "+zzzzzzzzzzz+", "+++++++++++++"});
            this.grayTint.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = PrefsDialog.this.grayTint.getValue();
                    CCFColor.setGrayTint(n);
                    colorPicker2.repaint();
                    colorPicker3.repaint();
                    colorPicker4.repaint();
                }
            });
            AAPanel aAPanel12 = new AAPanel(true);
            AAPanel aAPanel13 = new AAPanel(true);
            AAPanel aAPanel14 = new AAPanel(true);
            for (int i = 0; i < this.models.length; ++i) {
                JLabel jLabel8 = new JLabel(this.models[i].getName());
                this.emulators[i] = new JTextField(20);
                FileBrowse fileBrowse = new FileBrowse(jLabel8.getText(), this.emulators[i]);
                aAPanel13.add((Component)jLabel8, "pad=3,3,3,3;x=0;y=" + i + ";fill=h;wx=0");
                aAPanel13.add((Component)this.emulators[i], "pad=3,3,3,3;x=1;y=" + i + ";fill=h;wx=1");
                aAPanel13.add((Component)fileBrowse, "pad=3,3,3,3;x=2;y=" + i + ";fill=h;wx=0");
            }
            aAPanel12.define(',', (Component)aAPanel14, "wx=1;fill=b");
            aAPanel12.define('h', (Component)aAPanel13, "pad=3,3,3,3;fill=b;wx=1");
            aAPanel12.define('e', (Component)this.ieditor, "pad=3,3,3,3;fill=h;wx=1");
            aAPanel12.define('E', (Component)jLabel, "pad=3,3,3,3;fill=h");
            aAPanel12.define('u', (Component)this.ceditor, "pad=3,3,3,3;fill=h;wx=1");
            aAPanel12.define('U', (Component)jLabel2, "pad=3,3,3,3;fill=h");
            aAPanel12.define('2', (Component)this.fbCCF, "pad=3,3,3,3;fill=h");
            aAPanel12.define('3', (Component)this.fbIMG, "pad=3,3,3,3;fill=h");
            aAPanel12.setLayout(new String[]{"hhhhhhhhhhhhh", "h           h", "hhhhhhhhhhhhh", ",,,,,,,,,,,,,", ",MMM mmmmm 1,", ",UUU uuuuu 2,", ",EEE eeeee 3,", ",,,,,,,,,,,,,"});
            Util.setLabelBorder("Emulators", aAPanel13);
            Util.setLabelBorder("Editors", aAPanel14);
            jTabbedPane.addTab("Setup", aAPanel);
            jTabbedPane.addTab("Debug", aAPanel7);
            jTabbedPane.addTab("Comm", aAPanel8);
            jTabbedPane.addTab("Colors", aAPanel9);
            jTabbedPane.addTab("Helpers", aAPanel12);
            this.coFontSize.addActionListener(this);
            this.ckFontUsage.addActionListener(this);
            this.setContents(jTabbedPane);
        }

        private void checkScanOptions() {
            this.ckScanThreaded.setEnabled(this.ckScanOtherPorts.isSelected());
            this.ckScanModems.setEnabled(this.ckScanOtherPorts.isSelected());
        }

        private JLabel label(String string) {
            return new JLabel(string, 4);
        }

        private JSlider getSlider(String string, int n, int n2, int n3, int n4, int n5) {
            return this.getSlider(string, n, n2, n3, n4, n5, true);
        }

        private JSlider getSlider(String string, int n, int n2, int n3, int n4, int n5, boolean bl) {
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setPaintTicks(true);
            jSlider.setPaintLabels(true);
            jSlider.setSnapToTicks(bl);
            jSlider.setMajorTickSpacing(n4);
            jSlider.setMinorTickSpacing(n5);
            Util.setLabelBorder(string, jSlider);
            return jSlider;
        }

        private int parse(JTextField jTextField, int n, int n2) {
            try {
                return Util.bound(n2, 50, Integer.parseInt(jTextField.getText().trim()));
            }
            catch (Exception exception) {
                return n;
            }
        }

        @Override
        public void doOK() {
            String string;
            Object object;
            boolean bl = this.ckShowDevProp.isSelected() != prefShowDeviceProps;
            boolean bl2 = this.ckNetUpdate.isSelected() != prefNetworkUpdate;
            prefDefaultModel = ProntoModel.getModelByName(this.coDefaultModel.getSelectedItem().toString());
            prefTreeFontSize = (Integer)this.coFontSize.getSelectedItem();
            fileNew.setLabel("New " + prefDefaultModel.getName());
            prefLogToConsole = this.ckTermLogging.isSelected();
            prefObeyRemoteCap = this.ckObeyRemote.isSelected();
            prefUseAWTFileDialogs = this.ckOldDialogs.isSelected();
            prefUseProntoFont = this.ckFontUsage.isSelected();
            prefEmitIR = this.ckTestEmitIR.isSelected();
            prefSelectionLast = this.ckSelectLast.isSelected();
            prefCenterDialogs = this.ckCenterDialog.isSelected();
            prefShowDeviceProps = this.ckShowDevProp.isSelected();
            prefShowWebSafe = this.ckWebSafe.isSelected();
            prefNetworkUpdate = this.ckNetUpdate.isSelected();
            prefScanOtherPorts = this.ckScanOtherPorts.isSelected();
            prefScanThreaded = this.ckScanThreaded.isSelected();
            prefScanModems = this.ckScanModems.isSelected();
            DriverMac_OS_X.setIgnoreModems(!prefScanModems);
            String string2 = this.ieditor.getText().trim();
            String string3 = this.ceditor.getText().trim();
            prefEditor = string3.length() > 0 ? string3 : null;
            for (int i = 0; i < this.models.length; ++i) {
                object = "emulator.path." + this.models[i].getName();
                string = this.emulators[i].getText().trim();
                prefs.setProperty((String)object, string);
            }
            prefImageEditor = string2.length() > 0 ? string2 : null;
            String string4 = this.defaultPort.getText().trim();
            prefCommPort = string4.length() > 0 ? string4 : null;
            prefGrid = new Rectangle(this.parse(this.gval[0], prefGrid.x, 0), this.parse(this.gval[1], prefGrid.y, 0), this.parse(this.gval[2], prefGrid.width, 2), this.parse(this.gval[3], prefGrid.height, 2));
            prefGridSnap = this.ckGridSnap.isSelected();
            prefGridShow = this.ckGridShow.isSelected();
            prefGridMinorTicks = this.parse(this.gval[4], prefGridMinorTicks, 0);
            prefGridMinorColor = this.gridMi.getColor();
            prefGridMajorColor = this.gridMa.getColor();
            object = this.dval.keys();
            while (object.hasMoreElements()) {
                string = (String)object.nextElement();
                Debug.getInstance(string).setLevel(((JSlider)this.dval.get(string)).getValue());
            }
            for (int i = 0; i < 4; ++i) {
                prefColorMap[i] = this.cmap[i].getColor();
            }
            Comm.setLoadDelay(this.commLOD.getValue());
            Comm.setCommandDelay(this.commCMD.getValue());
            Comm.setAttentionDelay(this.commATN.getValue());
            Tonto.setLogging(prefLogToConsole);
            if (bl) {
                Tonto.refreshAllTreeModels();
            }
            if (bl2) {
                Tonto.setupNetworkUpdates();
            }
            if (CCFColor.getGrayTint() != this.oldTint) {
                Tonto.clearAllGrayIconCaches();
            }
            Tonto.savePreferences();
            Tonto.refreshAllMenus();
            Tonto.state().repaintAllPanels();
        }

        @Override
        public void doCancel() {
            CCFColor.setGrayTint(this.oldTint);
        }

        @Override
        public void show() {
            String string;
            this.oldTint = CCFColor.getGrayTint();
            this.grayTint.setValue(this.oldTint);
            this.coDefaultModel.setSelectedItem(prefDefaultModel.getName());
            this.coFontSize.setSelectedItem(new Integer(prefTreeFontSize));
            this.ckTermLogging.setSelected(prefLogToConsole);
            this.ckOldDialogs.setSelected(prefUseAWTFileDialogs);
            this.ckFontUsage.setSelected(prefUseProntoFont);
            this.ckObeyRemote.setSelected(prefObeyRemoteCap);
            this.ckTestEmitIR.setSelected(prefEmitIR);
            this.ckCenterDialog.setSelected(prefCenterDialogs);
            this.ckShowDevProp.setSelected(prefShowDeviceProps);
            this.ckWebSafe.setSelected(prefShowWebSafe);
            this.ckSelectLast.setSelected(prefSelectionLast);
            this.ckNetUpdate.setSelected(prefNetworkUpdate);
            this.ckScanOtherPorts.setSelected(prefScanOtherPorts);
            this.ckScanThreaded.setSelected(prefScanThreaded);
            this.ckScanModems.setSelected(prefScanModems);
            this.ieditor.setText(prefImageEditor != null ? prefImageEditor : "");
            this.ceditor.setText(prefEditor != null ? prefEditor : "");
            this.gridMa.setColor(prefGridMajorColor, true);
            this.gridMi.setColor(prefGridMinorColor, true);
            for (int i = 0; i < this.models.length; ++i) {
                string = "emulator.path." + this.models[i].getName();
                this.emulators[i].setText(prefs.getProperty(string, ""));
            }
            this.defaultPort.setText(prefCommPort != null ? prefCommPort : "");
            this.checkScanOptions();
            this.gval[0].setText(prefGrid.x + "");
            this.gval[1].setText(prefGrid.y + "");
            this.gval[2].setText(prefGrid.width + "");
            this.gval[3].setText(prefGrid.height + "");
            this.gval[4].setText(prefGridMinorTicks + "");
            this.ckGridSnap.setSelected(prefGridSnap);
            this.ckGridShow.setSelected(prefGridShow);
            Enumeration enumeration = this.dval.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                JSlider jSlider = (JSlider)this.dval.get(string);
                jSlider.setValue(Debug.getInstance(string).getLevel());
            }
            this.commLOD.setValue(Comm.getLoadDelay());
            this.commCMD.setValue(Comm.getCommandDelay());
            this.commATN.setValue(Comm.getAttentionDelay());
            for (int i = 0; i < 4; ++i) {
                this.cmap[i].setColor(prefColorMap[i], true);
            }
            super.show();
        }
    }

    class FirmwareDialog
    extends OKCancelDialog {
        private Firmware firmware;
        private JCheckBox force;

        FirmwareDialog(File file) throws IOException {
            super("Firmware Updater");
            this.force = new JCheckBox("Reload current segments");
            this.firmware = new Firmware(file.toString());
            String string = this.firmware.getDescription();
            String[][] stringArray = this.firmware.getSegmentReport();
            AAPanel aAPanel = new AAPanel(true);
            Color color = Color.red;
            aAPanel.add((Component)this.getLabel(string), "x=0;y=0;wx=1;fill=w;pad=15,5,15,5;w=3");
            aAPanel.add((Component)new Bar(), "x=0;y=1;wx=1;fill=w;pad=15,5,15,5;w=3");
            aAPanel.add((Component)this.getLabel("Segment", color), "x=0;y=2;w=1;fill=w;anchor=w;wx=1;pad=5,15,15,5");
            aAPanel.add((Component)this.getLabel("Offset", color), "x=1;y=2;w=1;fill=w;anchor=e;wx=0;pad=5,5,15,5");
            aAPanel.add((Component)this.getLabel("Length", color), "x=2;y=2;w=1;fill=w;anchor=e;wx=0;pad=5,5,15,15");
            int n = 3;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i][2].equals("0")) continue;
                aAPanel.add((Component)this.getLabel(stringArray[i][0]), "w=1;x=0;fill=w;anchor=w;wx=1;pad=5,15,5,5;y=" + n);
                aAPanel.add((Component)this.getLabel(stringArray[i][1]), "w=1;x=1;fill=w;anchor=e;wx=0;pad=5,5,5,5;y=" + n);
                aAPanel.add((Component)this.getLabel(stringArray[i][2]), "w=1;x=2;fill=w;anchor=e;wx=0;pad=5,5,5,15;y=" + n);
                ++n;
            }
            aAPanel.add((Component)new Bar(), "x=0;wx=1;fill=w;anchor=c;pad=15,5,15,5;w=3;y=" + n++);
            aAPanel.add((Component)this.force, "x=0;wx=1;fill=w;anchor=c;pad=5,5,5,5;w=3;y=" + n++);
            aAPanel.add((Component)this.getLabel("Click OK to update your remote's firmware", Color.blue), "x=0;wx=1;fill=w;anchor=c;pad=15,25,15,25;w=3;y=" + n);
            this.force.setSelected(true);
            this.setContents(aAPanel);
        }

        private JLabel getLabel(String string) {
            return this.getLabel(string, Color.black);
        }

        private JLabel getLabel(String string, Color color) {
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(color);
            return jLabel;
        }

        @Override
        public void doOK() {
            if (prefCommPort == null) {
                Tonto.errorDialog("The default port is not set in Preferences");
                return;
            }
            if (Tonto.confirmDialog("Are your sure?", "Are your sure you want to send this firmware to your remote?")) {
                if (Tonto.this.ccf != null && !Tonto.confirmDialog("CCF Type Check", "Are you sure the loaded CCF '" + Tonto.this.fileName + "' matches the remote?")) {
                    Tonto.errorDialog("Aborting Update");
                    return;
                }
                Tonto.this.downloadFirmware(this.firmware, this.force.isSelected());
            }
        }

        @Override
        public void doCancel() {
        }

        class Bar
        extends JPanel {
            Bar() {
                this.setBackground(Color.darkGray);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                return new Dimension(dimension.width, 3);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(300, 3);
            }
        }
    }

    class ButtonPasteDialog
    extends OKCancelDialog {
        private CCFButton src;
        private CCFButton dst;
        private JCheckBox ckFont;
        private JCheckBox ckText;
        private JCheckBox ckLabel;
        private JCheckBox ckIcons;
        private JCheckBox ckColors;
        private JCheckBox ckActions;

        ButtonPasteDialog() {
            super("Paste Options");
            this.ckFont = new JCheckBox("Font");
            this.ckText = new JCheckBox("Name");
            this.ckLabel = new JCheckBox("ID Tag");
            this.ckIcons = new JCheckBox("Icons");
            this.ckColors = new JCheckBox("Colors");
            this.ckActions = new JCheckBox("Actions");
            AAPanel aAPanel = new AAPanel(true);
            aAPanel.define('f', (Component)this.ckFont, "pad=5,5,5,5;wx=1;fill=b");
            aAPanel.define('l', (Component)this.ckText, "pad=5,5,5,5;wx=1;fill=b");
            aAPanel.define('t', (Component)this.ckLabel, "pad=5,5,5,5;wx=1;fill=b");
            aAPanel.define('i', (Component)this.ckIcons, "pad=5,5,5,5;wx=1;fill=b");
            aAPanel.define('c', (Component)this.ckColors, "pad=5,5,5,5;wx=1;fill=b");
            aAPanel.define('a', (Component)this.ckActions, "pad=5,5,5,5;wx=1;fill=b");
            aAPanel.setLayout(new String[]{" ff ii ", " ll cc ", " tt aa "});
            this.setContents(aAPanel);
            this.ckFont.setSelected(true);
            this.ckText.setSelected(true);
            this.ckLabel.setSelected(true);
            this.ckIcons.setSelected(true);
            this.ckColors.setSelected(true);
            this.ckActions.setSelected(false);
        }

        public void invoke(CCFButton cCFButton, CCFButton cCFButton2) {
            this.src = cCFButton;
            this.dst = cCFButton2;
            super.invoke();
        }

        @Override
        public void doOK() {
            DoNodeUpdate doNodeUpdate = new DoNodeUpdate(this.dst);
            if (this.ckFont.isSelected()) {
                this.dst.fontSize = this.src.fontSize;
            }
            if (this.ckText.isSelected()) {
                this.dst.name = this.src.name;
            }
            if (this.ckLabel.isSelected()) {
                this.dst.idtag = this.src.idtag;
            }
            if (this.ckIcons.isSelected()) {
                this.dst.iconIU = this.src.iconIU;
                this.dst.iconIS = this.src.iconIS;
                this.dst.iconAU = this.src.iconAU;
                this.dst.iconAS = this.src.iconAS;
            }
            if (this.ckColors.isSelected()) {
                this.dst.colorIU = this.src.colorIU;
                this.dst.colorIS = this.src.colorIS;
                this.dst.colorAU = this.src.colorAU;
                this.dst.colorAS = this.src.colorAS;
            }
            if (this.ckActions.isSelected()) {
                this.dst.actions = this.src.actions != null ? (CCFActionList)this.src.actions.getClone() : null;
            }
            doNodeUpdate.pushDoNewState();
            ButtonBox buttonBox = (ButtonBox)Tonto.this.getChildPanel(this.dst.getChildWrapper());
            buttonBox.readButton();
            buttonBox.getRootPanel().repaint();
        }

        @Override
        public void doCancel() {
        }
    }

    static interface Selectable {
        public void select(boolean var1);

        public void unselect();

        public boolean isSelected();
    }

    class ButtonBox
    extends ChildPanel
    implements Selectable,
    Deletable,
    Configurable,
    Resizable,
    Movable,
    Copyable,
    Namable,
    Pastable {
        private CCFButton button;

        ButtonBox(int n, int n2, CCFChild cCFChild) {
            super(cCFChild.intX, cCFChild.intY, n, n2, cCFChild);
            this.button = (CCFButton)cCFChild.child;
            this.readButton();
        }

        @Override
        public void refresh() {
            this.readButton();
        }

        public CCFButton getButton() {
            return this.button;
        }

        @Override
        public String getName() {
            return this.button.getName();
        }

        @Override
        public void setName(String string) {
            this.button.setName(string);
            this.readButton();
            this.repaint();
        }

        public int getFontSize() {
            return this.button.fontSize;
        }

        public void setFontSize(int n) {
            this.button.fontSize = n;
            this.readButton();
            this.repaint();
        }

        private void readButton() {
            Point point = this.button.getLocation();
            Dimension dimension = this.button.getSize();
            this.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.setText(this.button.getName());
            ImageFontLabel imageFontLabel = this.getLabel();
            imageFontLabel.setFont(Tonto.this.getIFont(this.button.getFont().getAWTSize()));
            boolean bl = Tonto.color();
            imageFontLabel.setForeground(this.button.getForeground().getAWTColor(bl));
            imageFontLabel.setAlignment(this.button.getTextAlignment());
            this.setBackground(this.button.getBackground().getAWTColor(bl));
            if (this.button.isActive()) {
                this.setImage(this.button.iconAU != null ? this.createImage(this.button.iconAU.getImageProducer()) : null);
            } else {
                this.setImage(this.button.iconIU != null ? this.createImage(this.button.iconIU.getImageProducer()) : null);
            }
        }

        @Override
        public Object copy() {
            return new ButtonBox(this.button.width(), this.button.height(), (CCFChild)this.getSource().getClone());
        }

        @Override
        public void editProperties() {
            Tonto.this.buttonProps.updateButton(this, this.button);
        }

        @Override
        public boolean isResizable() {
            return this.button.isResizable();
        }

        @Override
        public void delete() {
            Tonto.this.pushDo(new MultiDo(new Doable[]{new DoDeleteChild(this.button.getChildWrapper())}));
        }

        @Override
        public boolean acceptPaste(Object object) {
            return object instanceof ButtonBox;
        }

        @Override
        public void paste(Object object) {
            if (object instanceof ButtonBox) {
                Tonto.this.buttonPaste.invoke(((ButtonBox)object).getButton(), this.button);
            }
        }
    }

    class FrameBox
    extends ChildPanel
    implements Selectable,
    Configurable,
    Deletable,
    ButtonHost,
    FrameHost,
    Resizable,
    Movable,
    Pastable,
    Copyable,
    Namable {
        private CCFFrame frame;

        FrameBox(int n, int n2, CCFChild cCFChild) {
            super(cCFChild.intX, cCFChild.intY, n, n2, cCFChild);
            this.frame = (CCFFrame)cCFChild.child;
            this.readFrame();
            this.setChildren(this.frame.child);
        }

        public void readFrame() {
            Point point = this.frame.getLocation();
            Dimension dimension = this.frame.getSize();
            this.setBounds(point.x, point.y, dimension.width, dimension.height);
            this.setText(this.frame.getName());
            ImageFontLabel imageFontLabel = this.getLabel();
            imageFontLabel.setFont(Tonto.this.getIFont(this.frame.getFont().getAWTSize()));
            boolean bl = Tonto.color();
            imageFontLabel.setForeground(this.frame.getForeground().getAWTColor(bl));
            imageFontLabel.setAlignment(this.frame.getTextAlignment());
            this.setBackground(this.frame.getBackground().getAWTColor(bl));
            this.setImage(this.frame.icon != null ? this.createImage(this.frame.icon.getImageProducer()) : null);
        }

        @Override
        public void refresh() {
            this.setChildren(this.frame.child);
            this.readFrame();
        }

        @Override
        public String getName() {
            return this.frame.getName();
        }

        @Override
        public void setName(String string) {
            this.frame.setName(string);
            this.readFrame();
            this.repaint();
        }

        public int getFontSize() {
            return this.frame.fontSize;
        }

        public void setFontSize(int n) {
            this.frame.fontSize = n;
            this.readFrame();
            this.repaint();
        }

        @Override
        public void addButton() {
            Tonto.this.addNewButton(this.frame);
        }

        @Override
        public void addFrame() {
            Tonto.this.addNewFrame(this.frame);
        }

        @Override
        public Object copy() {
            return new FrameBox(this.frame.width(), this.frame.height(), (CCFChild)this.getSource().getClone());
        }

        @Override
        public void editProperties() {
            Tonto.this.frameProps.updateFrame(this, this.frame);
            Tonto.this.refreshPanel(this.frame.getParentPanel());
        }

        public CCFFrame getFrame() {
            return this.frame;
        }

        @Override
        public boolean isResizable() {
            return this.frame.isResizable();
        }

        @Override
        public void delete() {
            Tonto.this.pushDo(new DoDeleteChild(this.frame.getChildWrapper()));
        }

        @Override
        public boolean acceptPaste(Object object) {
            return object instanceof ButtonBox || object instanceof FrameBox;
        }

        @Override
        public void paste(Object object) {
            if (object instanceof ButtonBox || object instanceof FrameBox) {
                DoNodeUpdate doNodeUpdate = new DoNodeUpdate(this.frame);
                CCFChild cCFChild = ((ChildPanel)object).getSource();
                this.frame.addChild(cCFChild);
                Tonto.this.icons.addChild(cCFChild);
                doNodeUpdate.getNewState();
                Tonto.this.pushDo(doNodeUpdate);
                ChildPanel childPanel = Tonto.this.getChildPanel(cCFChild);
                if (childPanel != null) {
                    childPanel.select(true);
                }
            }
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            Rectangle rectangle2 = this.getBounds();
            if (rectangle2.x != rectangle.x && rectangle2.width != rectangle.width || rectangle2.y != rectangle.y && rectangle2.height != rectangle.height) {
                int n = rectangle.x - rectangle2.x;
                int n2 = rectangle.y - rectangle2.y;
                Component[] componentArray = this.getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    ChildPanel childPanel = (ChildPanel)componentArray[i];
                    Point point = childPanel.getLocation();
                    childPanel.setLocation(new Point(point.x - n, point.y - n2));
                }
            }
            super.setBounds(rectangle);
        }
    }

    class PanelPanel
    extends ChildPanel
    implements ButtonHost,
    FrameHost,
    Pastable,
    Selectable,
    Configurable {
        private CCFPanel panel;
        private boolean showGrid;
        private boolean snapGrid;
        private int scale;

        PanelPanel(CCFPanel cCFPanel) {
            super(0, 0, ((Tonto)Tonto.this).panelSize.width, ((Tonto)Tonto.this).panelSize.height);
            this.scale = 1;
            this.panel = cCFPanel;
            this.showGrid = prefGridShow;
            this.snapGrid = prefGridSnap;
            boolean bl = Tonto.color();
            this.setBackground(CCFColor.getNamedColor(3, bl).getAWTColor(bl));
            this.ccfChangeEvent();
            Tonto.bindAction(this, 49, 8, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PanelPanel.this.setScale(1);
                }
            });
            Tonto.bindAction(this, 50, 8, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PanelPanel.this.setScale(2);
                }
            });
            Tonto.bindAction(this, 71, 2, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PanelPanel.this.toggleGrid();
                }
            });
            EventAction eventAction = new EventAction(2051);
            EventAction eventAction2 = new EventAction(2052);
            EventAction eventAction3 = new EventAction(2049);
            EventAction eventAction4 = new EventAction(2050);
            Tonto.bindAction(this, 82, 0, eventAction3);
            Tonto.bindAction(this, 76, 0, eventAction4);
            Tonto.bindAction(this, 84, 0, eventAction);
            Tonto.bindAction(this, 66, 0, eventAction2);
            Tonto.bindAction(this, 33, 0, eventAction3);
            Tonto.bindAction(this, 34, 0, eventAction4);
            Tonto.bindAction(this, 36, 0, eventAction);
            Tonto.bindAction(this, 35, 0, eventAction2);
        }

        @Override
        public String toString() {
            return "PanelPanel:" + Integer.toHexString(this.hashCode());
        }

        @Override
        public void editProperties() {
            Tonto.this.panelProps.updatePanel(this.panel);
        }

        public void ccfChangeEvent() {
            this.setChildren(this.panel.child);
        }

        @Override
        public void addButton() {
            Tonto.this.addNewButton(this.panel);
        }

        @Override
        public void addFrame() {
            Tonto.this.addNewFrame(this.panel);
        }

        public CCFPanel getPanel() {
            return this.panel;
        }

        @Override
        public void refresh() {
            boolean bl = Tonto.color();
            this.setBackground(CCFColor.getNamedColor(3, bl).getAWTColor(bl));
            this.setSize(Tonto.this.panelSize);
            this.setChildren(this.panel.child);
            this.repaint();
        }

        public void delete() {
            Tonto.this.pushDo(new MultiDo(new Doable[]{new DoDeletePanel(this.panel)}));
        }

        @Override
        public boolean acceptPaste(Object object) {
            return object instanceof ButtonBox || object instanceof FrameBox;
        }

        @Override
        public void paste(Object object) {
            if (object instanceof ButtonBox || object instanceof FrameBox) {
                DoNodeUpdate doNodeUpdate = new DoNodeUpdate(this.panel);
                CCFChild cCFChild = ((ChildPanel)object).getSource();
                this.panel.addChild(cCFChild);
                Tonto.this.icons.addChild(cCFChild);
                doNodeUpdate.getNewState();
                Tonto.this.pushDo(doNodeUpdate);
                Tonto.this.setDragSelectionWithFocus(Tonto.this.getChildPanel(cCFChild));
            }
        }

        public CCFIcon getPicture(ChildPanel childPanel) {
            childPanel.setExclude(true);
            Dimension dimension = this.getSize();
            Dimension dimension2 = childPanel.getSize();
            Point point = this.getAbsoluteLocation(childPanel);
            Image image = this.createImage(dimension2.width, dimension2.height);
            Graphics graphics = image.getGraphics();
            graphics.translate(-point.x, -point.y);
            super.paint(graphics);
            graphics.translate(point.x, point.y);
            childPanel.setExclude(false);
            return CCFIcon.create(image, Tonto.iconMode());
        }

        @Override
        public void paint(Graphics graphics) {
            ((Graphics2D)graphics).scale(this.scale, this.scale);
            super.paint(graphics);
            if (this.isGridShowing()) {
                int n;
                Dimension dimension = this.getSize();
                ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.35f));
                int n2 = 0;
                int n3 = Math.max(prefGridMinorTicks + 1, 1);
                Color color = prefGridMajorColor.getAWTColor(true);
                Color color2 = prefGridMinorColor.getAWTColor(true);
                for (n = prefGrid.x; n < dimension.width; n += prefGrid.width) {
                    graphics.setColor(n2++ % n3 == 0 ? color : color2);
                    graphics.drawLine(n, 0, n, dimension.height);
                }
                n2 = 0;
                for (n = prefGrid.y; n < dimension.height; n += prefGrid.height) {
                    graphics.setColor(n2++ % n3 == 0 ? color : color2);
                    graphics.drawLine(0, n, dimension.width, n);
                }
                graphics.setPaintMode();
            }
            if (prefSelectionLast && !Tonto.this.hideSelection) {
                this.drawSelections(this, graphics, 0, 0);
            }
        }

        private void drawSelections(Container container, Graphics graphics, int n, int n2) {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                ChildPanel childPanel = (ChildPanel)componentArray[i];
                Rectangle rectangle = childPanel.getBounds();
                if (childPanel.selected) {
                    graphics.setColor(Color.red);
                    graphics.drawRect(n + rectangle.x, n2 + rectangle.y, rectangle.width - 1, rectangle.height - 1);
                }
                if (!(childPanel instanceof FrameBox)) continue;
                this.drawSelections(childPanel, graphics, n + rectangle.x, n2 + rectangle.y);
            }
        }

        @Override
        public boolean isSnapped() {
            return this.snapGrid;
        }

        @Override
        public void toggleSnap() {
            this.snapGrid = !this.snapGrid;
        }

        @Override
        public boolean isGridShowing() {
            return this.showGrid;
        }

        @Override
        public void toggleGrid() {
            this.showGrid = !this.showGrid;
            this.repaint();
        }

        @Override
        public void setScale(int n) {
            double d = (double)n / (double)this.scale;
            this.scale = n;
            this.repaint();
            Container container = this;
            int n2 = 0;
            while (!(container instanceof DeskPanel)) {
                container = container.getParent();
                ++n2;
            }
            if (container != null) {
                Dimension dimension = container.getSize();
                container.setSize((int)((double)dimension.width * d), (int)((double)dimension.height * d));
            }
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        class EventAction
        extends AbstractAction {
            private int event;

            EventAction(int n) {
                this.event = n;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tonto.sendEvent(this.event);
            }
        }
    }

    abstract class ChildPanel
    extends JLayeredPane
    implements Selectable,
    Parental {
        private CCFChild source;
        private boolean selected;
        private ImageProducer cachedIP;
        private Image image;
        private ImageFontLabel label;
        private int nextID;
        private Point offset;
        private Rectangle bounds;
        private Rectangle endBounds;
        private int sides;
        private boolean resize;
        private boolean readonly;
        private Stack cursors;
        private boolean exclude = false;

        ChildPanel(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, null);
        }

        public abstract void refresh();

        @Override
        public Image createImage(ImageProducer imageProducer) {
            if (imageProducer == this.cachedIP) {
                return this.image;
            }
            this.cachedIP = imageProducer;
            this.image = super.createImage(imageProducer);
            return this.image;
        }

        @Override
        public String toString() {
            return "ChildPanel:" + Integer.toHexString(this.hashCode()) + ":" + this.source;
        }

        private void testActions(CCFAction[] cCFActionArray) {
            for (int i = 0; cCFActionArray != null && i < cCFActionArray.length; ++i) {
                try {
                    if (cCFActionArray[i] instanceof ActionJumpPanel) {
                        Tonto.this.showDeskPanel(((ActionJumpPanel)cCFActionArray[i]).getPanel());
                        continue;
                    }
                    if (cCFActionArray[i] instanceof ActionIRCode) {
                        if (!prefEmitIR) continue;
                        CCFIRCode cCFIRCode = ((ActionIRCode)cCFActionArray[i]).getIRCode();
                        Tonto.getComm().testIR(cCFIRCode.getData());
                        continue;
                    }
                    if (cCFActionArray[i] instanceof ActionBeep) {
                        Toolkit.getDefaultToolkit().beep();
                        continue;
                    }
                    if (cCFActionArray[i] instanceof ActionAliasButton) {
                        this.testButton(((ActionAliasButton)cCFActionArray[i]).getButton());
                        continue;
                    }
                    if (!(cCFActionArray[i] instanceof ActionAliasDevice)) continue;
                    this.testActions(((ActionAliasDevice)cCFActionArray[i]).getDevice().getActions());
                    continue;
                }
                catch (Exception exception) {
                    Tonto.debug(exception);
                }
            }
        }

        private void testButton(CCFButton cCFButton) {
            this.testActions(cCFButton.getActions());
        }

        private void move(int n, int n2, int n3, int n4, boolean bl) {
            if (Tonto.this.dragSelection != null && Tonto.this.dragSelection instanceof Movable) {
                Rectangle rectangle = bl ? new Rectangle(n * prefGrid.width, n2 * prefGrid.height, n3 * prefGrid.width, n4 * prefGrid.height) : new Rectangle(n, n2, n3, n4);
                Point point = Tonto.this.dragSelection.getLocation();
                point.translate(rectangle.x, rectangle.y);
                Dimension dimension = Tonto.this.dragSelection.getSize();
                dimension.setSize(dimension.width + rectangle.width, dimension.height + rectangle.height);
                Rectangle rectangle2 = Tonto.this.dragSelection.getBounds();
                Rectangle rectangle3 = Tonto.this.visibleBounds(Tonto.this.dragSelection.getParent(), new Rectangle(point.x, point.y, dimension.width, dimension.height));
                int n5 = rectangle3.x - rectangle2.x;
                int n6 = rectangle3.y - rectangle2.y;
                int n7 = rectangle3.width - rectangle2.width;
                int n8 = rectangle3.height - rectangle2.height;
                MultiDo multiDo = new MultiDo();
                for (int i = 0; i < Tonto.this.multiSelect.size(); ++i) {
                    ChildPanel childPanel = (ChildPanel)Tonto.this.multiSelect.get(i);
                    Rectangle rectangle4 = childPanel.getBounds();
                    Rectangle rectangle5 = childPanel instanceof Resizable && ((Resizable)((Object)childPanel)).isResizable() ? new Rectangle(rectangle4.x + n5, rectangle4.y + n6, rectangle4.width + n7, rectangle4.height + n8) : new Rectangle(rectangle4.x + n5, rectangle4.y + n6, rectangle4.width, rectangle4.height);
                    multiDo.add(new DoBounds(childPanel, rectangle4, rectangle5));
                }
                Tonto.this.pushDo(multiDo);
                Tonto.this.setCCFChanged();
            }
        }

        ChildPanel(int n, int n2, int n3, int n4, CCFChild cCFChild) {
            this.setLayout(null);
            this.source = cCFChild;
            this.cursors = new Stack();
            this.label = Tonto.this.getFontLabel("", 0, 12);
            this.setBounds(n, n2, n3, n4);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    boolean bl = keyEvent.isShiftDown();
                    int n2 = keyEvent.isAltDown() ? 0 : 1;
                    int n3 = n = keyEvent.isAltDown() ? 1 : 0;
                    if (keyEvent.isControlDown()) {
                        --n;
                    }
                    switch (keyEvent.getKeyCode()) {
                        case 39: {
                            ChildPanel.this.move(n2, 0, n, 0, bl);
                            break;
                        }
                        case 37: {
                            ChildPanel.this.move(-n2, 0, -n, 0, bl);
                            break;
                        }
                        case 38: {
                            ChildPanel.this.move(0, -n2, 0, -n, bl);
                            break;
                        }
                        case 40: {
                            ChildPanel.this.move(0, n2, 0, n, bl);
                            break;
                        }
                        case 73: {
                            Tonto.this.buttonLearnIR();
                            break;
                        }
                        case 114: {
                            Tonto.this.buttonLink();
                        }
                    }
                    if (prefSelectionLast) {
                        ChildPanel.this.refreshDeskPanel();
                    } else {
                        ChildPanel.this.repaint();
                    }
                }
            });
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Component component = (Component)focusEvent.getSource();
                    if (!Tonto.this.multiSelect.contains(component)) {
                        Tonto.this.setDragSelection(component);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.isAltDown() && mouseEvent.isShiftDown()) {
                        Component component = ChildPanel.this.getComponentAt(ChildPanel.this.getPoint(mouseEvent));
                        if (component instanceof ButtonBox) {
                            ChildPanel.this.testButton(((ButtonBox)component).getButton());
                        }
                        return;
                    }
                    if (ChildPanel.this.readonly) {
                        return;
                    }
                    if (Tonto.isRightClick(mouseEvent)) {
                        if (Tonto.this.ccf == null) {
                            return;
                        }
                        Tonto.this.rightClickMenu(ChildPanel.this.getComponentAt(ChildPanel.this.getPoint(mouseEvent)), ChildPanel.this.getPoint(mouseEvent));
                        return;
                    }
                    if (mouseEvent.getClickCount() == 2) {
                        Tonto.sendEvent(39);
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    ChildPanel.this.bounds = null;
                    ChildPanel.this.endBounds = null;
                    ChildPanel.this.selectDrag(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (ChildPanel.this.bounds != null && ChildPanel.this.endBounds != null && !ChildPanel.this.bounds.equals(ChildPanel.this.endBounds) && !Tonto.isRightClick(mouseEvent)) {
                        MultiDo multiDo = new MultiDo();
                        for (int i = 0; i < Tonto.this.multiSelect.size(); ++i) {
                            ChildPanel childPanel = (ChildPanel)Tonto.this.multiSelect.get(i);
                            multiDo.add(new DoBounds(childPanel, childPanel.bounds, childPanel.endBounds));
                        }
                        Tonto.this.pushDo(multiDo);
                        if (prefSelectionLast) {
                            ChildPanel.this.refreshDeskPanel();
                        }
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    Component component = ChildPanel.this.getComponentAt(ChildPanel.this.getPoint(mouseEvent));
                    if (component != null && !ChildPanel.this.readonly) {
                        ChildPanel.this.cursors.push(component.getCursor());
                        component.setCursor(CURSOR_DEFAULT);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    Component component = ChildPanel.this.getComponentAt(ChildPanel.this.getPoint(mouseEvent));
                    if (component != null && !ChildPanel.this.cursors.empty() && !ChildPanel.this.readonly) {
                        component.setCursor((Cursor)ChildPanel.this.cursors.pop());
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    int n;
                    int n2;
                    if (Tonto.this.dragSelection == null || Tonto.isRightClick(mouseEvent) || ChildPanel.this.readonly) {
                        return;
                    }
                    if (!(Tonto.this.dragSelection instanceof Movable)) {
                        return;
                    }
                    if (ChildPanel.this.bounds == null) {
                        return;
                    }
                    Point point = ChildPanel.this.getAbsolutePoint(mouseEvent);
                    point.translate(-((ChildPanel)ChildPanel.this).offset.x, -((ChildPanel)ChildPanel.this).offset.y);
                    Rectangle rectangle = null;
                    if (!ChildPanel.this.resize) {
                        rectangle = new Rectangle(1, 1, 0, 0);
                    } else {
                        switch (ChildPanel.this.sides) {
                            case 1: {
                                rectangle = new Rectangle(0, 1, 0, -1);
                                break;
                            }
                            case 2: {
                                rectangle = new Rectangle(0, 0, 0, 1);
                                break;
                            }
                            case 4: {
                                rectangle = new Rectangle(0, 0, 1, 0);
                                break;
                            }
                            case 8: {
                                rectangle = new Rectangle(1, 0, -1, 0);
                                break;
                            }
                            case 9: {
                                rectangle = new Rectangle(1, 1, -1, -1);
                                break;
                            }
                            case 5: {
                                rectangle = new Rectangle(0, 1, 1, -1);
                                break;
                            }
                            case 10: {
                                rectangle = new Rectangle(1, 0, -1, 1);
                                break;
                            }
                            case 6: {
                                rectangle = new Rectangle(0, 0, 1, 1);
                                break;
                            }
                            default: {
                                rectangle = new Rectangle(1, 1, 0, 0);
                            }
                        }
                    }
                    int n3 = ((ChildPanel)ChildPanel.this).bounds.x + rectangle.x * point.x;
                    int n4 = ((ChildPanel)ChildPanel.this).bounds.y + rectangle.y * point.y;
                    int n5 = ((ChildPanel)ChildPanel.this).bounds.width + rectangle.width * point.x;
                    int n6 = ((ChildPanel)ChildPanel.this).bounds.height + rectangle.height * point.y;
                    n3 = Math.max(n3, -n5 + 2);
                    n4 = Math.max(n4, -n6 + 2);
                    n3 = Math.min(n3, ((Tonto)Tonto.this).panelSize.width - 2);
                    n4 = Math.min(n4, ((Tonto)Tonto.this).panelSize.height - 2);
                    if (ChildPanel.this.isSnapped()) {
                        n2 = (n3 + (int)(snaps.w * (double)n5)) % prefGrid.width;
                        n = (n4 + (int)(snaps.h * (double)n6)) % prefGrid.height;
                        n3 = n3 - n2 + prefGrid.x;
                        n4 = n4 - n + prefGrid.y;
                        if (rectangle.width != 0) {
                            n5 += n2;
                            n5 -= n5 % prefGrid.width;
                        }
                        if (rectangle.height != 0) {
                            n6 += n;
                            n6 -= n6 % prefGrid.height;
                        }
                    }
                    if (n5 > 0 && n6 > 0) {
                        n2 = n3 - ((ChildPanel)ChildPanel.this).bounds.x;
                        n = n4 - ((ChildPanel)ChildPanel.this).bounds.y;
                        int n7 = n5 - ((ChildPanel)ChildPanel.this).bounds.width;
                        int n8 = n6 - ((ChildPanel)ChildPanel.this).bounds.height;
                        for (int i = 0; i < Tonto.this.multiSelect.size(); ++i) {
                            ChildPanel childPanel = (ChildPanel)Tonto.this.multiSelect.get(i);
                            Rectangle rectangle2 = childPanel.bounds;
                            if (childPanel instanceof Resizable && ((Resizable)((Object)childPanel)).isResizable()) {
                                childPanel.endBounds = new Rectangle(rectangle2.x + n2, rectangle2.y + n, rectangle2.width + n7, rectangle2.height + n8);
                            } else {
                                childPanel.endBounds = new Rectangle(rectangle2.x + n2, rectangle2.y + n, rectangle2.width, rectangle2.height);
                            }
                            childPanel.setBounds(childPanel.endBounds);
                        }
                        Tonto.this.setCCFChanged();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    if (ChildPanel.this.readonly) {
                        return;
                    }
                    Point point = ChildPanel.this.getAbsolutePoint(mouseEvent);
                    Component component = ChildPanel.this.getComponentAt(ChildPanel.this.getPoint(mouseEvent));
                    if (component instanceof Movable) {
                        Cursor cursor = component.getCursor();
                        Cursor cursor2 = CURSOR_MOVE;
                        if (component instanceof Resizable && ((Resizable)((Object)component)).isResizable()) {
                            Dimension dimension = component.getSize();
                            Point point2 = ChildPanel.this.getAbsoluteLocation(component);
                            Point point3 = new Point(point2.x + dimension.width, point2.y + dimension.height);
                            ChildPanel.this.sides = 0;
                            ChildPanel.this.sides = ChildPanel.this.sides | (point.x - point2.x < 4 ? 8 : 0);
                            ChildPanel.this.sides = ChildPanel.this.sides | (point3.x - point.x < 4 ? 4 : 0);
                            ChildPanel.this.sides = ChildPanel.this.sides | (point.y - point2.y < 4 ? 1 : 0);
                            ChildPanel.this.sides = ChildPanel.this.sides | (point3.y - point.y < 4 ? 2 : 0);
                            ChildPanel.this.resize = ChildPanel.this.sides > 0;
                            switch (ChildPanel.this.sides) {
                                case 1: {
                                    cursor2 = CURSOR_NORTH;
                                    break;
                                }
                                case 2: {
                                    cursor2 = CURSOR_SOUTH;
                                    break;
                                }
                                case 4: {
                                    cursor2 = CURSOR_EAST;
                                    break;
                                }
                                case 8: {
                                    cursor2 = CURSOR_WEST;
                                    break;
                                }
                                case 9: {
                                    cursor2 = CURSOR_NW;
                                    break;
                                }
                                case 5: {
                                    cursor2 = CURSOR_NE;
                                    break;
                                }
                                case 10: {
                                    cursor2 = CURSOR_SW;
                                    break;
                                }
                                case 6: {
                                    cursor2 = CURSOR_SE;
                                }
                            }
                        }
                        if (cursor2 != cursor && ((Selectable)((Object)component)).isSelected()) {
                            component.setCursor(cursor2);
                        }
                    }
                }
            });
        }

        public void selectAll() {
            Component[] componentArray = this.getComponents();
            if (componentArray == null || componentArray.length == 0) {
                return;
            }
            Tonto.this.setDragSelection(null);
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof Selectable)) continue;
                Tonto.this.setDragSelection(componentArray[i], true);
            }
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            if (this.source != null) {
                this.source.setBounds(new Rectangle(n, n2, n3, n4));
            }
            Tonto.this.objectStatus.update();
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            super.setBounds(rectangle);
            if (this.source != null) {
                this.source.setBounds(rectangle);
            }
            Tonto.this.objectStatus.update();
        }

        @Override
        public Dimension getSize() {
            return this.source != null ? this.source.getSize() : super.getSize();
        }

        @Override
        public void setSize(Dimension dimension) {
            super.setSize(dimension);
            if (this.source != null) {
                this.source.setSize(dimension);
            }
            Tonto.this.objectStatus.update();
        }

        @Override
        public Point getLocation() {
            return this.source != null ? this.source.getLocation() : super.getLocation();
        }

        @Override
        public void setLocation(Point point) {
            super.setLocation(point);
            if (this.source != null) {
                this.source.setLocation(point);
            }
            Tonto.this.objectStatus.update();
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        public void setReadOnly(boolean bl) {
            this.readonly = bl;
            Component[] componentArray = this.getComponents();
            for (int i = 0; componentArray != null && i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof ChildPanel)) continue;
                ((ChildPanel)componentArray[i]).setReadOnly(bl);
            }
        }

        @Override
        public Object getMyParent() {
            return this.getParent();
        }

        public boolean isSnapped() {
            return ((ChildPanel)this.getParent()).isSnapped();
        }

        public void toggleSnap() {
            ((ChildPanel)this.getParent()).toggleSnap();
        }

        public boolean isGridShowing() {
            return ((ChildPanel)this.getParent()).isGridShowing();
        }

        public int getScale() {
            try {
                return ((ChildPanel)this.getParent()).getScale();
            }
            catch (Exception exception) {
                debug.log(0, exception.toString());
                return 1;
            }
        }

        public void toggleGrid() {
            ((ChildPanel)this.getParent()).toggleGrid();
        }

        public void setScale(int n) {
            ((ChildPanel)this.getParent()).setScale(n);
        }

        public CCFChild getSource() {
            return this.source;
        }

        public void setImage(Image image) {
            this.image = image;
            if (image == null) {
                this.cachedIP = null;
            }
        }

        public ImageFontLabel getLabel() {
            return this.label;
        }

        public void setText(String string) {
            this.label.setText(string != null ? string : "");
        }

        public void setChildren(CCFChild[] cCFChildArray) {
            this.removeAll();
            this.nextID = 0;
            for (int i = 0; cCFChildArray != null && i < cCFChildArray.length; ++i) {
                if (cCFChildArray[i] == null || cCFChildArray[i].child == null) continue;
                ChildPanel childPanel = (ChildPanel)Tonto.this.wrappers.get(cCFChildArray[i]);
                if (childPanel == null) {
                    Tonto.this.wrappers.put(cCFChildArray[i], this.addChild(cCFChildArray[i], new Integer(this.nextID++)));
                    continue;
                }
                this.add((Component)childPanel, new Integer(this.nextID++));
                childPanel.refresh();
            }
        }

        public ChildPanel addChild(CCFChild cCFChild, Integer n) {
            if (cCFChild.type == 0) {
                CCFFrame cCFFrame = (CCFFrame)cCFChild.child;
                FrameBox frameBox = new FrameBox(cCFFrame.width(), cCFFrame.height(), cCFChild);
                this.add((Component)frameBox, n);
                return frameBox;
            }
            CCFButton cCFButton = (CCFButton)cCFChild.child;
            ButtonBox buttonBox = new ButtonBox(cCFButton.width(), cCFButton.height(), cCFChild);
            this.add((Component)buttonBox, n);
            return buttonBox;
        }

        public ChildPanel findChild(CCFChild cCFChild) {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (!(componentArray[i] instanceof ChildPanel)) continue;
                ChildPanel childPanel = (ChildPanel)componentArray[i];
                if (childPanel.getSource() == cCFChild) {
                    return childPanel;
                }
                if ((childPanel = childPanel.findChild(cCFChild)) == null) continue;
                return childPanel;
            }
            return null;
        }

        public void setExclude(boolean bl) {
            this.exclude = bl;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.exclude) {
                return;
            }
            Dimension dimension = this.getSize();
            if (this.image != null) {
                graphics.drawImage(this.image, 0, 0, this);
            } else if (Tonto.custom()) {
                PanelPanel panelPanel;
                CCFPanel cCFPanel;
                if (!Tonto.this.ccf.getTransparentColor().getAWTColor(true).equals(this.getBackground())) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, dimension.width, dimension.height);
                }
                if (this instanceof PanelPanel && (cCFPanel = ((PanelPanel)this).getPanel().getTemplate()) != null && (panelPanel = Tonto.this.getPanelPanel(cCFPanel)) != null) {
                    panelPanel.paint(graphics);
                }
            } else {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
            if (this.label != null && this.label.getFont().getSize() > 4) {
                this.label.setBounds(0, 0, dimension.width, dimension.height);
                this.label.paint(graphics);
            }
            super.paint(graphics);
            if (!prefSelectionLast && this.selected && !Tonto.this.hideSelection) {
                graphics.setColor(Color.red);
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getBounds().getSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        @Override
        public void select(boolean bl) {
            this.selected = true;
            if (prefSelectionLast) {
                this.refreshDeskPanel();
            } else {
                this.repaint();
            }
            if (bl) {
                this.requestFocus();
            }
        }

        @Override
        public void unselect() {
            this.selected = false;
            if (prefSelectionLast) {
                this.refreshDeskPanel();
            } else {
                this.repaint();
            }
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        private Point getPoint(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.getScale();
            point.x /= n;
            point.y /= n;
            return point;
        }

        private Point getAbsolutePoint(MouseEvent mouseEvent) {
            Point point = this.getPoint(mouseEvent);
            if (this instanceof PanelPanel) {
                return point;
            }
            for (Container container = this; container != null && !(container instanceof PanelPanel); container = container.getParent()) {
                Point point2 = ((Component)container).getLocation();
                int n = this.getScale();
                point.translate(point2.x / n, point2.y / n);
            }
            return point;
        }

        public Point getAbsoluteLocation(Component component) {
            Point point = component.getLocation();
            int n = this.getScale();
            point.x /= n;
            point.y /= n;
            for (component = component.getParent(); component != null && !(component instanceof PanelPanel); component = component.getParent()) {
                Point point2 = component.getLocation();
                point.translate(point2.x / n, point2.y / n);
            }
            return point;
        }

        public void selectDrag(MouseEvent mouseEvent) {
            Point point = this.getAbsolutePoint(mouseEvent);
            Tonto.this.setDragSelection(this.getComponentAt(this.getPoint(mouseEvent)), mouseEvent.isShiftDown());
            for (int i = 0; i < Tonto.this.multiSelect.size(); ++i) {
                ChildPanel childPanel = (ChildPanel)Tonto.this.multiSelect.get(i);
                childPanel.bounds = childPanel.getBounds();
            }
            this.controlClone(mouseEvent);
            this.offset = point;
        }

        private void controlClone(MouseEvent mouseEvent) {
            if (Tonto.this.multiSelect.size() > 1 || Tonto.this.dragSelection == null) {
                return;
            }
            if (mouseEvent.isControlDown() && Tonto.this.dragSelection instanceof Copyable && Tonto.this.dragSelection instanceof ChildPanel) {
                ChildPanel childPanel = (ChildPanel)Tonto.this.dragSelection;
                ChildPanel childPanel2 = (ChildPanel)childPanel.getParent();
                childPanel = (ChildPanel)((Copyable)((Object)childPanel)).copy();
                if (childPanel2 instanceof PanelPanel) {
                    CCFPanel cCFPanel = ((PanelPanel)childPanel2).getPanel();
                    DoNodeUpdate doNodeUpdate = new DoNodeUpdate(cCFPanel);
                    cCFPanel.addChild(childPanel.getSource());
                    childPanel2.addChild(childPanel.getSource(), new Integer(this.nextID++));
                    Tonto.this.eventObjectTop();
                    doNodeUpdate.getNewState();
                    Tonto.this.pushDo(doNodeUpdate);
                } else if (childPanel2 instanceof FrameBox) {
                    CCFFrame cCFFrame = ((FrameBox)childPanel2).getFrame();
                    DoNodeUpdate doNodeUpdate = new DoNodeUpdate(cCFFrame);
                    cCFFrame.addChild(childPanel.getSource());
                    childPanel2.addChild(childPanel.getSource(), new Integer(this.nextID++));
                    Tonto.this.eventObjectTop();
                    doNodeUpdate.getNewState();
                    Tonto.this.pushDo(doNodeUpdate);
                }
            }
        }

        public PanelPanel getRootPanel() {
            ChildPanel childPanel;
            for (childPanel = this; childPanel != null && !(childPanel instanceof PanelPanel); childPanel = (ChildPanel)childPanel.getParent()) {
            }
            return (PanelPanel)childPanel;
        }

        public void refreshDeskPanel() {
            PanelPanel panelPanel = this.getRootPanel();
            if (panelPanel != null) {
                panelPanel.refresh();
            }
        }
    }

    class DeskPanel
    extends JInternalFrame {
        private PanelPanel child;

        DeskPanel(PanelPanel panelPanel) {
            super("panel", false, true, false, true);
            this.child = panelPanel;
            Container container = this.getRootPane().getContentPane();
            container.setLayout(new GridLayout(1, 1));
            container.add(panelPanel);
            this.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                }
            });
            this.updateTitle();
            this.pack();
            this.show();
        }

        public void updateTitle() {
            CCFPanel cCFPanel = this.child.getPanel();
            CCFDevice cCFDevice = cCFPanel.getParentDevice();
            if (cCFDevice != null) {
                this.setTitle(cCFDevice.getName() + " - " + cCFPanel.getName());
            } else {
                this.setTitle("SYS - " + cCFPanel.getName());
            }
        }

        public PanelPanel getPanel() {
            return this.child;
        }

        public void refresh() {
            this.child.refresh();
            this.pack();
        }

        @Override
        public void dispose() {
            super.dispose();
            Tonto.this.updateMenuState();
            if (this.child.getPanel() != null && this.child.getPanel().isTemplate()) {
                Tonto.this.repaintAllPanels();
            }
        }
    }

    class IRGraph
    extends JComponent {
        private IRSignal code;
        private Dimension size;
        private int[] signal;
        private final int inset = 3;

        IRGraph(IRSignal iRSignal) {
            this.setSignal(iRSignal);
        }

        public void setSignal(IRSignal iRSignal) {
            this.code = iRSignal;
            if (this.code == null) {
                this.size = new Dimension(50, 40);
                this.signal = new int[0];
            } else {
                int n;
                int[] nArray = this.code.getPulseIndex().getIndexValues();
                int n2 = -1;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == 0 || n2 != -1 && nArray[i] >= n2) continue;
                    n2 = nArray[i];
                }
                IRBurst iRBurst = this.code.getRepeat();
                iRBurst.cullRepeats();
                int[] nArray2 = this.code.getIntro().getPulses();
                int[] nArray3 = iRBurst.getPulses();
                this.signal = new int[nArray2.length + nArray3.length];
                int n3 = 0;
                int n4 = 0;
                for (n = 0; n < nArray2.length; ++n) {
                    this.signal[n4] = Math.min(nArray[nArray2[n]] / n2 + 2, 25);
                    n3 += this.signal[n4++];
                }
                for (n = 0; n < nArray3.length; ++n) {
                    this.signal[n4] = Math.min(nArray[nArray3[n]] / n2 + 2, 25);
                    n3 += this.signal[n4++];
                }
                this.size = new Dimension(n3 + 6, 40);
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            if (this.code == null) {
                graphics.setColor(Color.red);
                graphics.drawString("Not a learned code format", 5, dimension.height - 5);
                return;
            }
            int n = 3;
            int n2 = 3;
            int n3 = 3;
            int n4 = dimension.height - 1 - 3;
            for (int i = 0; i < this.signal.length; ++i) {
                graphics.drawLine(n2, n3, n2, n4);
                n2 += this.signal[i];
                if (i % 2 == 0) {
                    graphics.drawLine(n, n3, n2, n3);
                } else {
                    graphics.drawLine(n, n4, n2, n4);
                }
                n = n2;
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.size;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.size;
        }
    }

    static class TimerEvent
    extends AAPanel
    implements ActionListener {
        int days;
        int time;
        CCFAction action;
        private JButton chooser = new JButton();
        private JTextField timeHour = new JTextField(2);
        private JTextField timeMin = new JTextField(2);
        private JCheckBox[] check = new JCheckBox[]{new JCheckBox("Mon"), new JCheckBox("Tue"), new JCheckBox("Wed"), new JCheckBox("Thu"), new JCheckBox("Fri"), new JCheckBox("Sat"), new JCheckBox("Sun"), new JCheckBox("Weekly")};

        TimerEvent() {
            this.chooser.setFont(Tonto.getPFont());
            this.chooser.addActionListener(this);
            this.timeHour.addActionListener(this);
            this.timeMin.addActionListener(this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(2, 4));
            for (int i = 0; i < this.check.length; ++i) {
                jPanel.add(this.check[i]);
                this.check[i].addActionListener(this);
            }
            JLabel jLabel = new JLabel("Action", 2);
            JLabel jLabel2 = new JLabel("Time", 2);
            JLabel jLabel3 = new JLabel(":", 0);
            this.define('1', jLabel, "pad=3,3,3,3;");
            this.define('2', this.chooser, "pad=3,3,3,3;wx=1;fill=b");
            this.define('3', jLabel2, "pad=3,3,3,3;");
            this.define('4', "pad=3,3,3,3;wx=1;anchor=nw");
            this.define('5', this.timeHour, "pad=2,2,2,2;");
            this.define('6', jLabel3, "pad=2,2,2,2;");
            this.define('7', this.timeMin, "pad=2,2,2,2;");
            this.define('8', jPanel, "pad=3,3,3,3;wx=1;wy=1;anchor=nw");
            this.setLayout(new String[]{"                          ", " 111 22222222222222222222 ", "                          ", " 333 44444444444444444444 ", " 3 3 4 5 6 7            4 ", " 333 44444444444444444444 ", "                          ", " 888888888888888888888888 ", "                          "});
        }

        private String padString(int n) {
            if (n < 10) {
                return " " + n;
            }
            return Integer.toString(n);
        }

        public void update(int n, int n2, CCFAction cCFAction) {
            this.chooser.setText(cCFAction != null ? cCFAction.toString() : "<no action>");
            this.timeHour.setText(this.padString(n2 / 60));
            this.timeMin.setText(this.padString(n2 % 60));
            for (int i = 0; i < 8; ++i) {
                int n3 = 1 << i;
                this.check[i].setSelected((n & n3) == n3);
            }
            this.days = n;
            this.time = n2;
            this.action = cCFAction;
        }

        int getInt(String string) {
            try {
                return Integer.parseInt(string.trim());
            }
            catch (Exception exception) {
                return 0;
            }
        }

        void update() {
            this.days = 0;
            for (int i = 0; i < 8; ++i) {
                if (!this.check[i].isSelected()) continue;
                this.days |= 1 << i;
            }
            this.time = this.getInt(this.timeHour.getText()) * 60 + this.getInt(this.timeMin.getText());
            this.update(this.days, this.time, this.action);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CCFAction cCFAction;
            AliasChoice aliasChoice;
            Object object = actionEvent.getSource();
            if (object == this.chooser && (aliasChoice = new AliasChoice(cCFAction = this.action != null ? this.action : new CCFAction())).invoke()) {
                this.action = cCFAction;
            }
            this.update();
        }
    }

    class NameFontAttr
    extends JPanel
    implements ActionListener {
        private JButton name;
        private JComboBox font;
        private JComboBox align;
        private JCheckBox wrap;
        private int mode = 0;

        NameFontAttr() {
            this.setLayout(new GridLayout(1, 2));
            this.name = UIUtils.getActionButton("foo", this);
            this.name.setFont(Tonto.getPFont());
            this.name.setHorizontalAlignment(2);
            this.font = new JComboBox<String>(new String[]{"<none>", "pronto 8", "pronto 10", "pronto 12", "pronto 14", "pronto 16", "pronto 18"});
            this.font.setEditable(false);
            this.align = new JComboBox<String>(new String[]{"Left", "Center", "Right"});
            this.align.setEditable(false);
            this.wrap = new JCheckBox("Wrap");
            this.add(new LabelBox("Name", this.name));
            this.add(new LabelBox("Font", this.font));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.name) {
                this.name.setText(Tonto.this.getProntoName(this.name.getText(), this.font.getSelectedIndex() % 2 == 0));
                Tonto.this.setCCFChanged();
            }
        }

        @Override
        public String getName() {
            return this.name.getText();
        }

        @Override
        public void setName(String string) {
            this.name.setText(string);
        }

        public CCFFont getCCFFont() {
            return CCFFont.getFont(this.font.getSelectedIndex());
        }

        public void setCCFFont(CCFFont cCFFont) {
            this.font.setSelectedIndex(cCFFont.size);
        }

        public int getAlignment() {
            switch (this.align.getSelectedIndex()) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 2: {
                    return 2;
                }
            }
            return 0;
        }

        public void setAlignment(int n) {
            switch (n) {
                case 1: {
                    this.align.setSelectedIndex(0);
                    break;
                }
                case 0: {
                    this.align.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.align.setSelectedIndex(2);
                }
            }
        }

        public boolean getWrap() {
            return this.wrap.isSelected();
        }

        public void setWrap(boolean bl) {
            this.wrap.setSelected(bl);
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            int n2 = n = Tonto.custom() ? 1 : 0;
            if (n != this.mode) {
                this.mode = n;
                this.removeAll();
                switch (this.mode) {
                    case 0: {
                        this.setLayout(new GridLayout(1, 2));
                        this.add(new LabelBox("Name", this.name));
                        this.add(new LabelBox("Font", this.font));
                        break;
                    }
                    case 1: {
                        this.setLayout(new GridLayout(1, 3));
                        this.add(new LabelBox("Name", this.name));
                        this.add(new LabelBox("Font", this.font));
                        JPanel jPanel = new JPanel();
                        jPanel.setLayout(new BorderLayout(3, 3));
                        jPanel.add("Center", this.align);
                        jPanel.add("East", this.wrap);
                        this.add(new LabelBox("Align", jPanel));
                    }
                }
            }
            super.paint(graphics);
        }
    }

    class NameAttr
    extends JPanel
    implements ActionListener {
        private JButton name;
        private JComboBox fontState;
        private ActionListener listener;

        NameAttr(ActionListener actionListener) {
            this((String)null);
            this.listener = actionListener;
        }

        NameAttr() {
            this("Name");
        }

        NameAttr(String string) {
            this.name = UIUtils.getActionButton(string, this);
            this.name.setFont(Tonto.getPFont());
            this.name.setHorizontalAlignment(2);
            this.setLayout(new BorderLayout(4, 4));
            if (string != null) {
                this.add("Center", new LabelBox(string, this.name));
            } else {
                this.add("West", new JLabel("Name"));
                this.add("Center", this.name);
            }
        }

        void setFontState(JComboBox jComboBox) {
            this.fontState = jComboBox;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.name) {
                this.name.setText(Tonto.this.getProntoName(this.name.getText(), this.fontState == null ? true : this.fontState.getSelectedIndex() % 2 == 0));
                Tonto.this.setCCFChanged();
                if (this.listener != null) {
                    this.listener.actionPerformed(actionEvent);
                }
            }
        }

        public void click() {
            this.name.doClick();
        }

        @Override
        public String getName() {
            return this.name.getText();
        }

        @Override
        public void setName(String string) {
            this.name.setEnabled(true);
            this.name.setText(string != null ? string : " ");
        }

        @Override
        public void setEnabled(boolean bl) {
            this.name.setEnabled(bl);
        }

        private Dimension fixDim(Dimension dimension) {
            dimension.width = Math.max(dimension.width, 150);
            return dimension;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.fixDim(super.getMinimumSize());
        }

        @Override
        public Dimension getPreferredSize() {
            return this.fixDim(super.getPreferredSize());
        }
    }

    static class LabelBox
    extends JPanel {
        private JComponent c;

        LabelBox(String string) {
            this(string, new JPanel());
        }

        LabelBox(String string, JComponent jComponent) {
            this.setLayout(new GridLayout(1, 1));
            this.setContent(jComponent);
            Util.setLabelBorder(string, this);
        }

        public JComponent getContent() {
            return this.c;
        }

        public void setContent(JComponent jComponent) {
            if (this.c != null) {
                this.remove(this.c);
            }
            this.c = jComponent;
            this.add(jComponent);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dimension = super.getMinimumSize();
            Dimension dimension2 = super.getMaximumSize();
            return new Dimension(dimension2.width, dimension.height);
        }
    }

    class GeomPanel
    extends AAPanel
    implements ActionListener {
        private ChildPanel cp;
        private CCFChild child;
        private ActionButton set;
        private JTextField x = new MTextField();
        private JTextField y = new MTextField();
        private JTextField w = new MTextField();
        private JTextField h = new MTextField();

        GeomPanel() {
            this(false);
        }

        GeomPanel(boolean bl) {
            JLabel jLabel = new JLabel("X");
            JLabel jLabel2 = new JLabel("Y");
            JLabel jLabel3 = new JLabel("W");
            JLabel jLabel4 = new JLabel("H");
            this.set = new ActionButton("Set"){

                @Override
                public void action() {
                    GeomPanel.this.commit();
                }
            };
            this.define('X', jLabel, "pad=2,2,2,2");
            this.define('Y', jLabel2, "pad=2,2,2,2");
            this.define('W', jLabel3, "pad=2,2,2,2");
            this.define('H', jLabel4, "pad=2,2,2,2");
            this.define('x', this.x, "pad=2,2,2,2;wx=1;fill=b");
            this.define('y', this.y, "pad=2,2,2,2;wx=1;fill=b");
            this.define('w', this.w, "pad=2,2,2,2;wx=1;fill=b");
            this.define('h', this.h, "pad=2,2,2,2;wx=1;fill=b");
            if (bl) {
                this.define('s', this.set, "pad=2,2,2,2;wx=1;fill=b");
            }
            this.setLayout(new String[]{"X x Y y W w H h s"});
            if (!bl) {
                Util.setLabelBorder("Location/Size", this);
            }
            if (bl) {
                this.x.addActionListener(this);
                this.y.addActionListener(this);
                this.w.addActionListener(this);
                this.h.addActionListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.commit();
        }

        public void setChild(ChildPanel childPanel) {
            if (childPanel == null || !(childPanel instanceof Movable)) {
                this.x.setEnabled(false);
                this.x.setText("   ");
                this.y.setEnabled(false);
                this.y.setText("   ");
                this.w.setEnabled(false);
                this.w.setText("   ");
                this.h.setEnabled(false);
                this.h.setText("   ");
                this.set.setEnabled(false);
                this.child = null;
                return;
            }
            this.cp = childPanel;
            this.child = childPanel.getSource();
            this.x.setEnabled(true);
            this.y.setEnabled(true);
            this.w.setEnabled(this.child.isResizable());
            this.h.setEnabled(this.child.isResizable());
            this.set.setEnabled(true);
            this.update();
        }

        public void update() {
            if (this.child == null) {
                return;
            }
            Dimension dimension = this.child.getSize();
            Point point = this.child.getLocation();
            this.x.setText(point.x + "");
            this.y.setText(point.y + "");
            this.w.setText(dimension.width + "");
            this.h.setText(dimension.height + "");
        }

        public void commit() {
            int n = Integer.parseInt(this.x.getText());
            int n2 = Integer.parseInt(this.y.getText());
            int n3 = Integer.parseInt(this.w.getText());
            int n4 = Integer.parseInt(this.h.getText());
            Rectangle rectangle = this.child.getBounds();
            this.cp.move(n - rectangle.x, n2 - rectangle.y, n3 - rectangle.width, n4 - rectangle.height, false);
            Tonto.this.refreshPanel(this.child.getParentPanel());
        }

        class MTextField
        extends JTextField {
            private Dimension ps;

            MTextField() {
                super(3);
            }

            @Override
            public Dimension getMinimumSize() {
                if (this.ps == null) {
                    this.ps = this.getPreferredSize();
                }
                return this.ps;
            }
        }
    }

    class ObjectPanel
    extends AAPanel
    implements ActionListener {
        private boolean apply = false;
        private Object object;
        private JLabel flabel = new JLabel("Font");
        private NameAttr name = new NameAttr(this);
        private GeomPanel geom = new GeomPanel(true);
        private JComboBox font = new JComboBox<String>(new String[]{"<none>", "pronto 8", "pronto 10", "pronto 12", "pronto 14", "pronto 16", "pronto 18"});

        ObjectPanel() {
            JPanel jPanel = new JPanel();
            this.define('F', this.flabel, "pad=3,3,2,2;fill=b;wy=1");
            this.define('f', this.font, "pad=3,3,2,2;fill=n;wy=1");
            this.define('n', this.name, "pad=3,3,2,2;fill=n;wy=1");
            this.define('p', jPanel, "pad=3,3,2,2;fill=b;wy=1;wx=1");
            this.define('g', this.geom, "pad=3,3,2,2;fill=n;wy=1");
            this.setLayout(new String[]{"F f n p g"});
            this.setObject(null);
            this.font.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (ObjectPanel.this.hasfont()) {
                        ObjectPanel.this.setFontSize(ObjectPanel.this.font.getSelectedIndex());
                    }
                }
            });
            this.name.setFontState(this.font);
            this.apply = true;
            this.setBorder(new BevelBorder(1));
        }

        public void setObject(Object object) {
            this.apply = false;
            this.object = object;
            if (object instanceof ChildPanel) {
                this.geom.setChild((ChildPanel)object);
            } else {
                this.geom.setChild(null);
            }
            if (object instanceof Namable) {
                this.name.setName(((Namable)object).getName());
            } else {
                this.name.setName("   ");
                this.name.setEnabled(false);
            }
            if (this.hasfont()) {
                this.font.setEnabled(true);
                this.font.setSelectedIndex(this.getFontSize());
            } else {
                this.font.setEnabled(false);
                this.font.setSelectedIndex(0);
            }
            this.keepFocusOnSelection();
            this.apply = true;
        }

        private void keepFocusOnSelection() {
            if (Tonto.this.dragSelection != null) {
                Tonto.this.dragSelection.requestFocus();
            }
        }

        private boolean hasfont() {
            return this.object instanceof FrameBox || this.object instanceof ButtonBox;
        }

        private int getFontSize() {
            if (this.object instanceof FrameBox) {
                return ((FrameBox)this.object).getFontSize();
            }
            if (this.object instanceof ButtonBox) {
                return ((ButtonBox)this.object).getFontSize();
            }
            return 0;
        }

        private void setFontSize(int n) {
            if (!this.apply) {
                return;
            }
            int n2 = Tonto.this.startMultiDo();
            for (int i = 0; i < Tonto.this.multiSelect.size(); ++i) {
                DoNodeUpdate doNodeUpdate;
                Object e = Tonto.this.multiSelect.get(i);
                if (e instanceof FrameBox) {
                    doNodeUpdate = new DoNodeUpdate(((FrameBox)e).getFrame());
                    ((FrameBox)e).setFontSize(n);
                    doNodeUpdate.pushDoNewState();
                }
                if (!(e instanceof ButtonBox)) continue;
                doNodeUpdate = new DoNodeUpdate(((ButtonBox)e).getButton());
                ((ButtonBox)e).setFontSize(n);
                doNodeUpdate.pushDoNewState();
            }
            this.keepFocusOnSelection();
            Tonto.this.endMultiDo(n2);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.apply) {
                return;
            }
            if (Tonto.this.multiSelect.size() > 0) {
                int n = Tonto.this.startMultiDo();
                for (int i = 0; i < Tonto.this.multiSelect.size(); ++i) {
                    Object e = Tonto.this.multiSelect.get(i);
                    if (!(e instanceof Namable)) continue;
                    DoNodeUpdate doNodeUpdate = new DoNodeUpdate(((ChildPanel)e).getSource().child);
                    ((Namable)e).setName(this.name.getName());
                    doNodeUpdate.pushDoNewState();
                }
                Tonto.this.endMultiDo(n);
            } else if (this.object instanceof Namable) {
                ((Namable)this.object).setName(this.name.getName());
            }
        }

        public void editName() {
            if (this.object instanceof Namable) {
                this.name.click();
            }
        }

        public void update() {
            this.geom.update();
            this.keepFocusOnSelection();
        }

        public void updateAll() {
            this.setObject(this.object);
            this.update();
        }
    }

    class ActionPanel
    extends JPanel
    implements ActionListener,
    MouseListener,
    MouseMotionListener,
    KeyListener {
        private JList list;
        private AAPanel left;
        private Vector listeners;
        private Vector actions = new Vector();
        private CCFActionList actionList;
        private NameAttr name;
        private boolean inDrag;
        private int dropStart;
        private int dropEnd;
        private JButton b_alias;
        private JButton b_delay;
        private JButton b_ir;
        private JButton b_beep;
        private JButton b_timer;
        private JButton b_jump;
        private JButton b_delete;
        private JButton b_clear;
        private JButton b_edit;
        private JButton b_cut;
        private JButton b_copy;
        private JButton b_paste;
        private JButton b_selall;

        ActionPanel() {
            this(false);
        }

        ActionPanel(boolean bl) {
            this.name = new NameAttr();
            this.listeners = new Vector();
            this.setLayout(new BorderLayout(5, 5));
            this.left = new AAPanel();
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            jPanel.setLayout(new GridLayout(6, 1, 2, 2));
            jPanel2.setLayout(new GridLayout(4, 1, 2, 2));
            jPanel3.setLayout(new GridLayout(3, 1, 2, 2));
            this.left.add((Component)jPanel, "x=0;y=0;wx=1;wy=0;fill=b;pad=2,2,2,2;anchor=n");
            this.left.add((Component)new X(), "x=0;y=1;wx=1;wy=1;fill=b;pad=2,2,2,2;anchor=n");
            this.left.add((Component)jPanel2, "x=0;y=2;wx=1;wy=0;fill=b;pad=2,2,2,2;anchor=c");
            this.left.add((Component)new X(), "x=0;y=3;wx=1;wy=1;fill=b;pad=2,2,2,2;anchor=n");
            this.left.add((Component)jPanel3, "x=0;y=4;wx=1;wy=0;fill=b;pad=2,2,2,2;anchor=n");
            this.b_alias = Tonto.this.newButton("Alias", this, 76);
            this.b_delay = Tonto.this.newButton("Delay", this, 68);
            this.b_ir = Tonto.this.newButton("IR", this, 73);
            this.b_beep = Tonto.this.newButton("Beep", this, 66);
            this.b_timer = Tonto.this.newButton("Timer", this, 84);
            this.b_jump = Tonto.this.newButton("Jump", this, 74);
            this.b_cut = Tonto.this.newButton("Cut", this, 88);
            this.b_copy = Tonto.this.newButton("Copy", this, 67);
            this.b_paste = Tonto.this.newButton("Paste", this, 86);
            this.b_delete = Tonto.this.newButton("Delete", this, 69);
            this.b_edit = Tonto.this.newButton("Edit", this, -1);
            this.b_selall = Tonto.this.newButton("Select All", this, 65);
            this.b_clear = Tonto.this.newButton("Delete All", this, 82);
            jPanel.add(this.b_alias);
            jPanel.add(this.b_delay);
            jPanel.add(this.b_ir);
            jPanel.add(this.b_beep);
            jPanel.add(this.b_timer);
            jPanel.add(this.b_jump);
            jPanel2.add(this.b_cut);
            jPanel2.add(this.b_copy);
            jPanel2.add(this.b_paste);
            jPanel2.add(this.b_delete);
            jPanel3.add(this.b_edit);
            jPanel3.add(this.b_selall);
            jPanel3.add(this.b_clear);
            this.b_edit.setEnabled(false);
            this.b_delete.setEnabled(false);
            this.b_cut.setEnabled(false);
            this.b_copy.setEnabled(false);
            this.b_paste.setEnabled(false);
            this.b_selall.setEnabled(false);
            this.list = new JList(new ListModel(){

                @Override
                public void addListDataListener(ListDataListener listDataListener) {
                    ActionPanel.this.listeners.addElement(listDataListener);
                }

                public Object getElementAt(int n) {
                    return n >= 0 && n < ActionPanel.this.actions.size() ? ActionPanel.this.actions.elementAt(n) : null;
                }

                @Override
                public int getSize() {
                    ActionPanel.this.b_clear.setEnabled(ActionPanel.this.actions.size() > 0);
                    return ActionPanel.this.actions.size();
                }

                @Override
                public void removeListDataListener(ListDataListener listDataListener) {
                    ActionPanel.this.listeners.removeElement(listDataListener);
                }
            });
            this.list.setBorder(new BevelBorder(1));
            this.list.setFont(Tonto.getPFont());
            this.list.addMouseListener(this);
            this.list.addMouseMotionListener(this);
            this.list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JComponent jComponent = (JComponent)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (ActionPanel.this.inDrag && bl) {
                        jComponent.setBorder(border);
                    }
                    return jComponent;
                }
            });
            this.list.addKeyListener(this);
            this.list.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    ActionPanel.this.updateOptions();
                }
            });
            this.add("West", this.left);
            this.add("Center", new JScrollPane(this.list, 20, 31));
            if (bl) {
                this.add("South", this.name);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                this.deleteItems();
            } else if (keyEvent.getKeyCode() == 65 && keyEvent.isControlDown()) {
                this.selectAll();
            } else if (keyEvent.getKeyCode() == 88 && keyEvent.isControlDown()) {
                this.cut();
            } else if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                this.copy();
            } else if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown()) {
                this.paste();
            }
        }

        public void selectAll() {
            this.list.setSelectionInterval(0, this.actions.size() - 1);
        }

        public void cut() {
            this.copy();
            this.deleteItems();
        }

        public void copy() {
            Object[] objectArray = this.list.getSelectedValues();
            if (objectArray != null) {
                CCFAction[] cCFActionArray = new CCFAction[objectArray.length];
                for (int i = 0; i < cCFActionArray.length; ++i) {
                    cCFActionArray[i] = (CCFAction)((CCFAction)objectArray[i]).getClone();
                }
                Tonto.this.setClipboard(cCFActionArray);
            }
            this.updateOptions();
        }

        public void paste() {
            if (!(clipboard instanceof CCFAction) && !(clipboard instanceof CCFAction[])) {
                return;
            }
            if (clipboard instanceof CCFAction[]) {
                CCFAction[] cCFActionArray = (CCFAction[])clipboard;
                for (int i = 0; i < cCFActionArray.length; ++i) {
                    if (!(cCFActionArray[i] instanceof CCFAction)) continue;
                    this.appendAction((CCFAction)cCFActionArray[i].getClone(), false);
                }
            } else {
                this.appendAction((CCFAction)((CCFAction)clipboard).getClone(), false);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object e;
            if (mouseEvent.getClickCount() == 2 && (e = this.list.getSelectedValue()) instanceof CCFAction) {
                this.editAction((CCFAction)e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.inDrag = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.inDrag) {
                this.inDrag = true;
                this.dropStart = this.list.getSelectedIndex();
            } else {
                this.dropEnd = this.list.getSelectedIndex();
                if (this.dropEnd >= 0 && Math.abs(this.dropEnd - this.dropStart) == 1) {
                    Object e = this.actions.elementAt(this.dropEnd);
                    this.actions.setElementAt(this.actions.elementAt(this.dropStart), this.dropEnd);
                    this.actions.setElementAt(e, this.dropStart);
                    this.dropStart = this.dropEnd;
                    this.sendDataEvent(this.actions.size(), this.actions.size());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object == this.b_cut) {
                this.cut();
            } else if (object == this.b_copy) {
                this.copy();
            } else if (object == this.b_paste) {
                this.paste();
            } else if (object == this.b_selall) {
                this.selectAll();
            } else if (string.equals("Delete")) {
                this.deleteItems();
            } else if (string.equals("IR")) {
                this.appendAction(new ActionIRCode(new CCFIRCode(Tonto.this.ccf.header())));
            } else if (string.equals("Delay")) {
                this.appendAction(new ActionDelay(100));
            } else if (string.equals("Beep")) {
                this.appendAction(new ActionBeep(300, 5000, 90));
            } else if (string.equals("Alias")) {
                this.appendAction(new CCFAction(6, null, null));
            } else if (string.equals("Jump")) {
                this.appendAction(new ActionJumpPanel(null, Tonto.header().isNewMarantz()));
            } else if (string.equals("Timer")) {
                this.appendAction(new ActionTimer(new CCFTimer()));
            } else if (string.equals("Delete All")) {
                if (Tonto.confirmDialog("Delete All Actions", "Are you sure you want to delete all actions?")) {
                    this.clearActions();
                }
            } else if (string.equals("Edit")) {
                this.editAction((CCFAction)this.list.getSelectedValue());
                this.sendDataEvent(this.actions.size(), this.actions.size());
            }
        }

        @Override
        public String getName() {
            return this.name.getName();
        }

        public void update(CCFActionList cCFActionList) {
            this.update(cCFActionList, null);
        }

        public void update(CCFActionList cCFActionList, String string) {
            if (cCFActionList == null) {
                cCFActionList = new CCFActionList();
            }
            this.name.setName(string);
            if (Tonto.this.ccf.header().isMarantz()) {
                this.b_beep.setEnabled(false);
                this.b_timer.setEnabled(false);
            } else {
                this.b_beep.setEnabled(true);
                this.b_timer.setEnabled(true);
            }
            this.actionList = cCFActionList;
            int n = this.actions.size();
            if (cCFActionList != null) {
                this.actions = new Vector();
                CCFAction[] cCFActionArray = cCFActionList.getActions();
                if (cCFActionArray != null) {
                    for (int i = 0; i < cCFActionArray.length; ++i) {
                        this.actions.addElement(cCFActionArray[i]);
                    }
                }
            }
            int n2 = this.actions.size();
            this.sendDataEvent(n, n2);
            this.updateOptions();
        }

        public CCFActionList save() {
            Object[] objectArray = new CCFAction[this.actions.size()];
            this.actions.copyInto(objectArray);
            this.actionList.setActions((CCFAction[])objectArray);
            if (objectArray.length > 0) {
                return this.actionList;
            }
            return null;
        }

        private boolean hasJump() {
            for (int i = 0; i < this.actions.size(); ++i) {
                if (!(this.actions.get(i) instanceof ActionJumpPanel)) continue;
                return true;
            }
            return false;
        }

        private void updateOptions() {
            this.b_cut.setEnabled(this.list.getSelectedValue() != null);
            this.b_copy.setEnabled(this.list.getSelectedValue() != null);
            this.b_paste.setEnabled(clipboard instanceof CCFAction || clipboard instanceof CCFAction[]);
            this.b_selall.setEnabled(this.actions.size() > 1);
            this.b_edit.setEnabled(this.list.getSelectedValue() != null && this.list.getSelectedValues().length == 1);
            this.b_delete.setEnabled(this.list.getSelectedValue() != null);
            this.b_jump.setEnabled(Tonto.this.ccf.header().isMarantz() || Tonto.custom() || !this.hasJump());
        }

        private void deleteItems() {
            int n;
            int n2 = this.actions.size();
            int n3 = this.list.getSelectedIndex();
            Object[] objectArray = this.list.getSelectedValues();
            for (n = 0; objectArray != null && n < objectArray.length; ++n) {
                this.actions.remove(objectArray[n]);
            }
            n = this.actions.size();
            this.sendDataEvent(n2, n);
            this.list.setSelectedIndex(Math.max(n3 - 1, 0));
        }

        public void clearActions() {
            int n = this.actions.size();
            this.actions.setSize(0);
            this.sendDataEvent(0, n);
        }

        public void appendAction(CCFAction cCFAction) {
            this.appendAction(cCFAction, true);
        }

        public void appendAction(CCFAction cCFAction, boolean bl) {
            if (!bl || this.editAction(cCFAction)) {
                this.actions.addElement(cCFAction);
                this.sendDataEvent(this.actions.size() - 1, this.actions.size());
                this.list.setSelectedIndex(this.actions.size() - 1);
            }
        }

        private void sendDataEvent(int n, int n2) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ListDataListener listDataListener = (ListDataListener)enumeration.nextElement();
                listDataListener.intervalRemoved(new ListDataEvent(this, 2, 0, n));
                listDataListener.contentsChanged(new ListDataEvent(this, 0, 0, n2));
            }
        }

        public boolean editAction(CCFAction cCFAction) {
            StringValueDialog stringValueDialog = null;
            switch (cCFAction.type) {
                case 8: {
                    BeepValueDialog beepValueDialog = new BeepValueDialog((ActionBeep)cCFAction);
                    if (beepValueDialog.invoke()) {
                        cCFAction.p2 = beepValueDialog.getBeepValue();
                        return true;
                    }
                    return false;
                }
                case 4: {
                    stringValueDialog = new StringValueDialog("Delay", Integer.toString(cCFAction.p2), 0);
                    if (stringValueDialog.invoke()) {
                        cCFAction.p2 = Integer.parseInt(stringValueDialog.getValue());
                        return true;
                    }
                    return false;
                }
                case 1: {
                    IRValueDialog iRValueDialog;
                    CCFIRCode cCFIRCode = (CCFIRCode)cCFAction.action2;
                    if (cCFIRCode == null) {
                        cCFIRCode = new CCFIRCode(Tonto.this.ccf.header());
                    }
                    return (iRValueDialog = new IRValueDialog(cCFIRCode)).invoke();
                }
                case 3: 
                case 9: {
                    JumpChoice jumpChoice = new JumpChoice(cCFAction);
                    if (jumpChoice.invoke()) {
                        return jumpChoice.setActionValue(cCFAction);
                    }
                    return false;
                }
                case 2: 
                case 5: 
                case 6: {
                    return new AliasChoice(cCFAction).invoke(this.actionList);
                }
                case 7: {
                    if (cCFAction instanceof ActionTimer) {
                        ActionTimer actionTimer = (ActionTimer)cCFAction;
                        if (timerEditor.invoke(actionTimer.getTimer())) {
                            actionTimer.setTimer(timerEditor.getTimer());
                            return true;
                        }
                    }
                    return false;
                }
            }
            return false;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(300, 350);
        }

        class X
        extends JPanel {
            private Dimension d = new Dimension(20, 20);

            X() {
            }

            @Override
            public Dimension getMinimumSize() {
                return this.d;
            }

            @Override
            public Dimension getPreferredSize() {
                return this.d;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.d;
            }
        }
    }

    class IconButton
    extends JButton
    implements ActionListener {
        private CCFIcon icon;
        private CCFIcon oldIcon;
        private Icon cached;
        private Dimension iconSize;

        IconButton() {
            this.addActionListener(this);
        }

        IconButton(CCFIcon cCFIcon) {
            this.initButton(cCFIcon);
        }

        public void initButton(CCFIcon cCFIcon) {
            this.setCCFIcon(cCFIcon);
        }

        public CCFIcon getCCFIcon() {
            return this.icon;
        }

        public void setCCFIcon(CCFIcon cCFIcon) {
            this.icon = cCFIcon;
            if (cCFIcon == null) {
                this.setIcon(null);
            } else {
                this.cached = cCFIcon.getIcon(this);
                this.setIcon(this.cached);
            }
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            return new Dimension(Math.max(50, dimension.width), Math.max(30, dimension.height));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        public void revert() {
            this.setCCFIcon(this.oldIcon);
        }

        private boolean fit(Dimension dimension, Dimension dimension2) {
            return dimension.width <= dimension2.width && dimension.height <= dimension2.height;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.icon != null && this.cached != this.icon.getIcon(this)) {
                this.cached = this.icon.getIcon(this);
                this.setIcon(this.cached);
            }
            super.paint(graphics);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Tonto.this.icons.invoke(this.icon)) {
                this.setCCFIcon(Tonto.this.icons.getSelected());
            }
        }
    }

    class ColorChooser
    extends JPanel {
        private ColorPicker fg = new ColorPicker();
        private ColorPicker bg = new ColorPicker();
        private JLabel lfg = new JLabel("Text", 0);
        private JLabel lbg = new JLabel("Background", 0);
        private boolean hasColor;

        ColorChooser() {
            this.setLayout(new GridLayout(2, 2, 3, 2));
            this.add(this.lfg);
            this.add(this.lbg);
            this.add(this.fg);
            this.add(this.bg);
        }

        public void setWebSafe(boolean bl) {
            this.fg.setWebSafe(bl);
            this.bg.setWebSafe(bl);
        }

        public CCFColor getFG() {
            return this.fg.getColor();
        }

        public CCFColor getBG() {
            return this.bg.getColor();
        }

        public void setColors(int n) {
            boolean bl = Tonto.color();
            this.fg.setColor(CCFColor.getForeground(n, bl), bl);
            this.bg.setColor(CCFColor.getBackground(n, bl), bl);
        }

        public int getColors() {
            return CCFColor.getComposite(this.fg.getColor(), this.bg.getColor(), Tonto.color());
        }
    }

    class MyTextArea
    extends JTextArea {
        MyTextArea(int n, int n2) {
            super(n, n2);
            if (Util.onMacintosh()) {
                this.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                        if (keyEvent.getModifiers() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
                            if (keyEvent.getKeyCode() == 88) {
                                ((JTextArea)keyEvent.getSource()).cut();
                            } else if (keyEvent.getKeyCode() == 67) {
                                ((JTextArea)keyEvent.getSource()).copy();
                            } else if (keyEvent.getKeyCode() == 86) {
                                ((JTextArea)keyEvent.getSource()).paste();
                            } else if (keyEvent.getKeyCode() == 65) {
                                ((JTextArea)keyEvent.getSource()).selectAll();
                            }
                        }
                    }
                });
            }
        }
    }

    class MyLabel
    extends JLabel
    implements ChangeListener {
        Dimension d;

        MyLabel(String string) {
            super(string);
            this.setBorder(new BevelBorder(1));
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setText(Integer.toString(((JSlider)changeEvent.getSource()).getValue()));
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.d == null) {
                this.d = super.getPreferredSize();
            }
            return this.d;
        }
    }

    class MyIconButton
    extends IconButton {
        private StackedDialog dialog;
        private int width;
        private int height;

        MyIconButton(StackedDialog stackedDialog) {
            this(stackedDialog, 100, 100);
        }

        MyIconButton(StackedDialog stackedDialog, int n, int n2) {
            this.dialog = stackedDialog;
            this.width = n;
            this.height = n2;
        }

        @Override
        public Dimension getMinimumSize() {
            return Tonto.this.max(super.getMinimumSize(), this.width, this.height);
        }

        @Override
        public Dimension getPreferredSize() {
            return Tonto.this.max(super.getPreferredSize(), this.width, this.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return Tonto.this.max(super.getMaximumSize(), this.width, this.height);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            super.actionPerformed(actionEvent);
            this.dialog.repack();
        }
    }

    static class TextRCMenu
    implements MouseListener,
    ActionListener {
        private JPopupMenu pop = new JPopupMenu();
        private JMenuItem cut = new JMenuItem("Cut");
        private JMenuItem copy = new JMenuItem("Copy");
        private JMenuItem paste = new JMenuItem("Paste");
        private JMenuItem selall = new JMenuItem("Select All");
        private JTextComponent text;

        TextRCMenu(JTextComponent jTextComponent) {
            this.pop.add(this.cut);
            this.pop.add(this.copy);
            this.pop.add(this.paste);
            this.pop.addSeparator();
            this.pop.add(this.selall);
            this.cut.addActionListener(this);
            this.copy.addActionListener(this);
            this.paste.addActionListener(this);
            this.selall.addActionListener(this);
            this.text = jTextComponent;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.cut) {
                this.text.cut();
            } else if (actionEvent.getSource() == this.copy) {
                this.text.copy();
            } else if (actionEvent.getSource() == this.paste) {
                this.text.paste();
            } else if (actionEvent.getSource() == this.selall) {
                this.text.selectAll();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (Tonto.isRightClick(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                this.pop.show((Component)mouseEvent.getSource(), point.x, point.y);
            }
        }
    }

    class CCFTreeSystemFolder
    extends TreeFolder
    implements Configurable {
        CCFTreeSystemFolder(TreeFolder treeFolder) {
            super(treeFolder, null);
        }

        @Override
        public void refresh() {
            if (Tonto.custom()) {
                this.setContents(new Object[]{new CCFTreeSystemProperty(), new CCFTreePanel(this, Tonto.this.ccf.getMasterTemplate()), new CCFTreePanel(this, Tonto.this.ccf.getDeviceTemplate()), new CCFTreePanel(this, Tonto.this.ccf.getMacroTemplate())}, true);
            } else {
                this.setContents(new Object[]{new CCFTreeSystemProperty(), new CCFTreePanel(this, Tonto.this.ccf.getMacroPanel())}, true);
            }
        }

        @Override
        public void editProperties() {
            Tonto.this.editSystemProperties();
        }

        public String toString() {
            return "System";
        }
    }

    class CCFTreePanel
    extends TreeNode
    implements Deletable,
    ButtonHost,
    FrameHost,
    Configurable,
    Copyable,
    Namable,
    Pastable {
        private CCFPanel panel;

        CCFTreePanel(CCFTreeSystemFolder cCFTreeSystemFolder, CCFPanel cCFPanel) {
            super(cCFTreeSystemFolder);
            this.panel = cCFPanel;
        }

        CCFTreePanel(CCFTreeDevice cCFTreeDevice, CCFPanel cCFPanel) {
            super(cCFTreeDevice);
            this.panel = cCFPanel;
        }

        boolean isPanelShowing() {
            return Tonto.this.isPanelShowing(this.panel);
        }

        void setPanel(CCFPanel cCFPanel) {
            this.panel = cCFPanel;
            this.refresh();
        }

        CCFPanel getPanel() {
            return this.panel;
        }

        @Override
        public void refresh() {
            ((TreeFolder)this.getParent()).fireRereadContents();
            Tonto.this.tree.setSelectionPath(this.getTreePath());
        }

        @Override
        public String getName() {
            return this.panel.getName();
        }

        @Override
        public void setName(String string) {
            this.panel.setName(string);
            DeskPanel deskPanel = (DeskPanel)Tonto.this.panels.get(this.panel);
            if (deskPanel != null) {
                deskPanel.updateTitle();
            }
            this.refresh();
            Tonto.this.setTreeSelection(this.getTreePath());
        }

        @Override
        public void addButton() {
            Tonto.this.addNewButton(this.panel);
        }

        @Override
        public Object copy() {
            return this.panel.getClone();
        }

        @Override
        public void addFrame() {
            Tonto.this.addNewFrame(this.panel);
        }

        @Override
        public void delete() {
            if (this.panel != null && this.panel.isTemplate()) {
                return;
            }
            Tonto.this.pushDo(new MultiDo(new Doable[]{new DoDeletePanel(this.panel)}));
        }

        @Override
        public boolean acceptPaste(Object object) {
            return object instanceof ButtonBox || object instanceof FrameBox;
        }

        @Override
        public void paste(Object object) {
            if (object instanceof ButtonBox || object instanceof FrameBox) {
                DoNodeUpdate doNodeUpdate = new DoNodeUpdate(this.panel);
                CCFChild cCFChild = ((ChildPanel)object).getSource();
                this.panel.addChild(cCFChild);
                Tonto.this.icons.addChild(cCFChild);
                doNodeUpdate.getNewState();
                Tonto.this.pushDo(doNodeUpdate);
                Tonto.this.setDragSelectionWithFocus(Tonto.this.getChildPanel(cCFChild));
            }
        }

        @Override
        public void editProperties() {
            Tonto.this.panelProps.updatePanel(this.panel);
        }

        public String toString() {
            return this.panel.toString();
        }
    }

    class CCFTreeDeviceProperty
    implements TreeProperties {
        CCFTreeDeviceProperty() {
        }

        public String toString() {
            return "Properties";
        }
    }

    class CCFTreeSystemProperty
    implements TreeProperties {
        CCFTreeSystemProperty() {
        }

        public String toString() {
            return "Properties";
        }
    }

    class CCFTreeDevice
    extends TreeFolder
    implements Configurable,
    Deletable,
    Pastable,
    Copyable,
    Namable {
        private CCFDevice dev;
        private CCFTreeDeviceFolder folder;

        CCFTreeDevice(CCFTreeDeviceFolder cCFTreeDeviceFolder, CCFDevice cCFDevice) {
            super(cCFTreeDeviceFolder);
            this.folder = cCFTreeDeviceFolder;
            this.dev = cCFDevice;
            this.readContents(false);
        }

        private CCFDevice getDevice() {
            return this.dev;
        }

        @Override
        public void refresh() {
            this.readContents();
        }

        private void readContents() {
            this.readContents(true);
        }

        private void readContents(boolean bl) {
            Vector<Object> vector = new Vector<Object>();
            if (prefShowDeviceProps) {
                vector.addElement(new CCFTreeDeviceProperty());
            }
            for (CCFPanel cCFPanel = this.dev.getFirstPanel(); cCFPanel != null; cCFPanel = cCFPanel.getNextPanel()) {
                vector.addElement(cCFPanel);
            }
            this.setContents(vector.toArray(new Object[vector.size()]), bl);
        }

        @Override
        public String getName() {
            return this.dev.getName();
        }

        @Override
        public void setName(String string) {
            this.dev.setName(string);
            Tonto.this.updateTreeSelection();
        }

        @Override
        public void editProperties() {
            Tonto.this.deviceProps.updateDevice(this.dev);
        }

        public void newPanel() {
            Tonto.this.pushDo(new DoAddPanel(this, this.dev, this.dev.createPanel("NewPanel"), true));
        }

        @Override
        public Object copy() {
            return this.dev.getClone();
        }

        @Override
        public Object getReplacement(Object object) {
            if (object instanceof CCFPanel) {
                CCFTreePanel cCFTreePanel = (CCFTreePanel)Tonto.this.wrappers.get(object);
                if (cCFTreePanel == null) {
                    cCFTreePanel = new CCFTreePanel(this, (CCFPanel)object);
                    Tonto.this.wrappers.put(object, cCFTreePanel);
                } else {
                    cCFTreePanel.setParent(this);
                }
                return cCFTreePanel;
            }
            return object;
        }

        @Override
        public void delete() {
            Tonto.this.pushDo(new MultiDo(new Doable[]{new DoDeleteDevice(this.dev, this.folder)}));
        }

        @Override
        public boolean acceptPaste(Object object) {
            return object instanceof CCFPanel || object instanceof CCFTreePanel;
        }

        @Override
        public void paste(Object object) {
            if (object instanceof CCFPanel) {
                Tonto.this.pushDo(new DoAddPanel(this, this.dev, (CCFPanel)object, false));
            } else if (object instanceof CCFTreePanel) {
                Tonto.this.pushDo(new DoAddPanel(this, this.dev, ((CCFTreePanel)object).getPanel(), false));
            }
        }

        public String toString() {
            return this.dev.name;
        }
    }

    class CCFTreeDeviceFolder
    extends TreeFolder
    implements Pastable {
        private String name;
        private int root;

        CCFTreeDeviceFolder(int n, TreeFolder treeFolder, String string) {
            super(treeFolder);
            this.root = n;
            this.name = string;
        }

        public CCFDevice getRootDevice() {
            switch (this.root) {
                case 1: {
                    return Tonto.this.ccf.getFirstHomeDevice();
                }
                case 2: {
                    return Tonto.this.ccf.getFirstDevice();
                }
                case 3: {
                    return Tonto.this.ccf.getFirstMacroDevice();
                }
            }
            return null;
        }

        public void setRootDevice(CCFDevice cCFDevice) {
            switch (this.root) {
                case 1: {
                    Tonto.this.ccf.setFirstHomeDevice(cCFDevice);
                    break;
                }
                case 2: {
                    Tonto.this.ccf.setFirstDevice(cCFDevice);
                    break;
                }
                case 3: {
                    Tonto.this.ccf.setFirstMacroDevice(cCFDevice);
                }
            }
            Vector<CCFDevice> vector = new Vector<CCFDevice>();
            CCFDevice cCFDevice2 = cCFDevice;
            while (cCFDevice2 != null) {
                vector.addElement(cCFDevice2);
                cCFDevice2 = cCFDevice2.next;
            }
            this.setContents(vector.toArray(new CCFDevice[vector.size()]), true);
        }

        public void newDevice() {
            CCFDevice cCFDevice = Tonto.this.ccf.createDevice();
            cCFDevice.setName("NewDevice");
            Tonto.this.pushDo(new DoAddDevice(cCFDevice));
        }

        void addDevice(CCFDevice cCFDevice) {
            CCFDevice cCFDevice2 = this.getRootDevice();
            if (cCFDevice2 == null) {
                this.setRootDevice(cCFDevice);
            } else {
                cCFDevice2.appendDevice(cCFDevice);
            }
            this.refresh();
        }

        @Override
        public void refresh() {
            Vector<TreePath> vector = new Vector<TreePath>();
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                TreeNode treeNode = (TreeNode)this.getChild(i);
                TreePath treePath = treeNode.getTreePath();
                int n2 = Tonto.this.tree.getRowForPath(treePath);
                if (!Tonto.this.tree.isExpanded(n2)) continue;
                vector.add(treePath);
            }
            this.setRootDevice(this.getRootDevice());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Tonto.this.tree.expandPath((TreePath)enumeration.nextElement());
            }
        }

        @Override
        public boolean acceptPaste(Object object) {
            return object instanceof CCFDevice || object instanceof CCFTreeDevice;
        }

        @Override
        public void paste(Object object) {
            if (object instanceof CCFDevice) {
                Tonto.this.pushDo(new DoAddDevice((CCFDevice)object));
            } else if (object instanceof CCFTreeDevice) {
                Tonto.this.pushDo(new DoAddDevice(((CCFTreeDevice)object).getDevice()));
            }
        }

        @Override
        public Object getReplacement(Object object) {
            if (object instanceof CCFDevice) {
                CCFTreeDevice cCFTreeDevice = (CCFTreeDevice)Tonto.this.wrappers.get(object);
                if (cCFTreeDevice == null) {
                    cCFTreeDevice = new CCFTreeDevice(this, (CCFDevice)object);
                    Tonto.this.wrappers.put(object, cCFTreeDevice);
                } else {
                    cCFTreeDevice.setParent(this);
                }
                return cCFTreeDevice;
            }
            return object;
        }

        public String toString() {
            return this.name;
        }

        class DoAddDevice
        implements Doable {
            private CCFDevice device;

            DoAddDevice(CCFDevice cCFDevice) {
                this.device = cCFDevice;
            }

            @Override
            public void doIt() {
                CCFTreeDeviceFolder.this.addDevice(this.device);
            }

            @Override
            public void undoIt() {
                this.device.delete();
                CCFTreeDeviceFolder.this.refresh();
            }
        }
    }

    class CCFTreeRoot
    extends TreeFolder {
        CCFTreeSystemFolder sys;
        CCFTreeDeviceFolder home;
        CCFTreeDeviceFolder devices;
        CCFTreeDeviceFolder macros;

        CCFTreeRoot() {
            super(null);
            this.sys = new CCFTreeSystemFolder(this);
            this.home = new CCFTreeDeviceFolder(1, this, "Home");
            this.devices = new CCFTreeDeviceFolder(2, this, "Devices");
            this.macros = new CCFTreeDeviceFolder(3, this, "Macros");
            this.setContents(new Object[]{this.sys, this.home, this.devices, this.macros});
        }

        @Override
        public void refresh() {
            if (Tonto.this.ccf != null) {
                this.sys.refresh();
                this.home.refresh();
                this.devices.refresh();
                this.macros.refresh();
                Tonto.this.tree.expandPath(new TreePath(new Object[]{this, this.home}));
                Tonto.this.tree.expandPath(new TreePath(new Object[]{this, this.devices}));
                Tonto.this.tree.expandPath(new TreePath(new Object[]{this, this.macros}));
            }
        }
    }

    abstract class TreeFolder
    extends TreeNode {
        private Object[] contents;
        private Hashtable cache;

        TreeFolder(TreeFolder treeFolder) {
            this(treeFolder, null);
        }

        TreeFolder(TreeFolder treeFolder, Object[] objectArray) {
            super(treeFolder);
            this.contents = objectArray;
            this.cache = new Hashtable();
        }

        @Override
        public abstract void refresh();

        public void setContents(Object[] objectArray) {
            this.setContents(objectArray, false);
        }

        public void setContents(Object[] objectArray, boolean bl) {
            this.contents = objectArray;
            this.cache = new Hashtable();
            if (bl) {
                this.fireRereadContents();
            }
        }

        public void fireRereadContents() {
            Vector<TreeFolder> vector = new Vector<TreeFolder>();
            for (TreeNode treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
                vector.addElement((TreeFolder)treeNode);
            }
            Object[] objectArray = new Object[vector.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = vector.elementAt(objectArray.length - i - 1);
            }
            Tonto.this.model.fireTreeChanged(new TreeModelEvent((Object)this, objectArray));
        }

        public int getChildCount() {
            return this.contents != null ? this.contents.length : 0;
        }

        public Object getChild(int n) {
            return this.getCachedReplacement(this.contents[n]);
        }

        public int getIndexOf(Object object) {
            for (int i = 0; i < this.contents.length; ++i) {
                if (!this.getChild(i).equals(object)) continue;
                return i;
            }
            return -1;
        }

        public Object getReplacement(Object object) {
            return object;
        }

        public Object getCachedReplacement(Object object) {
            Object object2 = this.cache.get(object);
            if (object2 != null) {
                return object2;
            }
            object2 = this.getReplacement(object);
            this.cache.put(object, object2);
            return object2;
        }
    }

    abstract class TreeNode
    implements Parental {
        private TreeNode parent;

        TreeNode(TreeNode treeNode) {
            this.parent = treeNode;
        }

        @Override
        public Object getMyParent() {
            return this.getParent();
        }

        public void setParent(TreeNode treeNode) {
            this.parent = treeNode;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public abstract void refresh();

        public TreePath getTreePath() {
            Vector<TreeNode> vector = new Vector<TreeNode>();
            TreeNode treeNode = this;
            while (treeNode != null) {
                vector.add(treeNode);
                treeNode = treeNode.parent;
            }
            Object[] objectArray = new Object[vector.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = vector.elementAt(objectArray.length - i - 1);
            }
            return new TreePath(objectArray);
        }
    }

    class JTModel
    implements TreeModel {
        private Vector listeners = new Vector();
        private CCFTreeRoot root;

        JTModel() {
            this.root = new CCFTreeRoot();
        }

        public void refresh() {
            this.root.refresh();
        }

        public void fireTreeChanged(TreeModelEvent treeModelEvent) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = (TreeModelListener)enumeration.nextElement();
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.addElement(treeModelListener);
        }

        @Override
        public Object getChild(Object object, int n) {
            if (object instanceof TreeFolder) {
                return ((TreeFolder)object).getChild(n);
            }
            return null;
        }

        @Override
        public int getChildCount(Object object) {
            if (object instanceof TreeFolder) {
                return ((TreeFolder)object).getChildCount();
            }
            return 0;
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            if (object instanceof TreeFolder) {
                return ((TreeFolder)object).getIndexOf(object2);
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object object) {
            return !(object instanceof TreeFolder);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.listeners.removeElement(treeModelListener);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
            debug.log(2, "valueForPathChanged: " + treePath + " " + object);
        }
    }

    static class MenuAction
    implements ActionListener,
    MenuKeyListener {
        private int cmd;

        MenuAction(int n) {
            this.cmd = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tonto.sendEvent(this.cmd);
        }

        @Override
        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
        }

        @Override
        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        @Override
        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }
    }

    class ButtonAction
    extends AbstractAction {
        private JButton button;

        ButtonAction(JButton jButton) {
            this.button = jButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.button.doClick();
        }
    }

    static class DialogThread
    extends Thread {
        protected Throwable ex;
        protected StackedDialog dialog;

        DialogThread(StackedDialog stackedDialog) {
            this.dialog = stackedDialog;
        }

        @Override
        public void run() {
            try {
                this.body();
            }
            catch (Throwable throwable) {
                this.ex = throwable;
            }
            this.dialog.dispose();
        }

        public void body() throws Exception {
        }

        public void checkError() throws Throwable {
            this.start();
            this.dialog.show();
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }

    class TabMaster {
        private CCFDevice device;
        private CCFPanel panel;
        private Vector newPanels = new Vector();
        private Vector newButtons = new Vector();

        TabMaster(CCFPanel cCFPanel) {
            this.panel = cCFPanel;
            this.device = this.panel.getParentDevice();
            int n = 1;
            int n2 = Tonto.this.startMultiDo();
            try {
                Object object;
                CCFTreeDevice cCFTreeDevice = (CCFTreeDevice)Tonto.this.getTreeWrapper(this.device);
                while ((object = this.processTabPanel(this.panel, n)) != null) {
                    this.newPanels.add(object);
                    ((CCFPanel)object).setName("Tab-" + n++);
                    Tonto.this.pushDo(new DoAddPanel(cCFTreeDevice, this.device, (CCFPanel)object, false));
                }
                object = this.newButtons.elements();
                while (object.hasMoreElements()) {
                    CCFButton cCFButton = (CCFButton)object.nextElement();
                    n = Integer.parseInt(cCFButton.getIDTag().substring(4)) - 1;
                    if (n >= this.newPanels.size()) continue;
                    cCFButton.appendAction(new ActionJumpPanel((CCFPanel)this.newPanels.get(n), Tonto.header().isMarantz()));
                }
                Tonto.infoDialog("Created " + this.newPanels.size() + " new panels in Device '" + this.device.getName() + "'");
            }
            catch (Exception exception) {
                Tonto.debug(exception);
            }
            Tonto.this.endMultiDo(n2);
        }

        private CCFPanel processTabPanel(CCFPanel cCFPanel, int n) {
            CCFPanel cCFPanel2 = (CCFPanel)cCFPanel.getClone();
            if (this.processTabChildren(cCFPanel2.getChildren(), n)) {
                return cCFPanel2;
            }
            return null;
        }

        private boolean processTabChildren(CCFChild[] cCFChildArray, int n) {
            if (cCFChildArray == null || cCFChildArray.length == 0) {
                return false;
            }
            boolean bl = false;
            CCFChild[] cCFChildArray2 = new CCFChild[cCFChildArray.length];
            System.arraycopy(cCFChildArray, 0, cCFChildArray2, 0, cCFChildArray.length);
            for (int i = 0; i < cCFChildArray2.length; ++i) {
                if (this.processTabButton(cCFChildArray2[i].getButton(), n)) {
                    bl = true;
                }
                if (!this.processTabFrame(cCFChildArray2[i].getFrame(), n)) continue;
                bl = true;
            }
            return bl;
        }

        private boolean processTabFrame(CCFFrame cCFFrame, int n) {
            if (cCFFrame == null) {
                return false;
            }
            if (cCFFrame.getFont() == CCFFont.NONE && this.shouldDelete(cCFFrame.getName(), n)) {
                cCFFrame.delete();
                return false;
            }
            return this.processTabChildren(cCFFrame.getChildren(), n);
        }

        private boolean processTabButton(CCFButton cCFButton, int n) {
            if (cCFButton == null) {
                return false;
            }
            String string = cCFButton.getIDTag();
            if (string != null && string.startsWith("Tab:")) {
                if (string.equals("Tab:" + n)) {
                    cCFButton.getChildWrapper().top();
                    return true;
                }
                cCFButton.iconAS = cCFButton.iconIS;
                cCFButton.iconAU = cCFButton.iconIU;
                cCFButton.colorAS = cCFButton.colorIS;
                cCFButton.colorAU = cCFButton.colorIU;
                this.newButtons.add(cCFButton);
            }
            if (this.shouldDelete(cCFButton.getIDTag(), n)) {
                cCFButton.delete();
            }
            return false;
        }

        private boolean shouldDelete(String string, int n) {
            if (string == null || string.indexOf("Tab ") != 0) {
                return false;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(3));
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() < 2) continue;
                int n2 = Integer.parseInt(string2.substring(1));
                switch (string2.charAt(0)) {
                    case '-': {
                        if (n2 != n) break;
                        return true;
                    }
                    case '+': {
                        if (n2 == n) {
                            return false;
                        }
                        bl = true;
                    }
                }
            }
            return bl;
        }
    }

    class ThemeMaster {
        private Hashtable frames = new Hashtable();
        private Hashtable buttons = new Hashtable();
        private int count = 0;

        ThemeMaster() {
            CCFDevice cCFDevice = Tonto.device();
            if (cCFDevice == null) {
                Tonto.errorDialog("No device selected for theme");
                return;
            }
            if (cCFDevice.getName() == null || !cCFDevice.getName().startsWith("Theme-")) {
                Tonto.errorDialog("Selected device is not a theme");
                return;
            }
            for (CCFPanel cCFPanel = cCFDevice.getFirstPanel(); cCFPanel != null; cCFPanel = cCFPanel.getNextPanel()) {
                this.addPanel(cCFPanel);
            }
            new CCFWalker(Tonto.ccf()).walk(new IWalker2(){

                @Override
                public void onNode(CCFNode cCFNode) {
                    if (cCFNode instanceof CCFFrame) {
                        CCFFrame cCFFrame;
                        CCFFrame cCFFrame2 = (CCFFrame)cCFNode;
                        CCFFrame cCFFrame3 = cCFFrame = cCFFrame2.name != null ? (CCFFrame)ThemeMaster.this.frames.get(cCFFrame2.name) : null;
                        if (cCFFrame == null) {
                            return;
                        }
                        cCFFrame2.colors = cCFFrame.colors;
                        cCFFrame2.icon = cCFFrame.icon;
                        ThemeMaster.this.count++;
                    } else if (cCFNode instanceof CCFButton) {
                        CCFButton cCFButton;
                        CCFButton cCFButton2 = (CCFButton)cCFNode;
                        CCFButton cCFButton3 = cCFButton = cCFButton2.idtag != null ? (CCFButton)ThemeMaster.this.buttons.get(cCFButton2.idtag) : null;
                        if (cCFButton == null) {
                            return;
                        }
                        cCFButton2.setIconSet(cCFButton.getIconSet());
                        cCFButton2.fontSize = cCFButton.fontSize;
                        ThemeMaster.this.count++;
                    }
                }

                @Override
                public boolean processNode(CCFNode cCFNode) {
                    if (cCFNode instanceof CCFDevice) {
                        CCFDevice cCFDevice = (CCFDevice)cCFNode;
                        return cCFDevice.name != null && !cCFDevice.name.startsWith("Theme-");
                    }
                    return true;
                }
            });
            Tonto.infoDialog("Applied " + cCFDevice.getName() + " to " + this.count + " objects");
            Tonto.this.refreshAllPanels();
        }

        private void addPanel(CCFPanel cCFPanel) {
            this.addChildren(cCFPanel.getChildren());
        }

        private void addChildren(CCFChild[] cCFChildArray) {
            block4: for (int i = 0; cCFChildArray != null && i < cCFChildArray.length; ++i) {
                switch (cCFChildArray[i].type) {
                    case 1: {
                        this.addButton(cCFChildArray[i].getButton());
                        continue block4;
                    }
                    case 0: {
                        this.addFrame(cCFChildArray[i].getFrame());
                    }
                }
            }
        }

        private void addFrame(CCFFrame cCFFrame) {
            if (cCFFrame.getName() != null) {
                this.frames.put(cCFFrame.getName(), cCFFrame);
                this.addChildren(cCFFrame.getChildren());
            }
        }

        private void addButton(CCFButton cCFButton) {
            if (cCFButton.getIDTag() != null) {
                this.buttons.put(cCFButton.getIDTag(), cCFButton);
            }
        }
    }

    static class MyFileFilter
    extends FileFilter
    implements FilenameFilter {
        private String[] ok;
        private String desc;

        MyFileFilter(String[] stringArray, String string) {
            this.ok = stringArray;
            this.desc = string;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory() || this.ok == null || this.ok.length == 0) {
                return true;
            }
            String string = file.getName().toLowerCase();
            for (int i = 0; i < this.ok.length; ++i) {
                if (!string.endsWith(this.ok[i].toLowerCase())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean accept(File file, String string) {
            if (this.ok == null || this.ok.length == 0) {
                return true;
            }
            for (int i = 0; i < this.ok.length; ++i) {
                if (!string.toLowerCase().endsWith(this.ok[i].toLowerCase())) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    class DoEnd
    implements Doable {
        private int id;

        DoEnd(int n) {
            this.id = n;
        }

        @Override
        public void doIt() {
        }

        @Override
        public void undoIt() {
        }

        public String toString() {
            return "DoEnd:" + this.id;
        }
    }

    class DoStart
    implements Doable {
        private int id;

        DoStart() {
            this.id = Tonto.this.nextDoID++;
        }

        @Override
        public void doIt() {
        }

        @Override
        public void undoIt() {
        }

        public String toString() {
            return "DoStart:" + this.id;
        }
    }

    static class TontoEnum
    implements Enumeration {
        Tonto next;
        Enumeration tenum = Tonto.access$3100().elements();

        TontoEnum() {
            this.getNext();
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        public Object nextElement() {
            Tonto tonto = this.next;
            this.getNext();
            return tonto;
        }

        void getNext() {
            while (this.tenum.hasMoreElements()) {
                Object e = this.tenum.nextElement();
                if (!(e instanceof Tonto)) continue;
                this.next = (Tonto)e;
                return;
            }
            this.next = null;
        }
    }
}

