/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.ui.StackedDialog;
import com.neuron.io.ByteOutputBuffer;
import java.awt.Color;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class Util {
    private static final Color darkBlue = new Color(0, 0, 128);

    public static byte[] readFile(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.seek(0L);
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        return byArray;
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteOutputBuffer byteOutputBuffer = new ByteOutputBuffer();
        Util.readFully(inputStream, byteOutputBuffer);
        return byteOutputBuffer.toByteArray();
    }

    public static void readFully(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public static int bound(int n, int n2, int n3) {
        if (n3 > n2) {
            return n2;
        }
        if (n3 < n) {
            return n;
        }
        return n3;
    }

    public static String toHex(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static int unsign(byte by) {
        return by & 0xFF;
    }

    public static void safeSleep(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String sysprop(String string) {
        return Util.getProperty(string);
    }

    public static String getProperty(String string) {
        return System.getProperty(string);
    }

    public static void setProperty(String string, String string2) {
        System.getProperties().put(string, string2);
    }

    public static boolean onWindows() {
        return Util.sysprop("os.name").toLowerCase().indexOf("windows") >= 0;
    }

    public static boolean onWindows98() {
        return Util.sysprop("os.name").toLowerCase().indexOf("98") >= 0;
    }

    public static boolean onMacintosh() {
        return Util.sysprop("os.name").toLowerCase().startsWith("mac");
    }

    public static boolean isIBMJDK() {
        return Util.sysprop("java.vm.vendor").toLowerCase().indexOf("ibm") >= 0;
    }

    public static boolean isSunJDK() {
        return Util.sysprop("java.vm.vendor").toLowerCase().indexOf("sun") >= 0;
    }

    public static boolean isJDK13() {
        return Util.sysprop("java.version").indexOf("1.3") >= 0;
    }

    public static boolean isJDK14() {
        return Util.sysprop("java.version").indexOf("1.4") >= 0;
    }

    public static long time() {
        return System.currentTimeMillis();
    }

    public static String shortName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String nickname(Object object) {
        if (object == null) {
            return "<null>";
        }
        return Util.shortName(object.getClass()) + ":" + object.hashCode();
    }

    public static String unURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '%' && i < string.length() - 3) {
                stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                i += 2;
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static void setLabelBorder(String string, JComponent jComponent) {
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(1), string);
        titledBorder.setTitleColor(darkBlue);
        jComponent.setBorder(titledBorder);
    }

    public static void errorDialog(String string, Throwable throwable) {
        String string2;
        String string3 = string2 = throwable != null ? throwable.getMessage() : null;
        if (string2 == null || string2.length() == 0) {
            string2 = "Error";
        }
        JOptionPane.showMessageDialog(StackedDialog.parent(), string, string2, 0);
    }

    public static boolean confirmDialog(String string, String string2) {
        return JOptionPane.showConfirmDialog(StackedDialog.parent(), string2, string, 0) == 0;
    }

    public static JPanel panelWrap(JComponent jComponent) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jComponent);
        return jPanel;
    }

    public static int decompress(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws Exception {
        int n5;
        int n6 = n;
        int n7 = n3;
        if ((n5 = Util.unsign(byArray[n6++])) > 17) {
            n5 -= 17;
            do {
                byArray2[n7++] = byArray[n6++];
            } while (--n5 > 0);
            if ((n5 = Util.unsign(byArray[n6++])) < 16) {
                throw new Exception("Decompression Error");
            }
        }
        block1: while (true) {
            block31: {
                int n8;
                block30: {
                    if (n5 >= 16) break block30;
                    if (n5 == 0) {
                        while (byArray[n6] == 0) {
                            n5 += 255;
                            ++n6;
                        }
                        n5 = n5 + Util.unsign(byArray[n6++]) + 15;
                    }
                    n5 += 3;
                    do {
                        byArray2[n7++] = byArray[n6++];
                    } while (--n5 > 0);
                    if ((n5 = Util.unsign(byArray[n6++])) >= 16) break block30;
                    if ((n8 = n7 - 2049 - (n5 >> 2) - (Util.unsign(byArray[n6++]) << 2)) < n3) {
                        throw new Exception("Lookback overrun");
                    }
                    n5 = 3;
                    do {
                        byArray2[n7++] = byArray2[n8++];
                    } while (--n5 > 0);
                    n5 = byArray[n6 - 2] & 3;
                    if (n5 == 0) break block31;
                    do {
                        byArray2[n7++] = byArray[n6++];
                    } while (--n5 > 0);
                    n5 = Util.unsign(byArray[n6++]);
                }
                while (true) {
                    if (n5 >= 64) {
                        n8 = n7 - (n5 >> 2 & 7) - (Util.unsign(byArray[n6++]) << 3) - 1;
                        n5 = (n5 >> 5) - 1;
                    } else if (n5 >= 32) {
                        if ((n5 &= 0x1F) == 0) {
                            while (byArray[n6] == 0) {
                                n5 += 255;
                                ++n6;
                            }
                            n5 = n5 + Util.unsign(byArray[n6++]) + 31;
                        }
                        n8 = n7 - (Util.unsign(byArray[n6++]) >> 2) - (Util.unsign(byArray[n6++]) << 6) - 1;
                    } else if (n5 >= 16) {
                        n8 = n7 - ((n5 & 8) << 11);
                        if ((n5 &= 7) == 0) {
                            while (byArray[n6] == 0) {
                                n5 += 255;
                                ++n6;
                            }
                            n5 = n5 + 7 + Util.unsign(byArray[n6++]);
                        }
                        if ((n8 = n8 - (Util.unsign(byArray[n6++]) >> 2) - (Util.unsign(byArray[n6++]) << 6)) == n7) break block1;
                        n8 -= 16384;
                    } else {
                        n8 = n7 - (n5 >> 2) - (Util.unsign(byArray[n6++]) << 2) - 1;
                        n5 = 0;
                    }
                    if (n8 < n3) {
                        throw new Exception("Lookback overrun");
                    }
                    n5 += 2;
                    do {
                        byArray2[n7++] = byArray2[n8++];
                    } while (--n5 > 0);
                    n5 = byArray[n6 - 2] & 3;
                    if (n5 == 0) break;
                    do {
                        byArray2[n7++] = byArray[n6++];
                    } while (--n5 > 0);
                    n5 = Util.unsign(byArray[n6++]);
                }
            }
            n5 = Util.unsign(byArray[n6++]);
        }
        n7 -= n3;
        n6 -= n;
        if (n5 != 1) {
            throw new Exception("Decompression Error");
        }
        if (n6 > n2) {
            throw new Exception("Input too short");
        }
        if (n6 < n2) {
            throw new Exception("Input not exhausted");
        }
        return n7;
    }

    public static int getInt(byte[] byArray, int n) {
        return (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 0;
    }
}

