/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto;

import com.neuron.app.tonto.CRC16;
import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.IComm;
import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.RetryError;
import com.neuron.app.tonto.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

final class Xmodem {
    private static Debug debug = Debug.getInstance("xmodem");
    private static int eotThresh = 1;
    private static final int SOH = 1;
    private static final int STX = 2;
    private static final int EOT = 4;
    private static final int ACK = 6;
    private static final int NAK = 21;
    private static final int CAN = 24;
    private static final byte[] pad0 = new byte[1024];
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private IComm comm;
    private ITaskStatus status;
    private int nakCount;
    private int eotCount;
    private int canCount;
    private boolean inErr;
    private byte[] bakbuf;
    private int bakptr;

    public Xmodem(IComm iComm) {
        this(iComm, null);
    }

    public Xmodem(IComm iComm, ITaskStatus iTaskStatus) {
        this.comm = iComm;
        this.status = iTaskStatus;
        this.inErr = false;
    }

    public static void main(String[] stringArray) throws Exception {
        Xmodem.timeTest();
    }

    public static void timeTest() {
        try {
            System.out.println("Xmodem timing test");
            for (int i = 0; i < 50; ++i) {
                System.out.println("test: " + i);
                new Tester().runTest();
            }
            System.out.println("Xmodem timing test done");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int sendBlock(byte[] byArray, int n, int n2) throws IOException {
        int n3 = byArray.length - n;
        if (n3 == 0) {
            return 0;
        }
        int n4 = n3 >= 1024 ? 1024 : 128;
        int n5 = Math.max(0, n4 - n3);
        int n6 = n4 - n5;
        block8: for (int i = 0; i < 6; ++i) {
            this.send(n4 == 128 ? 1 : 2);
            this.send(n2);
            this.send(255 - n2);
            this.send(byArray, n, n6);
            CRC16 cRC16 = new CRC16(byArray, n, n6);
            if (n5 > 0) {
                this.send(pad0, 0, n5);
                cRC16.update(pad0, 0, n5);
            }
            int n7 = cRC16.getValue();
            debug.log(2, "send blk=" + n2 + " off=" + n + " len=" + n6 + "/" + n4 + " pad=" + n5 + " crc=" + n7);
            this.send(n7 >> 8);
            this.send(n7 & 0xFF);
            this.flush();
            block9: for (int j = 0; j < 3; ++j) {
                int n8 = this.nextByte();
                switch (n8) {
                    case 6: {
                        return n6;
                    }
                    case 21: {
                        ++this.nakCount;
                        debug.log(2, "  recv: NAK");
                        continue block9;
                    }
                    case 24: {
                        debug.log(2, "  recv: CAN");
                        if (j != 2) continue block9;
                        throw new IOException("Transfer remotely cancelled");
                    }
                    case -1: {
                        debug.log(2, "  recv: -1");
                        continue block9;
                    }
                    default: {
                        debug.log(1, "  error sending block " + n2 + " (" + n8 + ",0x" + Xmodem.hex(n8) + ")");
                        break block8;
                    }
                }
            }
            if (this.nakCount <= 0) continue;
            try {
                Thread.currentThread();
                Thread.sleep(this.nakCount * 10);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IOException("Unable to send block " + n2);
    }

    private void ACK() throws IOException {
        this.send(6);
        this.flush();
        this.inErr = false;
    }

    private void EOT() throws IOException {
        this.send(4);
        this.flush();
        this.inErr = false;
    }

    private void NAK() throws IOException {
        this.NAK(false);
    }

    private void NAK(boolean bl) throws IOException {
        if (this.bakbuf == null && (!this.inErr || bl)) {
            this.inErr = !bl;
        }
    }

    private void NAK(String string) throws IOException {
        if (this.inErr) {
            debug.log(3, "ERR:" + string);
        } else {
            debug.log(3, "NAK:" + string);
        }
        this.NAK();
    }

    private void CAN() throws IOException {
        this.send(24);
        this.send(24);
        this.send(24);
        this.send(24);
        this.send(24);
        this.flush();
    }

    private void notify(Object object) {
        if (this.status != null) {
            this.status.taskNotify(object);
        }
    }

    private void progress(String string, int n) {
        if (this.status != null) {
            this.status.taskStatus(n, string);
        }
    }

    private String getHex(byte[] byArray, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(hex[byArray[i + n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[i + n] & 0xF]);
            stringBuffer.append(" ");
            if (i % n3 != n3 - 1) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public static String hex(int n) {
        return new String(new char[]{hex[n >> 4 & 0xF], hex[n & 0xF]});
    }

    private byte[] recvBlock(int n, int n2) throws IOException {
        byte[] byArray;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l = System.currentTimeMillis();
        block8: while (true) {
            int n5;
            int n6;
            int n7;
            int n8;
            if (!bl) {
                debug.log(2, "recv blk=" + n + " off=" + n2 + " bak=" + (this.bakbuf != null));
            }
            if (n == 1) {
                this.comm.send(67);
            }
            boolean bl3 = false;
            int n9 = 128;
            if (!bl) {
                n3 = this.nextByte();
            }
            bl = false;
            switch (n3) {
                case 1: {
                    n9 = 128;
                    break;
                }
                case 2: {
                    n9 = 1024;
                    break;
                }
                case 24: {
                    if (this.inErr || this.canCount < 4) {
                        ++this.canCount;
                        debug.log(3, "loop on CAN #" + this.canCount);
                        continue block8;
                    }
                    this.NAK();
                    debug.log(2, "transfer remotely cancelled :: CAN");
                    throw new RetryError("Transfer remotely cancelled");
                }
                case 4: {
                    if (this.inErr) {
                        debug.log(3, "loop on EOT in error");
                        continue block8;
                    }
                    if (this.eotCount <= eotThresh) {
                        this.NAK(true);
                        ++this.eotCount;
                        continue block8;
                    }
                    this.ACK();
                    debug.log(1, "received EOT @ " + n2 + " in block " + n);
                    return null;
                }
                case -1: {
                    debug.log(1, "no data @ " + n2 + " in block " + n);
                    if (!bl2 && System.currentTimeMillis() - l < 30000L) continue block8;
                    if (++n4 == 5) {
                        throw new RetryError("No Data");
                    }
                    debug.log(2, "loop on -1");
                    continue block8;
                }
                case 33: {
                    debug.log(1, "spurious ! ... not a command");
                    if (++n4 >= 5) {
                        throw new RetryError("Upload Command failed");
                    }
                }
                default: {
                    this.NAK("Invalid command (" + n3 + ") (" + n9 + ")");
                    n8 = 0;
                    do {
                        if ((n3 = this.nextByte()) != 2 && (n9 != 128 || n3 != 1)) continue;
                        debug.log(3, "loop/skip on dup block");
                        bl = true;
                        continue block8;
                    } while (n3 != -1 || ++n8 <= 3);
                    throw new RetryError("End of Stream during Upload");
                }
            }
            this.eotCount = 0;
            this.canCount = 0;
            n8 = this.nextByte();
            int n10 = 255 - this.nextByte();
            if (n8 != n10) {
                this.NAK("block id mismatch (" + n8 + " != " + n10 + ")");
                n3 = n10;
                bl = true;
                continue;
            }
            if (n8 != n) {
                if (n8 == n - 1) {
                    bl3 = true;
                } else {
                    this.NAK("block sequence error (" + n8 + " != " + n + ")");
                    n3 = n10;
                    bl = true;
                    continue;
                }
            }
            debug.log(3, "cmd=" + Xmodem.hex(n3) + " blk=" + Xmodem.hex(n8) + " toRead=" + n9);
            byArray = new byte[n9];
            for (int i = 0; i < n9; i += n7) {
                n7 = this.nextRead(byArray, i, n9 - i);
                if (n7 >= 0) continue;
                this.NAK("block length mismatch: " + n9);
                continue block8;
            }
            n7 = this.nextByte();
            int n11 = n7 << 8 | (n6 = this.nextByte());
            if (n11 != (n5 = new CRC16(byArray, 0, n9).getValue())) {
                if (this.bakbuf == null) {
                    this.bakbuf = new byte[byArray.length + 2];
                    System.arraycopy(byArray, 0, this.bakbuf, 0, byArray.length);
                    this.bakbuf[byArray.length] = (byte)n7;
                    this.bakbuf[byArray.length + 1] = (byte)n6;
                    continue;
                }
                this.NAK("crc mismatch (" + n11 + " != " + n5 + ")");
                continue;
            }
            debug.log(2, "recv blk=" + n8 + " off=" + n2 + " len=" + n9 + " crc=" + n11);
            this.ACK();
            bl2 = true;
            if (!bl3) break;
        }
        return byArray;
    }

    private char toChar(int n) {
        if (n >= 32 || n <= 127) {
            return (char)n;
        }
        return '-';
    }

    public void sendFile(byte[] byArray) throws IOException {
        int n;
        int n2;
        debug.log(1, "send file=" + byArray.length);
        int n3 = 0;
        int n4 = 1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 8;
        block4: for (n2 = 0; n2 < n8; ++n2) {
            n = this.comm.recv();
            debug.log(2, "sendfile:recv: (" + n + ",0x" + Xmodem.hex(n) + "," + this.toChar(n) + ")");
            switch (n) {
                case 67: {
                    break block4;
                }
                case -1: {
                    if (++n6 < 3 || ++n7 >= 2) break;
                    this.comm.sendAttention();
                    this.nextByte();
                    this.send("dl ccf\r".getBytes());
                    this.flush();
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            if (n2 < n8 - 1) continue;
            throw new IOException("Send terminated. No Xmodem stream.");
        }
        while ((n2 = this.sendBlock(byArray, n3, n4++ % 256)) != 0) {
            n = (n3 += n2) * 100 / byArray.length;
            if (n == n5) continue;
            n5 = n;
            this.progress(null, n);
        }
        n2 = 0;
        do {
            if (n2++ > 4) {
                this.CAN();
                throw new IOException("Send terminated due to retry errors");
            }
            this.EOT();
        } while (this.nextByte() != 6);
        debug.log(1, "send file complete");
    }

    public byte[] recvFile() throws IOException {
        return this.recvFile(0);
    }

    public byte[] recvFile(int n) throws IOException {
        this.bakbuf = null;
        this.bakptr = 0;
        int n2 = Thread.currentThread().getPriority();
        debug.log(1, "recv size=" + n);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        long l = System.currentTimeMillis();
        int n3 = 1;
        int n4 = 0;
        try {
            Thread.currentThread().setPriority(10);
            byte[] byArray = null;
            while ((byArray = this.recvBlock(n3++ % 256, n4)) != null) {
                if (n3 == 2 && Util.getInt(byArray, 8) == 1296849487) {
                    n = Util.getInt(byArray, 4) * 3 / 5;
                    debug.log(1, "recv compressed ccf predict size " + n);
                }
                n4 += byArray.length;
                byteArrayOutputStream.write(byArray, 0, byArray.length);
                this.progress(null, byteArrayOutputStream.size() * 100 / Math.max(n, 1));
            }
            l = System.currentTimeMillis() - l;
            debug.log(1, "recv complete len=" + n4 + " time=" + l + " rate=" + (long)(n4 * 1000) / l);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        catch (IOException iOException) {
            debug.log(0, iOException.getMessage());
            if (n > 0 && n4 >= n) {
                debug.log(1, "recv complete with errors @ " + n4);
                this.NAK();
                this.ACK();
                this.CAN();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            this.CAN();
            int n5 = 0;
            while (this.nextByte() != -1) {
                ++n5;
            }
            if (n5 > 0) {
                debug.log(1, "drained " + n5 + " bytes");
            }
            throw iOException;
        }
        finally {
            Thread.currentThread().setPriority(n2);
        }
    }

    public int nextByte() throws IOException {
        if (this.bakbuf != null) {
            int n = this.bakbuf[this.bakptr++] & 0xFF;
            if (this.bakptr >= this.bakbuf.length) {
                this.bakbuf = null;
                this.bakptr = 0;
            }
            return n;
        }
        return this.comm.recv();
    }

    public int nextRead(byte[] byArray, int n, int n2) throws IOException {
        if (this.bakbuf != null) {
            int n3 = Math.min(n2, this.bakbuf.length - this.bakptr);
            System.arraycopy(this.bakbuf, this.bakptr, byArray, n, n3);
            this.bakptr += n3;
            if (this.bakptr >= this.bakbuf.length) {
                this.bakbuf = null;
                this.bakptr = 0;
            }
            return n3;
        }
        return this.comm.recv(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.comm.flush();
    }

    public void send(int n) throws IOException {
        this.comm.send(n);
    }

    public void send(byte[] byArray) throws IOException {
        this.comm.send(byArray, 0, byArray.length);
    }

    public void send(byte[] byArray, int n, int n2) throws IOException {
        this.comm.send(byArray, n, n2);
    }

    static {
        String string = System.getProperty("xmodem.eot");
        if (string != null) {
            try {
                eotThresh = Integer.parseInt(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static class Tester {
        MyComm c1 = new MyComm();
        MyComm c2 = new MyComm();
        Xmodem sender = new Xmodem(this.c1);
        Xmodem receiver = new Xmodem(this.c2);

        Tester() {
        }

        private void debug(String string) {
        }

        public void runTest() throws Exception {
            this.c1.connect(this.c2);
            this.debug("test started");
            long l = Util.time();
            TimedThread timedThread = new TimedThread(){

                @Override
                public void go() throws Exception {
                    Tester.this.sender.sendFile(new byte[8888]);
                }
            };
            TimedThread timedThread2 = new TimedThread(){

                @Override
                public void go() throws Exception {
                    Tester.this.receiver.recvFile();
                }
            };
            timedThread2.start();
            timedThread.start();
            this.debug("threads started");
            timedThread.join();
            timedThread2.join();
            long l2 = Util.time() - l;
            System.out.println("test took " + l2 + " ms");
        }

        abstract class TimedThread
        extends Thread {
            TimedThread() {
            }

            @Override
            public void run() {
                Tester.this.debug(Util.nickname(this) + " started");
                long l = Util.time();
                try {
                    this.go();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                long l2 = Util.time() - l;
                Tester.this.debug(Util.nickname(this) + " ran in " + l2 + " ms");
            }

            public abstract void go() throws Exception;
        }

        class MyComm
        implements IComm {
            PipedInputStream is = new PipedInputStream();
            PipedOutputStream os = new PipedOutputStream();
            int sc;
            int rc;

            MyComm() {
            }

            public void connect(MyComm myComm) throws Exception {
                myComm.is.connect(this.os);
                myComm.os.connect(this.is);
            }

            @Override
            public void sendAttention() throws IOException {
                Tester.this.debug("sendAttention");
            }

            @Override
            public void send(int n) throws IOException {
                Tester.this.debug("send[" + ++this.sc + "]: " + n);
                this.os.write(n);
            }

            @Override
            public void send(byte[] byArray) throws IOException {
                this.sc += byArray.length;
                Tester.this.debug("send[" + this.sc + "]: [" + byArray.length + "]");
                this.os.write(byArray, 0, byArray.length);
            }

            @Override
            public void send(byte[] byArray, int n, int n2) throws IOException {
                this.sc += n2;
                Tester.this.debug("send[" + this.sc + "]: [" + n2 + "]");
                this.os.write(byArray, n, n2);
            }

            @Override
            public int recv() throws IOException {
                int n = this.is.read();
                Tester.this.debug("recv[" + ++this.rc + "]: " + n);
                return n;
            }

            @Override
            public int recv(byte[] byArray) throws IOException {
                this.rc += byArray.length;
                int n = this.is.read(byArray, 0, byArray.length);
                Tester.this.debug("recv[" + this.rc + "]: [" + n + "]");
                return n;
            }

            @Override
            public int recv(byte[] byArray, int n, int n2) throws IOException {
                this.rc += n2;
                int n3 = this.is.read(byArray, n, n2);
                Tester.this.debug("recv[" + this.rc + "]: [" + n3 + "]");
                return n3;
            }

            @Override
            public void flush() throws IOException {
                this.os.flush();
            }
        }
    }
}

