/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class AAPanel
extends JPanel {
    private GridBagLayout layout;
    private GridBagConstraints option;
    private Hashtable common;
    private boolean[] done;
    private Component[] comp;
    private GridBagConstraints[] cons;
    private boolean managed;

    public static void main(String[] stringArray) {
        AAPanel aAPanel = new AAPanel();
        aAPanel.define('a', (Component)new Button("button1"), "fill=b;wy=1");
        aAPanel.define('b', (Component)new Button("button2"), "fill=b;wx=1");
        aAPanel.define('c', (Component)new Button("button3"), "fill=b;wx=1;wy=1");
        aAPanel.define('d', (Component)new Button("button4"), "fill=b;wx=1");
        aAPanel.define('e', (Component)new Button("button5"), "fill=b;wx=1;wy=1");
        aAPanel.define('x', (Component)new Button("button6"), "fill=b;wx=1;wy=1");
        aAPanel.define('f', (Component)new AAPanel(), "fill=b;wx=1;wy=1;pad=3,3,3,3");
        aAPanel.setLayout(new String[]{"aaaaaaaaa", "         ", "b fffffff", "b f     f", "b f ccc f", "b f xxx f", "b f     f", "b fffffff", "b        ", "b ddd eee"});
        Frame frame = new Frame("test");
        frame.setLayout(new GridLayout(1, 1));
        frame.add(aAPanel);
        frame.pack();
        frame.setVisible(true);
    }

    public AAPanel() {
        this(false);
    }

    public AAPanel(boolean bl) {
        this.managed = bl;
        this.layout = new GridBagLayout();
        this.option = new GridBagConstraints();
        this.common = new Hashtable();
        this.common.put("rem", new Integer(0));
        this.common.put("rel", new Integer(-1));
        this.common.put("h", new Integer(2));
        this.common.put("v", new Integer(3));
        this.common.put("b", new Integer(1));
        this.common.put("n", new Integer(0));
        this.common.put("+c", new Integer(10));
        this.common.put("+n", new Integer(11));
        this.common.put("+s", new Integer(15));
        this.common.put("+e", new Integer(13));
        this.common.put("+w", new Integer(17));
        this.common.put("+ne", new Integer(12));
        this.common.put("+nw", new Integer(18));
        this.common.put("+se", new Integer(14));
        this.common.put("+sw", new Integer(16));
        this.setLayout(this.layout);
    }

    private void checkSetup() {
        if (this.comp == null) {
            this.done = new boolean[256];
            this.comp = new Component[256];
            this.cons = new GridBagConstraints[256];
        }
    }

    public Component item(char c) {
        return this.comp[c & 0xFF];
    }

    private void ensureConstraints(int n) {
        if (this.cons[n &= 0xFF] == null) {
            this.cons[n] = new GridBagConstraints();
            this.cons[n].gridx = -1;
        }
    }

    public void define(char c) {
        this.define(c, new AAPanel(true));
    }

    public void define(char c, String string) {
        this.define(c, (Component)new AAPanel(true), string);
    }

    public void define(char c, Component component) {
        this.define(c, component, (String)null);
    }

    public void define(char c, Component component, String string) {
        this.define(Math.min(c & 0xFF, 255), component, string);
    }

    private void define(int n, Component component, String string) {
        this.checkSetup();
        this.ensureConstraints(n);
        this.comp[n] = component;
        this.cons[n] = this.config(string, this.cons[n]);
    }

    public void setLayout(String[] stringArray) {
        int n;
        int n2;
        this.checkSetup();
        int n3 = 0;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n3 = Math.max(n3, stringArray[n2].length());
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            for (n = 0; n < stringArray[n2].length(); ++n) {
                int n4 = stringArray[n2].charAt(n) & 0xFF;
                if (n4 == 32) continue;
                this.ensureConstraints(n4);
                if (this.cons[n4].gridx == -1) {
                    this.cons[n4].gridx = n;
                    this.cons[n4].gridy = n2;
                }
                this.cons[n4].gridwidth = n - this.cons[n4].gridx + 1;
                this.cons[n4].gridheight = n2 - this.cons[n4].gridy + 1;
            }
        }
        for (n2 = 0; n2 < this.comp.length; ++n2) {
            if (this.comp[n2] == null) continue;
            n = -1;
            for (int i = 0; i < this.comp.length; ++i) {
                if (n2 == i || this.comp[i] == null || !(this.comp[i] instanceof AAPanel) || !this.inside(this.cons[n2], this.cons[i]) || n != -1 && !this.inside(this.cons[i], this.cons[n])) continue;
                n = i;
            }
            if (n < 0) continue;
            AAPanel aAPanel = (AAPanel)this.comp[n];
            GridBagConstraints gridBagConstraints = this.cons[n];
            aAPanel.transfer(n2, this.comp[n2], this.cons[n2], gridBagConstraints.gridx, gridBagConstraints.gridy);
            this.done[n2] = true;
        }
        this.finishLayout();
    }

    private void finishLayout() {
        if (this.comp == null) {
            return;
        }
        for (int i = 0; i < this.comp.length; ++i) {
            if (this.comp[i] == null || this.done[i]) continue;
            if (this.comp[i] instanceof AAPanel && ((AAPanel)this.comp[i]).managed) {
                ((AAPanel)this.comp[i]).finishLayout();
            }
            this.layout.setConstraints(this.comp[i], this.cons[i]);
            this.add(this.comp[i]);
        }
    }

    private boolean inside(GridBagConstraints gridBagConstraints, GridBagConstraints gridBagConstraints2) {
        return gridBagConstraints.gridx > gridBagConstraints2.gridx && gridBagConstraints.gridy > gridBagConstraints2.gridy && gridBagConstraints.gridx + gridBagConstraints.gridwidth < gridBagConstraints2.gridx + gridBagConstraints2.gridwidth && gridBagConstraints.gridy + gridBagConstraints.gridheight < gridBagConstraints2.gridy + gridBagConstraints2.gridheight;
    }

    private void transfer(int n, Component component, GridBagConstraints gridBagConstraints, int n2, int n3) {
        try {
            this.checkSetup();
            this.ensureConstraints(n);
            this.comp[n] = component;
            this.cons[n] = (GridBagConstraints)gridBagConstraints.clone();
            this.cons[n].gridx -= n2;
            this.cons[n].gridy -= n3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private int common(String string, int n) {
        Integer n2 = (Integer)this.common.get(string);
        if (n2 != null) {
            return n2;
        }
        return n;
    }

    private int parse(String string) {
        return Integer.parseInt(string);
    }

    private double parseD(String string) {
        return new Double(string);
    }

    private int parseSize(String string) {
        if (string.equals("*")) {
            return 0;
        }
        return this.parse(string);
    }

    public void config(String string) {
        this.option = this.config(string, this.option);
    }

    private GridBagConstraints config(String string, GridBagConstraints gridBagConstraints) {
        if (string == null) {
            return gridBagConstraints;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            String string3 = stringTokenizer2.nextToken();
            String string4 = string2 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : "";
            if (string3.equals("clr")) {
                gridBagConstraints = new GridBagConstraints();
                continue;
            }
            if (string3.equals("x")) {
                gridBagConstraints.gridx = this.parse(string2);
                continue;
            }
            if (string3.equals("y")) {
                gridBagConstraints.gridy = this.parse(string2);
                continue;
            }
            if (string3.equals("w")) {
                gridBagConstraints.gridwidth = this.parseSize(string2);
                continue;
            }
            if (string3.equals("h")) {
                gridBagConstraints.gridheight = this.parseSize(string2);
                continue;
            }
            if (string3.equals("pad")) {
                stringTokenizer2 = new StringTokenizer(string2, ",");
                gridBagConstraints.insets = new Insets(this.parse(stringTokenizer2.nextToken()), this.parse(stringTokenizer2.nextToken()), this.parse(stringTokenizer2.nextToken()), this.parse(stringTokenizer2.nextToken()));
                continue;
            }
            if (string3.equals("ix")) {
                gridBagConstraints.ipadx = this.parse(string2);
                continue;
            }
            if (string3.equals("iy")) {
                gridBagConstraints.ipady = this.parse(string2);
                continue;
            }
            if (string3.equals("wx")) {
                gridBagConstraints.weightx = this.parseD(string2);
                continue;
            }
            if (string3.equals("wy")) {
                gridBagConstraints.weighty = this.parseD(string2);
                continue;
            }
            if (string3.equals("fill")) {
                gridBagConstraints.fill = this.common(string2, 0);
                continue;
            }
            if (!string3.equals("anchor")) continue;
            gridBagConstraints.anchor = this.common("+" + string2, 10);
        }
        return gridBagConstraints;
    }

    public Component add(Component component, String string) {
        this.config(string);
        this.layout.setConstraints(component, this.option);
        return super.add(component);
    }

    @Override
    public void disable() {
        this.able(this, false);
    }

    @Override
    public void enable() {
        this.able(this, true);
    }

    private void able(Container container, boolean bl) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            component.setEnabled(bl);
            if (!(component instanceof Container)) continue;
            this.able((Container)component, bl);
        }
    }

    public void clear() {
        this.clear(this);
    }

    private void clear(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component instanceof JTextComponent) {
                ((JTextComponent)component).setText("");
            }
            if (!(component instanceof Container)) continue;
            this.clear((Container)component);
        }
    }
}

