/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import com.neuron.app.tonto.CCFColor;
import com.neuron.app.tonto.ui.ModalWindow;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class ColorPicker
extends JPanel {
    private static final Dimension size = new Dimension(20, 20);
    private CCFColor color;
    private boolean ext;
    private boolean edit;
    private boolean websafe;
    private Window window;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("foo");
        frame.setBackground(Color.white);
        ColorPicker colorPicker = new ColorPicker(frame);
        ColorPicker colorPicker2 = new ColorPicker(frame);
        frame.setLayout(new GridLayout(2, 1, 5, 5));
        frame.add(colorPicker);
        frame.add(colorPicker2);
        colorPicker.setColor(CCFColor.getColor(0), true);
        colorPicker2.setColor(CCFColor.getColor(0), false);
        frame.pack();
        frame.show();
    }

    public ColorPicker() {
        this((Window)null, true);
    }

    public ColorPicker(CCFColor cCFColor) {
        this(cCFColor, true, true, true);
    }

    public ColorPicker(CCFColor cCFColor, boolean bl, boolean bl2) {
        this(cCFColor, bl, bl2, true);
    }

    public ColorPicker(CCFColor cCFColor, boolean bl, boolean bl2, boolean bl3) {
        this((Window)null, true);
        this.setColor(cCFColor, bl);
        this.setEditable(bl2);
        this.setWebSafe(bl3);
    }

    public ColorPicker(Window window) {
        this((Window)null, true);
    }

    public ColorPicker(Window window, boolean bl) {
        this.setBorder(new BevelBorder(0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ColorPicker.this.edit) {
                    ColorPicker.this.chooseColor();
                }
            }
        });
        this.window = window;
        this.setEditable(true);
        this.setWebSafe(bl);
    }

    @Override
    public Dimension getMinimumSize() {
        return size;
    }

    @Override
    public Dimension getPreferredSize() {
        return size;
    }

    public void setWebSafe(boolean bl) {
        this.websafe = bl;
    }

    public void setEditable(boolean bl) {
        this.edit = bl;
    }

    public void setColor(CCFColor cCFColor, boolean bl) {
        this.color = cCFColor;
        this.ext = bl;
        this.repaintOwner();
    }

    private void repaintOwner() {
        Container container;
        for (container = this; !(container instanceof Window) && container != null; container = container.getParent()) {
        }
        if (container != null) {
            container.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.setBackground(this.color.getAWTColor(this.ext));
        super.paint(graphics);
    }

    public void setOwner(Window window) {
        this.window = window;
    }

    public CCFColor getColor() {
        return this.color;
    }

    public void chooseColor() {
        Chooser chooser = this.ext ? new ColorChooser() : new GrayChooser();
        chooser.select(this.getPostLocation(), this.color.getColorIndex());
    }

    private Point getPostLocation() {
        Dimension dimension = this.getSize();
        Point point = this.getLocationOnScreen();
        return new Point(point.x + dimension.width / 2, point.y + dimension.height / 2);
    }

    private Window findOwner() {
        Container container;
        for (container = this; !(container instanceof Window) && container != null; container = container.getParent()) {
        }
        if (container != null) {
            return (Window)container;
        }
        return new Frame();
    }

    class Bar
    extends JPanel {
        private int value;
        private Dimension size;

        Bar(int n, Color color, int n2) {
            this.setBorder(new LineBorder(Color.black, 2));
            this.setBackground(color);
            this.value = n2;
            this.size = new Dimension(n, n);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.size;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.size;
        }
    }

    class ColorChooser
    extends Chooser {
        ColorChooser() {
            this.getContent().setLayout(ColorPicker.this.websafe ? new GridLayout(16, 16) : new GridLayout(12, 18));
            Color[] colorArray = CCFColor.getColorModel(true);
            for (int i = 0; i < Math.min(colorArray.length, ColorPicker.this.websafe ? 256 : 216); ++i) {
                this.addBar(new Bar(20, colorArray[i], i));
            }
            this.pack();
        }
    }

    class GrayChooser
    extends Chooser {
        GrayChooser() {
            this.getContent().setLayout(new GridLayout(1, 4));
            Color[] colorArray = CCFColor.getColorModel(false);
            for (int i = 0; i < colorArray.length; ++i) {
                this.addBar(new Bar(50, colorArray[i], i));
            }
            this.pack();
        }
    }

    class Chooser
    extends ModalWindow {
        private MouseListener adapter;
        private int value;
        private JPanel content;

        Chooser() {
            super(ColorPicker.this.window != null ? ColorPicker.this.window : ColorPicker.this.findOwner());
            this.adapter = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Chooser.this.clicked(mouseEvent.getSource());
                }
            };
            this.content = new JPanel();
            this.content.setBackground(Color.white);
            this.setLayout(new GridLayout(1, 1));
            this.add(this.content);
        }

        int getValue() {
            return this.value;
        }

        void addBar(Bar bar) {
            this.content.add(bar);
            bar.addMouseListener(this.adapter);
        }

        JPanel getContent() {
            return this.content;
        }

        void clicked(Object object) {
            if (object instanceof Bar) {
                this.value = ((Bar)object).value;
            }
            this.dispose();
            ColorPicker.this.setColor(CCFColor.getColor(this.value), ColorPicker.this.ext);
        }

        void select(Point point, int n) {
            this.setLocation(point);
            this.value = n;
            this.show();
        }
    }
}

