/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ImageFont {
    private static final ColorModel cm = ColorModel.getRGBdefault();
    private static final int zero = 0xFFFFFF;
    private static final int one = -1;
    private static final Component comp = new Panel();
    private static final MediaTracker mt = new MediaTracker(comp);
    private int height = 1;
    private int[] width = new int[256];
    private int[][] data = new int[256][];
    private Hashtable cache = new Hashtable();

    public ImageFont() {
    }

    public ImageFont(InputStream inputStream) throws IOException {
        this.readFont(inputStream);
    }

    public String toString() {
        return "font[h=" + this.height + "]";
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setChar(int n, int n2, int[] nArray) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.width[n] = n2;
        this.data[n] = nArray;
    }

    public void writeFont(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        bufferedWriter.write("height " + this.height);
        bufferedWriter.newLine();
        bufferedWriter.newLine();
        for (int i = 0; i < 256; ++i) {
            bufferedWriter.write("char " + i + " width " + this.width[i]);
            bufferedWriter.newLine();
            bufferedWriter.write("   ");
            for (int j = 0; j < this.data[i].length; ++j) {
                bufferedWriter.write(cm.getRed(this.data[i][j]) == 0 ? "1" : "-");
                if ((j + 1) % this.width[i] != 0) continue;
                bufferedWriter.newLine();
                bufferedWriter.write("   ");
            }
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
    }

    public void readFont(InputStream inputStream) throws IOException {
        this.data = new int[256][];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        this.height = Integer.parseInt(string.substring(7));
        for (int i = 0; i < 256; ++i) {
            string = bufferedReader.readLine();
            string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            stringTokenizer.nextToken();
            if (Integer.parseInt(stringTokenizer.nextToken()) != i) {
                throw new IOException("malformed font file @ " + i);
            }
            stringTokenizer.nextToken();
            this.width[i] = Integer.parseInt(stringTokenizer.nextToken());
            int[] nArray = new int[this.width[i] * this.height];
            for (int j = 0; j < this.height; ++j) {
                string = bufferedReader.readLine().trim();
                for (int k = 0; k < this.width[i]; ++k) {
                    int n = j * this.width[i] + k;
                    nArray[n] = string.charAt(k) == '-' ? 0xFFFFFF : -1;
                }
            }
            this.data[i] = nArray;
        }
    }

    private Image getCharImage(int n, int n2) {
        Integer n3 = new Integer(n << 24 | (n2 &= 0xFFFFFF));
        Image image = (Image)this.cache.get(n3);
        if (image == null) {
            int[] nArray = this.data[n];
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray2.length; ++i) {
                nArray2[i] = nArray[i] & 0xFF000000 | n2;
            }
            image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width[n], this.height, cm, nArray2, 0, this.width[n]));
            mt.addImage(image, n);
            try {
                mt.waitForID(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.cache.put(n3, image);
        }
        return image;
    }

    public void draw(int n, int n2, int n3, Graphics graphics, int n4) {
        graphics.drawImage(this.getCharImage(n, n4), n2, n3, null);
    }

    public void draw(String string, int n, int n2, Graphics graphics) {
        if (string == null) {
            return;
        }
        int n3 = graphics.getColor().getRGB();
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            this.draw(cArray[i], n, n2, graphics, n3);
            n += this.width[cArray[i]];
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getCharWidth(int n) {
        return this.width[n];
    }

    public int getStringWidth(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            n += this.width[cArray[i]];
        }
        return n;
    }
}

