/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import com.neuron.app.tonto.ui.ImageFont;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class ImageFontLabel
extends JLabel {
    private ImageFont font;
    private Dimension dim;
    private int align;
    private String[] text;
    private int[] width;

    public ImageFontLabel(ImageFont imageFont, String string) {
        this(imageFont, string, 0);
    }

    public ImageFontLabel(ImageFont imageFont, String string, int n) {
        super(string, n);
        this.setFont(imageFont);
        this.setAlignment(0);
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.parseText();
    }

    public void setFont(ImageFont imageFont) {
        this.font = imageFont;
        if (imageFont == null) {
            this.dim = new Dimension(0, 0);
            return;
        }
        if (this.getText() != null) {
            this.parseText();
        }
    }

    private void parseText() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getText(), "\n");
        this.text = new String[stringTokenizer.countTokens()];
        this.width = new int[this.text.length];
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.text[n2] = stringTokenizer.nextToken();
            if (this.text[n2].length() > this.text[n].length()) {
                n = n2;
            }
            if (this.font != null) {
                this.width[n2] = this.font.getStringWidth(this.text[n2]);
            }
            ++n2;
        }
        if (this.font != null && this.text.length > 0) {
            this.dim = new Dimension(this.width[n], this.font.getHeight());
        }
    }

    public void setAlignment(int n) {
        switch (n) {
            case 1: {
                this.setHorizontalAlignment(2);
                break;
            }
            case 0: {
                this.setHorizontalAlignment(0);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(4);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.font == null) {
            return;
        }
        Dimension dimension = this.getSize();
        int n = this.font.getHeight();
        boolean bl = false;
        int n2 = (dimension.height - n * this.text.length) / 2;
        int n3 = this.getHorizontalAlignment();
        graphics.setColor(this.getForeground());
        for (int i = 0; i < this.text.length; ++i) {
            switch (n3) {
                case 2: {
                    bl = false;
                    this.font.draw(this.text[i], 0, n2, graphics);
                    break;
                }
                case 0: {
                    this.font.draw(this.text[i], (dimension.width - this.width[i]) / 2, n2, graphics);
                    break;
                }
                case 4: {
                    this.font.draw(this.text[i], dimension.width - this.width[i], n2, graphics);
                }
            }
            n2 += n;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.dim;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dim;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.dim;
    }
}

