/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ModalWindow
extends Window {
    private EventQueue sysQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
    private MyQ myQ = new MyQ();
    private boolean open = false;

    public static void main(String[] stringArray) {
        Frame frame = new Frame("root frame");
        frame.setLayout(new GridLayout(2, 2));
        frame.add(new Button("1"));
        frame.add(new Button("2"));
        frame.add(new Button("3"));
        frame.add(new Button("4"));
        frame.pack();
        frame.show();
        ModalWindow modalWindow = new ModalWindow((Window)frame);
        modalWindow.setLayout(new GridLayout(2, 2));
        modalWindow.add(new Button("1"));
        modalWindow.add(new Button("2"));
        modalWindow.add(new Button("3"));
        modalWindow.add(new Button("4"));
        modalWindow.pack();
        modalWindow.show();
    }

    public ModalWindow(Window window) {
        super(window);
        this.setup();
    }

    private void setup() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                if (!ModalWindow.this.open) {
                    ModalWindow.this.open = true;
                    ModalWindow.this.sysQ.push(ModalWindow.this.myQ);
                }
                ModalWindow.this.toFront();
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (ModalWindow.this.open) {
                    ModalWindow.this.myQ.done();
                    ModalWindow.this.open = false;
                }
            }
        });
    }

    @Override
    public void show() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        rectangle.x = Math.min(dimension.width - rectangle.width, rectangle.x);
        rectangle.y = Math.min(dimension.height - rectangle.height, rectangle.y);
        this.setBounds(rectangle);
        super.show();
    }

    class MyQ
    extends EventQueue {
        MyQ() {
        }

        @Override
        public void dispatchEvent(AWTEvent aWTEvent) {
            Component component;
            Object object = aWTEvent.getSource();
            if (!(object instanceof Component)) {
                super.dispatchEvent(aWTEvent);
                return;
            }
            for (component = (Component)object; component != null && component != ModalWindow.this; component = component.getParent()) {
            }
            if (component == ModalWindow.this) {
                super.dispatchEvent(aWTEvent);
            } else {
                if (aWTEvent instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    if (mouseEvent.getID() == 500) {
                        ModalWindow.this.dispose();
                    }
                    return;
                }
                if (aWTEvent instanceof KeyEvent) {
                    return;
                }
                super.dispatchEvent(aWTEvent);
            }
        }

        public void done() {
            this.pop();
        }
    }
}

