/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import com.neuron.app.tonto.ui.StackedDialog;
import com.neuron.app.tonto.ui.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class OKCancelDialog
extends StackedDialog
implements ActionListener {
    private boolean ok;

    public OKCancelDialog(String string) {
        this(string, true);
    }

    public OKCancelDialog(String string, boolean bl) {
        super(string);
        this.setLayout(new BorderLayout());
        this.add("South", this.getButtons());
        if (bl) {
            this.bindOK();
        }
        this.bindCancel();
    }

    public void bindOK() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0, true), "OK");
        this.getActionMap().put("OK", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.enterOK();
            }
        });
    }

    public void bindCancel() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, true), "CANCEL");
        this.getActionMap().put("CANCEL", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OKCancelDialog.this.escCancel();
            }
        });
    }

    public void setContents(Component component) {
        if (component != null) {
            this.add("Center", component);
        }
    }

    public void setOK(boolean bl) {
        this.ok = bl;
    }

    public void enterOK() {
        this.setOK(true);
        this.doOK();
        this.dispose();
    }

    public void escCancel() {
        this.setOK(false);
        this.doCancel();
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.enterOK();
        } else if (string.equals("Cancel")) {
            this.escCancel();
        } else if (this.handleCmd(string)) {
            this.dispose();
        }
    }

    public JComponent getButtons() {
        return UIUtils.getOKCancel(this);
    }

    public boolean handleCmd(String string) {
        return false;
    }

    public boolean invoke() {
        this.show();
        return this.ok;
    }

    public abstract void doOK();

    public abstract void doCancel();
}

