/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import com.neuron.app.tonto.ui.ImageFont;
import com.neuron.app.tonto.ui.ImageFontLabel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class Snarfont {
    private Font font;
    private Font scaledfont;
    private FontMetrics metrics;
    private FontChar[] chars;
    private int ascent;
    private int descent;
    private int height;

    public static void main(String[] stringArray) throws Exception {
        new Snarfont(stringArray[0]).export(10, "tonto-08.iff");
        new Snarfont(stringArray[0]).export(13, "tonto-10.iff");
        new Snarfont(stringArray[0]).export(16, "tonto-12.iff");
        new Snarfont(stringArray[0]).export(18, "tonto-14.iff");
        new Snarfont(stringArray[0]).export(21, "tonto-16.iff");
        new Snarfont(stringArray[0]).export(24, "tonto-18.iff");
    }

    public Snarfont(String string) throws Exception {
        this.font = Font.createFont(0, new FileInputStream(string));
    }

    private void export(int n, String string) throws IOException {
        this.scaledfont = this.font.deriveFont((float)n);
        JFrame jFrame = new JFrame("snarf");
        this.metrics = jFrame.getToolkit().getFontMetrics(this.scaledfont);
        this.ascent = this.metrics.getMaxAscent();
        this.descent = this.metrics.getMaxDescent();
        this.height = this.ascent + this.descent;
        Container container = jFrame.getContentPane();
        container.setLayout(new GridLayout(16, 16));
        container.setBackground(Color.white);
        this.chars = new FontChar[256];
        for (int i = 0; i < 256; ++i) {
            this.chars[i] = new FontChar(i);
            container.add(this.chars[i]);
        }
        jFrame.pack();
        jFrame.show();
        ImageFont imageFont = new ImageFont();
        imageFont.setHeight(this.height);
        for (int i = 0; i < 256; ++i) {
            imageFont.setChar(i, this.chars[i].width, this.chars[i].getPixels());
        }
        imageFont.writeFont(new FileOutputStream(string));
        jFrame.dispose();
        imageFont = new ImageFont();
        imageFont.readFont(new FileInputStream(string));
        JFrame jFrame2 = new JFrame("test");
        jFrame2.setContentPane(new ImageFontLabel(imageFont, "This is a test of my ABC/123's!"));
        jFrame2.setSize(300, 100);
        jFrame2.show();
    }

    private class FontChar
    extends JComponent {
        int ch;
        int width;
        Dimension dim;
        Image buf;

        FontChar(int n) {
            this.ch = n;
            this.width = Math.max(1, Snarfont.this.metrics.charWidth(n));
            this.dim = new Dimension(this.width, Snarfont.this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.dim;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        public Dimension getMaximimSize() {
            return this.dim;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            if (this.buf == null) {
                FontChar fontChar = this;
                synchronized (fontChar) {
                    this.buf = this.createImage(this.width, Snarfont.this.height);
                    Graphics graphics2 = this.buf.getGraphics();
                    graphics2.setFont(Snarfont.this.scaledfont);
                    graphics2.setColor(Color.black);
                    graphics2.drawChars(new char[]{(char)this.ch}, 0, 1, 0, Snarfont.this.ascent);
                    this.notify();
                }
            }
            graphics.drawImage(this.buf, 0, 0, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getPixels() {
            Object object = this;
            synchronized (object) {
                if (this.buf == null) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            object = new int[this.width * Snarfont.this.height];
            PixelGrabber pixelGrabber = new PixelGrabber(this.buf, 0, 0, this.width, Snarfont.this.height, (int[])object, 0, this.width);
            try {
                if (pixelGrabber.grabPixels()) {
                    if ((pixelGrabber.getStatus() & 0x80) != 0) {
                        System.out.println("grab aborted!");
                        System.exit(1);
                    }
                    return object;
                }
                System.out.println("err grabbing pixels");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }
}

