/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import com.neuron.app.tonto.Debug;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.ui.AAPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class StackedDialog
extends AAPanel {
    private static Debug debug = Debug.getInstance("tonto");
    private Component parent;
    private JDialog dialog;
    private String title;
    private boolean modal;
    private boolean disposeOnShow;
    private static JFrame jframe = new JFrame();
    private static Stack dialogs = new Stack();

    public StackedDialog(String string) {
        this(string, true);
    }

    public StackedDialog(String string, boolean bl) {
        this.title = string;
        this.modal = bl;
    }

    public void setContentPane(Container container) {
        this.add((Component)container, "fill=b;wx=1;wy=1");
        if (container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, true), "ESC");
            jComponent.getActionMap().put("ESC", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StackedDialog.this.dispose();
                }
            });
        }
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.dialog != null) {
            this.dialog.setTitle(string);
        }
    }

    public void showHook(JDialog jDialog) {
    }

    public void repack() {
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        Component component = StackedDialog.parent();
        StackedDialog stackedDialog = this;
        synchronized (stackedDialog) {
            if (this.dialog == null || component != this.parent) {
                this.dialog = component instanceof JFrame ? new JDialog((JFrame)component, this.title, this.modal) : new JDialog((JDialog)component, this.title, this.modal);
                this.parent = component;
                this.dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent windowEvent) {
                        StackedDialog.this.windowClose();
                    }
                });
                this.dialog.setDefaultCloseOperation(2);
                Container container = this.dialog.getContentPane();
                container.setLayout(new GridLayout(1, 1));
                container.add(this);
            }
        }
        if (!this.disposeOnShow) {
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(this.parent);
            if (this.modal) {
                StackedDialog.dialogPush(this.dialog);
            }
            this.showHook(this.dialog);
            this.dialog.show();
        }
        this.disposeOnShow = false;
    }

    public void windowClose() {
        if (this.modal && this.dialog != null) {
            StackedDialog.dialogPop(this.dialog);
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            if (!this.dialog.isVisible()) {
                debug.log(2, "dispose called when dialog not visible");
            }
            this.windowClose();
            this.dialog.dispose();
        } else {
            debug.log(2, "dispose called with null dialog");
            this.disposeOnShow = true;
        }
    }

    public static Component parent() {
        if (dialogs.empty()) {
            return jframe;
        }
        return (JDialog)dialogs.peek();
    }

    private static void dialogPush(JDialog jDialog) {
        debug.log(3, "push " + Util.nickname(jDialog));
        dialogs.push(jDialog);
    }

    private static void dialogPop(JDialog jDialog) {
        debug.log(3, "pop  " + Util.nickname(jDialog));
        if (jDialog == null) {
            return;
        }
        Component component = StackedDialog.parent();
        if (component == jDialog) {
            dialogs.pop();
        } else if (dialogs.contains(jDialog)) {
            debug.log(3, "pop out of order: " + Util.nickname(jDialog) + " != " + Util.nickname(component));
            dialogs.remove(jDialog);
        }
    }

    public static void setDefaultParent(JFrame jFrame) {
        jframe = jFrame;
    }
}

