/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.io.FileInputStream;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TLabel
extends JComponent {
    public static final int ANCHOR_NW = 1;
    public static final int ANCHOR_N = 2;
    public static final int ANCHOR_NE = 3;
    public static final int ANCHOR_E = 4;
    public static final int ANCHOR_SE = 5;
    public static final int ANCHOR_S = 6;
    public static final int ANCHOR_SW = 7;
    public static final int ANCHOR_W = 8;
    public static final int ANCHOR_CENTER = 9;
    private static final int[] map = new int[256];
    private static final RenderingHints hints = new RenderingHints(new Hashtable());
    private int anchor;
    private int[] ctext;
    private String text;
    private Dimension size;
    private GlyphVector gv;

    private static final void addMap(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            TLabel.map[i + n] = i + n3;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Font font = Font.createFont(0, new FileInputStream("/tmp/pronto.ttf"));
        JFrame jFrame = new JFrame("font test");
        TLabel tLabel = new TLabel("!! Tonto Font Test U !!", 9);
        tLabel.setFont(font.deriveFont(18.0f));
        jFrame.getContentPane().add("Center", tLabel);
        jFrame.pack();
        jFrame.show();
    }

    public TLabel(String string) {
        this(string, 9);
    }

    public TLabel(String string, int n) {
        this.setText(string);
        this.setAnchor(n);
    }

    public void setText(String string) {
        this.text = string;
        this.ctext = new int[string.length()];
        for (int i = 0; i < this.ctext.length; ++i) {
            this.ctext[i] = map[string.charAt(i) & 0xFF];
            System.out.println("map (" + string.charAt(i) + ") to (" + this.ctext[i] + ")");
        }
    }

    public void setAnchor(int n) {
        this.anchor = n;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.size == null) {
            this.generateGlyph();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(hints);
        Dimension dimension = this.getSize();
        float f = 0.0f;
        float f2 = 0.0f;
        switch (this.anchor) {
            case 1: {
                graphics2D.drawGlyphVector(this.gv, 0.0f, this.size.height);
                break;
            }
            case 2: {
                graphics2D.drawGlyphVector(this.gv, (float)(dimension.width - this.size.width) / 2.0f, this.size.height);
                break;
            }
            case 3: {
                graphics2D.drawGlyphVector(this.gv, dimension.width - this.size.width, this.size.height);
                break;
            }
            case 4: {
                graphics2D.drawGlyphVector(this.gv, dimension.width - this.size.width, (float)(dimension.height + this.size.height) / 2.0f);
                break;
            }
            case 5: {
                graphics2D.drawGlyphVector(this.gv, dimension.width - this.size.width, dimension.height + this.size.height);
                break;
            }
            case 6: {
                graphics2D.drawGlyphVector(this.gv, (float)(dimension.width - this.size.width) / 2.0f, dimension.height + this.size.height);
                break;
            }
            case 7: {
                graphics2D.drawGlyphVector(this.gv, 0.0f, dimension.height);
                break;
            }
            case 8: {
                graphics2D.drawGlyphVector(this.gv, 0.0f, (float)(dimension.height + this.size.height) / 2.0f);
                break;
            }
            default: {
                graphics2D.drawGlyphVector(this.gv, (float)(dimension.width - this.size.width) / 2.0f, (float)(dimension.height + this.size.height) / 2.0f);
            }
        }
    }

    private void generateGlyph() {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setRenderingHints(hints);
        Font font = graphics2D.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.gv = font.createGlyphVector(fontRenderContext, this.ctext);
        Rectangle rectangle = this.gv.getVisualBounds().getBounds();
        this.size = new Dimension(rectangle.width, rectangle.height);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.size == null) {
            this.generateGlyph();
        }
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    static {
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        TLabel.addMap(32, 96, 3);
    }
}

