/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.app.tonto.ui;

import com.neuron.app.tonto.ITaskStatus;
import com.neuron.app.tonto.Util;
import com.neuron.app.tonto.ui.AAPanel;
import com.neuron.app.tonto.ui.ActionButton;
import com.neuron.app.tonto.ui.OKCancelDialog;
import com.neuron.app.tonto.ui.Task;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class TaskList
extends OKCancelDialog
implements ITaskStatus {
    private Vector tasks = new Vector();
    private JProgressBar current = new JProgressBar(0, 100);
    private JProgressBar total;
    private JLabel task;
    private JLabel which;
    private JLabel message;
    private double pctPerTask;
    private int taskSum;
    private int taskCount;
    private int taskWeight;
    private int taskTotals;
    private Throwable error;

    public static void main(String[] stringArray) {
        TaskList taskList = new TaskList("test list");
        taskList.addTasks(new Task[]{new Task("foo", 2){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                iTaskStatus.taskStatus(25, "abcdefg");
                TaskList.sleep(1000L);
                iTaskStatus.taskStatus(50, "hijklmn");
                TaskList.sleep(1000L);
                iTaskStatus.taskStatus(75, "opqrstu");
                TaskList.sleep(1000L);
            }
        }, new Task("bar", 1){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                iTaskStatus.taskStatus(25, "barrific");
                TaskList.sleep(1000L);
                iTaskStatus.taskStatus(50, "barrific");
                TaskList.sleep(2000L);
                iTaskStatus.taskStatus(75, "squeemish");
                TaskList.sleep(1000L);
            }
        }, new Task("xxx", 1){

            @Override
            public void invoke(ITaskStatus iTaskStatus) {
                iTaskStatus.taskStatus(30, "too cool");
                TaskList.sleep(1000L);
                iTaskStatus.taskStatus(40, "sweet");
                TaskList.sleep(1000L);
                iTaskStatus.taskStatus(75, "almost done");
                TaskList.sleep(2000L);
            }
        }});
        taskList.invoke();
    }

    private static void sleep(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public TaskList(String string) {
        super(string);
        this.current.setStringPainted(true);
        this.current.setValue(0);
        this.total = new JProgressBar(0, 100);
        this.total.setStringPainted(true);
        this.total.setValue(0);
        this.task = new JLabel("--------------------");
        this.which = new JLabel("( x of y )");
        this.message = new JLabel("--------------------");
        this.task.setForeground(Color.black);
        this.message.setForeground(Color.black);
        AAPanel aAPanel = new AAPanel();
        aAPanel.define('L', (Component)new JLabel("Task"), "pad=3,3,3,3");
        aAPanel.define('c', (Component)this.current, "pad=3,3,3,3;fill=b;wx=1");
        aAPanel.define('t', (Component)this.total, "pad=3,3,3,3;fill=b;wx=1");
        aAPanel.define('l', (Component)this.task, "pad=3,3,3,3;wx=1");
        aAPanel.define('m', (Component)this.message, "pad=3,3,3,3;wx=1");
        aAPanel.define('w', (Component)this.which, "pad=3,3,3,3");
        Util.setLabelBorder("Current", this.current);
        Util.setLabelBorder("Total", this.total);
        aAPanel.setLayout(new String[]{"L lw", "mmmm", "cccc", "tttt"});
        this.setContentPane(aAPanel);
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public void addTasks(Task[] taskArray) {
        for (int i = 0; i < taskArray.length; ++i) {
            this.addTask(taskArray[i]);
        }
    }

    private void updateTotal(int n) {
        int n2 = (int)((double)this.taskSum * this.pctPerTask) + (int)((double)this.taskWeight * this.pctPerTask * ((double)n / 100.0));
        this.total.setValue(n2);
        this.total.setString(n2 + "%");
    }

    @Override
    public void taskStatus(int n, String string) {
        int n2;
        if (string != null) {
            this.message.setText(string);
        }
        if (n - (n2 = this.current.getValue()) > 10) {
            for (int i = n2; i < n; i += 10) {
                this.current.setValue(i);
                this.updateTotal(i);
                TaskList.sleep(10L);
            }
        }
        this.current.setValue(n);
        this.current.setString(n + "%");
        this.updateTotal(n);
    }

    @Override
    public void taskError(Throwable throwable) {
        if (this.error == null || throwable == null) {
            this.error = throwable;
        }
    }

    @Override
    public void taskNotify(Object object) {
        if (object != null) {
            this.message.setText(object.toString());
        }
    }

    @Override
    public boolean invoke() {
        new Thread(){

            @Override
            public void run() {
                int n;
                TaskList.this.taskCount = TaskList.this.tasks.size();
                TaskList.this.taskTotals = 0;
                for (n = 0; n < TaskList.this.taskCount; ++n) {
                    TaskList.this.taskTotals = TaskList.this.taskTotals + ((Task)TaskList.this.tasks.get(n)).getWeight();
                }
                TaskList.this.pctPerTask = 100.0 / (double)TaskList.this.taskTotals;
                for (n = 0; n < TaskList.this.taskCount; ++n) {
                    Task task = (Task)TaskList.this.tasks.get(n);
                    TaskList.this.task.setText(task.getName());
                    TaskList.this.taskWeight = task.getWeight();
                    TaskList.this.which.setText("(" + (n + 1) + " of " + TaskList.this.taskCount + ")");
                    task.invoke(TaskList.this);
                    if (TaskList.this.error != null) {
                        TaskList.this.escCancel();
                        Util.errorDialog(TaskList.this.error.getMessage(), null);
                        break;
                    }
                    TaskList.this.taskStatus(100, "Complete");
                    TaskList.this.taskSum = TaskList.this.taskSum + TaskList.this.taskWeight;
                }
                TaskList.sleep(100L);
                TaskList.this.enterOK();
            }
        }.start();
        return super.invoke();
    }

    @Override
    public JComponent getButtons() {
        JPanel jPanel = new JPanel();
        jPanel.add(new ActionButton("Cancel"){

            @Override
            public void action() {
                TaskList.this.escCancel();
            }
        });
        return jPanel;
    }

    @Override
    public void doOK() {
    }

    @Override
    public void doCancel() {
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = super.getMinimumSize();
        return new Dimension(Math.max(250, dimension.width), dimension.height);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.max(250, dimension.width), dimension.height);
    }
}

