/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public final class ByteOutputBuffer
extends OutputStream {
    private int blen;
    private int idx;
    private int size;
    private int waiters;
    private Vector v;
    private byte[] cur;
    private boolean closed;
    private int readPtr;
    private int readIdx;
    private int readOff;
    private byte[] readBuf;

    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteOutputBuffer byteOutputBuffer = new ByteOutputBuffer(4096);
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray)) >= 0) {
            byteOutputBuffer.write(byArray, 0, n);
        }
        return byteOutputBuffer.toByteArray();
    }

    public ByteOutputBuffer() {
        this(256);
    }

    public ByteOutputBuffer(int n) {
        this.blen = n;
        this.idx = 0;
        this.size = 0;
        this.waiters = 0;
        this.v = new Vector();
        this.cur = new byte[this.blen];
        this.closed = false;
    }

    public synchronized void reset() {
        this.idx = 0;
        this.size = 0;
        this.v.removeAllElements();
    }

    @Override
    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ByteOutputBuffer byteOutputBuffer = this;
        synchronized (byteOutputBuffer) {
            this.notify();
            this.closed = true;
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Stream is already closed");
        }
        if (this.idx >= this.blen) {
            this._roll();
        }
        this.cur[this.idx++] = (byte)n;
        ++this.size;
        if (this.waiters > 0) {
            this.notify();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.closed) {
            throw new IOException("Stream is already closed");
        }
        int n4 = n2;
        while ((n3 = this.blen - this.idx) < n2) {
            System.arraycopy(byArray, n, this.cur, this.idx, n3);
            this._roll();
            n += n3;
            n2 -= n3;
        }
        System.arraycopy(byArray, n, this.cur, this.idx, n2);
        this.idx += n2;
        this.size += n4;
        if (this.waiters > 0) {
            this.notify();
        }
    }

    public int size() {
        return this.size;
    }

    private void _roll() {
        this.v.addElement(this.cur);
        if (this.blen < 0x100000) {
            this.blen *= 2;
        }
        this.cur = new byte[this.blen];
        this.idx = 0;
    }

    public synchronized void writeToStream(OutputStream outputStream) throws IOException {
        int n = this.v.size();
        for (int i = 0; i < n; ++i) {
            outputStream.write((byte[])this.v.elementAt(i));
        }
        outputStream.write(this.cur, 0, this.idx);
    }

    public synchronized byte[] toByteArray() {
        int n = 0;
        byte[] byArray = new byte[this.size];
        int n2 = this.v.size();
        for (int i = 0; i < n2; ++i) {
            byte[] byArray2 = (byte[])this.v.elementAt(i);
            int n3 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, n, n3);
            n += n3;
        }
        System.arraycopy(this.cur, 0, byArray, n, this.idx);
        return byArray;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String string) throws Exception {
        return new String(this.toByteArray(), string);
    }

    public void resetRead() {
        this.readIdx = 0;
        this.readPtr = 0;
        this.readOff = 0;
        this.readBuf = null;
    }

    public synchronized int read() {
        if (!this._waitData()) {
            return -1;
        }
        int n = this.readBuf[this.readOff++] & 0xFF;
        ++this.readIdx;
        if (this.readOff >= this.readBuf.length) {
            this._incrReadBuf();
        }
        return n;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        int n3;
        if (!this._waitData()) {
            return -1;
        }
        int n4 = Math.min(n2, this.available());
        for (int i = 0; i < n4; i += n3) {
            n3 = Math.min(n2 - i, this._leftInBuf());
            System.arraycopy(this.readBuf, this.readOff, byArray, n + i, n3);
            this.readOff += n3;
            this.readIdx += n3;
            if (this.readOff < this.readBuf.length) continue;
            this._incrReadBuf();
        }
        return n4;
    }

    private boolean _waitData() {
        if (this._leftInBuf() > 0) {
            return true;
        }
        if (this._buffersLeft() <= 0) {
            if (this.closed) {
                return this._incrReadBuf();
            }
            try {
                ++this.waiters;
                this.wait();
                --this.waiters;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                --this.waiters;
                return false;
            }
        }
        if (this.readBuf == null) {
            this._incrReadBuf();
        }
        return this._leftInBuf() > 0;
    }

    public byte[] getRemainder() {
        byte[] byArray = this.toByteArray();
        byte[] byArray2 = new byte[this.size - this.readIdx];
        System.arraycopy(byArray, this.readIdx, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private int _buffersLeft() {
        return this.v.size() - this.readPtr;
    }

    private int _leftInBuf() {
        if (this.readBuf == null) {
            return 0;
        }
        return Math.min(this.readBuf.length - this.readOff, this.size - this.readIdx);
    }

    public int available() {
        return this.size - this.readIdx;
    }

    private boolean _incrReadBuf() {
        if (this.readPtr < this.v.size()) {
            this.readOff = 0;
            this.readBuf = (byte[])this.v.elementAt(this.readPtr++);
            return true;
        }
        if (this.readPtr == this.v.size()) {
            this.readOff = 0;
            this.readBuf = this.cur;
            ++this.readPtr;
            return true;
        }
        return false;
    }
}

