/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XORInputStream
extends BufferedInputStream {
    private byte[] key;
    private int ptr;

    public XORInputStream(InputStream inputStream, byte[] byArray) {
        super(inputStream);
        this.key = byArray;
        this.ptr = 0;
    }

    @Override
    public int read() throws IOException {
        int n = super.read();
        if (n >= 0) {
            if (this.ptr >= this.key.length) {
                this.ptr = 0;
            }
            return n ^ this.key[this.ptr++] & 0xFF;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            for (int i = 0; i < n3; ++i) {
                if (this.ptr >= this.key.length) {
                    this.ptr = 0;
                }
                byArray[i + n] = (byte)(byArray[i + n] ^ this.key[this.ptr++] & 0xFF);
            }
        }
        return n3;
    }
}

