/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb;

import com.neuron.irdb.IRBurstCode;
import com.neuron.irdb.IRSignal;
import com.neuron.irdb.IntArray;
import com.neuron.irdb.PulseIndex;
import com.neuron.irdb.PulsePair;

public class IRBurst {
    private IRBurstCode burstCode;
    private IRSignal signal;
    private IntArray pulses = new IntArray();

    IRBurst(IRSignal iRSignal) {
        this.signal = iRSignal;
        this.pulses = new IntArray();
    }

    IRBurst(IRSignal iRSignal, int[] nArray) {
        this(iRSignal);
        this.setPulses(nArray);
    }

    public IRBurst getClone(IRSignal iRSignal) {
        return new IRBurst(iRSignal, this.pulses.getValues());
    }

    public IRBurstCode[] split() {
        int[] nArray = this.getPulses();
        if (nArray.length > 0 && nArray.length % 2 == 0) {
            int[] nArray2 = new int[nArray.length / 2];
            int[] nArray3 = new int[nArray.length / 2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            System.arraycopy(nArray, nArray2.length, nArray3, 0, nArray3.length);
            IRBurstCode[] iRBurstCodeArray = new IRBurstCode[]{new IRBurst(this.signal, nArray2).getBurstCode(), new IRBurst(this.signal, nArray3).getBurstCode()};
            if (iRBurstCodeArray[0] != null && iRBurstCodeArray[1] != null && iRBurstCodeArray[0].similar(iRBurstCodeArray[1])) {
                return iRBurstCodeArray;
            }
            return null;
        }
        return null;
    }

    public boolean subtract(IRBurst iRBurst) {
        if (iRBurst == null) {
            return false;
        }
        int[] nArray = this.getPulses();
        int[] nArray2 = iRBurst.getPulses();
        if (nArray.length == 0 || nArray2.length == 0 || nArray2.length > nArray.length) {
            return false;
        }
        int n = nArray.length - nArray2.length;
        for (int i = 0; i < n + 1; ++i) {
            if (!this.match(nArray, i, nArray2)) continue;
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, i);
            System.arraycopy(nArray, i + nArray2.length, nArray3, i, nArray.length - nArray2.length - i);
            this.setPulses(nArray3);
            return true;
        }
        return false;
    }

    private boolean match(int[] nArray, int n, int[] nArray2) {
        if (nArray.length - n < nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray[i + n] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof IRBurst) {
            int[] nArray = ((IRBurst)object).getPulses();
            int[] nArray2 = ((IRBurst)object).getPulseIndex().getIndexValues();
            int[] nArray3 = this.getPulses();
            int[] nArray4 = this.getPulseIndex().getIndexValues();
            if (nArray.length != nArray3.length) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (IRSignal.inRange(nArray2[nArray[i]], nArray4[nArray3[i]], 20)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int get(int n) {
        return this.pulses.get(n);
    }

    public IRSignal getSignal() {
        return this.signal;
    }

    public PulseIndex getPulseIndex() {
        return this.signal.getPulseIndex();
    }

    public void setPulses(int[] nArray) {
        this.burstCode = null;
        this.pulses.setSize(0);
        this.pulses.append(nArray);
    }

    public int[] getPulses() {
        return this.pulses.getValues();
    }

    public PulsePair[] getPulsePairs() {
        int[] nArray = this.getPulses();
        int n = nArray.length / 2;
        PulsePair[] pulsePairArray = new PulsePair[n];
        for (int i = 0; i < n; ++i) {
            pulsePairArray[i] = new PulsePair(nArray[i * 2], nArray[i * 2 + 1]);
        }
        return pulsePairArray;
    }

    public int[] getPulseValues() {
        int[] nArray = this.getPulseIndex().getIndexValues();
        int[] nArray2 = this.getPulses();
        int[] nArray3 = new int[nArray2.length];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = nArray[nArray2[i]];
        }
        return nArray3;
    }

    public IRBurstCode getBurstCode() {
        if (this.burstCode == null) {
            this.burstCode = IRBurstCode.createCode(this);
        }
        return this.burstCode;
    }

    public int getBurstLength() {
        int[] nArray = this.getPulseValues();
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n += nArray[i];
        }
        return n;
    }

    public int cullRepeats() {
        int[] nArray = this.getPulses();
        int n = nArray.length;
        if (n < 30 || n % 2 != 0) {
            return 0;
        }
        this.burstCode = null;
        block0: for (int i = 10; i > 1; --i) {
            if (n % i != 0) continue;
            int n2 = n / i;
            for (int j = 0; j < n2; ++j) {
                for (int k = 1; k < i; ++k) {
                    if (nArray[j] != nArray[k * n2 + j]) continue block0;
                }
            }
            this.pulses.setSize(n2);
            return i - 1;
        }
        return 0;
    }

    public int length() {
        return this.pulses.size();
    }

    public boolean empty() {
        return this.length() == 0;
    }

    public void clear() {
        this.burstCode = null;
        this.setLength(0);
    }

    public void setLength(int n) {
        this.burstCode = null;
        this.pulses.setSize(n);
    }

    public void addTimePulse(int n) {
        this.burstCode = null;
        this.pulses.append(this.getPulseIndex().addPulse(n));
    }

    public void addIndexPulse(int n) {
        this.burstCode = null;
        this.pulses.append(n);
    }

    public void decodePulseString(String string) {
        string = string.trim();
        int[] nArray = new int[string.length()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = string.charAt(i) - 48;
        }
        this.setPulses(nArray);
    }

    public String getPulseString() {
        return this.pulses.getString(null);
    }

    public String toString() {
        return this.getPulseString();
    }
}

