/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb;

import com.neuron.irdb.IRBurst;
import com.neuron.irdb.IRSignal;
import com.neuron.irdb.PulseIndex;
import com.neuron.irdb.PulsePair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IRBurstCode {
    private IRSignal signal;
    private boolean valid;
    private int bits;
    private long code;
    private PulsePair bit0;
    private PulsePair bit1;
    private Vector head = new Vector();
    private Vector tail = new Vector();
    private Hashtable pairs = new Hashtable();

    private static void debug(String string) {
        System.out.println(string);
    }

    public static IRBurstCode createCode(IRBurst iRBurst) {
        IRBurstCode iRBurstCode = new IRBurstCode(iRBurst);
        return iRBurstCode.valid ? iRBurstCode : null;
    }

    public IRBurstCode(IRSignal iRSignal) {
        this.signal = iRSignal;
    }

    private int len(PulsePair pulsePair) {
        PulseIndex pulseIndex = this.signal.getPulseIndex();
        return pulseIndex.getPulse(pulsePair.getBit0()) + pulseIndex.getPulse(pulsePair.getBit1());
    }

    public IRBurstCode(IRBurst iRBurst) {
        this.valid = true;
        this.signal = iRBurst.getSignal();
        Vector<PulsePair> vector = new Vector<PulsePair>();
        PulsePair[] pulsePairArray = iRBurst.getPulsePairs();
        if (pulsePairArray.length == 0) {
            this.valid = false;
            return;
        }
        for (int i = 0; i < pulsePairArray.length; ++i) {
            vector.add(pulsePairArray[i]);
            this.addPair(pulsePairArray[i]);
        }
        this.bit0 = this.removeMostCommon();
        this.bit1 = this.removeMostCommon();
        if (this.bit0 == null || this.bit1 == null) {
            this.valid = false;
            return;
        }
        if (this.len(this.bit0) > this.len(this.bit1)) {
            PulsePair pulsePair = this.bit0;
            this.bit0 = this.bit1;
            this.bit1 = pulsePair;
        }
        Vector<PulsePair> vector2 = new Vector<PulsePair>();
        Enumeration enumeration = vector.elements();
        PulsePair pulsePair = (PulsePair)enumeration.nextElement();
        while (pulsePair != null && !pulsePair.equals(this.bit0) && !pulsePair.equals(this.bit1)) {
            this.head.add(pulsePair);
            pulsePair = enumeration.hasMoreElements() ? (PulsePair)enumeration.nextElement() : null;
        }
        while (pulsePair != null && (pulsePair.equals(this.bit0) || pulsePair.equals(this.bit1))) {
            vector2.add(pulsePair);
            pulsePair = enumeration.hasMoreElements() ? (PulsePair)enumeration.nextElement() : null;
        }
        while (pulsePair != null && !pulsePair.equals(this.bit0) && !pulsePair.equals(this.bit1)) {
            this.tail.add(pulsePair);
            pulsePair = enumeration.hasMoreElements() ? (PulsePair)enumeration.nextElement() : null;
        }
        if (enumeration.hasMoreElements()) {
            this.valid = false;
            return;
        }
        this.bits = vector2.size();
        for (long i = 0L; i < (long)this.bits; ++i) {
            if (!vector2.get((int)i).equals(this.bit1)) continue;
            this.code |= 1L << (int)((long)this.bits - i - 1L);
        }
    }

    private PulsePair removeMostCommon() {
        PulsePair pulsePair = null;
        int n = 0;
        Enumeration enumeration = this.pairs.keys();
        while (enumeration.hasMoreElements()) {
            PulsePair pulsePair2 = (PulsePair)enumeration.nextElement();
            int n2 = (Integer)this.pairs.get(pulsePair2);
            if (n2 <= n) continue;
            pulsePair = pulsePair2;
            n = n2;
        }
        if (pulsePair == null) {
            return null;
        }
        this.pairs.remove(pulsePair);
        return pulsePair;
    }

    private boolean same(PulsePair pulsePair, PulsePair pulsePair2) {
        if (pulsePair == null || pulsePair2 == null) {
            return pulsePair == pulsePair2;
        }
        return pulsePair.equals(pulsePair2);
    }

    private boolean same(Vector vector, Vector vector2) {
        if (vector == null || vector2 == null) {
            return vector == vector2;
        }
        if (vector.size() != vector2.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            PulsePair pulsePair;
            PulsePair pulsePair2 = (PulsePair)vector.get(i);
            if (pulsePair2.equals(pulsePair = (PulsePair)vector2.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean similar(IRBurstCode iRBurstCode) {
        return iRBurstCode.getBitCount() == this.getBitCount() && this.same(iRBurstCode.bit0, this.bit0) && this.same(iRBurstCode.bit1, this.bit1) && this.same(iRBurstCode.head, this.head) && this.same(iRBurstCode.tail, this.tail);
    }

    public void swapBits() {
        for (long i = 0L; i < (long)this.bits; ++i) {
            long l = 1L << (int)((long)this.bits - i - 1L);
            this.code ^= l;
        }
        PulsePair pulsePair = this.bit0;
        this.bit0 = this.bit1;
        this.bit1 = pulsePair;
    }

    public int getBitCount() {
        return this.bits;
    }

    public void setBitCount(int n) {
        this.bits = n;
    }

    public long getValue() {
        return this.code;
    }

    public void setValue(long l) {
        this.code = l;
    }

    public PulsePair getBit0() {
        return this.bit0;
    }

    public void setBit0(PulsePair pulsePair) {
        this.bit0 = pulsePair;
    }

    public PulsePair getBit1() {
        return this.bit1;
    }

    public void setBit1(PulsePair pulsePair) {
        this.bit1 = pulsePair;
    }

    public PulsePair[] getHead() {
        return (PulsePair[])this.head.toArray();
    }

    public String getHeadString() {
        return this.seq(this.head);
    }

    public void setHead(PulsePair[] pulsePairArray) {
        if (pulsePairArray == null) {
            return;
        }
        this.head = new Vector();
        for (int i = 0; i < pulsePairArray.length; ++i) {
            this.head.add(pulsePairArray[i]);
        }
    }

    public void setHead(Vector vector) {
        this.head = vector;
    }

    public PulsePair[] getTail() {
        return (PulsePair[])this.head.toArray();
    }

    public String getTailString() {
        return this.seq(this.tail);
    }

    public void setTail(Vector vector) {
        this.tail = vector;
    }

    public void setTail(PulsePair[] pulsePairArray) {
        if (pulsePairArray == null) {
            return;
        }
        this.tail = new Vector();
        for (int i = 0; i < pulsePairArray.length; ++i) {
            this.tail.add(pulsePairArray[i]);
        }
    }

    public IRBurst getIRBurst() {
        Vector vector = new Vector();
        for (int i = 0; i < this.head.size(); ++i) {
            vector.add(this.head.get(i));
        }
        for (long i = 0L; i < (long)this.bits; ++i) {
            long l = 1L << (int)((long)this.bits - i - 1L);
            vector.add((this.code & l) == l ? this.bit1 : this.bit0);
        }
        for (int i = 0; i < this.tail.size(); ++i) {
            vector.add(this.tail.get(i));
        }
        Object[] objectArray = vector.toArray();
        PulsePair[] pulsePairArray = new PulsePair[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            pulsePairArray[i] = (PulsePair)objectArray[i];
        }
        int[] nArray = new int[pulsePairArray.length * 2];
        for (int i = 0; i < pulsePairArray.length; ++i) {
            nArray[i * 2 + 0] = pulsePairArray[i].getBit0();
            nArray[i * 2 + 1] = pulsePairArray[i].getBit1();
        }
        return new IRBurst(this.signal, nArray);
    }

    private void addPair(PulsePair pulsePair) {
        Integer n = (Integer)this.pairs.get(pulsePair);
        if (n != null) {
            this.pairs.put(pulsePair, new Integer(n + 1));
        } else {
            this.pairs.put(pulsePair, new Integer(1));
        }
    }

    private String bits(int n, long l) {
        char[] cArray = new char[n];
        for (long i = 0L; i < (long)n; ++i) {
            long l2 = 1L << (int)((long)n - i - 1L);
            cArray[(int)i] = (l & l2) == l2 ? 49 : 48;
        }
        return new String(cArray, 0, cArray.length);
    }

    private String seq(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString());
        }
        return stringBuffer.toString();
    }

    public void decode(String string) {
        Tokenizer tokenizer = new Tokenizer(string.trim());
        this.bits = Integer.parseInt(tokenizer.next());
        tokenizer.next();
        this.code = Long.parseLong(tokenizer.next(), 16);
        this.bit0 = IRBurstCode.parsePulsePair(tokenizer.next());
        this.bit1 = IRBurstCode.parsePulsePair(tokenizer.next());
        this.head = IRBurstCode.parsePulsePairs(tokenizer.next());
        this.tail = IRBurstCode.parsePulsePairs(tokenizer.next());
    }

    public static PulsePair parsePulsePair(String string) {
        string = string.trim();
        return new PulsePair(string.charAt(0) - 48, string.charAt(1) - 48);
    }

    public static Vector parsePulsePairs(String string) {
        string = string.trim();
        int n = string.length() / 2;
        Vector<PulsePair> vector = new Vector<PulsePair>();
        for (int i = 0; i < n; ++i) {
            vector.add(new PulsePair(string.charAt(i * 2) - 48, string.charAt(i * 2 + 1) - 48));
        }
        return vector;
    }

    public String getBitString() {
        return this.bits(this.bits, this.code);
    }

    public static long decodeBitString(String string) {
        string = string.trim();
        long l = 0L;
        long l2 = string.length();
        for (long i = 0L; i < l2; ++i) {
            if (string.charAt((int)i) != '1') continue;
            l |= 1L << (int)(l2 - i - 1L);
        }
        return l;
    }

    public String toShortString() {
        return this.bits + "," + Long.toHexString(this.code) + "," + this.bit0 + "," + this.bit1 + "," + this.seq(this.head) + "," + this.seq(this.tail);
    }

    public String toString() {
        return this.bits + "," + this.bits(this.bits, this.code) + "," + Long.toHexString(this.code) + "," + this.bit0 + "," + this.bit1 + "," + this.seq(this.head) + "," + this.seq(this.tail);
    }

    private class Tokenizer {
        private String str;
        private int pos;

        Tokenizer(String string) {
            this.str = string;
            this.pos = 0;
        }

        String next() {
            int n = this.str.indexOf(44, this.pos);
            if (n >= 0) {
                String string = this.str.substring(this.pos, n);
                this.pos = n + 1;
                return string;
            }
            return this.str.substring(this.pos);
        }
    }
}

