/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb;

import com.neuron.irdb.IRRemote;
import com.neuron.irdb.IRSignal;
import com.neuron.irdb.impl.Pronto;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class IRDatabase {
    private static final String pad = "                                             ";
    private String file;
    private Vector remotes;

    public static IRDatabase create(String string) throws IOException {
        return new IRDatabase(string, false);
    }

    public static IRDatabase open(String string) throws IOException {
        return new IRDatabase(string, true);
    }

    public static void main(String[] stringArray) throws IOException {
        IRDatabase.open(stringArray[0]);
    }

    private IRDatabase(String string, boolean bl) throws IOException {
        this.file = string;
        this.remotes = new Vector();
        if (bl) {
            try {
                this.read(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void read(String string) throws IOException {
        if (!new File(string).exists()) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        IRRemote iRRemote = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            Object object;
            String string3;
            Object object2;
            int n;
            if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
            if (string2.charAt(0) == '[') {
                n = string2.indexOf(93);
                if (n < 0) continue;
                string2 = string2.substring(1, n);
                object2 = new StringTokenizer(string2, ",");
                string3 = ((StringTokenizer)object2).nextToken();
                object = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken() : "unknown";
                String string4 = ((StringTokenizer)object2).hasMoreTokens() ? ((StringTokenizer)object2).nextToken() : "";
                iRRemote = new IRRemote(string3, (String)object, string4);
                this.add(iRRemote);
                continue;
            }
            if (iRRemote == null || (n = string2.indexOf(61)) < 0) continue;
            object2 = string2.substring(0, n).trim();
            string3 = string2.substring(n + 1).trim();
            if (string3.startsWith("Pronto")) {
                object = new Pronto(string3.substring(7));
                ((IRSignal)object).setName((String)object2);
                iRRemote.add((IRSignal)object);
                continue;
            }
            object = new IRSignal();
            ((IRSignal)object).setName((String)object2);
            ((IRSignal)object).decode(string3);
            iRRemote.add((IRSignal)object);
        }
    }

    public void write() throws IOException {
        this.write(this.file);
    }

    private String pad(String string, int n) {
        if (string.length() < n) {
            return string + pad.substring(0, n - string.length());
        }
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    public void write(String string) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n = 0;
        Object object5 = this.remotes.elements();
        while (object5.hasMoreElements()) {
            object4 = (IRRemote)object5.nextElement();
            object3 = ((IRRemote)object4).getKeys();
            while (object3.hasMoreElements()) {
                object2 = (IRSignal)object3.nextElement();
                object = ((IRSignal)object2).getName();
                if (object == null || ((String)object).length() <= n) continue;
                n = ((String)object).length();
            }
        }
        object5 = new BufferedWriter(new FileWriter(string));
        object4 = this.remotes.elements();
        while (object4.hasMoreElements()) {
            object3 = (IRRemote)object4.nextElement();
            ((Writer)object5).write("[" + ((IRRemote)object3).getModel() + "," + ((IRRemote)object3).getCompany() + "," + ((IRRemote)object3).getDescription() + "]");
            ((BufferedWriter)object5).newLine();
            object2 = ((IRRemote)object3).getKeys();
            while (object2.hasMoreElements()) {
                object = (IRSignal)object2.nextElement();
                ((Writer)object5).write("  " + this.pad(((IRSignal)object).getName(), n) + " = " + ((IRSignal)object).toString());
                ((BufferedWriter)object5).newLine();
            }
        }
        ((BufferedWriter)object5).flush();
        ((BufferedWriter)object5).close();
    }

    public void add(IRRemote iRRemote) {
        this.remotes.add(iRRemote);
    }

    public boolean remove(IRRemote iRRemote) {
        return this.remotes.remove(iRRemote);
    }

    public void clear() {
        this.remotes.clear();
    }

    public int size() {
        return this.remotes.size();
    }

    public IRRemote getByIndex(int n) {
        return (IRRemote)this.remotes.get(n);
    }

    public Enumeration getRemotes() {
        return this.remotes.elements();
    }
}

