/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb;

import com.neuron.irdb.IRBurstCode;
import com.neuron.irdb.IRSignal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class IRRemote {
    public static final int SORT_NAME = 1;
    public static final int SORT_INTRO = 2;
    public static final int SORT_REPEAT = 3;
    private String model;
    private String company;
    private String desc;
    private Vector keys = new Vector();

    public IRRemote(String string, String string2, String string3) {
        this.setModel(string);
        this.setCompany(string2);
        this.setDescription(string3);
    }

    public String toString() {
        return "[" + this.model + "," + this.company + "," + this.desc + "]";
    }

    public void sort(int n, boolean bl) {
        if (n < 1 || n > 3) {
            return;
        }
        IRSignal[] iRSignalArray = new IRSignal[this.keys.size()];
        this.keys.toArray(iRSignalArray);
        final int n2 = n;
        final int n3 = bl ? -1 : 1;
        Arrays.sort(iRSignalArray, new Comparator(){

            public int compare(Object object, Object object2) {
                long l;
                if (!(object instanceof IRSignal) || !(object2 instanceof IRSignal)) {
                    return 1;
                }
                IRSignal iRSignal = (IRSignal)object;
                IRSignal iRSignal2 = (IRSignal)object2;
                IRBurstCode iRBurstCode = null;
                IRBurstCode iRBurstCode2 = null;
                switch (n2) {
                    case 1: {
                        String string = iRSignal.getName();
                        String string2 = iRSignal2.getName();
                        if (string == null || string2 == null) {
                            return 0;
                        }
                        return string.compareTo(string2) * n3;
                    }
                    case 2: {
                        iRBurstCode = iRSignal.getIntro().getBurstCode();
                        iRBurstCode2 = iRSignal2.getIntro().getBurstCode();
                        break;
                    }
                    case 3: {
                        iRBurstCode = iRSignal.getRepeat().getBurstCode();
                        iRBurstCode2 = iRSignal2.getRepeat().getBurstCode();
                    }
                }
                long l2 = iRBurstCode != null ? iRBurstCode.getValue() : 0L;
                long l3 = l = iRBurstCode2 != null ? iRBurstCode2.getValue() : 0L;
                if (l2 > l) {
                    return 1 * n3;
                }
                if (l > l2) {
                    return -1 * n3;
                }
                return 0;
            }

            @Override
            public boolean equals(Object object) {
                return object == this;
            }
        });
        this.keys.setSize(0);
        for (int i = 0; i < iRSignalArray.length; ++i) {
            this.keys.add(iRSignalArray[i]);
        }
    }

    private String valid(String string) {
        if (string == null) {
            return "";
        }
        return string.replace(',', '_');
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String string) {
        this.model = this.valid(string);
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String string) {
        this.company = this.valid(string);
    }

    public String getDescription() {
        return this.desc;
    }

    public void setDescription(String string) {
        this.desc = this.valid(string);
    }

    public void add(IRSignal iRSignal) {
        this.keys.add(iRSignal);
    }

    public boolean remove(int n) {
        return this.keys.remove(n) != null;
    }

    public void clear() {
        this.keys.clear();
    }

    public boolean remove(String string) {
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!((IRSignal)this.keys.get(i)).getName().equals(string)) continue;
            this.keys.remove(i);
            return true;
        }
        return false;
    }

    public IRSignal getByIndex(int n) {
        return (IRSignal)this.keys.get(n);
    }

    public IRSignal get(String string) {
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!((IRSignal)this.keys.get(i)).getName().equals(string)) continue;
            return (IRSignal)this.keys.get(i);
        }
        return null;
    }

    public Enumeration getKeys() {
        return this.keys.elements();
    }

    public int numKeys() {
        return this.keys.size();
    }
}

