/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb;

import com.neuron.irdb.IRBurst;
import com.neuron.irdb.IRBurstCode;
import com.neuron.irdb.PulseIndex;
import java.util.StringTokenizer;

public class IRSignal {
    private static final int TYPE_OLD = 0;
    private static final int TYPE_NEW = 1;
    public static final int REPEAT_NORM = 0;
    public static final int REPEAT_FULL = 1;
    public static final int REPEAT_NONE = 2;
    private String name;
    private int type;
    private int freq;
    private PulseIndex index;
    private IRBurst intro;
    private IRBurst repeat;
    private int minRepeat;
    private int repeatType;

    public static boolean inRange(int n, int n2, int n3) {
        if (n == n2) {
            return true;
        }
        double d = (double)n3 / 100.0;
        int n4 = Math.abs(n - n2);
        return (double)n4 < (double)n * d || (double)n4 < (double)n2 * d;
    }

    public IRSignal() {
        this.name = "";
        this.index = new PulseIndex();
        this.intro = new IRBurst(this);
        this.repeat = new IRBurst(this);
        this.setFrequency(38500);
        this.index.setPulses(new int[]{1500, 3500, 7000, 50000});
    }

    public IRSignal(IRSignal iRSignal) {
        this.copyFrom(iRSignal);
    }

    public IRSignal getClone() {
        return new IRSignal(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.replace('=', '_').replace(' ', '_');
    }

    public boolean decode(String string) {
        IRBurstCode iRBurstCode;
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{;}", true);
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("{")) {
            this.type = 0;
        } else {
            this.type = Integer.parseInt(string2);
            stringTokenizer.nextToken();
            this.setFlags(stringTokenizer.nextToken());
            stringTokenizer.nextToken();
        }
        this.setFrequency(Integer.parseInt(stringTokenizer.nextToken()));
        stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken().trim(), ",");
        int[] nArray = new int[stringTokenizer2.countTokens()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringTokenizer2.nextToken());
        }
        this.index = new PulseIndex(nArray);
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string3.equals(";")) {
            string3 = "";
        } else {
            stringTokenizer.nextToken();
        }
        String string4 = stringTokenizer.nextToken();
        if (string4.equals(";")) {
            string4 = "";
        } else {
            stringTokenizer.nextToken();
        }
        if (string3.indexOf(44) >= 0) {
            iRBurstCode = this.createBurstCode();
            iRBurstCode.decode(string3);
            this.intro = iRBurstCode.getIRBurst();
        } else {
            this.intro = new IRBurst(this);
            for (int i = 0; i < string3.length(); ++i) {
                this.intro.addIndexPulse(string3.charAt(i) - 48);
            }
        }
        if (string4.indexOf(44) >= 0) {
            iRBurstCode = this.createBurstCode();
            iRBurstCode.decode(string4);
            this.repeat = iRBurstCode.getIRBurst();
        } else {
            this.repeat = new IRBurst(this);
            for (int i = 0; i < string4.length(); ++i) {
                this.repeat.addIndexPulse(string4.charAt(i) - 48);
            }
        }
        this.minRepeat = Integer.parseInt(stringTokenizer.nextToken());
        return true;
    }

    public String encode() {
        return this.toString();
    }

    public void setFlags(String string) {
        if (string == null) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            return;
        }
        switch (string.charAt(0)) {
            case 'S': {
                this.repeatType = 0;
                break;
            }
            case 'F': {
                this.repeatType = 1;
                break;
            }
            case 'N': {
                this.repeatType = 2;
            }
        }
    }

    public String getFlags() {
        switch (this.repeatType) {
            case 0: {
                return "S";
            }
            case 1: {
                return "F";
            }
            case 2: {
                return "N";
            }
        }
        return "";
    }

    public int getRepeatType() {
        return this.repeatType;
    }

    public void setRepeatType(int n) {
        this.repeatType = n;
    }

    public void copyFrom(IRSignal iRSignal) {
        this.setup(iRSignal.getFrequency(), iRSignal.getPulseIndex().getClone(), iRSignal.getIntro().getClone(this), iRSignal.getRepeat().getClone(this), iRSignal.getMinRepeat(), iRSignal.getRepeatType());
        this.setName(iRSignal.getName());
    }

    private void setup(int n, PulseIndex pulseIndex, IRBurst iRBurst, IRBurst iRBurst2, int n2, int n3) {
        this.freq = n;
        this.index = pulseIndex;
        this.intro = iRBurst;
        this.repeat = iRBurst2;
        this.minRepeat = n2;
        this.repeatType = n3;
    }

    public int hashCode() {
        return this.intro.getPulseString().hashCode() + this.repeat.getPulseString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof IRSignal) {
            IRSignal iRSignal = (IRSignal)object;
            int n = this.getFrequency();
            return IRSignal.inRange(n, iRSignal.getFrequency(), 15) && this.getIntro().equals(iRSignal.getIntro()) && this.getRepeat().equals(iRSignal.getRepeat());
        }
        return false;
    }

    public int getFrequency() {
        return Math.max(this.freq, 1);
    }

    public PulseIndex getPulseIndex() {
        return this.index;
    }

    public IRBurst getIntro() {
        return this.intro;
    }

    public IRBurst getRepeat() {
        return this.repeat;
    }

    public int getMinRepeat() {
        return this.minRepeat;
    }

    public int getMinSigTime() {
        return this.intro.getBurstLength() + this.repeat.getBurstLength();
    }

    public void setFrequency(int n) {
        this.freq = n;
    }

    public void setPulseIndex(PulseIndex pulseIndex) {
        this.index = pulseIndex;
    }

    public void setIntro(IRBurst iRBurst) {
        this.intro = iRBurst;
    }

    public void setRepeat(IRBurst iRBurst) {
        this.repeat = iRBurst;
    }

    public void setMinRepeat(int n) {
        this.minRepeat = n;
    }

    public IRBurst createBurst() {
        return new IRBurst(this);
    }

    public IRBurstCode createBurstCode() {
        return new IRBurstCode(this);
    }

    public void cleanup() {
        IRBurstCode[] iRBurstCodeArray;
        IRBurst iRBurst = this.getIntro();
        IRBurst iRBurst2 = this.getRepeat();
        if (iRBurst.empty() && iRBurst2.empty()) {
            return;
        }
        if (!iRBurst.empty() && !iRBurst2.empty()) {
            if (iRBurst2.subtract(iRBurst)) {
                this.setRepeatType(1);
            }
        } else if (iRBurst.empty()) {
            IRBurstCode[] iRBurstCodeArray2 = iRBurst2.split();
            if (iRBurstCodeArray2 != null) {
                this.setIntro(iRBurstCodeArray2[0].getIRBurst());
                this.setRepeat(iRBurstCodeArray2[1].getIRBurst());
                this.setRepeatType(1);
            }
        } else if (iRBurst2.empty() && (iRBurstCodeArray = iRBurst.split()) != null) {
            this.setIntro(iRBurstCodeArray[0].getIRBurst());
            this.setRepeat(iRBurstCodeArray[1].getIRBurst());
            this.setRepeatType(2);
        }
    }

    public String toString() {
        IRBurstCode iRBurstCode = this.intro.getBurstCode();
        IRBurstCode iRBurstCode2 = this.repeat.getBurstCode();
        return "1;" + this.getFlags() + ";" + this.freq + ";" + this.index + ";" + (iRBurstCode != null ? iRBurstCode.toString() : this.intro.toString()) + ";" + (iRBurstCode2 != null ? iRBurstCode2.toString() : this.repeat.toString()) + ";" + this.minRepeat;
    }
}

