/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb;

import com.neuron.irdb.IntArray;
import java.util.StringTokenizer;

public class PulseIndex {
    private IntArray index;

    public PulseIndex() {
        this.index = new IntArray();
    }

    public PulseIndex(int[] nArray) {
        this();
        this.addPulses(nArray);
    }

    private PulseIndex(IntArray intArray) {
        this.index = intArray;
    }

    public String toString() {
        return this.index.getString(",");
    }

    public static PulseIndex parseIndexString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        return new PulseIndex(nArray);
    }

    public PulseIndex getClone() {
        return new PulseIndex(this.index.getClone());
    }

    public void setPulses(int[] nArray) {
        this.index.setSize(0);
        this.addPulses(nArray);
    }

    public void addPulses(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.addPulse(nArray[i]);
        }
    }

    public int addPulse(int n) {
        for (int i = 0; i < this.index.size(); ++i) {
            int n2 = this.index.get(i);
            if (Math.abs(n - n2) > n2 / 10) continue;
            return i;
        }
        this.index.append(n);
        return this.index.size() - 1;
    }

    public int getPulse(int n) {
        if (n < 0 || n > this.index.size() - 1) {
            return 0;
        }
        return this.index.get(n);
    }

    public void setPulse(int n, int n2) {
        this.index.set(n, n2);
    }

    public int[] getIndexValues() {
        return this.index.getValues();
    }

    public int size() {
        return this.index.size();
    }

    public void clear() {
        this.index.setSize(0);
    }

    public void round(int n) {
        int[] nArray = this.getIndexValues();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = PulseIndex.round(nArray[i], n);
        }
        this.setPulses(nArray);
    }

    public static int round(int n, int n2) {
        int n3 = n - n % n2;
        int n4 = n3 + n2;
        if (Math.abs(n - n3) < Math.abs(n - n4)) {
            return n3;
        }
        return n4;
    }
}

