/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb.impl;

import com.neuron.irdb.IRSignal;
import com.neuron.irdb.impl.ProntoConstants;
import java.util.StringTokenizer;

public class Pronto
extends IRSignal
implements ProntoConstants {
    public static final int VERSION1 = 1;
    public static final int VERSION2 = 2;
    private byte[] raw;
    private boolean is0100;

    public Pronto(byte[] byArray) {
        this.decode(byArray);
    }

    public Pronto(String string) {
        this(string, false);
    }

    public Pronto(String string, int n) {
        this(string, n == 2);
    }

    public Pronto(String string, boolean bl) {
        this.decode(string, bl);
    }

    public Pronto(IRSignal iRSignal) {
        super(iRSignal);
        if (iRSignal instanceof Pronto) {
            this.is0100 = ((Pronto)iRSignal).is0100;
            this.raw = ((Pronto)iRSignal).raw;
        }
    }

    public boolean isRawSignal() {
        return this.raw != null;
    }

    public byte[] getRawSignal() {
        return this.raw;
    }

    @Override
    public String toString() {
        if (this.isRawSignal()) {
            return "Pronto " + this.encode();
        }
        return super.toString();
    }

    @Override
    public boolean equals(Object object) {
        Pronto pronto;
        if (this.isRawSignal() && object instanceof Pronto && (pronto = (Pronto)object).isRawSignal()) {
            byte[] byArray = pronto.getRawSignal();
            if (byArray.length != this.raw.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == this.raw[i]) continue;
                return false;
            }
        }
        return super.equals(object);
    }

    private String print(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Integer.toString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    private int word(byte[] byArray, int n) {
        return (byArray[n * 2] & 0xFF) << 8 | byArray[n * 2 + 1] & 0xFF;
    }

    private void biphaseAddBit(StringBuffer stringBuffer, boolean bl) {
        stringBuffer.append(bl ? "01" : "10");
    }

    private void biphaseAddBits(StringBuffer stringBuffer, int n, int n2) {
        for (int i = n2 - 1; i >= 0; --i) {
            this.biphaseAddBit(stringBuffer, (n >>> i & 1) == 1);
        }
    }

    private void decodeRC5(byte[] byArray, boolean bl) {
        int n;
        int n2;
        int n3 = this.word(byArray, 0);
        int n4 = this.word(byArray, 1);
        int n5 = this.word(byArray, 2);
        int n6 = this.word(byArray, 3);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n6; ++i) {
            n2 = this.word(byArray, 4 + i * 2);
            n = this.word(byArray, 5 + i * 2);
            this.biphaseAddBit(stringBuffer, true);
            if (n > 64) {
                n -= 64;
                this.biphaseAddBit(stringBuffer, false);
            } else {
                this.biphaseAddBit(stringBuffer, true);
            }
            this.biphaseAddBit(stringBuffer, bl);
            this.biphaseAddBits(stringBuffer, n2, 5);
            this.biphaseAddBits(stringBuffer, n, 6);
        }
        this.getPulseIndex().clear();
        this.getIntro().clear();
        this.getRepeat().clear();
        this.setFrequency(37449);
        this.setMinRepeat(1);
        String string = stringBuffer.toString();
        if (string.startsWith("0")) {
            string = string.substring(1);
        }
        n2 = 1;
        n = string.charAt(0);
        for (int i = 1; i < string.length(); ++i) {
            if (n == string.charAt(i)) {
                ++n2;
                continue;
            }
            this.getRepeat().addTimePulse(n2 * 112 * 32);
            n = string.charAt(i);
            n2 = 1;
        }
        this.getRepeat().addTimePulse(n2 * 112 * 32);
        this.getRepeat().addTimePulse(89600);
    }

    public boolean decode(byte[] byArray) {
        int n;
        int n2;
        byte by;
        byte by2;
        int n3;
        int n4 = 0;
        if (byArray.length < 8) {
            this.raw = byArray;
            return false;
        }
        int n5 = byArray.length;
        boolean bl = true;
        switch (this.word(byArray, 0)) {
            case 0: {
                bl = false;
                break;
            }
            case 256: {
                bl = false;
                this.is0100 = true;
                break;
            }
            case 20480: {
                n5 = this.word(byArray, 3) == 2 ? 16 : 12;
                this.decodeRC5(byArray, false);
                break;
            }
            case 20481: {
                n5 = 16;
                break;
            }
            case 24576: {
                n5 = 16;
                break;
            }
            case 24577: {
                n5 = 16;
                break;
            }
            case 28672: {
                break;
            }
            case 32768: {
                n5 = this.word(byArray, 2) == 2 ? 16 : 8;
                break;
            }
            case 36864: {
                n5 = 16;
            }
        }
        if (bl) {
            if (byArray.length > n5) {
                byte[] byArray2 = new byte[n5];
                System.arraycopy(byArray, 0, byArray2, 0, n5);
                byArray = byArray2;
            }
            this.raw = byArray;
            return false;
        }
        n4 = 2;
        this.getPulseIndex().clear();
        this.getIntro().clear();
        this.getRepeat().clear();
        int n6 = byArray[n4++] << 8 | byArray[n4++] & 0xFF;
        this.setFrequency(0x400000 / Math.max(n6, 1));
        int n7 = (byArray[n4++] << 8 | byArray[n4++] & 0xFF) * 2;
        int n8 = (byArray[n4++] << 8 | byArray[n4++] & 0xFF) * 2;
        for (n3 = 0; n3 < n7; ++n3) {
            by2 = byArray[n4++];
            by = byArray[n4++];
            n2 = (by2 & 0xFF) << 8 | by & 0xFF;
            n = n6 * n2;
            this.getIntro().addTimePulse(n);
        }
        for (n3 = 0; n3 < n8; ++n3) {
            by2 = byArray[n4++];
            by = byArray[n4++];
            n2 = (by2 & 0xFF) << 8 | by & 0xFF;
            n = n6 * n2;
            this.getRepeat().addTimePulse(n);
        }
        this.setMinRepeat(this.getIntro().cullRepeats() + this.getRepeat().cullRepeats() + 1);
        this.cleanup();
        return true;
    }

    @Override
    public boolean decode(String string) {
        return this.decode(string, false);
    }

    public boolean decode(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n");
        int n = stringTokenizer.countTokens();
        if (bl && n > 3) {
            n -= 3;
            for (int i = 0; i < 3; ++i) {
                stringTokenizer.nextToken();
            }
        }
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n3 = Pronto.value(string2) & 0xFFFF;
            byArray[n2] = (byte)(n3 >> 8 & 0xFF);
            byArray[n2 + 1] = (byte)(n3 & 0xFF);
            n2 += 2;
        }
        return this.decode(byArray);
    }

    @Override
    public String encode() {
        return this.encode(1, false);
    }

    public String encode(int n) {
        return this.encode(n, false);
    }

    public String encode(int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isRawSignal()) {
            for (int i = 0; i < this.raw.length; i += 2) {
                stringBuffer.append(Pronto.hex(((this.raw[i] & 0xFF) << 8 | this.raw[i + 1] & 0xFF) & 0xFFFF));
            }
            return stringBuffer.toString();
        }
        int n2 = 0x400000 / this.getFrequency();
        int[] nArray = this.getPulseIndex().getIndexValues();
        int[] nArray2 = this.getIntro().getPulses();
        int[] nArray3 = this.getRepeat().getPulses();
        if (n == 2) {
            stringBuffer.append(Pronto.hex(0));
            stringBuffer.append(Pronto.hex(0));
            stringBuffer.append(Pronto.hex(0));
            stringBuffer.append(this.is0100 ? Pronto.hex(256) : Pronto.hex(0));
        } else {
            stringBuffer.append(this.is0100 ? Pronto.hex(256) : Pronto.hex(0));
        }
        int n3 = Math.max(this.getMinRepeat(), 1);
        stringBuffer.append(Pronto.hex(n2));
        int n4 = this.getRepeatType();
        switch (n4) {
            case 0: {
                stringBuffer.append(Pronto.hex(nArray2.length / 2));
                stringBuffer.append(Pronto.hex(nArray3.length * n3 / 2));
                break;
            }
            case 1: {
                stringBuffer.append(Pronto.hex(0));
                stringBuffer.append(Pronto.hex((nArray2.length + nArray3.length) * n3 / 2));
                break;
            }
            case 2: {
                stringBuffer.append(Pronto.hex((nArray2.length + nArray3.length) * n3 / 2));
                stringBuffer.append(Pronto.hex(0));
            }
        }
        int n5 = 8;
        for (int i = 0; i < n3; ++i) {
            int n6;
            if (n4 == 0 && i == 0 || n4 != 0) {
                for (n6 = 0; n6 < nArray2.length; ++n6) {
                    stringBuffer.append(Pronto.hex(nArray[nArray2[n6]] / n2));
                    if (!bl || n5++ % 8 != 0) continue;
                    stringBuffer.append("\n");
                }
            }
            for (n6 = 0; n6 < nArray3.length; ++n6) {
                stringBuffer.append(Pronto.hex(nArray[nArray3[n6]] / n2));
                if (!bl || n5++ % 8 != 0) continue;
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private static String hex(int n) {
        String string = Integer.toString(n, 16);
        if (string.length() < 4) {
            return "0000".substring(string.length()) + string + " ";
        }
        return string + " ";
    }

    private static int value(String string) {
        return Integer.valueOf(string, 16);
    }
}

