/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.irdb.impl;

import com.neuron.irdb.IRBurst;
import com.neuron.irdb.IRSignal;
import com.neuron.irdb.PulseIndex;

public class RedRat
extends IRSignal {
    public RedRat(String string) {
        this.decode(string);
    }

    public RedRat(IRSignal iRSignal) {
        super(iRSignal);
    }

    @Override
    public boolean decode(String string) {
        int n;
        if (string == null || string.length() == 0) {
            throw new RuntimeException("malformed code (" + string + ")");
        }
        if (string.charAt(0) == 'S' || string.charAt(0) == 'P') {
            string = string.substring(1);
        }
        if (string.charAt(0) != 'F' || string.charAt(3) != 'L') {
            throw new RuntimeException("malformed code (" + string + ")");
        }
        int n2 = string.indexOf(88, 4);
        int n3 = string.indexOf(80, n2);
        int n4 = string.indexOf(82, n3);
        int n5 = 4000000 / RedRat.value(string.substring(1, 3));
        int n6 = (n2 - 4) / 4;
        int[] nArray = new int[n6];
        for (int i = 0; i < n6; ++i) {
            nArray[i] = RedRat.value(string.substring(4 + i * 4, 8 + i * 4));
        }
        this.getPulseIndex().clear();
        IRBurst iRBurst = this.getIntro();
        IRBurst iRBurst2 = this.getRepeat();
        iRBurst.clear();
        iRBurst2.clear();
        String string2 = RedRat.BinStringToRat(RedRat.HexToBinString(string.substring(n2 + 1, n3)));
        int n7 = string2.indexOf("9");
        int n8 = string2.indexOf("9", n7 + 1);
        for (n = 0; n < n7; ++n) {
            iRBurst.addTimePulse(nArray[string2.charAt(n) - 48]);
        }
        for (n = n7 + 1; n < n8; ++n) {
            iRBurst2.addTimePulse(nArray[string2.charAt(n) - 48]);
        }
        n = RedRat.value(string.substring(n3 + 1, n4)) * 8;
        int n9 = RedRat.value(string.substring(n4 + 1));
        if (n > 0) {
            if (iRBurst.length() > 0) {
                iRBurst.addTimePulse(n);
            }
            if (iRBurst2.length() > 0) {
                iRBurst2.addTimePulse(n);
            }
        }
        this.setMinRepeat(n9);
        return true;
    }

    @Override
    public String encode() {
        return this.getCodedString();
    }

    private static String hex(int n) {
        return RedRat.hex(n, 4);
    }

    private static String hex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        if (string.length() < n2) {
            return "00000000".substring(8 - (n2 - string.length())) + string;
        }
        return string;
    }

    private static int value(String string) {
        return Integer.valueOf(string, 16);
    }

    private boolean trimSignal() {
        return false;
    }

    private static String HexToBinString(String string) {
        string = string.toUpperCase();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 4);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = c - 48 < 10 ? c - 48 : c - 65 + 10;
            stringBuffer.append((n2 & 8) > 0 ? "1" : "0");
            stringBuffer.append((n2 & 4) > 0 ? "1" : "0");
            stringBuffer.append((n2 & 2) > 0 ? "1" : "0");
            stringBuffer.append((n2 & 1) > 0 ? "1" : "0");
        }
        return stringBuffer.toString();
    }

    private static String BinStringToHex(String string) {
        while (string.length() % 4 != 0) {
            string = string + "0";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; i += 4) {
            int n2 = 0;
            n2 |= string.charAt(i + 0) == '0' ? 0 : 8;
            n2 |= string.charAt(i + 1) == '0' ? 0 : 4;
            n2 |= string.charAt(i + 2) == '0' ? 0 : 2;
            stringBuffer.append((n2 |= string.charAt(i + 3) == '0' ? 0 : 1) < 10 ? (char)(48 + n2) : (char)(65 + n2 - 10));
        }
        while (stringBuffer.length() % 4 != 0) {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    private static String RatToBinString(String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (n = 0; n < string.length(); ++n) {
            switch (string.charAt(n)) {
                case '0': {
                    stringBuffer.append("0100");
                    continue block11;
                }
                case '1': {
                    stringBuffer.append("00");
                    continue block11;
                }
                case '2': {
                    stringBuffer.append("1");
                    continue block11;
                }
                case '3': {
                    stringBuffer.append("0111");
                    continue block11;
                }
                case '4': {
                    stringBuffer.append("01010");
                    continue block11;
                }
                case '5': {
                    stringBuffer.append("01011");
                    continue block11;
                }
                case '6': {
                    stringBuffer.append("011010");
                    continue block11;
                }
                case '7': {
                    stringBuffer.append("011011");
                    continue block11;
                }
                case '9': {
                    stringBuffer.append("01100");
                }
            }
        }
        n = stringBuffer.length() % 4;
        if (n > 0) {
            stringBuffer.append("0000".substring(n));
        }
        return stringBuffer.toString();
    }

    private static String BinStringToRat(String string) {
        int n = string.length();
        int n2 = n - 1;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (string.charAt(n4++) == '0') {
                if (n4 > n2) break;
                if (string.charAt(n4++) == '0') {
                    stringBuffer.append('1');
                    if (n4 <= n2) continue;
                    break;
                }
                if (string.charAt(n4++) == '0') {
                    if (n4 > n2) break;
                    if (string.charAt(n4++) == '0') {
                        stringBuffer.append('0');
                        if (n4 <= n2) continue;
                        break;
                    }
                    if (string.charAt(n4++) == '0') {
                        stringBuffer.append('4');
                        if (n4 <= n2) continue;
                        break;
                    }
                    stringBuffer.append('5');
                    if (n4 <= n2) continue;
                    break;
                }
                if (string.charAt(n4++) == '0') {
                    if (n4 > n2) break;
                    if (string.charAt(n4++) == '0') {
                        stringBuffer.append('9');
                        if (++n3 < 2 && n4 <= n2) continue;
                        break;
                    }
                    if (string.charAt(n4++) == '0') {
                        stringBuffer.append('6');
                        if (n4 <= n2) continue;
                        break;
                    }
                    stringBuffer.append('7');
                    continue;
                }
                stringBuffer.append('3');
                continue;
            }
            stringBuffer.append('2');
        }
        return stringBuffer.toString();
    }

    private static String IntsToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append((char)(48 + nArray[i]));
        }
        return stringBuffer.toString();
    }

    public String getSendString() {
        return this.getSendString(this.getMinRepeat());
    }

    public String getSendString(int n) {
        return "P" + this.getCodedString(n);
    }

    public String getCodedString() {
        return this.getCodedString(this.getMinRepeat());
    }

    public String getCodedString(int n) {
        PulseIndex pulseIndex = this.getPulseIndex().getClone();
        IRBurst iRBurst = this.getIntro().getClone(this);
        IRBurst iRBurst2 = this.getRepeat().getClone(this);
        if (iRBurst2.length() == 0) {
            iRBurst2 = iRBurst;
        }
        if (iRBurst.length() > 0 && iRBurst != iRBurst2 && iRBurst.get(iRBurst.length() - 1) == iRBurst2.get(iRBurst2.length() - 1)) {
            iRBurst.setLength(iRBurst.length() - 1);
        }
        int n2 = iRBurst2.get(iRBurst2.length() - 1);
        int n3 = pulseIndex.getPulse(n2);
        pulseIndex.setPulse(n2, 0);
        iRBurst2.setLength(iRBurst2.length() - 1);
        int[] nArray = iRBurst.getPulses();
        int[] nArray2 = iRBurst2.getPulses();
        String string = nArray.length == 0 || iRBurst == iRBurst2 ? RedRat.IntsToString(nArray2) + "99" : RedRat.IntsToString(nArray) + "9" + RedRat.IntsToString(nArray2) + "9";
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray3 = pulseIndex.getIndexValues();
        for (int i = 0; i < nArray3.length; ++i) {
            stringBuffer.append(RedRat.hex(nArray3[i]));
        }
        return "F" + RedRat.hex(4000000 / this.getFrequency(), 2) + "L" + stringBuffer + "X" + RedRat.BinStringToHex(RedRat.RatToBinString(string)) + "P" + RedRat.hex(n3 / 8) + "R" + RedRat.hex(Math.max(n, 1), 2);
    }
}

