/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.xml;

import java.util.Enumeration;
import java.util.Vector;

public class XMLNode {
    private String tag;
    private String val;
    private Vector attrs;
    private Vector nodes;

    XMLNode() {
    }

    XMLNode(String string, String string2) {
        this.tag = string;
        this.val = string2;
    }

    public void addChild(XMLNode xMLNode) {
        if (this.nodes == null) {
            this.nodes = new Vector(3);
        }
        this.nodes.add(xMLNode);
    }

    public void setName(String string) {
        this.tag = string;
    }

    public void setValue(String string) {
        this.val = string;
    }

    public String getName() {
        return this.tag;
    }

    public String getValue() {
        return this.val;
    }

    public XMLNode[] getAllNodes() {
        if (this.nodes == null) {
            return null;
        }
        Object[] objectArray = new XMLNode[this.nodes.size()];
        this.nodes.copyInto(objectArray);
        return objectArray;
    }

    public XMLNode[] getNodeArray(String string) {
        Enumeration enumeration = this.getNodeEnumeration(string);
        if (enumeration == null) {
            return null;
        }
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        Object[] objectArray = new XMLNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Enumeration getNodeEnumeration(String string) {
        if (this.nodes == null) {
            return null;
        }
        final String string2 = string;
        return new Enumeration(){
            private int next = 0;
            private boolean init = false;
            private XMLNode match = null;

            @Override
            public boolean hasMoreElements() {
                this.init();
                return this.match != null;
            }

            public Object nextElement() {
                this.init();
                if (this.match != null) {
                    XMLNode xMLNode = this.match;
                    this.findNext();
                    return xMLNode;
                }
                throw new IllegalArgumentException("no more elements");
            }

            private void findNext() {
                while (this.next < XMLNode.this.nodes.size()) {
                    XMLNode xMLNode = (XMLNode)XMLNode.this.nodes.get(this.next++);
                    if (!xMLNode.getName().equals(string2)) continue;
                    this.match = xMLNode;
                    return;
                }
                this.match = null;
            }

            private void init() {
                if (!this.init) {
                    this.findNext();
                    this.init = true;
                }
            }
        };
    }

    public XMLNode getNode(String string) {
        if (this.nodes == null) {
            return null;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            XMLNode xMLNode = (XMLNode)this.nodes.get(i);
            if (!xMLNode.getName().equals(string)) continue;
            return xMLNode;
        }
        return null;
    }

    public int getNodeCount() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public int getAttributeCount() {
        return this.attrs != null ? this.attrs.size() : 0;
    }

    public void addAttribute(String string, String string2) {
        if (this.attrs == null) {
            this.attrs = new Vector(3);
        }
        this.attrs.add(new XMLNode(string, string2));
    }

    public XMLNode[] getAttributes() {
        if (this.attrs == null) {
            return null;
        }
        Object[] objectArray = new XMLNode[this.attrs.size()];
        this.attrs.copyInto(objectArray);
        return objectArray;
    }

    public String getAttribute(String string) {
        if (this.attrs == null) {
            return null;
        }
        for (int i = 0; i < this.attrs.size(); ++i) {
            XMLNode xMLNode = (XMLNode)this.attrs.get(i);
            if (!xMLNode.getName().equals(string)) continue;
            return xMLNode.getValue();
        }
        return null;
    }

    public boolean hasAttribute(String string) {
        if (this.attrs == null) {
            return false;
        }
        for (int i = 0; i < this.attrs.size(); ++i) {
            XMLNode xMLNode = (XMLNode)this.attrs.get(i);
            if (!xMLNode.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.attrs != null) {
            for (int i = 0; i < this.attrs.size(); ++i) {
                XMLNode xMLNode = (XMLNode)this.attrs.get(i);
                stringBuffer.append(" ");
                stringBuffer.append(xMLNode.getName());
                String string = xMLNode.getValue();
                if (string == null) continue;
                stringBuffer.append("=\"" + string + "\"");
            }
        }
        if (this.nodes == null || this.nodes.size() == 0) {
            if (this.val != null) {
                return "<" + this.tag + stringBuffer + ">" + this.val + "</" + this.tag + ">";
            }
            return "<" + this.tag + stringBuffer + " />";
        }
        return "<" + this.tag + stringBuffer + ">";
    }
}

