/*
 * Decompiled with CFR 0.152.
 */
package com.neuron.xml;

import com.neuron.xml.XMLNode;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class XMLParser {
    private XMLNode root;

    public static void main(String[] stringArray) throws Exception {
        XMLParser xMLParser = new XMLParser();
        xMLParser.load(stringArray[0]);
        xMLParser.print();
    }

    public static XMLNode parseStream(InputStream inputStream) throws IOException {
        XMLParser xMLParser = new XMLParser();
        xMLParser.load(inputStream);
        return xMLParser.getRootNode();
    }

    public void print() {
        this.print(0, this.root);
    }

    private void print(int n, XMLNode xMLNode) {
        for (int i = 0; i < n; ++i) {
            System.out.print("  ");
        }
        System.out.println(xMLNode);
        XMLNode[] xMLNodeArray = xMLNode.getAllNodes();
        if (xMLNodeArray != null && xMLNodeArray.length > 0) {
            int n2;
            for (n2 = 0; n2 < xMLNodeArray.length; ++n2) {
                this.print(n + 1, xMLNodeArray[n2]);
            }
            for (n2 = 0; n2 < n; ++n2) {
                System.out.print("  ");
            }
            System.out.println("</" + xMLNode.getName() + ">");
        }
    }

    public XMLNode getRootNode() {
        return this.root;
    }

    public void load(InputStream inputStream) throws IOException {
        this.skipUntil(inputStream, 60);
        this.root = this.readTag(inputStream);
    }

    public void load(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.load(fileInputStream);
        fileInputStream.close();
    }

    private XMLNode readTag(InputStream inputStream) throws IOException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        XMLNode xMLNode = new XMLNode();
        int n = inputStream.read();
        if (n == 47) {
            while (n != 62) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            xMLNode.setName(stringBuffer.toString());
            return xMLNode;
        }
        if (n == 63) {
            this.skipUntil(inputStream, "?>");
            this.skipUntil(inputStream, 60);
            return this.readTag(inputStream);
        }
        if (n == 33) {
            this.skipUntil(inputStream, "->");
            this.skipUntil(inputStream, 60);
            return this.readTag(inputStream);
        }
        while (n != 32 && n != 47 && n != 62) {
            stringBuffer.append((char)n);
            n = inputStream.read();
        }
        String string = stringBuffer.toString();
        xMLNode.setName(string);
        while (n == 32) {
            stringBuffer.setLength(0);
            while ((n = inputStream.read()) == 32) {
            }
            while (n != 32 && n != 61 && n != 47 && n != 62) {
                stringBuffer.append((char)n);
                n = inputStream.read();
            }
            if (n == 61) {
                if (inputStream.read() != 34) {
                    throw this.stateError("expected '\"' after '='");
                }
                object = stringBuffer.toString();
                stringBuffer.setLength(0);
                while ((n = inputStream.read()) != 34) {
                    stringBuffer.append((char)n);
                }
                if (n != 34) {
                    throw this.stateError("expected '\"' to terminate value");
                }
                n = 32;
                xMLNode.addAttribute((String)object, stringBuffer.toString());
                continue;
            }
            if (n != 32 && n != 62) break;
            if (stringBuffer.length() <= 0) continue;
            xMLNode.addAttribute(stringBuffer.toString(), null);
        }
        if (n == 47) {
            n = inputStream.read();
            if (n != 62) {
                throw this.stateError("expected '>' but got '" + (char)n + "'");
            }
            return xMLNode;
        }
        if (n == 62) {
            while (true) {
                this.loadUntil(stringBuffer2, inputStream, 60);
                object = this.readTag(inputStream);
                if (((XMLNode)object).getName().equals("/" + string)) {
                    if (stringBuffer2.length() > 0) {
                        xMLNode.setValue(stringBuffer2.toString());
                    }
                    return xMLNode;
                }
                if (object == null) continue;
                xMLNode.addChild((XMLNode)object);
            }
        }
        if (stringBuffer2.length() > 0) {
            xMLNode.setValue(stringBuffer2.toString());
        }
        return xMLNode;
    }

    private void skipUntil(InputStream inputStream, int n) throws IOException {
        int n2;
        while ((n2 = inputStream.read()) != n && n2 >= 0) {
        }
        if (n2 < 0) {
            throw new EOFException();
        }
    }

    private void loadUntil(StringBuffer stringBuffer, InputStream inputStream, int n) throws IOException {
        int n2;
        while ((n2 = inputStream.read()) != n && n2 >= 0) {
            stringBuffer.append((char)n2);
        }
        if (n2 < 0) {
            throw new EOFException();
        }
    }

    private void skipUntil(InputStream inputStream, String string) throws IOException {
        int n;
        byte[] byArray = string.getBytes();
        int[] nArray = new int[byArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = (byte)inputStream.read();
            if (nArray[n] >= 0) continue;
            throw new EOFException();
        }
        n = 0;
        while (true) {
            int n2 = n;
            for (int i = 0; i < byArray.length && byArray[i] == (byte)nArray[n2]; ++i) {
                if (++n2 >= nArray.length) {
                    n2 = 0;
                }
                if (n2 != n) continue;
                return;
            }
            nArray[n] = inputStream.read();
            if (nArray[n] < 0) {
                throw new EOFException();
            }
            if (++n < nArray.length) continue;
            n = 0;
        }
    }

    private IOException stateError(String string) {
        return new IOException(string);
    }
}

