/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import gnu.io.Zystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

public final class RXTXPort
extends SerialPort {
    protected static final boolean debug = false;
    protected static final boolean debug_read = false;
    protected static final boolean debug_read_results = false;
    protected static final boolean debug_write = false;
    protected static final boolean debug_events = false;
    protected static final boolean debug_verbose = false;
    private static Zystem z;
    boolean MonitorThreadAlive = false;
    int IOLocked = 0;
    Object IOLockedMutex = new Object();
    private int fd = 0;
    long eis = 0L;
    int pid = 0;
    static boolean dsrFlag;
    private final SerialOutputStream out = new SerialOutputStream();
    private final SerialInputStream in = new SerialInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private SerialPortEventListener SPEventListener;
    private MonitorThread monThread;
    boolean monThreadisInterrupted = true;
    boolean MonitorThreadLock = true;
    boolean closeLock = false;

    private static native void Initialize();

    public RXTXPort(String name) throws PortInUseException {
        this.fd = this.open(name);
        this.name = name;
        this.MonitorThreadLock = true;
        this.monThread = new MonitorThread();
        this.monThread.setDaemon(true);
        this.monThread.start();
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadAlive = true;
        this.timeout = -1;
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private native int nativeGetParity(int var1);

    private native int nativeGetFlowControlMode(int var1);

    public synchronized void setSerialPortParams(int b, int d, int s, int p) throws UnsupportedCommOperationException {
        if (this.nativeSetSerialPortParams(b, d, s, p)) {
            throw new UnsupportedCommOperationException("Invalid Parameter");
        }
        this.speed = b;
        this.dataBits = s == 3 ? 5 : d;
        this.stopBits = s;
        this.parity = p;
        z.reportln("RXTXPort:setSerialPortParams(" + b + " " + d + " " + s + " " + p + ") returning");
    }

    private native boolean nativeSetSerialPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        return this.speed;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int flowcontrol) {
        if (this.monThreadisInterrupted) {
            return;
        }
        try {
            this.setflowcontrol(flowcontrol);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        this.flowmode = flowcontrol;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int f) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
    }

    public boolean isReceiveFramingEnabled() {
        return false;
    }

    public int getReceiveFramingByte() {
        return 0;
    }

    public native int NativegetReceiveTimeout();

    private native boolean NativeisReceiveTimeoutEnabled();

    private native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        this.timeout = -1;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
    }

    public void enableReceiveTimeout(int time) {
        if (time < 0) {
            throw new IllegalArgumentException("Unexpected negative timeout value");
        }
        this.timeout = time;
        this.NativeEnableReceiveTimeoutThreshold(time, this.threshold, this.InputBuffer);
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int thresh) {
        if (thresh < 0) {
            throw new IllegalArgumentException("Unexpected negative threshold value");
        }
        this.threshold = thresh;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
    }

    public void disableReceiveThreshold() {
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.threshold > 0;
    }

    public void setInputBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.InputBuffer = size;
    }

    public int getInputBufferSize() {
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.OutputBuffer = size;
    }

    public int getOutputBufferSize() {
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    protected native void writeByte(int var1, boolean var2) throws IOException;

    protected native void writeArray(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected native boolean nativeDrain(boolean var1) throws IOException;

    protected native int nativeavailable() throws IOException;

    protected native int readByte() throws IOException;

    protected native int readArray(byte[] var1, int var2, int var3) throws IOException;

    protected native int readTerminatedArray(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    native void eventLoop();

    private native void interruptEventLoop();

    public boolean checkMonitorThread() {
        if (this.monThread != null) {
            return this.monThreadisInterrupted;
        }
        return true;
    }

    public boolean sendEvent(int event, boolean state) {
        if (this.fd == 0 || this.SPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (event) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
        }
        switch (event) {
            case 1: {
                if (this.monThread.Data) break;
                return false;
            }
            case 2: {
                if (this.monThread.Output) break;
                return false;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return false;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return false;
            }
            case 5: {
                if (this.monThread.RI) break;
                return false;
            }
            case 6: {
                if (this.monThread.CD) break;
                return false;
            }
            case 7: {
                if (this.monThread.OE) break;
                return false;
            }
            case 8: {
                if (this.monThread.PE) break;
                return false;
            }
            case 9: {
                if (this.monThread.FE) break;
                return false;
            }
            case 10: {
                if (this.monThread.BI) break;
                return false;
            }
            default: {
                System.err.println("unknown event: " + event);
                return false;
            }
        }
        SerialPortEvent e = new SerialPortEvent(this, event, !state, state);
        if (this.monThreadisInterrupted) {
            return true;
        }
        if (this.SPEventListener != null) {
            this.SPEventListener.serialEvent(e);
        }
        return this.fd == 0 || this.SPEventListener == null || this.monThread == null;
    }

    public void addEventListener(SerialPortEventListener lsnr) throws TooManyListenersException {
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = lsnr;
        if (!this.MonitorThreadAlive) {
            this.MonitorThreadLock = true;
            this.monThread = new MonitorThread();
            this.monThread.setDaemon(true);
            this.monThread.start();
            this.waitForTheNativeCodeSilly();
            this.MonitorThreadAlive = true;
        }
    }

    public void removeEventListener() {
        this.waitForTheNativeCodeSilly();
        if (this.monThreadisInterrupted) {
            z.reportln("\tRXTXPort:removeEventListener() already interrupted");
            this.monThread = null;
            this.SPEventListener = null;
            return;
        }
        if (this.monThread != null && this.monThread.isAlive()) {
            this.monThreadisInterrupted = true;
            this.interruptEventLoop();
            try {
                this.monThread.join(3000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        this.monThread = null;
        this.SPEventListener = null;
        this.MonitorThreadLock = false;
        this.MonitorThreadAlive = false;
        this.monThreadisInterrupted = true;
        z.reportln("RXTXPort:removeEventListener() returning");
    }

    protected void waitForTheNativeCodeSilly() {
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    private native void nativeSetEventFlag(int var1, int var2, boolean var3);

    public void notifyOnDataAvailable(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 1, enable);
        this.monThread.Data = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOutputEmpty(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 2, enable);
        this.monThread.Output = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCTS(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 3, enable);
        this.monThread.CTS = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnDSR(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 4, enable);
        this.monThread.DSR = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnRingIndicator(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 5, enable);
        this.monThread.RI = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCarrierDetect(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 6, enable);
        this.monThread.CD = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOverrunError(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 7, enable);
        this.monThread.OE = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnParityError(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 8, enable);
        this.monThread.PE = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnFramingError(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 9, enable);
        this.monThread.FE = enable;
        this.MonitorThreadLock = false;
    }

    public void notifyOnBreakInterrupt(boolean enable) {
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 10, enable);
        this.monThread.BI = enable;
        this.MonitorThreadLock = false;
    }

    private native void nativeClose(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RXTXPort rXTXPort = this;
        synchronized (rXTXPort) {
            while (this.IOLocked > 0) {
                try {
                    this.wait(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.closeLock) {
                return;
            }
            this.closeLock = true;
        }
        if (this.fd <= 0) {
            z.reportln("RXTXPort:close detected bad File Descriptor");
            return;
        }
        this.setDTR(false);
        this.setDSR(false);
        if (!this.monThreadisInterrupted) {
            this.removeEventListener();
        }
        this.nativeClose(this.name);
        super.close();
        this.fd = 0;
        this.closeLock = false;
    }

    protected void finalize() {
        if (this.fd > 0) {
            this.close();
        }
        z.finalize();
    }

    public void setRcvFifoTrigger(int trigger) {
    }

    private static native void nativeStaticSetSerialPortParams(String var0, int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDSR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetDTR(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticSetRTS(String var0, boolean var1) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDSR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsDTR(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCTS(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsCD(String var0) throws UnsupportedCommOperationException;

    private static native boolean nativeStaticIsRI(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetBaudRate(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetDataBits(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetParity(String var0) throws UnsupportedCommOperationException;

    private static native int nativeStaticGetStopBits(String var0) throws UnsupportedCommOperationException;

    private native byte nativeGetParityErrorChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetParityErrorChar(byte var1) throws UnsupportedCommOperationException;

    private native byte nativeGetEndOfInputChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetEndOfInputChar(byte var1) throws UnsupportedCommOperationException;

    private native boolean nativeSetUartType(String var1, boolean var2) throws UnsupportedCommOperationException;

    native String nativeGetUartType() throws UnsupportedCommOperationException;

    private native boolean nativeSetBaudBase(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetBaudBase() throws UnsupportedCommOperationException;

    private native boolean nativeSetDivisor(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetDivisor() throws UnsupportedCommOperationException;

    private native boolean nativeSetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeGetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeSetCallOutHangup(boolean var1) throws UnsupportedCommOperationException;

    private native boolean nativeGetCallOutHangup() throws UnsupportedCommOperationException;

    private native boolean nativeClearCommInput() throws UnsupportedCommOperationException;

    public static int staticGetBaudRate(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetBaudRate(port);
    }

    public static int staticGetDataBits(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetDataBits(port);
    }

    public static int staticGetParity(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetParity(port);
    }

    public static int staticGetStopBits(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticGetStopBits(port);
    }

    public static void staticSetSerialPortParams(String f, int b, int d, int s, int p) throws UnsupportedCommOperationException {
        RXTXPort.nativeStaticSetSerialPortParams(f, b, d, s, p);
    }

    public static boolean staticSetDSR(String port, boolean flag) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticSetDSR(port, flag);
    }

    public static boolean staticSetDTR(String port, boolean flag) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticSetDTR(port, flag);
    }

    public static boolean staticSetRTS(String port, boolean flag) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticSetRTS(port, flag);
    }

    public static boolean staticIsRTS(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsRTS(port);
    }

    public static boolean staticIsCD(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsCD(port);
    }

    public static boolean staticIsCTS(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsCTS(port);
    }

    public static boolean staticIsDSR(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsDSR(port);
    }

    public static boolean staticIsDTR(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsDTR(port);
    }

    public static boolean staticIsRI(String port) throws UnsupportedCommOperationException {
        return RXTXPort.nativeStaticIsRI(port);
    }

    public byte getParityErrorChar() throws UnsupportedCommOperationException {
        byte ret = this.nativeGetParityErrorChar();
        return ret;
    }

    public boolean setParityErrorChar(byte b) throws UnsupportedCommOperationException {
        return this.nativeSetParityErrorChar(b);
    }

    public byte getEndOfInputChar() throws UnsupportedCommOperationException {
        byte ret = this.nativeGetEndOfInputChar();
        return ret;
    }

    public boolean setEndOfInputChar(byte b) throws UnsupportedCommOperationException {
        return this.nativeSetEndOfInputChar(b);
    }

    public boolean setUARTType(String type, boolean test) throws UnsupportedCommOperationException {
        return this.nativeSetUartType(type, test);
    }

    public String getUARTType() throws UnsupportedCommOperationException {
        return this.nativeGetUartType();
    }

    public boolean setBaudBase(int BaudBase) throws UnsupportedCommOperationException, IOException {
        return this.nativeSetBaudBase(BaudBase);
    }

    public int getBaudBase() throws UnsupportedCommOperationException, IOException {
        return this.nativeGetBaudBase();
    }

    public boolean setDivisor(int Divisor) throws UnsupportedCommOperationException, IOException {
        return this.nativeSetDivisor(Divisor);
    }

    public int getDivisor() throws UnsupportedCommOperationException, IOException {
        return this.nativeGetDivisor();
    }

    public boolean setLowLatency() throws UnsupportedCommOperationException {
        return this.nativeSetLowLatency();
    }

    public boolean getLowLatency() throws UnsupportedCommOperationException {
        return this.nativeGetLowLatency();
    }

    public boolean setCallOutHangup(boolean NoHup) throws UnsupportedCommOperationException {
        return this.nativeSetCallOutHangup(NoHup);
    }

    public boolean getCallOutHangup() throws UnsupportedCommOperationException {
        return this.nativeGetCallOutHangup();
    }

    public boolean clearCommInput() throws UnsupportedCommOperationException {
        return this.nativeClearCommInput();
    }

    static {
        try {
            z = new Zystem();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RXTXVersion.loadLibrary("rxtxSerial");
        RXTXPort.Initialize();
        dsrFlag = false;
    }

    class MonitorThread
    extends Thread {
        private volatile boolean CTS = false;
        private volatile boolean DSR = false;
        private volatile boolean RI = false;
        private volatile boolean CD = false;
        private volatile boolean OE = false;
        private volatile boolean PE = false;
        private volatile boolean FE = false;
        private volatile boolean BI = false;
        private volatile boolean Data = false;
        private volatile boolean Output = false;

        MonitorThread() {
        }

        public void run() {
            RXTXPort.this.monThreadisInterrupted = false;
            RXTXPort.this.eventLoop();
        }

        protected void finalize() throws Throwable {
        }
    }

    class SerialInputStream
    extends InputStream {
        SerialInputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read() throws IOException {
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                z.reportln("+++++++++ read() monThreadisInterrupted");
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int result;
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n = result = RXTXPort.this.readByte();
                return n;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] b) throws IOException {
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int result;
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n = result = this.read(b, 0, b.length);
                return n;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int a;
            if (RXTXPort.this.fd == 0) {
                z.reportln("+++++++ IOException()\n");
                throw new IOException();
            }
            if (b == null) {
                z.reportln("+++++++ NullPointerException()\n");
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                z.reportln("+++++++ IndexOutOfBoundsException()\n");
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int Minimum = len;
            Minimum = RXTXPort.this.threshold == 0 ? ((a = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(Minimum, a)) : Math.min(Minimum, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int result;
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n = result = RXTXPort.this.readArray(b, off, Minimum);
                return n;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(byte[] b, int off, int len, byte[] t) throws IOException {
            int a;
            if (RXTXPort.this.fd == 0) {
                z.reportln("+++++++ IOException()\n");
                throw new IOException();
            }
            if (b == null) {
                z.reportln("+++++++ NullPointerException()\n");
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off + len > b.length) {
                z.reportln("+++++++ IndexOutOfBoundsException()\n");
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int Minimum = len;
            Minimum = RXTXPort.this.threshold == 0 ? ((a = RXTXPort.this.nativeavailable()) == 0 ? 1 : Math.min(Minimum, a)) : Math.min(Minimum, RXTXPort.this.threshold);
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int result;
                RXTXPort.this.waitForTheNativeCodeSilly();
                int n = result = RXTXPort.this.readTerminatedArray(b, off, Minimum, t);
                return n;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int available() throws IOException {
            if (RXTXPort.this.monThreadisInterrupted) {
                return 0;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                int r;
                int n = r = RXTXPort.this.nativeavailable();
                return n;
            }
            finally {
                Object object2 = RXTXPort.this.IOLockedMutex;
                synchronized (object2) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }
    }

    class SerialOutputStream
    extends OutputStream {
        SerialOutputStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.fd == 0) {
                    throw new IOException();
                }
                RXTXPort.this.writeByte(b, RXTXPort.this.monThreadisInterrupted);
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(b, 0, b.length, RXTXPort.this.monThreadisInterrupted);
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (off + len > b.length) {
                throw new IndexOutOfBoundsException("Invalid offset/length passed to read");
            }
            byte[] send = new byte[len];
            System.arraycopy(b, off, send, 0, len);
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                RXTXPort.this.writeArray(send, 0, len, RXTXPort.this.monThreadisInterrupted);
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            if (RXTXPort.this.speed == 0) {
                return;
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (RXTXPort.this.monThreadisInterrupted) {
                return;
            }
            Object object = RXTXPort.this.IOLockedMutex;
            synchronized (object) {
                ++RXTXPort.this.IOLocked;
            }
            try {
                RXTXPort.this.waitForTheNativeCodeSilly();
                if (RXTXPort.this.nativeDrain(RXTXPort.this.monThreadisInterrupted)) {
                    RXTXPort.this.sendEvent(2, true);
                }
            }
            finally {
                object = RXTXPort.this.IOLockedMutex;
                synchronized (object) {
                    --RXTXPort.this.IOLocked;
                }
            }
        }
    }
}

