/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;

public class RXTXVersion {
    private static String Version;
    private static HashMap<String, Boolean> isLoaded;

    public static String getVersion() {
        return Version;
    }

    public static native String nativeGetVersion();

    static void loadLibrary(String baseName) {
        if (isLoaded.get(baseName) != null) {
            return;
        }
        boolean success = RXTXVersion.systemLoadLibrary(baseName) || RXTXVersion.localLoadLibrary(baseName);
    }

    private static boolean systemLoadLibrary(String baseName) {
        try {
            System.loadLibrary(baseName);
            isLoaded.put(baseName, Boolean.TRUE);
            return true;
        }
        catch (UnsatisfiedLinkError e1) {
            return false;
        }
    }

    private static boolean localLoadLibrary(String baseName) {
        String folderName = (System.getProperty("os.name").startsWith("Windows") ? "Windows" : System.getProperty("os.name")) + '-' + System.getProperty("os.arch").toLowerCase(Locale.US);
        String mappedName = System.mapLibraryName(baseName);
        String libraryFile = folderName + File.separator + mappedName;
        if (System.getProperty("harctoolbox.jniLibsHome") != null) {
            libraryFile = System.getProperty("harctoolbox.jniLibsHome") + File.separator + libraryFile;
        }
        if (RXTXVersion.loadAbsoluteLibrary(baseName, libraryFile)) {
            return true;
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            mappedName = System.mapLibraryName(baseName).replaceFirst("\\.dylib", ".jnilib");
            libraryFile = folderName + File.separator + mappedName;
            return RXTXVersion.loadAbsoluteLibrary(baseName, libraryFile);
        }
        return false;
    }

    private static boolean loadAbsoluteLibrary(String baseName, String path) {
        try {
            System.load(new File(path).getAbsolutePath());
            isLoaded.put(baseName, Boolean.TRUE);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    static {
        isLoaded = new HashMap();
        RXTXVersion.loadLibrary("rxtxSerial");
        Version = "RXTX-2.2pre2";
    }
}

