/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;

public class CommPortIdentifier {
    public static final int PORT_PARALLEL = 2;
    public static final int PORT_SERIAL = 1;
    private static CommPortIdentifier rootPort;
    private static boolean valid;
    private int portType;
    private String portName;
    private CommDriver driver;
    private CommPortIdentifier nextPort;
    private Vector portListeners = new Vector(1, 1);
    private boolean owned;
    private String ownerApp;
    private CommPort ownerPort;

    static void setInvalid() {
        valid = false;
    }

    private CommPortIdentifier(int n, String string, CommDriver commDriver) {
        this.portType = n;
        this.portName = string;
        this.driver = commDriver;
        this.owned = false;
    }

    void dropOwner() {
        this.owned = false;
        this.ownerApp = null;
        this.ownerPort = null;
    }

    public static void addPortName(String string, int n, CommDriver commDriver) {
        if (rootPort == null) {
            rootPort = new CommPortIdentifier(n, string, commDriver);
        } else {
            CommPortIdentifier commPortIdentifier = rootPort;
            while (commPortIdentifier.nextPort != null) {
                commPortIdentifier = commPortIdentifier.nextPort;
            }
            commPortIdentifier.nextPort = new CommPortIdentifier(n, string, commDriver);
        }
    }

    public void addPortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        if (!this.portListeners.contains(commPortOwnershipListener)) {
            this.portListeners.addElement(commPortOwnershipListener);
        }
    }

    public String getCurrentOwner() {
        if (this.owned) {
            return this.ownerApp;
        }
        return null;
    }

    public String toString() {
        return "CommPort(" + this.portName + ")";
    }

    public String getName() {
        return this.portName;
    }

    public static CommPortIdentifier getPortIdentifier(CommPort commPort) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier = rootPort;
        while (commPortIdentifier != null) {
            if (commPortIdentifier.ownerPort == commPort) {
                return commPortIdentifier;
            }
            commPortIdentifier = commPortIdentifier.nextPort;
        }
        throw new NoSuchPortException();
    }

    public static CommPortIdentifier getPortIdentifier(String string) throws NoSuchPortException {
        CommPortIdentifier commPortIdentifier = rootPort;
        while (commPortIdentifier != null) {
            if (commPortIdentifier.portName == string || commPortIdentifier.portName.equals(string)) {
                return commPortIdentifier;
            }
            commPortIdentifier = commPortIdentifier.nextPort;
        }
        throw new NoSuchPortException();
    }

    public static Enumeration getPortIdentifiers() {
        if (!valid) {
            return null;
        }
        return new Enumeration(){
            CommPortIdentifier root = CommPortIdentifier.access$000();

            @Override
            public boolean hasMoreElements() {
                return this.root != null;
            }

            public Object nextElement() {
                CommPortIdentifier commPortIdentifier = this.root;
                this.root = this.root.nextPort;
                return commPortIdentifier;
            }
        };
    }

    public int getPortType() {
        return this.portType;
    }

    public boolean isCurrentlyOwned() {
        return this.owned;
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException();
    }

    public CommPort open(String string, int n) throws PortInUseException {
        CommPort commPort = this.driver.getCommPort(this.portName, this.portType);
        this.owned = true;
        this.ownerPort = commPort;
        this.ownerApp = string;
        return commPort;
    }

    public void removePortOwnershipListener(CommPortOwnershipListener commPortOwnershipListener) {
        this.portListeners.removeElement(commPortOwnershipListener);
    }

    static /* synthetic */ CommPortIdentifier access$000() {
        return rootPort;
    }

    static {
        valid = true;
        String string = System.getProperty("os.name");
        String string2 = string.replace(' ', '_');
        if (string.toLowerCase().indexOf("windows") >= 0) {
            string2 = "Windows";
        }
        try {
            Class<?> clazz = Class.forName("javax.comm.Driver" + string2);
            if (clazz != null) {
                ((Runnable)clazz.newInstance()).run();
            }
        }
        catch (Throwable throwable) {
            System.err.println("Unable to find Comm driver for '" + string2 + "'");
        }
    }
}

