/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;
import javax.comm.ParallelPort;
import javax.comm.ParallelPortEventListener;
import javax.comm.SerialPort;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

public class DriverGenUnix
implements Runnable,
CommDriver {
    @Override
    public void run() {
        this.addPorts(System.getProperty("javax.comm.ports.serial"), 1);
        this.addPorts(System.getProperty("javax.comm.ports.parallel"), 2);
        this.addPorts(this.getSerial(), 1);
        this.addPorts(this.getParallel(), 2);
    }

    protected String[][] getSerial() {
        return new String[][]{{"/dev", "ttyS"}, {"/dev/usb", "ttyUSB"}};
    }

    protected String[][] getParallel() {
        return new String[0][];
    }

    private void addPorts(String[][] stringArray, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPorts(stringArray[i][0], stringArray[i][1], n);
        }
    }

    protected boolean skipPort(File file) {
        return false;
    }

    private void addPorts(String string, String string2, int n) {
        String[] stringArray = new File(string).list();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(string, stringArray[i]);
            if (this.skipPort(file) || !stringArray[i].startsWith(string2) || !file.canRead() || !file.canWrite()) continue;
            CommPortIdentifier.addPortName(file.getAbsolutePath(), n, this);
        }
    }

    private void addPorts(String string, int n) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists()) continue;
            CommPortIdentifier.addPortName(file.getAbsolutePath(), n, this);
        }
    }

    @Override
    public CommPort getCommPort(String string, int n) {
        if (n == 1) {
            return new Serial(string);
        }
        if (n == 1) {
            return new Parallel(string);
        }
        throw new IllegalArgumentException("invalid port type");
    }

    @Override
    public void initialize() {
    }

    private native int available(int var1);

    private native void close(int var1);

    private native int read(int var1, byte[] var2, int var3, int var4, int var5);

    private native void write(int var1, byte[] var2, int var3, int var4);

    static {
        try {
            System.loadLibrary("jnijcomm");
        }
        catch (Throwable throwable) {
            System.err.println("Error loading JComm JNI library");
            throwable.printStackTrace();
            CommPortIdentifier.setInvalid();
        }
    }

    private final class FDOutputStream
    extends OutputStream {
        private int fd;

        private FDOutputStream(int n) {
            this.fd = n;
        }

        private void checkFD() throws IOException {
            if (this.fd <= 0) {
                throw new IOException("Stream was closed");
            }
        }

        @Override
        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            DriverGenUnix.this.write(this.fd, byArray, 0, 1);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.checkFD();
            DriverGenUnix.this.write(this.fd, byArray, n, n2);
        }

        @Override
        public void close() throws IOException {
            if (this.fd > 0) {
                DriverGenUnix.this.close(this.fd);
                this.fd = -1;
            }
        }
    }

    private final class FDInputStream
    extends InputStream {
        private int fd;
        private TimedIO timed;

        private FDInputStream(int n, TimedIO timedIO) {
            this.fd = n;
            this.timed = timedIO;
        }

        private void checkFD() throws IOException {
            if (this.fd <= 0) {
                throw new IOException("Stream was closed");
            }
        }

        @Override
        public int available() throws IOException {
            return DriverGenUnix.this.available(this.fd);
        }

        @Override
        public int read() throws IOException {
            this.checkFD();
            byte[] byArray = new byte[1];
            int n = 0;
            n = DriverGenUnix.this.read(this.fd, byArray, 0, 1, this.timed.getTimeout());
            if (n <= 0) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.checkFD();
            return DriverGenUnix.this.read(this.fd, byArray, n, n2, this.timed.getTimeout());
        }

        @Override
        public void close() throws IOException {
            if (this.fd > 0) {
                DriverGenUnix.this.close(this.fd);
                this.fd = -1;
            }
        }
    }

    private final class Parallel
    extends ParallelPort {
        Parallel(String string) {
            this.name = string;
        }

        @Override
        public void disableReceiveFraming() {
        }

        @Override
        public void disableReceiveThreshold() {
        }

        @Override
        public void disableReceiveTimeout() {
        }

        @Override
        public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        }

        @Override
        public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        }

        @Override
        public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        }

        @Override
        public int getInputBufferSize() {
            return -1;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return null;
        }

        @Override
        public int getOutputBufferSize() {
            return -1;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        @Override
        public int getReceiveFramingByte() {
            return -1;
        }

        @Override
        public int getReceiveThreshold() {
            return -1;
        }

        @Override
        public int getReceiveTimeout() {
            return -1;
        }

        @Override
        public boolean isReceiveFramingEnabled() {
            return false;
        }

        @Override
        public boolean isReceiveThresholdEnabled() {
            return false;
        }

        @Override
        public boolean isReceiveTimeoutEnabled() {
            return false;
        }

        @Override
        public void setInputBufferSize(int n) {
        }

        @Override
        public void setOutputBufferSize(int n) {
        }

        @Override
        public void addEventListener(ParallelPortEventListener parallelPortEventListener) throws TooManyListenersException {
        }

        @Override
        public int getMode() {
            return -1;
        }

        @Override
        public int getOutputBufferFree() {
            return -1;
        }

        @Override
        public boolean isPaperOut() {
            return false;
        }

        @Override
        public boolean isPrinterBusy() {
            return false;
        }

        @Override
        public boolean isPrinterError() {
            return false;
        }

        @Override
        public boolean isPrinterSelected() {
            return false;
        }

        @Override
        public boolean isPrinterTimedOut() {
            return false;
        }

        @Override
        public void notifyOnBuffer(boolean bl) {
        }

        @Override
        public void notifyOnError(boolean bl) {
        }

        @Override
        public void removeEventListener() {
        }

        @Override
        public void restart() {
        }

        @Override
        public int setMode(int n) throws UnsupportedCommOperationException {
            return -1;
        }

        @Override
        public void suspend() {
        }
    }

    private final class Serial
    extends SerialPort
    implements TimedIO {
        private int fd;
        private int timeout;

        Serial(String string) {
            this.name = string;
            this.fd = this.open(string);
        }

        private native int open(String var1);

        private native void enableReceiveThreshold(int var1, int var2);

        private native void enableReceiveTimeout(int var1, int var2);

        private native int getReceiveThreshold(int var1);

        private native int getReceiveTimeout(int var1);

        private native int getBaudRate(int var1);

        private native int getDataBits(int var1);

        private native int getFlowControlMode(int var1);

        private native int getParity(int var1);

        private native int getStopBits(int var1);

        private native void sendBreak(int var1, int var2);

        private native void setDTR(int var1, boolean var2);

        private native void setFlowControlMode(int var1, int var2) throws UnsupportedCommOperationException;

        private native void setRTS(int var1, boolean var2);

        private native void setSerialPortParams(int var1, int var2, int var3, int var4, int var5) throws UnsupportedCommOperationException;

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public void close() {
            DriverGenUnix.this.close(this.fd);
            super.close();
        }

        @Override
        public void disableReceiveFraming() {
        }

        @Override
        public void disableReceiveThreshold() {
            try {
                this.enableReceiveThreshold(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void disableReceiveTimeout() {
            try {
                this.enableReceiveTimeout(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        }

        @Override
        public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
            this.enableReceiveThreshold(this.fd, n);
        }

        @Override
        public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
            this.timeout = n;
            this.enableReceiveTimeout(this.fd, n);
        }

        @Override
        public int getInputBufferSize() {
            return 0;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FDInputStream(this.fd, this);
        }

        @Override
        public int getOutputBufferSize() {
            return 0;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new FDOutputStream(this.fd);
        }

        @Override
        public int getReceiveFramingByte() {
            return 0;
        }

        @Override
        public int getReceiveThreshold() {
            return this.getReceiveThreshold(this.fd);
        }

        @Override
        public int getReceiveTimeout() {
            return this.getReceiveTimeout(this.fd);
        }

        @Override
        public boolean isReceiveFramingEnabled() {
            return false;
        }

        @Override
        public boolean isReceiveThresholdEnabled() {
            return this.getReceiveThreshold() > 0;
        }

        @Override
        public boolean isReceiveTimeoutEnabled() {
            return this.getReceiveTimeout() > 0;
        }

        @Override
        public void setInputBufferSize(int n) {
        }

        @Override
        public void setOutputBufferSize(int n) {
        }

        @Override
        public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        }

        @Override
        public int getBaudRate() {
            return this.getBaudRate(this.fd);
        }

        @Override
        public int getDataBits() {
            return this.getDataBits(this.fd);
        }

        @Override
        public int getFlowControlMode() {
            return this.getFlowControlMode(this.fd);
        }

        @Override
        public int getParity() {
            return this.getParity(this.fd);
        }

        @Override
        public int getStopBits() {
            return this.getStopBits(this.fd);
        }

        @Override
        public boolean isCD() {
            return false;
        }

        @Override
        public boolean isCTS() {
            return false;
        }

        @Override
        public boolean isDSR() {
            return false;
        }

        @Override
        public boolean isDTR() {
            return false;
        }

        @Override
        public boolean isRI() {
            return false;
        }

        @Override
        public boolean isRTS() {
            return false;
        }

        @Override
        public void notifyOnBreakInterrupt(boolean bl) {
        }

        @Override
        public void notifyOnCarrierDetect(boolean bl) {
        }

        @Override
        public void notifyOnCTS(boolean bl) {
        }

        @Override
        public void notifyOnDataAvailable(boolean bl) {
        }

        @Override
        public void notifyOnDSR(boolean bl) {
        }

        @Override
        public void notifyOnFramingError(boolean bl) {
        }

        @Override
        public void notifyOnOutputEmpty(boolean bl) {
        }

        @Override
        public void notifyOnOverrunError(boolean bl) {
        }

        @Override
        public void notifyOnParityError(boolean bl) {
        }

        @Override
        public void notifyOnRingIndicator(boolean bl) {
        }

        @Override
        public void removeEventListener() {
        }

        @Override
        public void sendBreak(int n) {
            this.sendBreak(this.fd, n);
        }

        @Override
        public void setDTR(boolean bl) {
        }

        @Override
        public void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        }

        @Override
        public void setRTS(boolean bl) {
        }

        @Override
        public void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
            this.setSerialPortParams(this.fd, n, n2, n3, n4);
        }
    }

    private static interface TimedIO {
        public int getTimeout();
    }
}

