/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.ArrayList;
import org.antlr.runtime.tree.CommonTree;
import org.harctoolbox.IrpMaster.BitDirection;
import org.harctoolbox.IrpMaster.BitField;
import org.harctoolbox.IrpMaster.BitSpec;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.Duration;
import org.harctoolbox.IrpMaster.DurationType;
import org.harctoolbox.IrpMaster.GeneralSpec;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.Pass;
import org.harctoolbox.IrpMaster.PrimaryIrStream;
import org.harctoolbox.IrpMaster.PrimaryIrStreamItem;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.RepeatMarker;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UserComm;

public class ASTTraverser {
    private Protocol env;
    private int state;
    private int pass;
    private boolean considerRepeatMins;
    private static final int indentDepth = 3;

    public ASTTraverser(int pass, boolean considerRepeatMins, Protocol env) {
        this.env = env;
        this.pass = pass;
        this.state = 0;
        this.considerRepeatMins = considerRepeatMins;
    }

    public ASTTraverser(Protocol env) {
        this(0, false, env);
    }

    public GeneralSpec generalspec(CommonTree tree, int level) {
        double frequency = 38000.0;
        double dutyCycle = -1.0;
        BitDirection bitDirection = GeneralSpec.defaultBitDirection;
        double unit = 1.0;
        double unit_pulses = -1.0;
        for (int i = 0; i < tree.getChildCount(); ++i) {
            CommonTree child = (CommonTree)tree.getChild(i);
            if (child.getText().equals("FREQUENCY")) {
                if (child.getChild(0).getText().equals("FLOAT")) {
                    CommonTree val = (CommonTree)child.getChild(0);
                    frequency = 1000.0 * Double.parseDouble(val.getChild(0).getText() + "." + val.getChild(1).getText());
                    continue;
                }
                frequency = 1000 * Integer.parseInt(child.getChild(0).getText());
                continue;
            }
            if (child.getText().equals("DUTYCYCLE")) {
                if (child.getChild(0).getText().equals("FLOAT")) {
                    CommonTree val = (CommonTree)child.getChild(0);
                    dutyCycle = Double.parseDouble(val.getChild(0).getText() + "." + val.getChild(1).getText());
                    continue;
                }
                dutyCycle = Integer.parseInt(child.getChild(0).getText());
                continue;
            }
            if (child.getText().equals("UNIT")) {
                double number;
                if (child.getChild(0).getText().equals("FLOAT")) {
                    CommonTree val = (CommonTree)child.getChild(0);
                    number = Double.parseDouble(val.getChild(0).getText() + "." + val.getChild(1).getText());
                } else {
                    number = Integer.parseInt(child.getChild(0).getText());
                }
                if (child.getChildCount() == 1 || child.getChild(1).getText().equals("u")) {
                    unit = number;
                    continue;
                }
                if (child.getChild(1).getText().equals("p")) {
                    unit_pulses = number;
                    continue;
                }
                throw new IllegalArgumentException("invalid postfix in unit.");
            }
            if (child.getText().equals("BITDIRECTION")) {
                bitDirection = BitDirection.valueOf(child.getChild(0).getText());
                continue;
            }
            throw new IllegalArgumentException("Parse error in GeneralSpec");
        }
        return new GeneralSpec(bitDirection, unit, unit_pulses, frequency, dutyCycle);
    }

    public Duration duration(CommonTree tree, int level, boolean forceOk) throws UnassignedException, DomainViolationException {
        if (!this.passOk(forceOk, level)) {
            return null;
        }
        this.nodeBegin(tree, level);
        String type = tree.getText();
        double time = this.name_or_number((CommonTree)tree.getChild(0), level + 1);
        String unit = tree.getChildCount() == 2 ? ((CommonTree)tree.getChild(1)).getText() : "";
        Duration d = Duration.newDuration(this.env, time, unit, DurationType.valueOf(type.toLowerCase(IrpUtils.dumbLocale)));
        this.nodeEnd(tree, level, d);
        return d;
    }

    public BitField bitfield(CommonTree tree, int level, boolean forceOk) throws UnassignedException, DomainViolationException {
        if (!this.passOk(forceOk, level)) {
            return null;
        }
        this.nodeBegin(tree, level);
        boolean complement = false;
        boolean reverse = false;
        boolean infinite = tree.getText().equals("INFINITE_BITFIELD");
        int offset = 0;
        if (((CommonTree)tree.getChild(offset)).getText().equals("~")) {
            complement = true;
            ++offset;
        }
        if (((CommonTree)tree.getChild(offset)).getText().equals("-") && ((CommonTree)tree.getChild(offset)).getChildCount() == 0) {
            reverse = true;
        }
        int n = ++offset;
        ++offset;
        long data = this.expression((CommonTree)tree.getChild(n), level + 1);
        long width = infinite ? 63L : this.expression((CommonTree)tree.getChild(offset++), level + 1);
        long skip = offset < tree.getChildCount() ? this.expression((CommonTree)tree.getChild(offset), level + 1) : 0L;
        BitField bitField = new BitField(this.env, complement, reverse, infinite, data, width, skip);
        this.nodeEnd(tree, level, bitField);
        return bitField;
    }

    public PrimaryIrStream irstream(CommonTree tree, int level, boolean forceOk, RepeatMarker parentRepeat) throws UnassignedException, InvalidRepeatException, DomainViolationException, IncompatibleArgumentException {
        this.nodeBegin(tree, level);
        PrimaryIrStream bareIrStream = null;
        RepeatMarker repeatMarker = null;
        RepeatMarker repeatMarker2 = repeatMarker = tree.getChildCount() > 1 ? this.repeatmarker((CommonTree)tree.getChild(1), level + 1, null) : new RepeatMarker();
        if (parentRepeat != null && parentRepeat.isInfinite() && repeatMarker.isInfinite()) {
            throw new InvalidRepeatException("Hierachical repeats not implemented");
        }
        int noAlternatives = 0;
        PrimaryIrStream irStream = null;
        if (repeatMarker.min >= 1) {
            bareIrStream = this.bare_irstream((CommonTree)tree.getChild(0), level + 1, forceOk, Pass.intro, repeatMarker);
            irStream = bareIrStream != null ? new PrimaryIrStream(this.env, bareIrStream, null, 0) : null;
            noAlternatives = bareIrStream.getNoAlternatives();
            if (repeatMarker.isInfinite() && !this.considerRepeatMins) {
                irStream = null;
            }
            if (repeatMarker.max < 2 && noAlternatives > 1) {
                UserComm.warning("Variations inside of IrSequence with repeat max < 2. Second and third alternative are ignored.");
            } else if (noAlternatives > 0) {
                ++this.state;
                this.env.assign("$state", (long)this.state);
                if (repeatMarker.max < 3 && noAlternatives == 3) {
                    UserComm.warning("3-part Variations inside of IrSequence with repeat max < 3. Second alternative is ignored.");
                } else {
                    bareIrStream = this.bare_irstream((CommonTree)tree.getChild(0), level + 1, forceOk, Pass.repeat, repeatMarker);
                    if (irStream == null) {
                        irStream = bareIrStream != null ? new PrimaryIrStream(this.env, bareIrStream, null, 0) : null;
                    } else {
                        irStream.concatenate(bareIrStream);
                    }
                }
                if (noAlternatives == 3) {
                    ++this.state;
                    this.env.assign("$state", (long)this.state);
                    bareIrStream = this.bare_irstream((CommonTree)tree.getChild(0), level + 1, forceOk, Pass.ending, repeatMarker);
                    if (irStream == null) {
                        irStream = bareIrStream != null ? new PrimaryIrStream(this.env, bareIrStream, null, 0) : null;
                    } else {
                        irStream.concatenate(bareIrStream);
                    }
                }
            } else if (this.considerRepeatMins || !repeatMarker.isInfinite()) {
                for (int i = 0; i < repeatMarker.min - 1; ++i) {
                    bareIrStream = this.bare_irstream((CommonTree)tree.getChild(0), level + 1, forceOk, Pass.intro, repeatMarker);
                    if (irStream == null) {
                        irStream = bareIrStream != null ? new PrimaryIrStream(this.env, bareIrStream, null, 0) : null;
                        continue;
                    }
                    irStream.concatenate(bareIrStream);
                }
            }
        }
        if (noAlternatives == 0) {
            if (repeatMarker.isInfinite()) {
                ++this.state;
                this.env.assign("$state", (long)this.state);
            }
            if (this.state == this.pass && repeatMarker.isInfinite()) {
                bareIrStream = this.bare_irstream((CommonTree)tree.getChild(0), level + 1, forceOk, Pass.intro, repeatMarker);
                if (this.state == this.pass) {
                    PrimaryIrStream primaryIrStream = irStream = bareIrStream != null ? new PrimaryIrStream(this.env, bareIrStream, null, 0) : null;
                }
                if (bareIrStream.getNoAlternatives() > 0) {
                    throw new InvalidRepeatException("Invalid repeat: Variations enclosed in ( ... )* are not supported.");
                }
            }
            if (repeatMarker.isInfinite()) {
                ++this.state;
                this.env.assign("$state", (long)this.state);
                Debug.debugASTParser("AST traverse state changed to " + this.state + ".");
            }
        }
        this.nodeEnd(tree, level, irStream);
        return irStream;
    }

    public PrimaryIrStream bare_irstream(CommonTree tree, int level, boolean forceOk, Pass variationAlternative, RepeatMarker repeatMarker) throws UnassignedException, InvalidRepeatException, DomainViolationException, IncompatibleArgumentException {
        this.nodeBegin(tree, level);
        int noAlternatives = 0;
        PrimaryIrStream bareIrStream = null;
        ArrayList<PrimaryIrStreamItem> list = new ArrayList<PrimaryIrStreamItem>();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            PrimaryIrStreamItem irStreamItem = this.irstream_item((CommonTree)tree.getChild(i), level + 1, variationAlternative, repeatMarker, forceOk);
            if (irStreamItem != null && irStreamItem.getNoAlternatives() > 0) {
                noAlternatives = irStreamItem.getNoAlternatives();
            }
            if (irStreamItem != null && !irStreamItem.isEmpty()) {
                list.add(irStreamItem);
            }
            if (noAlternatives > 0 && irStreamItem.isEmpty()) break;
        }
        bareIrStream = new PrimaryIrStream(this.env, list, null, noAlternatives);
        this.nodeEnd(tree, level, bareIrStream);
        return bareIrStream;
    }

    public PrimaryIrStream bitspec_irstream(CommonTree tree, int level, boolean forceOk, RepeatMarker repeatMarker) throws UnassignedException, InvalidRepeatException, DomainViolationException, IncompatibleArgumentException {
        BitSpec bitSpec = null;
        if (level == 1) {
            this.env.assign("$state", (long)this.state);
            this.env.assign("$pass", (long)this.pass);
        }
        this.nodeBegin(tree, level);
        bitSpec = this.bitspec((CommonTree)tree.getChild(0), level + 1, true, repeatMarker);
        PrimaryIrStream irStreamWithoutBitSpec = this.irstream((CommonTree)tree.getChild(1), level + 1, forceOk, repeatMarker);
        PrimaryIrStream irStream = new PrimaryIrStream(this.env, irStreamWithoutBitSpec, bitSpec);
        this.nodeEnd(tree, level, irStream);
        if (level == 1) {
            this.env.assign("$final_state", (long)this.state);
        }
        return irStream;
    }

    public PrimaryIrStreamItem irstream_item(CommonTree tree, int level, Pass variationAlternative, RepeatMarker repeatMarker, boolean forceOk) throws UnassignedException, InvalidRepeatException, DomainViolationException, IncompatibleArgumentException {
        this.nodeIntermediate(tree, level, "IrStreamItem");
        String type = tree.getText();
        if (type.equals("FLASH") || type.equals("GAP") || type.equals("EXTENT")) {
            return this.duration(tree, level, forceOk);
        }
        if (type.equals("BITFIELD") || type.equals("INFINITE_BITFIELD")) {
            return this.bitfield(tree, level, forceOk);
        }
        if (type.equals("IRSTREAM")) {
            return this.irstream(tree, level, forceOk, repeatMarker);
        }
        if (type.equals("BITSPEC_IRSTREAM")) {
            return this.bitspec_irstream(tree, level, forceOk, repeatMarker);
        }
        if (type.equals("ASSIGNMENT")) {
            return this.assignment(tree, level, forceOk, repeatMarker);
        }
        if (type.equals("VARIATION")) {
            return this.variation(tree, level, forceOk, variationAlternative, repeatMarker);
        }
        throw new RuntimeException("Something I did not think about, " + type + ", occured.");
    }

    public BitSpec bitspec(CommonTree tree, int level, boolean forceOk, RepeatMarker repeatMarker) throws UnassignedException, InvalidRepeatException, DomainViolationException, IncompatibleArgumentException {
        this.nodeBegin(tree, level);
        ArrayList<PrimaryIrStream> list = new ArrayList<PrimaryIrStream>();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            list.add(this.bare_irstream((CommonTree)tree.getChild(i), level + 1, forceOk, Pass.intro, repeatMarker));
        }
        BitSpec b = new BitSpec(this.env, list);
        this.nodeEnd(tree, level, b);
        return b;
    }

    public RepeatMarker repeatmarker(CommonTree tree, int level, RepeatMarker dummy) {
        this.nodeBegin(tree, level);
        RepeatMarker repeatMarker = tree.getChildCount() == 2 ? new RepeatMarker(Integer.parseInt(((CommonTree)tree.getChild(0)).getText()), ((CommonTree)tree.getChild(1)).getText().charAt(0)) : new RepeatMarker(((CommonTree)tree.getChild(0)).getText());
        this.nodeEnd(tree, level, repeatMarker);
        return repeatMarker;
    }

    public long expression(CommonTree tree, int level) throws UnassignedException, DomainViolationException {
        this.nodeBegin(tree, level);
        String type = tree.getText();
        long result = type.equals("**") ? IrpUtils.power(this.expression((CommonTree)tree.getChild(0), level + 1), this.expression((CommonTree)tree.getChild(1), level + 1)) : (type.equals("%") ? this.expression((CommonTree)tree.getChild(0), level + 1) % this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("/") ? this.expression((CommonTree)tree.getChild(0), level + 1) / this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("*") ? this.expression((CommonTree)tree.getChild(0), level + 1) * this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("-") ? this.expression((CommonTree)tree.getChild(0), level + 1) - this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("+") ? this.expression((CommonTree)tree.getChild(0), level + 1) + this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("&") ? this.expression((CommonTree)tree.getChild(0), level + 1) & this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("^") ? this.expression((CommonTree)tree.getChild(0), level + 1) ^ this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("|") ? this.expression((CommonTree)tree.getChild(0), level + 1) | this.expression((CommonTree)tree.getChild(1), level + 1) : (type.equals("UMINUS") ? -this.expression((CommonTree)tree.getChild(0), level + 1) : (type.equals("BITCOUNT") ? (long)Long.bitCount(this.expression((CommonTree)tree.getChild(0), level + 1)) : (type.equals("BITFIELD") ? this.bitfield(tree, level + 1, true).toLong() : (type.equals("INFINITE_BITFIELD") ? this.bitfield(tree, level + 1, true).toLong() : (type.matches("[0-9]+") ? Long.parseLong(type) : this.env.evaluateName(type))))))))))))));
        this.nodeEnd(tree, level, result);
        return result;
    }

    public PrimaryIrStream assignment(CommonTree tree, int level, boolean forceOk, RepeatMarker repeatMarker) throws UnassignedException, DomainViolationException {
        if (!this.passOk(forceOk, level)) {
            return null;
        }
        this.nodeBegin(tree, level);
        String name = ((CommonTree)tree.getChild(0)).getText();
        long num = this.expression((CommonTree)tree.getChild(1), level + 1);
        this.env.assign(name, num);
        this.nodeEnd(tree, level, num);
        return new PrimaryIrStream(this.env, true);
    }

    public PrimaryIrStream variation(CommonTree tree, int level, boolean forceOk, Pass variationAlternative, RepeatMarker repeatMarker) throws UnassignedException, InvalidRepeatException, DomainViolationException, IncompatibleArgumentException {
        this.nodeBegin(tree, level);
        int childNo = variationAlternative.toInt();
        PrimaryIrStream bareIrStream = tree.getChildCount() > childNo ? this.bare_irstream((CommonTree)tree.getChild(childNo), level + 1, forceOk, Pass.intro, null) : null;
        PrimaryIrStream irStream = new PrimaryIrStream(this.env, bareIrStream, null, tree.getChildCount());
        this.nodeEnd(tree, level, irStream);
        return irStream;
    }

    public double float_number(CommonTree tree, int level) {
        this.nodeBegin(tree, level);
        double num = Double.parseDouble(tree.getChild(0).getText() + "." + tree.getChild(1).getText());
        this.nodeEnd(tree, level, num);
        return num;
    }

    public double number_with_decimals(CommonTree tree, int level) {
        this.nodeBegin(tree, level);
        String label = tree.getText();
        double num = label.matches("[0-9]+") ? (double)Integer.parseInt(label) : this.float_number(tree, level);
        this.nodeEnd(tree, level, num);
        return num;
    }

    public double name_or_number(CommonTree tree, int level) throws UnassignedException, DomainViolationException {
        this.nodeBegin(tree, level);
        String label = tree.getText();
        double num = label.equals("FLOAT") ? this.float_number(tree, level) : (label.matches("[0-9\\.]+") ? this.number_with_decimals(tree, level) : (double)this.env.evaluateName(label));
        this.nodeEnd(tree, level, num);
        return num;
    }

    private boolean passOk(boolean forceOk, int level) {
        boolean ok = forceOk || this.pass == this.state;
        Debug.debugASTParser(ASTTraverser.indent(level) + (forceOk ? "Forced OK" : "Pass: " + this.pass + (ok ? "==" : "!=") + this.state + (ok ? ", proceeding..." : ". Traversing interrupted.")));
        return ok;
    }

    private static String indent(int level) {
        return IrpUtils.spaces((level - 1) * 3);
    }

    private void nodeBegin(CommonTree tree, int level) {
        if (Debug.getInstance().debugOn(Debug.Item.ASTParser)) {
            Debug.debugASTParser(ASTTraverser.indent(level) + "AST node " + tree.getText() + " entered, having " + tree.getChildCount() + " child(ren). State = " + this.state);
        }
    }

    private void nodeEnd(CommonTree tree, int level, Object object) {
        if (Debug.getInstance().debugOn(Debug.Item.ASTParser)) {
            Debug.debugASTParser(ASTTraverser.indent(level) + "AST node " + tree.getText() + " left, producing " + (object == null ? "null" : object.getClass().getSimpleName() + ": " + object.toString()) + ". State = " + this.state);
        }
    }

    private void nodeIntermediate(CommonTree tree, int level, String type) {
        if (Debug.getInstance().debugOn(Debug.Item.ASTParser)) {
            Debug.debugASTParser(ASTTraverser.indent(level) + "AST intermediate node (" + type + ") " + tree.getText() + " entered, having " + tree.getChildCount() + " child(ren).");
        }
    }

    public static long expression(Protocol env, CommonTree tree) throws UnassignedException, DomainViolationException {
        ASTTraverser ast = new ASTTraverser(env);
        return ast.expression(tree, 1);
    }

    public static PrimaryIrStream bitspec_irstream(int pass, boolean considerRepeatMin, Protocol env, CommonTree tree) throws UnassignedException, InvalidRepeatException, DomainViolationException, IncompatibleArgumentException {
        ASTTraverser ast = new ASTTraverser(pass, considerRepeatMin, env);
        return ast.bitspec_irstream(tree, 1, false, null);
    }

    public static Duration duration(Protocol env, CommonTree tree) throws UnassignedException, DomainViolationException {
        ASTTraverser ast = new ASTTraverser(env);
        return ast.duration(tree, 1, true);
    }

    public static BitField bitfield(Protocol env, CommonTree tree) throws UnassignedException, DomainViolationException {
        ASTTraverser ast = new ASTTraverser(env);
        return ast.bitfield(tree, 1, true);
    }

    public static GeneralSpec generalspec(CommonTree tree) throws UnassignedException {
        ASTTraverser ast = new ASTTraverser(null);
        return ast.generalspec(tree, 1);
    }
}

