/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.harctoolbox.IrpMaster.ASTTraverser;
import org.harctoolbox.IrpMaster.BitSpec;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.GeneralSpec;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.PrimaryIrStreamItem;
import org.harctoolbox.IrpMaster.PrimitiveIrStreamItem;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;

public class BitField
extends PrimaryIrStreamItem {
    public static final int maxWidth = 63;
    private boolean complement;
    boolean reverse;
    boolean infinite;
    long data;
    int width = 63;
    int skip = 0;
    long value;

    public BitField(Protocol p, boolean complement, boolean reverse, boolean infinite, long data, long width, long skip) throws DomainViolationException {
        super(p);
        if (width > 63L) {
            throw new DomainViolationException("Max width of bitfields (= 63) exceeded.");
        }
        if (width < 0L) {
            throw new DomainViolationException("Width of bitfield must be nonnegative.");
        }
        if (skip > 63L) {
            throw new DomainViolationException("Max skip value in bitfields (= 63) exceeded.");
        }
        if (skip < 0L) {
            throw new DomainViolationException("Skip value of bitfield must be nonnegative.");
        }
        this.complement = complement;
        this.reverse = reverse;
        this.infinite = infinite;
        this.data = data;
        this.width = infinite ? 63 : (int)width;
        this.skip = (int)skip;
        this.compute();
        Debug.debugBitFields("new Bitfield: " + this.toString() + " = " + this.toLong());
    }

    public static BitField newBitfield(Protocol env, String str, boolean debug) {
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(str));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        try {
            IrpParser.bitfield_return r = parser.bitfield();
            CommonTree AST2 = r.getTree();
            if (debug) {
                System.out.println(AST2.toStringTree());
            }
            return ASTTraverser.bitfield(env, AST2);
        }
        catch (RecognitionException | DomainViolationException | UnassignedException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public final String toString() {
        return (this.complement ? "~" : "") + this.data + ":" + (this.reverse ? "-" : "") + (this.infinite ? "" : Integer.valueOf(this.width)) + ":" + this.skip;
    }

    private void compute() {
        long x = this.data >> this.skip;
        if (this.complement) {
            x ^= 0xFFFFFFFFFFFFFFFFL;
        }
        x &= (1L << this.width) - 1L;
        if (this.reverse) {
            x = IrpUtils.reverse(x, this.width);
        }
        this.value = x;
    }

    public String evaluateAsString() {
        String padding = this.value >= 0L ? "0000000000000000000000000000000000000000000000000000000000000000" : "1111111111111111111111111111111111111111111111111111111111111111";
        String s = Long.toBinaryString(this.value);
        if (s.length() > this.width) {
            s = s.substring(s.length() - this.width);
        } else if (s.length() < this.width) {
            s = padding.substring(0, this.width - s.length()) + s;
        }
        return s;
    }

    public long toLong() {
        return this.value;
    }

    public long evaluate() {
        return this.value;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    private static void usage(int code) {
        System.out.println("Usage:");
        System.out.println("\tBitfield [-d]? <bitfield> [<name>=<value>|{<name>=<value>}]*");
        System.exit(code);
    }

    public static void main(String[] args) {
        boolean debug = false;
        if (args.length == 0) {
            BitField.usage(1);
        }
        int arg_i = 0;
        if (args[0].equals("-d")) {
            debug = true;
            ++arg_i;
        }
        Protocol prot = new Protocol(new GeneralSpec());
        String bitfield = null;
        try {
            bitfield = args[arg_i].trim();
            prot.assign(args, arg_i + 1);
        }
        catch (IncompatibleArgumentException ex) {
            System.err.println(ex.getMessage());
            BitField.usage(3);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            BitField.usage(1);
        }
        BitField bf = BitField.newBitfield(prot, bitfield, debug);
        if (bf != null) {
            System.out.println(bf.toString() + "\tint=" + bf.toLong() + "\tstring=" + bf.evaluateAsString());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.width == 0;
    }

    @Override
    public ArrayList<PrimitiveIrStreamItem> evaluate(BitSpec bitSpec) throws IncompatibleArgumentException, UnassignedException {
        throw new UnsupportedOperationException("This cannot happen.");
    }
}

