/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.ArrayList;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrStreamItem;
import org.harctoolbox.IrpMaster.PrimaryIrStream;
import org.harctoolbox.IrpMaster.Protocol;

public class BitSpec
extends IrStreamItem {
    private int chunkSize;
    private PrimaryIrStream[] bitCodes;

    private static int computeNoBits(int n) {
        if (n == 1) {
            return 1;
        }
        int x = n - 1;
        int m = 0;
        while (x != 0) {
            x >>= 1;
            ++m;
        }
        return m;
    }

    public BitSpec(Protocol env, PrimaryIrStream[] s) {
        super(env);
        this.bitCodes = s;
        this.chunkSize = BitSpec.computeNoBits(s.length);
    }

    public BitSpec(Protocol env, ArrayList<PrimaryIrStream> list) {
        this(env, list.toArray(new PrimaryIrStream[list.size()]));
    }

    public PrimaryIrStream getBitIrsteam(int index) throws IncompatibleArgumentException {
        if (index >= this.bitCodes.length) {
            throw new IncompatibleArgumentException("Cannot encode " + index + " with current bitspec.");
        }
        return this.bitCodes[index];
    }

    public void assignBitSpecs(BitSpec bitSpec) {
        for (PrimaryIrStream pis : this.bitCodes) {
            pis.assignBitSpecs(bitSpec);
        }
    }

    public String toString() {
        if (this.bitCodes == null || this.bitCodes.length == 0) {
            return "<null>";
        }
        StringBuilder s = new StringBuilder();
        s.append("<").append(this.bitCodes[0]);
        for (int i = 1; i < this.bitCodes.length; ++i) {
            s.append("|").append(this.bitCodes[i]);
        }
        return s.append(">").toString();
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean isEmpty() {
        return this.bitCodes.length == 0;
    }
}

